/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.controls.RuleResult;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PersonRangeEdit
extends SWCDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(PersonRangeEdit.class);
    private static final String CALLBACK_VERIFY_RANGE = "CALLBACK_VERIFY_RANGE";
    private static final String VER_RANGE_STR = "verrangestr";
    private static final String RULE_DATE_FORMAT = "ruleDateFormat";

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey = evt.getProperty().getName();
        if ("ruledate".equals(fieldKey)) {
            Object newValue = evt.getChangeSet()[0].getNewValue();
            if (newValue instanceof Date) {
                RuleCondition conditionControl = this.getConditionControl();
                RuleResult resultControl = this.getResultControl();
                this.updateRuleDate((Date)newValue, new RuleControl[]{conditionControl, resultControl});
            }
            this.getModel().setValue("ruledate", null);
            this.getModel().setDataChanged(false);
        }
    }

    private void updateRuleDate(Date date, RuleControl ... controls) {
        if (controls == null || controls.length < 1 || null == date) {
            return;
        }
        String dateFormat = this.getView().getPageCache().get(RULE_DATE_FORMAT);
        String value = SWCStringUtils.isEmpty((String)dateFormat) ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date, (String)dateFormat);
        for (RuleControl ruleControl : controls) {
            ruleControl.setDate(value);
        }
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        this.initDataValue(event);
    }

    private void initDataValue(EventObject event) {
        RuleCondition condition = this.getConditionControl();
        condition.setScene(String.valueOf(this.getSceneId()));
        RuleResult result = this.getResultControl();
        result.setScene(String.valueOf(this.getSceneId()));
        String ruleDesignDataStr = (String)this.getView().getFormShowParameter().getCustomParam("RULE_DESIGN_DATA");
        HrRuleDesignEntity ruleDesignData = null;
        if (!SWCStringUtils.isEmpty((String)ruleDesignDataStr)) {
            try {
                ruleDesignData = (HrRuleDesignEntity)SWCJSONUtils.cast((String)ruleDesignDataStr, HrRuleDesignEntity.class);
            }
            catch (IOException ex) {
                LOGGER.info("cast json error. data = {}", (Object)ruleDesignDataStr, (Object)ex);
            }
        }
        if (ruleDesignData != null) {
            this.getConditionControl().setValueAndUpdateControl(ruleDesignData.getFilterCondition());
            this.getResultControl().setValueAndUpdateControl(ruleDesignData.getFilterResult());
            this.getModel().setValue("number", (Object)ruleDesignData.getRuleNumber());
            this.getModel().setValue("name", (Object)ruleDesignData.getRuleName());
            this.getModel().setValue("id", (Object)ruleDesignData.getId());
        } else {
            String ruleNumber = TaskRuleHelper.newRuleNumber();
            this.getModel().setValue("name", (Object)ruleNumber);
            this.getModel().setValue("number", (Object)ruleNumber);
            this.getModel().setValue("id", (Object)TaskRuleHelper.newRuleId());
            this.getResultControl().setValueAndUpdateControl(TaskRuleHelper.getResultData());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_ok": {
                this.barOkClick(evt);
                break;
            }
        }
    }

    private void barOkClick(ItemClickEvent evt) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().invokeOperation("close");
            return;
        }
        List<String> msgList = this.getRuleControlValidateMsg();
        if (!CollectionUtil.isEmpty(msgList)) {
            msgList.forEach(msg -> this.getView().showTipNotification(msg));
            return;
        }
        this.returnConditionToParent();
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private void returnConditionToParent() {
        HrRuleDesignEntity hrRule = this.getHrRule();
        this.getView().returnDataToParent((Object)hrRule);
    }

    private HrRuleDesignEntity getHrRule() {
        HrRuleDesignEntity rule = new HrRuleDesignEntity();
        rule.setId(Long.valueOf(this.getModel().getDataEntity().getLong("id")));
        rule.setRuleName(this.getName());
        rule.setRuleNumber(this.getNumber());
        rule.setSceneId(this.getSceneId());
        rule.setFilterCondition(this.getConditionControlValue());
        rule.setFilterResult(this.getResultControlValue());
        return rule;
    }

    private String getName() {
        return this.getModel().getDataEntity().getString("name");
    }

    private String getNumber() {
        return this.getModel().getDataEntity().getString("number");
    }

    private String getResultControlValue() {
        RuleResult result = this.getResultControl();
        if (result == null) {
            return "";
        }
        return result.getValue();
    }

    private String getConditionControlValue() {
        RuleCondition condition = this.getConditionControl();
        if (condition == null) {
            return "";
        }
        return condition.getValue();
    }

    private void validateRuleControl(List<String> msgList, RuleControl ruleControl) {
        RuleValidateInfo validate = ruleControl.validate();
        if (!validate.isSuccess()) {
            msgList.addAll(validate.getMsgList());
        }
    }

    private List<String> getRuleControlValidateMsg() {
        ArrayList<String> msgList = new ArrayList<String>();
        this.validateRuleControl(msgList, (RuleControl)this.getConditionControl());
        return msgList;
    }

    private Long getSceneId() {
        String sceneId = (String)this.getView().getFormShowParameter().getCustomParam("sceneId");
        if (SWCStringUtils.isEmpty((String)sceneId)) {
            return 0L;
        }
        return Long.valueOf(sceneId);
    }

    private RuleCondition getConditionControl() {
        return (RuleCondition)this.getControl("rulecondition");
    }

    private RuleResult getResultControl() {
        return (RuleResult)this.getControl("ruleresult");
    }
}

