/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.basedata.SubApiSettingHelper;
import kd.swc.hpdi.common.entity.ApiXmlData;
import kd.swc.hpdi.common.entity.ApiXmlParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SubApiSettingEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(SubApiSettingEdit.class);
    private static final Map<Long, String> DEFAULT_API_NUMBER_MAP;
    public static final String CONFIRM_CALLBACK_DELETE_API = "CONFIRM_CALLBACK_DELETE_API";
    private static final Pattern COMPILE;
    public static final String FIELD_FIELD_KEY = "fieldkey";
    public static final String FIELD_MSG_SUBSCRIBER = "msgsubscriber";
    public static final String ENTRY_INPUT_SUB_ENTRY_ENTITY = "inputsubentryentity";
    public static final String ENTRY_OUTPUT_SUB_ENTRY_ENTITY = "outputsubentryentity";
    public static final String ENTRY_INPUT_ENTRY_ENTITY = "inputentryentity";
    public static final String ENTRY_OUTPUT_ENTRY_ENTITY = "outputentryentity";
    public static final String FIELD_API_DEPLOY = "apideploy";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_ENTITY_NAME = "entityname";
    public static final String FIELD_MAP_FIELD_KEY = "mapfieldkey";
    public static final String FIELD_MAP_BASE_DATA = "mapbasedata";
    public static final String FIELD_MSG_PUBLISHER = "msgpublisher";
    public static final String FIELD_API_FIELD_KEY = "apifieldkey";
    public static final String FIELD_OUTPUT_FIELD_KEY = "outputfieldkey";
    public static final String FIELD_API_FIELD_NAME = "apifieldname";
    public static final String FIELD_API_FIELD_TYPE = "apifieldtype";
    public static final String FIELD_OUTPUT_FIELD_NAME = "outputfieldname";
    public static final String FIELD_OUTPUT_FIELD_TYPE = "outputfieldtype";
    public static final String FIELD_INPUT_FIELD_KEY = "inputfieldkey";
    public static final String FIELD_FIELD_TYPE = "fieldtype";
    public static final String FIELD_FIELD_NAME = "fieldname";
    public static final String FIELD_INPUT_FIELD_TYPE = "inputfieldtype";
    public static final String FIELD_INPUT_FIELD_NAME = "inputfieldname";
    public static final String CONFIRM_CALLBACK_MSG_SUBSCRIBER = "CONFIRM_CALLBACK_MSG_SUBSCRIBER";
    public static final String CONFIRM_CALLBACK_ENABLE_REPLACE = "CONFIRM_CALLBACK_ENABLE_REPLACE";
    public static final String CACHE_MSG_SUBSCRIBER_CHANGE_SET_DATA = "CACHE_MSG_SUBSCRIBER_CHANGE_SET_DATA";
    public static final String CACHE_MSG_SUBSCRIBER_IS_SHOW_CONFIRM = "CACHE_MSG_SUBSCRIBER_IS_SHOW_CONFIRM";
    public static final String CACHE_API_TREE_NODE_DATA = "CACHE_API_TREE_NODE_DATA";
    public static final String CACHE_TREE_SEARCH_DATA = "CACHE_TREE_SEARCH_DATA";
    public static final String IS_BACKGROUND_INVOKE_ENABLE_OP = "IS_BACKGROUND_INVOKE_ENABLE_OP";
    public static final String CACHE_DELETE_DATA_IDS = "CACHE_DISABLE_DATA_IDS";
    public static final String CONTROL_TREE_VIEW = "treeviewap";
    public static final String CONTROL_SEARCH = "searchap";
    public static final String LAST_SEARCH_INDEX = "lastSearchIndex";
    public static final String LAST_SEARCH_TEXT = "lastSearchText";
    public static final String TREE_NODE_SPLITE_FLAG = "#";
    public static final String SEQ = "seq";
    public static final String API_TYPE_DEFAULT = "1";
    public static final String IS_NEW = "isNew";
    public static final String DELETE_ENABLED_DATA_IDS = "deleteEnabledDataIds";
    public static final String HPDI_SUBAPISETTING = "hpdi_subapiset";
    public static final String FIELD_TARGET_OBJ = "targetobj";
    public static final String FIELD_IS_CONVERT_OBJ = "isconvertobj";
    public static final String FIELD_TARGET_OBJECT = "targetobject";
    public static final String FIELD_IS_CONVERT_OBJECT = "isconvertobject";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit msgSubscriber = (BasedataEdit)this.getControl(FIELD_MSG_SUBSCRIBER);
        msgSubscriber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView apiTreeView = this.getApiTreeView();
        apiTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(CONTROL_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        Vector addApiVector = (Vector)this.getControl("addapi");
        addApiVector.addClickListener((ClickListener)this);
        Vector deleteApiVector = (Vector)this.getControl("deleteapi");
        deleteApiVector.addClickListener((ClickListener)this);
    }

    private void registerListeners() {
        TreeView fieldMapTree = this.getApiTreeView();
        List treeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)fieldMapTree);
        if (treeNodeClickListeners == null || treeNodeClickListeners.isEmpty() || !treeNodeClickListeners.contains((Object)this)) {
            fieldMapTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate source = (FormOperate)event.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "enable": {
                this.beforeEnableOperation(event);
                break;
            }
        }
    }

    private void beforeEnableOperation(BeforeDoOperationEventArgs event) {
        QFilter enableFilter;
        QFilter idFilter;
        FormOperate op = (FormOperate)event.getSource();
        OperateOption option = op.getOption();
        RefObject refObject = new RefObject();
        option.tryGetVariableValue(IS_BACKGROUND_INVOKE_ENABLE_OP, refObject);
        String isBackgroundInvoke = (String)refObject.getValue();
        if (!SWCStringUtils.isEmpty((String)isBackgroundInvoke)) {
            this.getView().getPageCache().remove(IS_BACKGROUND_INVOKE_ENABLE_OP);
            return;
        }
        long mssageId = this.getModel().getDataEntity().getLong("msgsubscriber.id");
        long id = this.getModel().getDataEntity().getLong("id");
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper(HPDI_SUBAPISETTING);
        QFilter messageQFilter = new QFilter(FIELD_MSG_SUBSCRIBER, "=", (Object)mssageId);
        DynamicObject[] deleteDatas = subApiSettingOrm.query("id,name", new QFilter[]{messageQFilter, idFilter = new QFilter("id", "!=", (Object)id), enableFilter = new QFilter("enable", "=", (Object)API_TYPE_DEFAULT)});
        if (deleteDatas == null || deleteDatas.length <= 0) {
            return;
        }
        event.setCancel(true);
        ArrayList<String> deleteName = new ArrayList<String>(deleteDatas.length);
        ArrayList<Long> deleteIds = new ArrayList<Long>(deleteDatas.length);
        for (int i = 0; i < deleteDatas.length; ++i) {
            DynamicObject data = deleteDatas[i];
            deleteIds.add(data.getLong("id"));
            deleteName.add(data.getString("name"));
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(CACHE_DELETE_DATA_IDS, deleteIds);
        String nameString = deleteName.stream().collect(Collectors.joining("\u201d\u3001\u201c"));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c{0}\u201d\u7684\u53ef\u7528\u5df2\u8ba2\u9605API\u53c2\u6570\u914d\u7f6e\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"SubApiSettingEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[]{nameString}), ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"SubApiSettingEdit_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALLBACK_ENABLE_REPLACE, (IFormPlugin)this));
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam(IS_NEW, (Object)Boolean.TRUE);
        this.initTargetObjectEnable(null);
    }

    void initTargetObjectEnable(DynamicObject apiDeploy) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount <= 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_TARGET_OBJ, FIELD_IS_CONVERT_OBJ});
            return;
        }
        boolean isConvertObj = this.getModel().getDataEntity().getBoolean(FIELD_IS_CONVERT_OBJ);
        this.getView().setEnable(Boolean.valueOf(isConvertObj), new String[]{FIELD_TARGET_OBJ});
        this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_IS_CONVERT_OBJ});
        if (apiDeploy == null) {
            return;
        }
        if (DEFAULT_API_NUMBER_MAP.containsKey(apiDeploy.getLong("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_IS_CONVERT_OBJ, FIELD_TARGET_OBJ});
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean isSystemPreset = this.getModel().getDataEntity().getBoolean("issyspreset");
        if (isSystemPreset) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterCopyData(EventObject evt) {
        super.afterCopyData(evt);
        this.updateEntryEntity();
    }

    public void afterBindData(EventObject evt) {
        Boolean isCopy;
        super.afterBindData(evt);
        this.reloadApiTreeData();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isNew = (Boolean)customParams.get(IS_NEW);
        if (isNew == null || !isNew.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_MSG_SUBSCRIBER});
        }
        if ((isCopy = (Boolean)customParams.get("iscopy")) != null && isCopy.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_MSG_SUBSCRIBER});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        IDataEntityProperty property = args.getProperty();
        switch (name = property.getName()) {
            case "msgsubscriber": {
                this.onMsgSubscriberPropertyChanged(args);
                break;
            }
            case "isconvertobj": {
                this.onIsConvertObjPropertyChanged(args);
                break;
            }
            case "targetobj": {
                this.onTargetObjPropertyChanged(args);
                break;
            }
            case "mapfieldkey": {
                this.onMapFieldKeyPropertyChanged(args);
                break;
            }
            case "mapbasedata": {
                this.onMapBaseDataPropertyChanged(args);
                break;
            }
        }
    }

    private void onMapBaseDataPropertyChanged(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        if (rowIndex < 0) {
            this.getView().updateView(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
        }
    }

    private void onMapFieldKeyPropertyChanged(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        boolean find = false;
        if (SWCStringUtils.isEmpty((String)newValue)) {
            find = true;
        } else {
            Matcher matcher = COMPILE.matcher(newValue);
            find = matcher.find();
        }
        if (find) {
            this.resetMapFieldKeyValue(changeData);
        }
    }

    private void resetMapFieldKeyValue(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        int parentRowIndex = changeData.getParentRowIndex();
        int rowIndex = changeData.getRowIndex();
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u5b57\u6bb5\u6807\u8bc6\u201c{0}\u201d\u586b\u5199\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7ec4\u6210\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u7684\u503c\u3002", (String)"SubApiSettingEdit_4", (String)"swc-hpdi-formplugin", (Object[])new Object[]{newValue}));
        IDataModel model = this.getModel();
        String oldValue = (String)changeData.getOldValue();
        if (!SWCStringUtils.isEmpty((String)oldValue)) {
            Matcher oldMatcher = COMPILE.matcher(oldValue);
            model.beginInit();
            if (oldMatcher.find()) {
                model.setValue(FIELD_MAP_FIELD_KEY, null, rowIndex, parentRowIndex);
                return;
            }
        }
        model.setValue(FIELD_MAP_FIELD_KEY, (Object)oldValue, rowIndex, parentRowIndex);
        model.endInit();
    }

    private void onTargetObjPropertyChanged(PropertyChangedArgs args) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount <= 0) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        ChangeData[] changeSet = args.getChangeSet();
        this.getModel().setValue(FIELD_TARGET_OBJECT, changeSet[0].getNewValue(), entryCurrentRowIndex);
    }

    private void onIsConvertObjPropertyChanged(PropertyChangedArgs args) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount <= 0) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        ChangeData[] changeSet = args.getChangeSet();
        Boolean newValue = (Boolean)changeSet[0].getNewValue();
        this.getModel().setValue(FIELD_IS_CONVERT_OBJECT, (Object)newValue, entryCurrentRowIndex);
        this.getView().setVisible(Boolean.valueOf(newValue == false), new String[]{FIELD_MAP_BASE_DATA});
        this.getView().setEnable(newValue, new String[]{FIELD_TARGET_OBJ});
        if (!newValue.booleanValue()) {
            this.getModel().setValue(FIELD_TARGET_OBJ, null);
        }
    }

    private void reloadApiTreeData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.clearApiTreeData();
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(CONTROL_TREE_VIEW);
        treeView.deleteAllNodes();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject data = (DynamicObject)entryEntity.get(i);
            String apiDeployName = data.getString("apideploy.name");
            TreeNode leafNode = new TreeNode();
            leafNode.setId(data.hashCode() + TREE_NODE_SPLITE_FLAG + i);
            leafNode.setText(apiDeployName);
            leafNode.setLeaf(true);
            nodes.add(leafNode);
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        TreeView apiTree = this.getApiTreeView();
        apiTree.addNodes(nodes);
        this.saveTreeNodesCache(nodes);
        this.registerListeners();
        TreeNode firstTreeNode = (TreeNode)nodes.get(0);
        apiTree.treeNodeClick(null, firstTreeNode.getId());
        apiTree.focusNode(firstTreeNode);
    }

    public void treeNodeClick(TreeNodeEvent event) {
        this.clearSearchCache();
        String nodeId = (String)event.getNodeId();
        String[] split = nodeId.split(TREE_NODE_SPLITE_FLAG);
        if (split.length < 2) {
            return;
        }
        String rowIndex = split[1];
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex("entryentity", Integer.parseInt(rowIndex));
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", Integer.parseInt(rowIndex));
        model.setValue(FIELD_IS_CONVERT_OBJ, (Object)entryRowEntity.getBoolean(FIELD_IS_CONVERT_OBJECT));
        model.setValue(FIELD_TARGET_OBJ, (Object)entryRowEntity.getDynamicObject(FIELD_TARGET_OBJECT));
        DynamicObject apiDeploy = entryRowEntity.getDynamicObject(FIELD_API_DEPLOY);
        model.setDataChanged(false);
        this.updatePageLayout(apiDeploy);
        this.getView().updateView(ENTRY_INPUT_SUB_ENTRY_ENTITY);
        model.setEntryCurrentRowIndex(ENTRY_INPUT_SUB_ENTRY_ENTITY, 0);
        this.getView().updateView(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
        model.setEntryCurrentRowIndex(ENTRY_OUTPUT_SUB_ENTRY_ENTITY, 0);
        this.initTargetObjectEnable(apiDeploy);
    }

    private void updatePageLayout(DynamicObject apiDeploy) {
        String type = apiDeploy.getString(FIELD_TYPE);
        this.getView().setVisible(Boolean.valueOf(API_TYPE_DEFAULT.equals(type)), new String[]{FIELD_ENTITY_NAME});
        boolean isConvertObj = this.getModel().getDataEntity().getBoolean(FIELD_IS_CONVERT_OBJ);
        this.getView().setVisible(Boolean.valueOf(!isConvertObj), new String[]{FIELD_MAP_BASE_DATA});
    }

    private void clearApiTreeData() {
        TreeView apiTree = this.getApiTreeView();
        apiTree.deleteAllNodes();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.remove(CACHE_API_TREE_NODE_DATA);
    }

    private TreeView getApiTreeView() {
        return (TreeView)this.getControl(CONTROL_TREE_VIEW);
    }

    private void onMsgSubscriberPropertyChanged(PropertyChangedArgs args) {
        ChangeData changeSet = args.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeSet.getOldValue();
        if (oldValue == null) {
            this.updateMsgPublisher();
            this.updateEntryEntity();
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Boolean isShowConfirm = (Boolean)swcPageCache.get(CACHE_MSG_SUBSCRIBER_IS_SHOW_CONFIRM, Boolean.class);
        if (isShowConfirm != null) {
            swcPageCache.remove(CACHE_MSG_SUBSCRIBER_IS_SHOW_CONFIRM);
            return;
        }
        HashMap<String, DynamicObject> changeMap = new HashMap<String, DynamicObject>(2);
        changeMap.put("newValue", newValue);
        changeMap.put("oldValue", oldValue);
        swcPageCache.put(CACHE_MSG_SUBSCRIBER_CHANGE_SET_DATA, changeMap);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u5c06\u4f1a\u5237\u65b0API\u53c2\u6570\u914d\u7f6e\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SubApiSettingEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_MSG_SUBSCRIBER, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "CONFIRM_CALLBACK_MSG_SUBSCRIBER": {
                this.onMsgSubscriberConfirmCallback(event);
                break;
            }
            case "CONFIRM_CALLBACK_ENABLE_REPLACE": {
                this.onEnableReplaceCallback(event);
                break;
            }
            case "CONFIRM_CALLBACK_DELETE_API": {
                this.onDeleteApiCallback(event);
                break;
            }
        }
    }

    private void onDeleteApiCallback(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (result.equals((Object)MessageBoxResult.Yes)) {
            this.deleteApi();
        }
    }

    private void onEnableReplaceCallback(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            IPageCache pageCache = this.getView().getPageCache();
            String deleteDataIds = pageCache.get(CACHE_DELETE_DATA_IDS);
            pageCache.remove(CACHE_DELETE_DATA_IDS);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(IS_BACKGROUND_INVOKE_ENABLE_OP, "TRUE");
            if (SWCStringUtils.isNotEmpty((String)deleteDataIds)) {
                operateOption.setVariableValue(DELETE_ENABLED_DATA_IDS, deleteDataIds);
            }
            this.getView().invokeOperation("enable", operateOption);
        }
    }

    private void onMsgSubscriberConfirmCallback(MessageBoxClosedEvent event) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map changeData = (Map)swcPageCache.get(CACHE_MSG_SUBSCRIBER_CHANGE_SET_DATA, Map.class);
        LinkedHashMap newValue = (LinkedHashMap)changeData.get("newValue");
        LinkedHashMap oldValue = (LinkedHashMap)changeData.get("oldValue");
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            swcPageCache.put(CACHE_MSG_SUBSCRIBER_IS_SHOW_CONFIRM, (Object)Boolean.FALSE);
            this.getModel().setValue(FIELD_MSG_SUBSCRIBER, oldValue.get("id"));
        }
        if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(FIELD_MSG_SUBSCRIBER);
            this.updateMsgPublisher();
            this.updateEntryEntity();
        }
        swcPageCache.remove(CACHE_MSG_SUBSCRIBER_CHANGE_SET_DATA);
    }

    private void updateMsgPublisher() {
        DynamicObject msgSubscriber = this.getModel().getDataEntity().getDynamicObject(FIELD_MSG_SUBSCRIBER);
        if (msgSubscriber == null) {
            return;
        }
        long msgPublisherId = msgSubscriber.getLong("msgpublisher.id");
        this.getModel().setValue(FIELD_MSG_PUBLISHER, (Object)msgPublisherId);
        this.getModel().setDataChanged(false);
    }

    private void updateEntryEntity() {
        DynamicObject msgSubscriber = this.getModel().getDataEntity().getDynamicObject(FIELD_MSG_SUBSCRIBER);
        if (msgSubscriber == null) {
            this.clearEntryEntity();
            return;
        }
        String msgSubscriberNumber = msgSubscriber.getString("number");
        this.updateEntryEntity(msgSubscriberNumber);
    }

    private void updateEntryEntity(String msgSubscriberNumber) {
        List msgSubApiDatas = SubApiSettingHelper.getInstance().getAPIInfoByMsgSubNo(msgSubscriberNumber);
        if (msgSubApiDatas == null || msgSubApiDatas.isEmpty()) {
            this.clearEntryEntity();
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        this.clearEntryEntity();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField(FIELD_API_DEPLOY, new Object[0]);
        tableValueSetter.addField(FIELD_IS_CONVERT_OBJECT, new Object[0]);
        tableValueSetter.addField(FIELD_TARGET_OBJECT, new Object[0]);
        Set<Long> apiIdSet = this.getApiIdSet();
        for (Map msgSubApiData : msgSubApiDatas) {
            Long id = Long.valueOf((String)msgSubApiData.get("id"));
            if (apiIdSet.contains(id)) continue;
            String targetObject = DEFAULT_API_NUMBER_MAP.get(id);
            tableValueSetter.addRow(new Object[]{id, SWCStringUtils.isNotEmpty((String)targetObject), targetObject});
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.reloadApiTreeData();
        this.updateSubEntryEntity();
    }

    private void updateSubEntryEntity() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject rowData = (DynamicObject)entryEntity.get(i);
            DynamicObject apiDeploy = rowData.getDynamicObject(FIELD_API_DEPLOY);
            if (apiDeploy == null) continue;
            String apiType = apiDeploy.getString(FIELD_TYPE);
            if (API_TYPE_DEFAULT.equals(apiType)) {
                this.updateDefaultApiDataSubEntryEntity(i, apiDeploy);
                continue;
            }
            this.updateCustomApiDataSubEntryEntity(i, apiDeploy);
        }
    }

    private void updateDefaultApiDataSubEntryEntity(int rowIndex, DynamicObject apiDeploy) {
        long apiId = apiDeploy.getLong("id");
        String xmlData = (String)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getXMLDescById", (Object[])new Object[]{apiId});
        if (SWCStringUtils.isEmpty((String)xmlData)) {
            return;
        }
        ApiXmlData apiData = SubApiSettingHelper.getInstance().parse(xmlData);
        List outputParams = apiData.getOutputParams();
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            return;
        }
        this.updateDefaultOutputSubEntryEntity(outputParams, rowIndex);
        this.updateDefaultInputSubEntryEntity(apiDeploy, rowIndex);
    }

    private void updateDefaultInputSubEntryEntity(DynamicObject apiDeploy, int rowIndex) {
        DynamicObjectCollection apiFieldEntryEntity = apiDeploy.getDynamicObjectCollection("entryfield1");
        DynamicObject dataObject = this.getModel().getDataEntity();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection inputSubEntryEntity = entryRowEntity.getDynamicObjectCollection(ENTRY_INPUT_SUB_ENTRY_ENTITY);
        Set<String> inputParamKeySet = this.getInputParamKeySet(inputSubEntryEntity);
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper(HPDI_SUBAPISETTING);
        for (int i = 0; i < apiFieldEntryEntity.size(); ++i) {
            String fieldKey;
            DynamicObject dynamicObject = (DynamicObject)apiFieldEntryEntity.get(i);
            if (!dynamicObject.getBoolean("isparam1") || !dynamicObject.getBoolean("enablefield1") || inputParamKeySet.contains(fieldKey = dynamicObject.getString("apifieldkey1"))) continue;
            DynamicObject outPutRowData = subApiSettingOrm.generateEmptyEntryDynamicObject(dataObject, ENTRY_INPUT_SUB_ENTRY_ENTITY);
            outPutRowData.set(FIELD_FIELD_KEY, (Object)dynamicObject.getString("apifieldkey1"));
            outPutRowData.set(FIELD_FIELD_TYPE, (Object)dynamicObject.getString("apifieldtype1"));
            outPutRowData.set(FIELD_FIELD_NAME, (Object)dynamicObject.getString("apifieldname1"));
            outPutRowData.set(SEQ, (Object)i);
            inputSubEntryEntity.add((Object)outPutRowData);
        }
        this.getView().updateView(ENTRY_INPUT_SUB_ENTRY_ENTITY);
    }

    private void updateDefaultOutputSubEntryEntity(List<ApiXmlParam> outputParams, int rowIndex) {
        DynamicObject dataObject = this.getModel().getDataEntity();
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper(HPDI_SUBAPISETTING);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection outPutSubEntryEntity = entryRowEntity.getDynamicObjectCollection(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
        Set<String> outputParamKeySet = this.getOutputParamKeySet(outPutSubEntryEntity);
        for (int i = 0; i < outputParams.size(); ++i) {
            ApiXmlParam apiXmlParam = outputParams.get(i);
            String fieldKey = apiXmlParam.getQueryFieldRelEntity() + "." + apiXmlParam.getKey();
            if (outputParamKeySet.contains(fieldKey)) continue;
            DynamicObject outPutRowData = subApiSettingOrm.generateEmptyEntryDynamicObject(dataObject, ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
            outPutRowData.set(FIELD_ENTITY_NAME, (Object)apiXmlParam.getQueryFieldRelEntity());
            outPutRowData.set(FIELD_API_FIELD_KEY, (Object)fieldKey);
            outPutRowData.set(FIELD_API_FIELD_NAME, (Object)apiXmlParam.getName());
            outPutRowData.set(FIELD_API_FIELD_TYPE, (Object)apiXmlParam.getType());
            outPutRowData.set(FIELD_MAP_FIELD_KEY, (Object)this.getMapFiledKey(apiXmlParam.getQueryFieldRelEntity() + "." + apiXmlParam.getKey()));
            outPutRowData.set(SEQ, (Object)i);
            outPutSubEntryEntity.add((Object)outPutRowData);
        }
        this.getView().updateView(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
    }

    private String getMapFiledKey(String originalFieldKey) {
        if (SWCStringUtils.isEmpty((String)originalFieldKey)) {
            return "";
        }
        return originalFieldKey.replaceAll("\\.", "_");
    }

    private void updateCustomApiDataSubEntryEntity(int rowIndex, DynamicObject apiDeploy) {
        DynamicObjectCollection inputEntryEntity = apiDeploy.getDynamicObjectCollection(ENTRY_INPUT_ENTRY_ENTITY);
        this.updateCustomInputSubEntryEntity(inputEntryEntity, rowIndex);
        DynamicObjectCollection outputEntryEntity = apiDeploy.getDynamicObjectCollection(ENTRY_OUTPUT_ENTRY_ENTITY);
        this.updateCustomOutputSubEntryEntity(outputEntryEntity, rowIndex);
    }

    private void updateCustomOutputSubEntryEntity(DynamicObjectCollection outputEntryEntity, int rowIndex) {
        DynamicObject dataObject = this.getModel().getDataEntity();
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper(HPDI_SUBAPISETTING);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection outPutSubEntryEntity = entryRowEntity.getDynamicObjectCollection(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
        Set<String> outputParamKeySet = this.getOutputParamKeySet(outPutSubEntryEntity);
        for (int i = 0; i < outputEntryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)outputEntryEntity.get(i);
            String fieldKey = dynamicObject.getString(FIELD_OUTPUT_FIELD_KEY);
            if (outputParamKeySet.contains(fieldKey)) continue;
            DynamicObject outPutRowData = subApiSettingOrm.generateEmptyEntryDynamicObject(dataObject, ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
            outPutRowData.set(FIELD_API_FIELD_KEY, (Object)fieldKey);
            outPutRowData.set(FIELD_API_FIELD_NAME, (Object)dynamicObject.getString(FIELD_OUTPUT_FIELD_NAME));
            outPutRowData.set(FIELD_API_FIELD_TYPE, (Object)dynamicObject.getString(FIELD_OUTPUT_FIELD_TYPE));
            outPutRowData.set(FIELD_MAP_FIELD_KEY, (Object)this.trimId(dynamicObject.getString(FIELD_OUTPUT_FIELD_KEY)));
            outPutRowData.set(SEQ, (Object)i);
            outPutSubEntryEntity.add((Object)outPutRowData);
        }
        this.getView().updateView(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
    }

    private String trimId(String source) {
        if (SWCStringUtils.isEmpty((String)source) || !source.endsWith("_id")) {
            return source;
        }
        return source.substring(0, source.length() - 3);
    }

    private void updateCustomInputSubEntryEntity(DynamicObjectCollection inputEntryEntity, int rowIndex) {
        DynamicObject dataObject = this.getModel().getDataEntity();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObjectCollection inputSubEntryEntity = entryRowEntity.getDynamicObjectCollection(ENTRY_INPUT_SUB_ENTRY_ENTITY);
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper(HPDI_SUBAPISETTING);
        Set<String> inputParamKeySet = this.getInputParamKeySet(inputSubEntryEntity);
        for (int i = 0; i < inputEntryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)inputEntryEntity.get(i);
            String fieldKey = dynamicObject.getString(FIELD_INPUT_FIELD_KEY);
            if (inputParamKeySet.contains(fieldKey)) continue;
            DynamicObject outPutRowData = subApiSettingOrm.generateEmptyEntryDynamicObject(dataObject, ENTRY_INPUT_SUB_ENTRY_ENTITY);
            outPutRowData.set(FIELD_FIELD_KEY, (Object)fieldKey);
            outPutRowData.set(FIELD_FIELD_TYPE, (Object)dynamicObject.getString(FIELD_INPUT_FIELD_TYPE));
            outPutRowData.set(FIELD_FIELD_NAME, (Object)dynamicObject.getString(FIELD_INPUT_FIELD_NAME));
            outPutRowData.set(SEQ, (Object)i);
            inputSubEntryEntity.add((Object)outPutRowData);
        }
        this.getView().updateView(ENTRY_INPUT_SUB_ENTRY_ENTITY);
    }

    private Set<String> getInputParamKeySet(DynamicObjectCollection inputEntryEntity) {
        return this.getParamKeySet(inputEntryEntity, FIELD_FIELD_KEY);
    }

    private Set<String> getOutputParamKeySet(DynamicObjectCollection outputEntryEntity) {
        return this.getParamKeySet(outputEntryEntity, FIELD_API_FIELD_KEY);
    }

    private Set<String> getParamKeySet(DynamicObjectCollection inputEntryEntity, String fieldKeyName) {
        if (CollectionUtils.isEmpty((Collection)inputEntryEntity)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(16);
        for (DynamicObject dynamicObject : inputEntryEntity) {
            result.add(dynamicObject.getString(fieldKeyName));
        }
        return result;
    }

    private void clearEntryEntity() {
        this.getView().updateView("entryentity");
        this.getView().updateView(ENTRY_INPUT_SUB_ENTRY_ENTITY);
        this.getView().updateView(ENTRY_OUTPUT_SUB_ENTRY_ENTITY);
        this.reloadApiTreeData();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        switch (name = event.getProperty().getName()) {
            case "msgsubscriber": {
                this.onMsgSubscriberF7Selected(event);
                break;
            }
        }
    }

    private void onMsgSubscriberF7Selected(BeforeF7SelectEvent event) {
        event.addCustomQFilter(new QFilter("subscribebd.id", "=", (Object)107010L));
        event.addCustomQFilter(new QFilter("substatus", "=", (Object)API_TYPE_DEFAULT));
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Integer searchResultIndex;
        String searchText = searchEnterEvent.getText();
        if (SWCStringUtils.isEmpty((String)searchText)) {
            this.clearSearchCache();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u66f4\u591a\u641c\u7d22\u7ed3\u679c\u3002", (String)"SubApiSettingEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        List<TreeNode> treeNodes = this.getTreeNodes();
        Map<String, Object> searchCacheData = this.getSearchCacheData();
        Integer lastSearchIndex = (Integer)searchCacheData.get(LAST_SEARCH_INDEX);
        String lastSearchText = (String)searchCacheData.get(LAST_SEARCH_TEXT);
        if (!SWCStringUtils.equals((String)searchText, (String)lastSearchText)) {
            lastSearchIndex = -1;
        }
        if ((searchResultIndex = this.matchNodeText(searchText, treeNodes, lastSearchIndex)) == null) {
            this.clearSearchCache();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u66f4\u591a\u641c\u7d22\u7ed3\u679c\u3002", (String)"SubApiSettingEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView apiTreeView = this.getApiTreeView();
        TreeNode searchResult = treeNodes.get(searchResultIndex);
        apiTreeView.treeNodeClick(null, searchResult.getId());
        apiTreeView.focusNode(searchResult);
        this.saveSearchCache(searchText, searchResultIndex);
    }

    private void saveSearchCache(String searchText, Integer searchResultIndex) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(2);
        cacheMap.put(LAST_SEARCH_INDEX, searchResultIndex);
        cacheMap.put(LAST_SEARCH_TEXT, searchText);
        new SWCPageCache(this.getView()).put(CACHE_TREE_SEARCH_DATA, cacheMap);
    }

    private Map<String, Object> getSearchCacheData() {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        HashMap<String, Integer> searchCacheMap = (HashMap<String, Integer>)swcPageCache.get(CACHE_TREE_SEARCH_DATA, Map.class);
        if (searchCacheMap == null || searchCacheMap.isEmpty()) {
            searchCacheMap = new HashMap<String, Integer>(2);
            searchCacheMap.put(LAST_SEARCH_INDEX, -1);
        }
        return searchCacheMap;
    }

    private void clearSearchCache() {
        this.getView().getPageCache().remove(CACHE_TREE_SEARCH_DATA);
    }

    private Integer matchNodeText(String searchText, List<TreeNode> treeNodes, int lastSearchIndex) {
        if (CollectionUtils.isEmpty(treeNodes) || treeNodes.size() - 1 <= lastSearchIndex) {
            return null;
        }
        for (int i = lastSearchIndex + 1; i < treeNodes.size(); ++i) {
            TreeNode treeNode = treeNodes.get(i);
            String text = treeNode.getText();
            if (SWCStringUtils.isEmpty((String)text) || !text.contains(searchText)) continue;
            return i;
        }
        return null;
    }

    private List<TreeNode> getTreeNodes() {
        IPageCache pageCache = this.getView().getPageCache();
        String treeNodeJson = pageCache.get(CACHE_API_TREE_NODE_DATA);
        if (SWCStringUtils.isEmpty((String)treeNodeJson)) {
            return new ArrayList<TreeNode>(0);
        }
        try {
            return (List)SWCJSONUtils.cast((String)treeNodeJson, List.class, (Class[])new Class[]{TreeNode.class});
        }
        catch (IOException ex) {
            LOGGER.info("getTreeNodes error", (Object)ex);
            return new ArrayList<TreeNode>(0);
        }
    }

    private void saveTreeNodesCache(List<TreeNode> treeNodes) {
        try {
            String json = SWCJSONUtils.toString(treeNodes);
            this.getView().getPageCache().put(CACHE_API_TREE_NODE_DATA, json);
        }
        catch (IOException ex) {
            LOGGER.info("saveTreeNodesCache error.", (Object)ex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("CALLBACK_API".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            this.addApiDeploy(returnData);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "addapi": {
                this.showApiSelectF7();
                break;
            }
            case "deleteapi": {
                this.clickDeleteApi();
                break;
            }
        }
    }

    private void clickDeleteApi() {
        int entryCurrentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        if (entryCurrentRowIndex < 0) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SubApiSettingEdit_5", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE_API, (IFormPlugin)this));
    }

    private void deleteApi() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().deleteEntryRow("entryentity", entryCurrentRowIndex);
        this.reloadApiTreeData();
    }

    private void addApiDeploy(ListSelectedRowCollection returnData) {
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Set<Long> apiIdSet = this.getApiIdSet();
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField(FIELD_API_DEPLOY, new Object[0]);
        tableValueSetter.addField(FIELD_IS_CONVERT_OBJECT, new Object[0]);
        tableValueSetter.addField(FIELD_TARGET_OBJECT, new Object[0]);
        for (ListSelectedRow returnDatum : returnData) {
            Object id = returnDatum.getPrimaryKeyValue();
            if (apiIdSet.contains(id)) continue;
            String targetObject = DEFAULT_API_NUMBER_MAP.get(id);
            tableValueSetter.addRow(new Object[]{id, SWCStringUtils.isNotEmpty((String)targetObject), targetObject});
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.reloadApiTreeData();
        this.updateSubEntryEntity();
    }

    private Set<Long> getApiIdSet() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptySet();
        }
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject entry : dynamicObjectCollection) {
            result.add(entry.getLong("apideploy.id"));
        }
        return result;
    }

    private void showApiSelectF7() {
        ListShowParameter msg = ShowFormHelper.createShowListForm((String)"hrcs_apideploy", (boolean)true, (int)2);
        ListFilterParameter listFilterParameter = msg.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("id", "not in", this.getApiIdSet()));
        qFilters.add(new QFilter("enable", "=", (Object)API_TYPE_DEFAULT));
        msg.setCloseCallBack(new CloseCallBack(SubApiSettingEdit.class.getName(), "CALLBACK_API"));
        this.getView().showForm((FormShowParameter)msg);
    }

    static {
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        dataMap.put(1400967165800215552L, "hsas_pereduexp");
        dataMap.put(1355771386509054976L, "hsas_personhr");
        dataMap.put(1355777059179385856L, "hsas_employee");
        dataMap.put(1355810811012109312L, "hsas_depemp");
        dataMap.put(1355822002220487680L, "hsas_cmpemp");
        dataMap.put(1355825638925219840L, "hsas_managingscope");
        dataMap.put(1355835341138900992L, "hsas_empposorgrelhr");
        dataMap.put(1355843782897226752L, "hsas_empentrel");
        dataMap.put(1352894602364871680L, "hsas_empjobrel");
        dataMap.put(1352921235960390656L, "hsas_perserlen");
        dataMap.put(1352935241186161664L, "hsas_perprotitlehr");
        dataMap.put(1352938855451472896L, "hsas_pernontsprop");
        dataMap.put(1352940460947158016L, "hsas_pertsprop");
        dataMap.put(1341892060726262784L, "hsas_trialperiod");
        DEFAULT_API_NUMBER_MAP = Collections.unmodifiableMap(dataMap);
        COMPILE = Pattern.compile("[^\\w\\d_]+|^\\d");
    }
}

