/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class SubApiSettingList
extends SWCDataBaseList {
    public static final String IS_BACKGROUND_INVOKE_ENABLE_OP = "IS_BACKGROUND_INVOKE_ENABLE_OP";
    public static final String CACHE_DELETE_DATA_IDS = "CACHE_DELETE_DATA_IDS";
    public static final String CONFIRM_CALLBACK_ENABLE_REPLACE = "CONFIRM_CALLBACK_ENABLE_REPLACE";
    public static final String DELETE_ENABLED_DATA_IDS = "deleteEnabledDataIds";

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        FormOperate source = (FormOperate)event.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "enable": {
                this.beforeEnableOperation(event);
                break;
            }
        }
    }

    private void beforeEnableOperation(BeforeDoOperationEventArgs event) {
        FormOperate op = (FormOperate)event.getSource();
        OperateOption option = op.getOption();
        RefObject refObject = new RefObject();
        option.tryGetVariableValue(IS_BACKGROUND_INVOKE_ENABLE_OP, refObject);
        String isBackgroundInvoke = (String)refObject.getValue();
        if (!SWCStringUtils.isEmpty((String)isBackgroundInvoke)) {
            this.getView().getPageCache().remove(IS_BACKGROUND_INVOKE_ENABLE_OP);
            return;
        }
        ListSelectedRowCollection listSelectedData = event.getListSelectedData();
        if (listSelectedData.size() > 1) {
            event.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"SubApiSettingList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection dataEntities = event.getListSelectedData();
        if (dataEntities == null || dataEntities.size() == 0) {
            return;
        }
        List<Long> ids = dataEntities.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] deleteDatas = this.disableOtherDataWithMsgSubscriberId(ids);
        if (deleteDatas == null || deleteDatas.length <= 0) {
            return;
        }
        event.setCancel(true);
        ArrayList<String> deleteName = new ArrayList<String>(deleteDatas.length);
        ArrayList<Long> deleteIds = new ArrayList<Long>(deleteDatas.length);
        for (int i = 0; i < deleteDatas.length; ++i) {
            DynamicObject data = deleteDatas[i];
            deleteIds.add(data.getLong("id"));
            deleteName.add(data.getString("name"));
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(CACHE_DELETE_DATA_IDS, deleteIds);
        String nameString = deleteName.stream().collect(Collectors.joining("\u201d\u3001\u201c"));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c{0}\u201d\u7684\u53ef\u7528\u5df2\u8ba2\u9605API\u53c2\u6570\u914d\u7f6e\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"SubApiSettingList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[]{nameString}), ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"SubApiSettingList_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALLBACK_ENABLE_REPLACE, (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "CONFIRM_CALLBACK_ENABLE_REPLACE": {
                this.onEnableReplaceCallback(event);
                break;
            }
        }
    }

    private void onEnableReplaceCallback(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            IPageCache pageCache = this.getView().getPageCache();
            String deleteDataIds = pageCache.get(CACHE_DELETE_DATA_IDS);
            pageCache.remove(CACHE_DELETE_DATA_IDS);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(IS_BACKGROUND_INVOKE_ENABLE_OP, "TRUE");
            if (deleteDataIds != null) {
                operateOption.setVariableValue(DELETE_ENABLED_DATA_IDS, deleteDataIds);
            }
            this.getView().invokeOperation("enable", operateOption);
        }
    }

    private DynamicObject[] disableOtherDataWithMsgSubscriberId(List<Long> ids) {
        SWCDataServiceHelper subApiSettingOrm = new SWCDataServiceHelper("hpdi_subapiset");
        DynamicObject[] query = subApiSettingOrm.query("id,msgsubscriber", new QFilter[]{new QFilter("id", "in", ids)});
        if (query == null || query.length == 0) {
            return null;
        }
        List messageIds = Arrays.stream(query).map(item -> item.getLong("msgsubscriber.id")).collect(Collectors.toList());
        QFilter messageQFilter = new QFilter("msgsubscriber", "in", messageIds);
        QFilter idFilter = new QFilter("id", "not in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return subApiSettingOrm.query("id,name", new QFilter[]{messageQFilter, idFilter, enableFilter});
    }
}

