/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.HPDICloudCollaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterDetailInfoEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setEntryDetail();
        this.getModel().setDataChanged(false);
    }

    private void setEntryDetail() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        HashMap<String, Set> param = new HashMap<String, Set>(16);
        for (DynamicObject dynamicObject : entryEntity) {
            String crClass = dynamicObject.getString("collaruleclass");
            long crId = dynamicObject.getLong("collarule.id");
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L) continue;
            Set tempIds = param.computeIfAbsent(crClass, item -> new HashSet(16));
            tempIds.add(crId);
        }
        Table crObjectTable = HPDICloudCollaHelper.getInstance().queryMultiClassObject(param);
        IDataModel model = this.getModel();
        model.beginInit();
        for (int i = 0; i < entryEntity.size(); ++i) {
            long crId;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            String crClass = entry.getString("collaruleclass");
            DynamicObject cr = (DynamicObject)crObjectTable.get((Object)crClass, (Object)(crId = entry.getLong("collarule.id")));
            if (cr == null) continue;
            this.getModel().setValue("hrorg", (Object)cr.getLong("createorg.id"), i);
            this.getModel().setValue("payrollact", (Object)this.getPayRollActName(cr), i);
            this.getModel().setValue("bizappname", (Object)cr.getString("payrollactgtpl.bizapp.id"), i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String getPayRollActName(DynamicObject cr) {
        DynamicObjectCollection actEntry = cr.getDynamicObjectCollection("entryentity");
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : actEntry) {
            String name = dynamicObject.getString("payrollact.name");
            if (!SWCStringUtils.isNotEmpty((String)name)) continue;
            nameList.add(name);
        }
        if (CollectionUtils.isEmpty(nameList)) {
            return "";
        }
        return String.join((CharSequence)";", nameList);
    }
}

