/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.job.JobDispatcherService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterEdit
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskCenterEdit.class);
    private static final String MSG_RECEIVE = "orgmsgrecvcenter";
    private static final String TASK_RULE = "taskrule";
    public static final String CACHE_REL_VERIFY_BILL_DATA = "CACHE_REL_VERIFY_BILL_DATA";

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        IFormView view = this.getView();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (status.compareTo((Enum)OperationStatus.VIEW) != 0) {
            DynamicObject orgDyobj;
            IDataModel dataModel = this.getModel();
            if ("0".equals(this.getModel().getValue("enable"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_execute", "bar_disable"});
            }
            if (null != (orgDyobj = (DynamicObject)dataModel.getValue("org"))) {
                view.setEnable(Boolean.TRUE, new String[]{MSG_RECEIVE});
                this.setBasedataFilter(orgDyobj, MSG_RECEIVE);
            } else {
                view.setEnable(Boolean.FALSE, new String[]{MSG_RECEIVE});
            }
            DynamicObject orgMsgReceiveCenterDyobj = (DynamicObject)dataModel.getValue(MSG_RECEIVE);
            if (null != orgMsgReceiveCenterDyobj) {
                view.setEnable(Boolean.TRUE, new String[]{TASK_RULE});
                this.setBasedataFilter(orgMsgReceiveCenterDyobj, TASK_RULE);
            } else {
                view.setEnable(Boolean.FALSE, new String[]{TASK_RULE});
            }
        }
        this.setNextExecuteTime();
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject event) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (null != params) {
            this.getModel().setValue("name", params.get("name"));
            this.getModel().setValue(MSG_RECEIVE, params.get(MSG_RECEIVE));
            String orgObj = (String)params.get("orgid");
            if (!SWCStringUtils.isEmpty((String)orgObj)) {
                this.getModel().setValue("org", (Object)orgObj);
            }
        }
    }

    private void setNextExecuteTime() {
        if (!"B".equals(this.getModel().getValue("taskexecutestatus")) || !"1".equals(this.getModel().getValue("enable"))) {
            return;
        }
        long schCfgId = this.getModel().getDataEntity().getLong("taskrule.schconfig.id");
        if (schCfgId == 0L) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_schplancfg");
        DynamicObject schCfgDy = helper.queryOriginalOne("schedule", (Object)schCfgId);
        if (schCfgDy == null) {
            return;
        }
        String scheduleId = schCfgDy.getString("schedule");
        if (SWCStringUtils.isEmpty((String)scheduleId)) {
            return;
        }
        String[] idArr = new String[]{scheduleId};
        Map executeTimeMap = JobDispatcherService.getInstance().getExecuteTime(idArr);
        ZonedDateTime time = executeTimeMap.getOrDefault(scheduleId, null);
        if (null == time) {
            return;
        }
        ZonedDateTime systemTime = time.withZoneSameInstant(ZoneId.of(TimeZone.getDefault().getID()));
        this.getModel().setValue("nextexecutetime", (Object)Date.from(systemTime.toInstant()));
    }

    public void propertyChanged(PropertyChangedArgs event) {
        switch (event.getProperty().getName()) {
            case "org": {
                this.orgPropertyChanged(event.getChangeSet()[0]);
                break;
            }
            case "orgmsgrecvcenter": {
                this.msgReceiveCenterPropertyChanged(event.getChangeSet()[0]);
                break;
            }
            case "taskrule": {
                this.setTaskRuleV(event.getChangeSet()[0]);
                this.taskRulePropertyChanged(event.getChangeSet()[0]);
                break;
            }
        }
    }

    private void setTaskRuleV(ChangeData changeData) {
        if (null == changeData.getNewValue()) {
            return;
        }
        DynamicObject taskRuleObj = (DynamicObject)changeData.getNewValue();
        this.getModel().setValue("taskrulev", (Object)taskRuleObj.getLong("vid"));
    }

    private void taskRulePropertyChanged(ChangeData changeData) {
        if (null == changeData.getNewValue()) {
            return;
        }
        DynamicObject taskRuleObj = (DynamicObject)changeData.getNewValue();
        DynamicObjectCollection entryEntity = taskRuleObj.getDynamicObjectCollection("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().insertEntryRow("entryentity", i);
            this.getModel().setValue("payrollactg", ((DynamicObject)entryEntity.get(i)).get("payrollactg"), i);
            this.getModel().setValue("stopexecafterfail", ((DynamicObject)entryEntity.get(i)).get("stopexecafterfail"), i);
        }
        this.getModel().deleteEntryRow("entryentity", entryEntity.size());
        this.getView().updateView("entryentity");
        this.getModel().endInit();
    }

    private void msgReceiveCenterPropertyChanged(ChangeData changeData) {
        DynamicObject msgReceiveCenterDyobj = (DynamicObject)changeData.getNewValue();
        if (null != msgReceiveCenterDyobj) {
            this.getView().setEnable(Boolean.TRUE, new String[]{TASK_RULE});
            this.setBasedataFilter(msgReceiveCenterDyobj, TASK_RULE);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{TASK_RULE});
        }
    }

    private void orgPropertyChanged(ChangeData changeData) {
        DynamicObject orgDyobj = (DynamicObject)changeData.getNewValue();
        if (null != orgDyobj) {
            this.getView().setEnable(Boolean.TRUE, new String[]{MSG_RECEIVE, TASK_RULE});
            this.setBasedataFilter(orgDyobj, MSG_RECEIVE);
            this.setBasedataFilter(orgDyobj, TASK_RULE);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{MSG_RECEIVE, TASK_RULE});
        }
    }

    private void setBasedataFilter(DynamicObject dyobj, String fieldKey) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(fieldKey);
        QFilter qFilter = this.getBaseDataQFilter(dyobj, fieldKey);
        basedataEdit.setQFilters(Collections.singletonList(qFilter));
    }

    private QFilter getBaseDataQFilter(DynamicObject dyobj, String fieldKey) {
        QFilter qFilter = null;
        if (SWCStringUtils.equals((String)fieldKey, (String)MSG_RECEIVE)) {
            qFilter = new QFilter("org.id", "=", dyobj.get("id"));
        } else {
            DynamicObject orgDyobj = (DynamicObject)this.getModel().getValue("org");
            qFilter = new QFilter("createorg.id", "=", orgDyobj.get("id"));
            qFilter.and(new QFilter("msgsubscriber.msgsubno", "=", (Object)dyobj.getString("msgsubno")));
        }
        return qFilter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("executetask".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_showverifybill": {
                this.showVerifyBill();
                break;
            }
        }
    }

    private void showVerifyBill() {
        SWCDataServiceHelper sumOrm = new SWCDataServiceHelper("hpdi_summaryvbill");
        long relBillId = this.getModel().getDataEntity().getLong("sumverifybillid");
        if (!sumOrm.isExists((Object)relBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u60a8\u6240\u9700\u7684\u6838\u5b9a\u5355\u6570\u636e\u3002\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"TaskCenterEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId("hpdi_sumvbillview");
        formShowParameter.setPkId((Object)relBillId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList<String> opeIds = new ArrayList<String>();
        opeIds.add("donothing_showverifybill");
        Boolean isNeedHideColumn = Boolean.TRUE;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            long crId = entry.getLong("collarule.id");
            String crClass = entry.getString("collaruleclass");
            boolean isManualVerify = entry.getBoolean("ismanualverify");
            if (SWCStringUtils.isEmpty((String)crClass) || crId == 0L || !isManualVerify) {
                entryGrid.hideOperateItems("operationcolumnap", i, opeIds);
                continue;
            }
            isNeedHideColumn = isNeedHideColumn & Boolean.FALSE;
        }
        if (isNeedHideColumn.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
        }
    }
}

