/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.sql.Date;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.job.JobDispatcherService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskCenterList
extends AbstractListPlugin {
    private Map<Long, ZonedDateTime> executeTimeMap = new HashMap<Long, ZonedDateTime>(16);
    private static final String EXECUTE_TASK = "executetask";
    private static final String VALIDATE_NEW = "validatenew";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("collaapp.fbasedataid.name".equals(fieldName)) {
            args.getQfilters().add(new QFilter("bizcloud.number", "in", (Object)new String[]{"SWC", "SIT"}));
            args.getQfilters().add(new QFilter("visible", "=", (Object)"1"));
            args.getQfilters().add(new QFilter("deploystatus", "=", (Object)"2"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "executetask": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "validatenew": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("new");
                break;
            }
            case "donothing_disable": 
            case "donothing_enable": {
                FormOperate op = (FormOperate)afterDoOperationEventArgs.getSource();
                ((IEntityOperate)op).setCancelRefresh(false);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                Map executeTimeMapIn;
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                HashSet<Long> schCfgIds = new HashSet<Long>(10);
                if (!CollectionUtils.isEmpty((Collection)rows)) {
                    boolean containsKey = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"taskrule");
                    if (containsKey) {
                        for (DynamicObject row : rows) {
                            schCfgIds.add(row.getLong("taskrule.schconfig.id"));
                        }
                    } else {
                        SWCDataServiceHelper taskCenterOrm;
                        DynamicObject[] query;
                        Set taskCenterids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                        if (!SWCStringUtils.isEmpty((String)billFormId) && (query = (taskCenterOrm = new SWCDataServiceHelper(billFormId)).query("taskrule.schconfig.id", new QFilter[]{new QFilter("id", "in", taskCenterids)})) != null && query.length > 0) {
                            schCfgIds.addAll(Arrays.stream(query).map(item -> item.getLong("taskrule.schconfig.id")).collect(Collectors.toList()));
                        }
                    }
                }
                HashMap schIdMap = new HashMap(schCfgIds.size());
                DynamicObjectCollection schCfgDyColl = new SWCDataServiceHelper("hsbs_schplancfg").queryOriginalCollection("id,schedule", new QFilter("id", "in", schCfgIds).toArray());
                if (schCfgDyColl != null && !schCfgDyColl.isEmpty()) {
                    schCfgDyColl.forEach(dy -> schIdMap.put(dy.getString("schedule"), dy.getLong("id")));
                }
                if ((executeTimeMapIn = JobDispatcherService.getInstance().getExecuteTime(schIdMap.keySet().toArray(new String[0]))) != null) {
                    for (Map.Entry entry : executeTimeMapIn.entrySet()) {
                        Long schCfgId = (Long)schIdMap.get(entry.getKey());
                        if (schCfgId == null) continue;
                        TaskCenterList.this.executeTimeMap.put(schCfgId, entry.getValue());
                    }
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        String fieldKey;
        super.packageData(evt);
        ColumnDesc columnDesc = (ColumnDesc)evt.getSource();
        switch (fieldKey = columnDesc.getFieldKey()) {
            case "nextexecutetime": {
                this.setNextExecuteTime(evt);
                break;
            }
        }
    }

    private void setNextExecuteTime(PackageDataEvent arg) {
        ZonedDateTime time;
        if ("B".equals(arg.getRowData().getString("taskexecutestatus")) && "1".equals(arg.getRowData().getString("enable")) && (time = (ZonedDateTime)this.executeTimeMap.getOrDefault(arg.getRowData().getLong("taskrule.schconfig.id"), null)) != null) {
            ZonedDateTime systemTime = time.withZoneSameInstant(ZoneId.of(TimeZone.getDefault().getID()));
            arg.setFormatValue((Object)Date.from(systemTime.toInstant()));
        }
    }
}

