/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class TaskRuleAddVerifyPersonRangeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaskRuleAddVerifyPersonRangeEdit.class);
    public static final String CONFIRM_CALLBACK_SCENE_CHANGED = "CONFIRM_CALLBACK_SCENE_CHANGED";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TextEdit ruleDesign = (TextEdit)this.getView().getControl("verrangestr");
        ruleDesign.addButtonClickListener((ClickListener)this);
        BasedataEdit sceneEdit = (BasedataEdit)this.getView().getControl("scene");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCopyData(EventObject evt) {
        super.afterCopyData(evt);
        this.initDataFromCopy();
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.initDataValue();
    }

    private void initDataFromCopy() {
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            this.getModel().setValue("policy", null);
            this.getModel().setValue("policynumber", null);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                return;
            }
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                DynamicObject ruleDesign = dynamicObject.getDynamicObject("ruledesign");
                if (ruleDesign == null) continue;
                HrRuleDesignEntity hrRuleDesignEntity = TaskRuleHelper.convertHrRuleDesignWithNewId((DynamicObject)ruleDesign);
                hrRuleDesignEntity.setRuleName(hrRuleDesignEntity.getRuleNumber());
                this.getModel().setValue("ruledesign", null, i);
                this.getModel().setValue("verrangestr", (Object)TaskRuleHelper.formatRuleConditionInfo((String)hrRuleDesignEntity.getFilterCondition()), i);
                this.getModel().setValue("rulenumber", (Object)hrRuleDesignEntity.getRuleNumber(), i);
                this.getModel().setValue("rulejson", (Object)TaskRuleHelper.toJsonString((Object)hrRuleDesignEntity), i);
            }
        }
    }

    private void initDataValue() {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        model.beginInit();
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            this.getView().setEnable(Boolean.valueOf(dynamicObject.getBoolean("ismanualverify")), i, new String[]{"verrangestr"});
            String ruleNumber = dynamicObject.getString("ruledesign.number");
            if (SWCStringUtils.isEmpty((String)ruleNumber)) continue;
            model.setValue("rulenumber", (Object)ruleNumber, i);
            DynamicObject ruleDesign = dynamicObject.getDynamicObject("ruledesign");
            model.setValue("verrangestr", (Object)TaskRuleHelper.formatRuleConditionInfo((String)ruleDesign.getString("conditions")), i);
            HrRuleDesignEntity hrRuleDesignEntity = TaskRuleHelper.convertHrRuleDesignEntity((DynamicObject)ruleDesign);
            model.setValue("rulejson", (Object)TaskRuleHelper.toJsonString((Object)hrRuleDesignEntity), i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        super.propertyChanged(event);
        IDataEntityProperty property = event.getProperty();
        switch (property.getName()) {
            case "verrangestr": {
                this.onVerifyPersonRangePropertyChanged(event);
                break;
            }
            case "ismanualverify": {
                this.onIsManualVerifyPropertyChanged(event);
                break;
            }
            case "scene": {
                this.onScenePropertyChanged(event);
                break;
            }
        }
    }

    private void onScenePropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        DynamicObject oldValue = (DynamicObject)changeSet.getOldValue();
        if (oldValue == null) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u201c\u573a\u666f\u201d\uff0c\u5c06\u6e05\u7a7a\u201c\u6838\u5b9a\u4eba\u5458\u8303\u56f4\u914d\u7f6e\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRuleAddVerifyPersonRangeEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALLBACK_SCENE_CHANGED, (IFormPlugin)this), null, String.valueOf(oldValue.getLong("id")));
    }

    private void onIsManualVerifyPropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        Boolean newValue = (Boolean)changeSet.getNewValue();
        int entryCurrentRowIndex = changeSet.getRowIndex();
        if (!newValue.booleanValue()) {
            this.clearRuleFieldData(entryCurrentRowIndex);
        }
        this.getView().setEnable(newValue, entryCurrentRowIndex, new String[]{"verrangestr"});
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("entryentity");
        int rowIndex = 0;
        for (DynamicObject entry : entryentitys) {
            Boolean isManualVerify = entry.getBoolean("ismanualverify");
            this.getView().setEnable(isManualVerify, rowIndex++, new String[]{"verrangestr"});
        }
    }

    private void clearPolicyAndRuleData() {
        IDataModel model = this.getModel();
        model.setValue("policy", null);
        model.setValue("policynumber", null);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.clearRuleFieldData(i);
        }
    }

    private void onVerifyPersonRangePropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        String newValue = (String)changeSet.getNewValue();
        String oldValue = (String)changeSet.getOldValue();
        if (SWCStringUtils.isEmpty((String)newValue) && SWCStringUtils.isNotEmpty((String)oldValue)) {
            this.clearRuleFieldData(changeSet.getRowIndex());
        }
    }

    private void clearRuleFieldData(int entryCurrentRowIndex) {
        this.getModel().setValue("rulenumber", null, entryCurrentRowIndex);
        this.getModel().setValue("verrangestr", null, entryCurrentRowIndex);
        this.getModel().setValue("ruledesign", null, entryCurrentRowIndex);
        this.getModel().setValue("rulejson", null, entryCurrentRowIndex);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initHisChangeData();
    }

    private void initHisChangeData() {
        Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
        if (isChange != null && isChange.booleanValue()) {
            this.getModel().setValue("policy", null);
            this.getModel().setValue("policynumber", null);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                return;
            }
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                DynamicObject ruleDesign = dynamicObject.getDynamicObject("ruledesign");
                if (ruleDesign == null) continue;
                HrRuleDesignEntity hrRuleDesignEntity = TaskRuleHelper.convertHrRuleDesignWithNewId((DynamicObject)ruleDesign);
                hrRuleDesignEntity.setRuleName(hrRuleDesignEntity.getRuleNumber());
                this.getModel().setValue("ruledesign", null, i);
                this.getModel().setValue("rulenumber", (Object)hrRuleDesignEntity.getRuleNumber(), i);
                this.getModel().setValue("rulejson", (Object)TaskRuleHelper.toJsonString((Object)hrRuleDesignEntity), i);
                this.getModel().setValue("verrangestr", (Object)TaskRuleHelper.formatRuleConditionInfo((String)hrRuleDesignEntity.getFilterCondition()), i);
            }
        }
    }

    public void createNewData(BizDataEventArgs evt) {
        super.createNewData(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "auditconfirmchange": 
            case "changesave": {
                this.onBeforeSaveOperation(args);
                break;
            }
        }
    }

    private void onBeforeSaveOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long sceneId = dataEntity.getLong("scene.id");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject entry : entryEntity) {
                String ruleJson = entry.getString("rulejson");
                if (SWCStringUtils.isEmpty((String)ruleJson) || sceneId != 0L) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u6838\u5b9a\u4eba\u5458\u8303\u56f4\uff0c\u201c\u573a\u666f\u201d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TaskRuleAddVerifyPersonRangeEdit_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        this.initPolicyNumber();
        this.addRuleEnginData(args);
    }

    private void addRuleEnginData(BeforeDoOperationEventArgs args) {
        DynamicObject entity = this.getModel().getDataEntity();
        HRPolicyEntity policy = TaskRuleHelper.getExePreRulePolicy((DynamicObject)entity);
        if (policy == null) {
            return;
        }
        ResponseDTO mapResponseDTO = TaskRuleHelper.batchInsertOrUpdateHrPolicy(Collections.singletonList(policy));
        Map result = (Map)mapResponseDTO.getResult();
        if (!mapResponseDTO.isSuccess() || CollectionUtils.isEmpty((Map)result)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TaskRuleAddVerifyPersonRangeEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long policyId = (Long)result.get(policy.getNumber());
        this.getModel().setValue("policy", (Object)policyId);
        DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        Map ruleIdMap = TaskRuleHelper.getRuleNumberIdMap((DynamicObject)this.getModel().getDataEntity());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            String ruleNumberStr = dynamicObject.getString("rulenumber");
            if (SWCStringUtils.isEmpty((String)ruleNumberStr)) continue;
            this.getModel().setValue("ruledesign", ruleIdMap.get(ruleNumberStr), i);
        }
    }

    private void initPolicyNumber() {
        String policyNumber = this.getModel().getDataEntity().getString("policy.number");
        if (SWCStringUtils.isEmpty((String)policyNumber)) {
            policyNumber = TaskRuleHelper.newPolicyNumber();
        }
        this.getModel().setValue("policynumber", (Object)policyNumber);
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "submit": 
            case "audit": 
            case "auditconfirmchange": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("verrangestr".equals(key)) {
            this.showExeVerifyRangeDesignPage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CONFIRM_CALLBACK_SCENE_CHANGED.equalsIgnoreCase(callBackId)) {
            this.onSceneChangedCallback(event);
        }
    }

    private void onSceneChangedCallback(MessageBoxClosedEvent event) {
        String oldValue = event.getCustomVaule();
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.clearPolicyAndRuleData();
        }
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("scene", SWCStringUtils.isNotEmpty((String)oldValue) && !"null".equalsIgnoreCase(oldValue) ? oldValue : null);
            model.endInit();
            this.getView().updateView("scene");
        }
    }

    private void showExeVerifyRangeDesignPage() {
        DynamicObject sceneObject = this.getModel().getDataEntity().getDynamicObject("scene");
        if (sceneObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u573a\u666f\u201d\u3002", (String)"TaskRuleAddVerifyPersonRangeEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("hpdi_verrange");
        StyleCss inlineStyleCss = new StyleCss();
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_VERIFY_RANGE"));
        billShowParameter.setCustomParam("sceneId", (Object)String.valueOf(this.getModel().getDataEntity().getString("scene.id")));
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        billShowParameter.setCustomParam("RULE_DESIGN_DATA", this.getModel().getValue("rulejson", entryCurrentRowIndex));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("CALLBACK_VERIFY_RANGE".equalsIgnoreCase(actionId)) {
            this.verifyRangeCallBack(closedCallBackEvent);
        }
    }

    private void verifyRangeCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HrRuleDesignEntity returnData = (HrRuleDesignEntity)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("rulenumber", (Object)returnData.getRuleNumber(), entryCurrentRowIndex);
        this.getModel().setValue("rulejson", (Object)TaskRuleHelper.toJsonString((Object)returnData), entryCurrentRowIndex);
        this.getModel().setValue("verrangestr", (Object)TaskRuleHelper.formatRuleConditionInfo((String)returnData.getFilterCondition()), entryCurrentRowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("scene".equalsIgnoreCase(name)) {
            List<String> appIds = Arrays.asList("/UHMBBGZQ65X", "0NXW1VOPH+QV");
            event.addCustomQFilter(new QFilter("bizappid.id", "in", appIds));
            FormShowParameter formShowParameter = event.getFormShowParameter();
            formShowParameter.setCustomParam("bizappids", (Object)appIds.stream().collect(Collectors.joining("\",\"", "[\"", "\"]")));
        }
    }
}

