/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.schedule.SwcBizSchConfigConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class TaskRuleCommonEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(TaskRuleCommonEdit.class);
    private static final String SWC_HPDI_FORMPLUGIN = "swc-hpdi-formplugin";
    private static final String BAR_TOOL = "advcontoolbarap";
    private static final String BAR_ADD_PAYROLLACTG = "bar_addpayrollactg";
    private static final String BAR_ADD_ADDENTRY = "bar_addentry";
    private static final String BAR_ADD_DELETEENTRY = "bar_deleteentry";
    private static final String DISABLE_PARAM_CONFIRM = "disable_afterconfirm";
    private static final String ENABLE_CONFIRM = "enable_afterconfirm";
    private static final String AFTER_CONFIRM = "afterconfirm";
    private static final String MSGSUBSCRIBERID_CACHE_KEY = "msgsubscriberid";
    private static final String MSG_SUBSCRIBER = "msgsubscriber";
    private static final String MSG_SUBSCRIBER_CONFIRM = "msgsubscriber_afterconfirm";
    private static final String COLLA_RULE = "collarule";
    private static final String IS_MANUAL_VERIFY = "ismanualverify";
    private static final String HR_ORG = "hrorgname";
    private static final String KEY_SCHCONFIG = "schconfig";
    private static final String MSGSUBSCRIBERID_CHANGED_CACHE_KEY = "msgsubscriberid_change";
    private static final String IS_CANCEL = "isCancel";
    private static final String CACHE_TASH_RULE_SCH_PLAN_PAGE_ID = "taskruleschplanpageId";
    private static final String IMMEDIATELY = "immediately";
    private static final String FORM_HPDI_TASK_RULE_SCH_PLAN = "hpdi_taskruleschplan";
    private static final String EXEC_PLAN_JSON = "execplanjson";
    private static final String STOP_EXEC_AFTER_FAIL = "stopexecafterfail";
    private static final String CACHE_IS_CREATE_PLAN_JOB = "istaskruleschplanvisable";
    private static final String CACHE_CHILD_DATA_JSON = "taskruleschplanjson";
    private static final String DONOTHING_CACHE_MODEL = "donothing_cachemodel";
    private static final String MSG_SUBSCRIBER_ID = "msgsubscriber.id";
    private static final String BIZ_TYPE = "biztype";
    private static final String COLLA_RULE_TYPE = "collaruletype";
    private static final Long PAYROLL_MANAGE_BIZ_TYPE = 107010L;
    private static final String PAYROLL_BASEDATA_TYPE = "hpdi_collarulesal";
    private static final Long SALARY_MANAGE_BIZ_TYPE = 107020L;
    private static final String SALARY_BASEDATA_TYPE = "hpdi_collarulecdm";
    private static final Long TAX_MANAGE_BIZ_TYPE = 107030L;
    private static final String TAX_BASEDATA_TYPE = "hpdi_collaruletax";
    private static final Long SOCIAL_MANAGE_BIZ_TYPE = 107050L;
    private static final String SOCIAL_BASEDATA_TYPE = "hpdi_collarulecsi";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setBarToolEnable(Boolean.TRUE);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                dynamicObject.set("executeseq", (Object)(i + 1));
            }
        }
        if (this.getView().getFormShowParameter().getCustomParam("tool_enable") != null && !CollectionUtils.isEmpty((Collection)entryentity)) {
            this.setBarToolEnable(Boolean.FALSE);
        }
        if (this.getModel().getValue(MSG_SUBSCRIBER) != null) {
            this.getPageCache().put(MSGSUBSCRIBERID_CACHE_KEY, this.getModel().getDataEntity().getString(MSG_SUBSCRIBER_ID));
        }
        this.setTaskDispatchVisable(this.getModel().getDataEntity().getBoolean(IMMEDIATELY), false);
        this.setAllPayrollActEnable();
    }

    public void afterBindData(EventObject evt) {
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{MSG_SUBSCRIBER});
        }
        this.refreshInfo();
    }

    private void refreshInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        String props = "id,name,number,entryentity,entryentity.payrollact,entryentity.payrollact.name,payrollactgtpl.bizapp.number,payrollactgtpl.bizapp.name,createorg.name";
        Map collaRuleDyMap = TaskRuleHelper.queryCollaRuleInfo((DynamicObjectCollection)entryEntity, (String)props);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            this.getView().setEnable(Boolean.valueOf(dynamicObject.getBoolean(IS_MANUAL_VERIFY)), i, new String[]{"verrangestr"});
            long collaRuleId = dynamicObject.getLong("collarule.id");
            String type = dynamicObject.getString(COLLA_RULE_TYPE);
            Map collaRuleMap = (Map)collaRuleDyMap.get(type);
            String bizAppNumber = "";
            String bizAppName = "";
            String payrollActName = "";
            String hrOrgName = "";
            if (collaRuleMap != null) {
                DynamicObject collaRuleDyDb = (DynamicObject)collaRuleMap.get(collaRuleId);
                this.getModel().setValue(COLLA_RULE, (Object)collaRuleDyDb, i);
                if (collaRuleDyDb != null) {
                    bizAppNumber = collaRuleDyDb.getString("payrollactgtpl.bizapp.number");
                    bizAppName = collaRuleDyDb.getString("payrollactgtpl.bizapp.name");
                    hrOrgName = collaRuleDyDb.getString("createorg.name");
                    DynamicObjectCollection actgEntities = collaRuleDyDb.getDynamicObjectCollection("entryentity");
                    if (!actgEntities.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        for (int j = 0; j < actgEntities.size(); ++j) {
                            if (j != 0) {
                                sb.append("; ");
                            }
                            sb.append(((DynamicObject)actgEntities.get(j)).getString("payrollact.name"));
                        }
                        payrollActName = sb.toString();
                        this.getModel().setValue("payrollact", (Object)payrollActName, i);
                    }
                }
            }
            this.getView().getModel().setValue("payrollact", (Object)payrollActName, i);
            this.getModel().setValue("bizappnumber", (Object)bizAppNumber, i);
            this.getModel().setValue("bizappname", (Object)bizAppName, i);
            this.getModel().setValue(HR_ORG, (Object)hrOrgName, i);
        }
        this.getModel().setDataChanged(false);
    }

    private void setSchConfigVisible(boolean isExeNow, boolean isPropChanged) {
        BasedataEdit control;
        this.getView().setVisible(Boolean.valueOf(!isExeNow), new String[]{KEY_SCHCONFIG});
        if (isExeNow && isPropChanged) {
            this.getModel().setValue(KEY_SCHCONFIG, null);
        }
        if ((control = (BasedataEdit)this.getView().getControl(KEY_SCHCONFIG)) != null) {
            control.setMustInput(!isExeNow);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{BAR_TOOL, BAR_ADD_PAYROLLACTG});
        BasedataEdit control = (BasedataEdit)this.getControl(COLLA_RULE);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgSub = (BasedataEdit)this.getControl(MSG_SUBSCRIBER);
        msgSub.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit schPlan = (BasedataEdit)this.getView().getControl(KEY_SCHCONFIG);
        if (schPlan != null) {
            schPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        super.afterAddRow(evt);
        if ("entryentity".equals(evt.getEntryProp().getName())) {
            this.refreshStopExecafterFail(evt);
        }
    }

    private void refreshStopExecafterFail(AfterAddRowEventArgs evt) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() < 2) {
            return;
        }
        DynamicObject firstData = (DynamicObject)entryEntity.get(0);
        RowDataEntity[] rowDataEntities = evt.getRowDataEntities();
        boolean stopExeValue = firstData.getBoolean(STOP_EXEC_AFTER_FAIL);
        for (RowDataEntity rowDataEntity : rowDataEntities) {
            this.getModel().setValue(STOP_EXEC_AFTER_FAIL, (Object)stopExeValue, rowDataEntity.getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String changedItem;
        switch (changedItem = evt.getProperty().getName()) {
            case "msgsubscriber": {
                this.handleMsgSubscriberChanged(evt);
                break;
            }
            case "immediately": {
                this.setTaskDispatchVisable((Boolean)evt.getChangeSet()[0].getNewValue(), true);
                break;
            }
            case "collarule": {
                this.refreshInfo();
                break;
            }
            case "biztype": {
                this.setPayrollActEnable(this.getModel().getEntryCurrentRowIndex("entryentity"), true);
                break;
            }
        }
    }

    private void setPayrollActEnable(int entryCurrentRowIndex, boolean isPropChange) {
        Object bizType = this.getModel().getValue(BIZ_TYPE, entryCurrentRowIndex);
        if (bizType == null) {
            this.getView().setEnable(Boolean.FALSE, entryCurrentRowIndex, new String[]{COLLA_RULE});
            this.getView().setEnable(Boolean.FALSE, entryCurrentRowIndex, new String[]{IS_MANUAL_VERIFY});
            this.getView().setEnable(Boolean.FALSE, entryCurrentRowIndex, new String[]{"verrangestr"});
        } else {
            this.getView().setEnable(Boolean.TRUE, entryCurrentRowIndex, new String[]{COLLA_RULE});
            this.getView().setEnable(Boolean.TRUE, entryCurrentRowIndex, new String[]{IS_MANUAL_VERIFY});
            this.getView().setEnable(Boolean.TRUE, entryCurrentRowIndex, new String[]{"verrangestr"});
            if (bizType instanceof DynamicObject) {
                DynamicObject bizTypeDy = (DynamicObject)bizType;
                long bizTypeId = bizTypeDy.getLong("id");
                String collaRuleType = TaskRuleHelper.getCollaRuleType((long)bizTypeId);
                if (StringUtils.isEmpty((CharSequence)collaRuleType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleEdit_8", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (!collaRuleType.equals(this.getModel().getValue(COLLA_RULE_TYPE, entryCurrentRowIndex))) {
                    this.getModel().setValue(COLLA_RULE_TYPE, (Object)collaRuleType, entryCurrentRowIndex);
                }
            }
        }
        if (isPropChange) {
            this.getModel().setValue(COLLA_RULE, null, entryCurrentRowIndex);
        }
    }

    private void setTaskDispatchVisable(boolean executeAfterCreateRule, boolean isPropChanged) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap1"});
        this.setSchConfigVisible(executeAfterCreateRule, isPropChanged);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String control;
        switch (control = beforeF7SelectEvent.getProperty().getName()) {
            case "collarule": {
                this.showF7TargetObjectList(beforeF7SelectEvent);
                break;
            }
            case "msgsubscriber": {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("subscribebd.id", "=", (Object)107010L));
                break;
            }
            case "schconfig": {
                this.schPlanF7(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.clearNullEnt();
                this.clearSchConfig();
                break;
            }
            case "audit": {
                this.preAuditValid(args, formOperate, opKey);
                break;
            }
            case "enable": {
                this.enableConfirm(args, formOperate);
                break;
            }
            case "disable": {
                formOperate.setConfirmMessage("1");
                this.disableConfirm(args, formOperate);
                break;
            }
            case "changesave": {
                this.clearSchConfig();
                break;
            }
            case "auditconfirmchange": {
                this.preAuditValid(args, formOperate, opKey);
                this.clearSchConfig();
                break;
            }
            case "newentry": {
                this.checkSubscriber(args);
                break;
            }
        }
    }

    private void checkSubscriber(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        if (view.getModel().getValue(MSG_SUBSCRIBER) == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201d\u3002", (String)"TaskRuleEdit_1", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            view.showTipNotification(msg);
            args.setCancel(true);
        }
    }

    private void clearNullEnt() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (null != ((DynamicObject)entryEntity.get(i)).get(COLLA_RULE)) continue;
            list.add(i);
        }
        int[] indexArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indexArray[i] = (Integer)list.get(i);
        }
        this.getModel().deleteEntryRows("entryentity", indexArray);
    }

    private void clearSchConfig() {
        if (this.getModel().getDataEntity().getBoolean(IMMEDIATELY)) {
            this.getModel().setValue(KEY_SCHCONFIG, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.getPageCache().put(MSGSUBSCRIBERID_CACHE_KEY, this.getModel().getDataEntity().getString(MSG_SUBSCRIBER_ID));
                break;
            }
            case "newentry": {
                this.setAllPayrollActEnable();
                this.reSortSeq();
                break;
            }
            case "deleteentry": 
            case "moveentryup": 
            case "moveentrydown": {
                this.reSortSeq();
                break;
            }
            case "audit": {
                break;
            }
            case "unsubmit": {
                break;
            }
        }
    }

    private void setAllPayrollActEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            this.setPayrollActEnable(index, false);
        }
    }

    private void reSortSeq() {
        DynamicObjectCollection entObjs = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entObjs.size(); ++i) {
            this.getModel().setValue("executeseq", (Object)(i + 1), i);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        OperateOption op = OperateOption.create();
        String result = evt.getResult().toString();
        switch (callBackId = evt.getCallBackId()) {
            case "auditafterconfirm": 
            case "auditconfirmchangeafterconfirm": {
                if (!result.equals("Yes")) break;
                op.setVariableValue(AFTER_CONFIRM, "true");
                this.getView().invokeOperation(callBackId.replace(AFTER_CONFIRM, ""), op);
                break;
            }
            case "enable_afterconfirm": {
                if (!result.equals("Yes")) break;
                op.setVariableValue(ENABLE_CONFIRM, "true");
                this.getView().invokeOperation("enable", op);
                break;
            }
            case "disable_afterconfirm": {
                if (!result.equals("Yes")) break;
                op.setVariableValue(DISABLE_PARAM_CONFIRM, "true");
                this.getView().invokeOperation("disable", op);
                break;
            }
            case "msgsubscriber_afterconfirm": {
                this.handleMsgSubscriberConfirm(evt);
                break;
            }
        }
    }

    private void showF7TargetObjectList(BeforeF7SelectEvent beforeF7SelectEvent) {
        IFormView view = this.getView();
        if (view.getModel().getValue(MSG_SUBSCRIBER) == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u201d\u3002", (String)"TaskRuleEdit_1", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            view.showTipNotification(msg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Object bizType = this.getModel().getValue(BIZ_TYPE, entryCurrentRowIndex);
        if (!(bizType instanceof DynamicObject)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u3002", (String)"TaskRuleEdit_7", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            view.showTipNotification(msg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        this.setListShowParameter(beforeF7SelectEvent, showParameter, (DynamicObject)bizType);
    }

    private void setListShowParameter(BeforeF7SelectEvent beforeF7SelectEvent, ListShowParameter showParameter, DynamicObject bizType) {
        QFilter filter1 = new QFilter("status", "=", (Object)"C");
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        long msgSubsriberId = this.getModel().getDataEntity().getLong(MSG_SUBSCRIBER_ID);
        QFilter filter3 = new QFilter(MSG_SUBSCRIBER_ID, "=", (Object)msgSubsriberId);
        long bizTypeId = bizType.getLong("id");
        String collaRuleType = TaskRuleHelper.getCollaRuleType((long)bizTypeId);
        if (StringUtils.isEmpty((CharSequence)collaRuleType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskRuleEdit_8", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
        QFilter createOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)collaRuleType, (Long)this.getModel().getDataEntity().getLong("createorg.id"));
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(filter1, filter2, filter3, createOrgFilter));
    }

    private void handleMsgSubscriberChanged(PropertyChangedArgs evt) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(IS_CANCEL))) {
            this.getPageCache().remove(IS_CANCEL);
            return;
        }
        DynamicObject newObj = (DynamicObject)evt.getChangeSet()[0].getNewValue();
        DynamicObject oldObj = (DynamicObject)evt.getChangeSet()[0].getOldValue();
        if (oldObj != null) {
            this.getPageCache().put(MSGSUBSCRIBERID_CHANGED_CACHE_KEY, String.valueOf(oldObj.getLong("id")));
        }
        if (newObj != null && oldObj != null) {
            long oldObjectId;
            long newObjectId = newObj.getLong("id");
            if (newObjectId != (oldObjectId = oldObj.getLong("id"))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u5c06\u6e05\u7a7a\u534f\u4f5c\u89c4\u5219\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRuleEdit_2", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MSG_SUBSCRIBER_CONFIRM, (IFormPlugin)this));
            }
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u5c06\u6e05\u7a7a\u534f\u4f5c\u89c4\u5219\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRuleEdit_2", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MSG_SUBSCRIBER_CONFIRM, (IFormPlugin)this));
        }
    }

    private void handleMsgSubscriberConfirm(MessageBoxClosedEvent evt) {
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getModel().deleteEntryData("entryentity");
        } else {
            this.getPageCache().put(IS_CANCEL, "true");
            String msgSubscriberId = this.getPageCache().get(MSGSUBSCRIBERID_CHANGED_CACHE_KEY);
            this.getModel().setValue(MSG_SUBSCRIBER, (Object)Long.valueOf(msgSubscriberId));
        }
    }

    private void enableConfirm(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        String formId = this.getFormId();
        DynamicObject selectObject = TaskRuleHelper.getTaskRuleById((Object)this.getModel().getValue("id"), (String)formId);
        SWCDataServiceHelper anotherHelper = new SWCDataServiceHelper(formId);
        DynamicObject anotherObject = TaskRuleHelper.getAnotherData((SWCDataServiceHelper)anotherHelper, (DynamicObject)selectObject, (String)"1");
        if (!formOperate.getOption().tryGetVariableValue(ENABLE_CONFIRM, new RefObject())) {
            String status = this.getModel().getDataEntity().getString("status");
            if (anotherObject != null && "C".equals(status)) {
                String name = selectObject.getString("createorg.name");
                String msgsubscriberName = selectObject.getString("msgsubscriber.name");
                String msg = ResManager.loadKDString((String)"{0}\u4e0b\u5b58\u5728\u201c{1}\u201d\u7684\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"TaskRuleEdit_5", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[]{name, msgsubscriberName});
                String submsg = ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"TaskRuleEdit_6", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showConfirm(msg, submsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ENABLE_CONFIRM));
                args.setCancel(true);
            }
        } else {
            anotherObject.set("enable", (Object)"0");
            anotherHelper.updateOne(anotherObject);
        }
    }

    private void disableConfirm(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        String formId = this.getFormId();
        DynamicObject selectObject = TaskRuleHelper.getTaskRuleById((Object)this.getModel().getValue("id"), (String)formId);
        if (selectObject == null) {
            return;
        }
        if (selectObject.getString("status").equals("A") || selectObject.getString("enable").equals("0")) {
            return;
        }
        if (!formOperate.getOption().tryGetVariableValue(DISABLE_PARAM_CONFIRM, new RefObject())) {
            SWCDataServiceHelper anotherHelper = new SWCDataServiceHelper(formId);
            DynamicObject anotherObject = TaskRuleHelper.getAnotherData((SWCDataServiceHelper)anotherHelper, (DynamicObject)selectObject, (String)"1");
            String status = this.getModel().getDataEntity().getString("status");
            if (anotherObject == null && "C".equals(status)) {
                String msg = ResManager.loadKDString((String)"\u7981\u7528\u8be5\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u540e\uff0c\u5bf9\u5e94\u7684\u8ba2\u9605\u6d88\u606f\u5c06\u65e0\u6cd5\u4f7f\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u3002\u662f\u5426\u7981\u7528\uff1f", (String)"TaskRuleEdit_4", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
                this.showConfirm(msg, DISABLE_PARAM_CONFIRM);
                args.setCancel(true);
            }
        }
    }

    private String getFormId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return "hpdi_taskrule";
        }
        return formId;
    }

    private void preAuditValid(BeforeDoOperationEventArgs args, FormOperate formOperate, String opKey) {
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM, new RefObject())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long selfId = dataEntity.getLong("boid");
        long msgsubscriberId = dataEntity.getLong(MSG_SUBSCRIBER_ID);
        long orgId = dataEntity.getLong("createorg.id");
        String name = dataEntity.getString("createorg.name");
        String msgsubscriberName = dataEntity.getString("msgsubscriber.name");
        if (TaskRuleHelper.isRuleExist((long)orgId, (long)msgsubscriberId, (long)selfId, (String)this.getFormId())) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"{0}\u4e0b\u5b58\u5728\u201c{1}\u201d\u7684\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"TaskRuleEdit_5", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[]{name, msgsubscriberName});
            String submsg = ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"TaskRuleEdit_6", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, submsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(opKey + AFTER_CONFIRM));
        }
    }

    private void showConfirm(String msg, String confirmListener) {
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(confirmListener));
    }

    private void setBarToolEnable(Boolean flag) {
        this.getView().setEnable(flag, new String[]{BAR_TOOL, BAR_ADD_PAYROLLACTG, BAR_ADD_ADDENTRY, BAR_ADD_DELETEENTRY});
    }

    private void schPlanF7(BeforeF7SelectEvent event) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        long sysPresetId = SwcBizSchConfigConstants.PRE_DATA_TASK_RULE;
        if (!"hpdi_taskrule".equals(this.getFormId())) {
            sysPresetId = SwcBizSchConfigConstants.PRE_DATA_TASK_ARRANGE;
        }
        qFilter.and("useobj", "=", (Object)sysPresetId);
        param.getListFilterParameter().setFilter(qFilter);
    }
}

