/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class TaskRuleExportList
extends SWCDataBaseList
implements HRExportPlugin {
    public void afterQueryData(AfterQueryDataEventArgs args) {
        super.afterQueryData(args);
        List dataList = args.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        HashMap idMap = new HashMap(16);
        for (DynamicObject data : dataList) {
            TaskRuleHelper.getCollaRuleIdByType(idMap, (DynamicObject)data);
        }
        String props = "entryentity,entryentity.payrollact,entryentity.payrollact.name,payrollactgtpl.bizapp.name,createorg.name";
        Map payRollActMap = TaskRuleHelper.queryCollaRuleInfo(idMap, (String)props);
        if (CollectionUtils.isEmpty((Map)payRollActMap)) {
            return;
        }
        for (DynamicObject dynamicObject : dataList) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                DynamicObject queryData;
                String conditions = object.getString("ruledesign.conditions");
                object.set("verrangestr", (Object)TaskRuleHelper.formatRuleConditionInfo((String)conditions));
                String type = object.getString("collaruletype");
                long tempId = object.getLong("collarule.id");
                Map payRollActGroupData = (Map)payRollActMap.get(type);
                if (payRollActGroupData == null || (queryData = (DynamicObject)payRollActGroupData.get(tempId)) == null) continue;
                object.set("bizappname", (Object)queryData.getString("payrollactgtpl.bizapp.name"));
                String payRollActNames = queryData.getDynamicObjectCollection("entryentity").stream().map(item -> item.getString("payrollact.name")).collect(Collectors.joining(";"));
                object.set("payrollact", (Object)payRollActNames);
                object.set("hrorgname", (Object)queryData.getString("createorg.name"));
            }
        }
    }
}

