/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class TaskRuleImportList
extends SWCDataBaseList
implements HRImportPlugin {
    private static final Log log = LogFactory.getLog(TaskRuleImportList.class);

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        log.info("TaskRuleImportList.beforeCallOperation...begin...");
        super.beforeCallOperation(args);
        DynamicObject[] dynamicObjects = (DynamicObject[])args.getDynamicObjects();
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            String props = "id,name,number,entryentity,entryentity.payrollact,entryentity.payrollact.name,payrollactgtpl.bizapp.number,payrollactgtpl.bizapp.name,createorg.name";
            Map collaRuleDyMap = TaskRuleHelper.queryCollaRuleInfo((DynamicObjectCollection)entryEntity, (String)props);
            String verNumber = "HDD-" + SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSSS");
            HashMap<String, String> appVerRlsMap = new HashMap<String, String>(16);
            for (DynamicObject entry : entryEntity) {
                String type = entry.getString("collaruletype");
                Map collaRuleMap = (Map)collaRuleDyMap.get(type);
                long collaRuleId = entry.getLong("collarule.id");
                DynamicObject collaRuleDyDb = (DynamicObject)collaRuleMap.get(collaRuleId);
                entry.set("bizappnumber", (Object)collaRuleDyDb.getString("payrollactgtpl.bizapp.number"));
                entry.set("bizappname", (Object)collaRuleDyDb.getString("payrollactgtpl.bizapp.name"));
                Boolean isManualVerify = entry.getBoolean("ismanualverify");
                String verifyNumber = entry.getString("verifynumber");
                String bizAppNumber = entry.getString("bizappnumber");
                if (!isManualVerify.booleanValue() || !SWCStringUtils.isNotEmpty((String)verifyNumber)) continue;
                appVerRlsMap.putIfAbsent(bizAppNumber, verifyNumber);
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryDyObj = (DynamicObject)entryEntity.get(i);
                entryDyObj.set("executeseq", (Object)(i + 1));
                long bizTypeId = entryDyObj.getLong("biztype.id");
                String baseDataType = TaskRuleHelper.getCollaRuleType((long)bizTypeId);
                entryDyObj.set("collaruletype", (Object)baseDataType);
                Boolean isManualVerify = entryDyObj.getBoolean("ismanualverify");
                String verifyNumber = entryDyObj.getString("verifynumber");
                String bizAppNumber = entryDyObj.getString("bizappnumber");
                if (!isManualVerify.booleanValue() && SWCStringUtils.isNotEmpty((String)verifyNumber)) {
                    entryDyObj.set("verifynumber", (Object)" ");
                }
                String verNumberExcel = (String)appVerRlsMap.get(bizAppNumber);
                if (isManualVerify.booleanValue() && SWCStringUtils.isNotEmpty((String)verNumberExcel)) {
                    entryDyObj.set("verifynumber", (Object)verNumberExcel);
                    verifyNumber = verNumberExcel;
                }
                if (!isManualVerify.booleanValue() || !SWCStringUtils.isEmpty((String)verifyNumber)) continue;
                entryDyObj.set("verifynumber", (Object)verNumber);
            }
        }
        log.info("TaskRuleImportList.beforeCallOperation...end...");
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        log.info("TaskRuleImportList.beforeValidate...begin...");
        super.beforeValidate(args);
        List billDatas = args.getBillDatas();
        if (billDatas == null) {
            return;
        }
        String mainEntityId = this.getEntityId(billDatas);
        Map<String, String> comboKeyValue = this.getCollaRuleTypeCombo(mainEntityId);
        Map<String, Long> bizTypeIdMap = this.queryAllBizTypeNumberAndId();
        for (ImportBillData billData : billDatas) {
            JSONArray jsonArray;
            JSONObject jsonObject;
            JSONObject data;
            if (billData == null || billData.getData() == null || !((data = billData.getData()).get((Object)mainEntityId) instanceof JSONObject) || (jsonObject = (JSONObject)data.get((Object)mainEntityId)) == null || (jsonArray = jsonObject.getJSONArray("entryentity")) == null) continue;
            for (Object obj : jsonArray) {
                if (!(obj instanceof JSONObject)) continue;
                JSONObject entryJson = (JSONObject)obj;
                JSONObject bizType = entryJson.getJSONObject("biztype");
                if (bizType != null) {
                    String baseDataType;
                    String baseDataTypeName;
                    String number = bizType.getString("number");
                    Long bizTypeId = bizTypeIdMap.get(number);
                    if (bizTypeId == null) {
                        bizTypeId = 0L;
                    }
                    if (StringUtils.isEmpty((CharSequence)(baseDataTypeName = comboKeyValue.get(baseDataType = TaskRuleHelper.getCollaRuleType((long)bizTypeId))))) {
                        baseDataTypeName = comboKeyValue.get("hpdi_collarulesal");
                    }
                    entryJson.put("collaruletype", (Object)baseDataTypeName);
                    continue;
                }
                entryJson.put("collaruletype", (Object)comboKeyValue.get("hpdi_collarulesal"));
            }
        }
        log.info("TaskRuleImportList.beforeValidate...end...");
    }

    private String getEntityId(List<ImportBillData> billDatas) {
        if (billDatas == null) {
            return "hpdi_taskrule";
        }
        for (ImportBillData billData : billDatas) {
            if (billData == null || billData.getData() == null) continue;
            String mainEntityId = billData.getMainEntityId();
            if (StringUtils.isEmpty((CharSequence)mainEntityId)) {
                mainEntityId = "hpdi_taskrule";
            }
            return mainEntityId;
        }
        return "hpdi_taskrule";
    }

    private Map<String, String> getCollaRuleTypeCombo(String mainEntityId) {
        HashMap<String, String> comboKeyValue = new HashMap<String, String>(16);
        try {
            List comboItems = new ArrayList(10);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainEntityId);
            EntityType entityType = (EntityType)mainType.getAllEntities().get("entryentity");
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                ItemClassTypeProp itemTypeProp;
                if (!(property instanceof ItemClassTypeProp) || !"collaruletype".equals((itemTypeProp = (ItemClassTypeProp)property).getName())) continue;
                comboItems = itemTypeProp.getComboItems();
                break;
            }
            for (ValueMapItem comboItem : comboItems) {
                comboKeyValue.put(comboItem.getValue(), comboItem.getName().getLocaleValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return comboKeyValue;
    }

    private Map<String, Long> queryAllBizTypeNumberAndId() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hbss_bussinessfield");
        DynamicObjectCollection bizTypeDyColl = helper.queryOriginalCollection("id,number", new QFilter("1", "=", (Object)1).toArray());
        HashMap<String, Long> bizTypeIdMap = new HashMap<String, Long>(16);
        if (bizTypeDyColl != null && !bizTypeDyColl.isEmpty()) {
            for (DynamicObject bizTypeDy : bizTypeDyColl) {
                bizTypeIdMap.put(bizTypeDy.getString("number"), bizTypeDy.getLong("id"));
            }
        }
        return bizTypeIdMap;
    }
}

