/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.swc.hpdi.business.basedata.TaskRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class TaskRuleList
extends AbstractListPlugin {
    private static final String SWC_HPDI_FORMPLUGIN = "swc-hpdi-formplugin";
    private static final String DISABLE_PARAM_CONFIRM = "disable_afterconfirm";
    private static final String ENABLE_CONFIRM = "enable_afterconfirm";
    private static final String AUDIT_CONFIRM = "audit_afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectIds = listView.getSelectedRows();
        Object[] primaryKeys = selectIds.getPrimaryKeyValues();
        switch (opKey) {
            case "audit": {
                this.preAuditValid(args, formOperate, primaryKeys);
                break;
            }
            case "enable": {
                this.enableConfirm(args, formOperate, primaryKeys);
                break;
            }
            case "disable": {
                this.disableConfirm(args, formOperate, primaryKeys);
                break;
            }
        }
    }

    private void preAuditValid(BeforeDoOperationEventArgs args, FormOperate formOperate, Object[] primaryKeys) {
        DynamicObject[] dataEntitys;
        if (formOperate.getOption().tryGetVariableValue(AUDIT_CONFIRM, new RefObject())) {
            return;
        }
        if (primaryKeys.length > 1) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6838\u65f6\uff0c\u5c06\u7981\u7528\u76f8\u540c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u548c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u4e0b\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6570\u636e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRuleList_4", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(AUDIT_CONFIRM));
            return;
        }
        String billFormId = this.getBillFormId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billFormId);
        for (DynamicObject dataEntity : dataEntitys = helper.query(primaryKeys)) {
            long selfId = dataEntity.getLong("boid");
            long msgsubscriberId = dataEntity.getLong("msgsubscriber.id");
            long orgId = dataEntity.getLong("createorg.id");
            String name = dataEntity.getString("createorg.name");
            String msgsubscriberName = dataEntity.getString("msgsubscriber.name");
            if (!TaskRuleHelper.isRuleExist((long)orgId, (long)msgsubscriberId, (long)selfId, (String)billFormId)) continue;
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"{0}\u4e0b\u5b58\u5728\u201d{1}\u201d\u7684\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"TaskRuleList_5", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[]{name, msgsubscriberName});
            String submsg = ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"TaskRuleList_6", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, submsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(AUDIT_CONFIRM));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        OperateOption op = OperateOption.create();
        String result = evt.getResult().toString();
        if ("Yes".equals(result)) {
            String callBackId;
            switch (callBackId = evt.getCallBackId()) {
                case "audit_afterconfirm": {
                    op.setVariableValue(AUDIT_CONFIRM, "true");
                    this.getView().invokeOperation("audit", op);
                    break;
                }
                case "enable_afterconfirm": {
                    op.setVariableValue(ENABLE_CONFIRM, "true");
                    this.getView().invokeOperation("enable", op);
                    break;
                }
                case "disable_afterconfirm": {
                    op.setVariableValue(DISABLE_PARAM_CONFIRM, "true");
                    this.getView().invokeOperation("disable", op);
                    break;
                }
            }
        }
    }

    private void enableConfirm(BeforeDoOperationEventArgs args, FormOperate formOperate, Object[] primaryKeys) {
        if (formOperate.getOption().tryGetVariableValue(ENABLE_CONFIRM, new RefObject())) {
            return;
        }
        if (primaryKeys.length > 1) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6279\u91cf\u542f\u7528\u65f6\uff0c\u5c06\u7981\u7528\u76f8\u540c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u548c\u5df2\u8ba2\u9605\u4e1a\u52a1\u4e8b\u4ef6\u4e0b\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6570\u636e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaskRuleList_3", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ENABLE_CONFIRM));
            return;
        }
        String billFormId = this.getBillFormId();
        DynamicObject selectObject = TaskRuleHelper.getTaskRuleById((Object)primaryKeys[0], (String)billFormId);
        SWCDataServiceHelper anotherHelper = new SWCDataServiceHelper(billFormId);
        DynamicObject anotherObject = TaskRuleHelper.getAnotherData((SWCDataServiceHelper)anotherHelper, (DynamicObject)selectObject, (String)"1");
        String status = selectObject.getString("status");
        if (anotherObject != null && "C".equals(status)) {
            String name = selectObject.getString("createorg.name");
            String msgsubscriberName = selectObject.getString("msgsubscriber.name");
            String msg = ResManager.loadKDString((String)"{0}\u4e0b\u5b58\u5728\u201d{1}\u201d\u7684\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u6570\u636e\uff0c\u662f\u5426\u66ff\u6362\uff1f", (String)"TaskRuleList_5", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[]{name, msgsubscriberName});
            String submsg = ResManager.loadKDString((String)"\u88ab\u66ff\u6362\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u7981\u7528\uff0c\u4e0d\u53ef\u518d\u88ab\u4f7f\u7528\u3002", (String)"TaskRuleList_6", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(msg, submsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ENABLE_CONFIRM));
            args.setCancel(true);
        }
    }

    private String getBillFormId() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (StringUtils.isEmpty((CharSequence)billFormId)) {
            return "hpdi_taskrule";
        }
        return billFormId;
    }

    private void disableConfirm(BeforeDoOperationEventArgs args, FormOperate formOperate, Object[] primaryKeys) {
        DynamicObject[] selectObject;
        for (DynamicObject taskRule : selectObject = TaskRuleHelper.getTaskRuleByIds(Arrays.asList(primaryKeys), (String)this.getBillFormId())) {
            if ("C".equals(taskRule.getString("status")) && !taskRule.getString("enable").equals("0")) continue;
            return;
        }
        if (!formOperate.getOption().tryGetVariableValue(DISABLE_PARAM_CONFIRM, new RefObject())) {
            String msg = ResManager.loadKDString((String)"\u7981\u7528\u8be5\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u540e\uff0c\u5bf9\u5e94\u7684\u8ba2\u9605\u6d88\u606f\u5c06\u65e0\u6cd5\u4f7f\u7528\u534f\u4f5c\u4efb\u52a1\u7f16\u6392\u3002\u662f\u5426\u7981\u7528\uff1f", (String)"TaskRuleList_0", (String)SWC_HPDI_FORMPLUGIN, (Object[])new Object[0]);
            this.showConfirm(msg, DISABLE_PARAM_CONFIRM);
            args.setCancel(true);
        }
    }

    private void showConfirm(String msg, String confirmListener) {
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(confirmListener));
    }
}

