/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaskRuleVerConfEdit
extends AbstractBasePlugIn {
    private static final String VER_PREFIX = "flexverbillcardone";
    private static final String CACHE_VISIBLE = "_visible";
    private static final String CACHE_CLICK = "_click";
    private static final String CACHE_NEWVERFLEXINDEX = "newVerFlexIndex";
    private static final String CACHE_MANUALVERAPPS = "manualverapps";
    private static final String VERNUMBER_PREFIX = "lbverbillcardoup";
    private static final String VER_APP_PREFIX = "flexverbillcardoapp";
    private static final String VER_APP_ADD_PREFIX = "flexverbillcardoappadd";
    private static final String VER_APP_VEC_PREFIX = "vecverbillcardoapp";
    private static final String VER_APP_ADD_VEC_PREFIX = "vecverbillcardoappadd";
    private static final String VER_APP_ADD_LB_PREFIX = "lbverbillcardoappadd";
    private static final String[] ALL_APPS = new String[]{"hsas", "hcdm", "itc", "hcsi"};
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vecverbillcardoappadd1", "vecverbillcardoappadd2", "vecverbillcardoappadd3", "vecverbillcardoappadd4"});
        this.addClickListeners(new String[]{"lbverbillcardoappadd1", "lbverbillcardoappadd2", "lbverbillcardoappadd3", "lbverbillcardoappadd4"});
        for (String app : ALL_APPS) {
            this.addClickListeners(new String[]{VER_APP_VEC_PREFIX + app + "_" + 1});
            this.addClickListeners(new String[]{VER_APP_VEC_PREFIX + app + "_" + 2});
            this.addClickListeners(new String[]{VER_APP_VEC_PREFIX + app + "_" + 3});
            this.addClickListeners(new String[]{VER_APP_VEC_PREFIX + app + "_" + 4});
        }
    }

    public void click(EventObject evt) {
        String labelKey;
        Label curClickLabel;
        if (evt.getSource() instanceof Label) {
            curClickLabel = (Label)evt.getSource();
            labelKey = curClickLabel.getKey();
            this.getPageCache().put("flexverbillcardone_click", labelKey.replaceAll(VER_APP_ADD_LB_PREFIX, ""));
        }
        if (evt.getSource() instanceof Vector) {
            curClickLabel = (Vector)evt.getSource();
            labelKey = curClickLabel.getKey();
            if (labelKey.contains(VER_APP_ADD_VEC_PREFIX)) {
                this.getPageCache().put("flexverbillcardone_click", labelKey.replaceAll(VER_APP_ADD_VEC_PREFIX, ""));
            } else if (labelKey.contains(VER_APP_VEC_PREFIX)) {
                String appAndIndex = labelKey.replaceAll(VER_APP_VEC_PREFIX, "");
                String[] appAndIndexArr = appAndIndex.split("_");
                String appNumber = appAndIndexArr[0];
                String verIndex = appAndIndexArr[1];
                ArrayList<String> apps = new ArrayList<String>(2);
                apps.add(appNumber);
                this.verRemoveApp(verIndex, apps, "deleteapp");
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.refreshVerifyBill();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (fieldKey) {
            case "collarule": {
                this.getModel().setValue("ismanualverify", (Object)Boolean.FALSE);
                break;
            }
            case "ismanualverify": {
                if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
                    this.sameAppSetVerifyNumber();
                }
                this.setAndGetManualVerApps();
                this.refreshVerifyBill();
                break;
            }
        }
    }

    private void sameAppSetVerifyNumber() {
        Long id = this.getModel().getDataEntity().getLong("id");
        Long boid = this.getModel().getDataEntity().getLong("boid");
        String createtimeVerNumber = this.generateVerNumber(this.getModel().getDataEntity().getDate("createtime"));
        HashMap<String, String> appVerNumRlsMap = new HashMap<String, String>(6);
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (DynamicObject entry : entryentitys) {
            String bizAppNumber = entry.getString("bizappnumber");
            String verifyNumber = entry.getString("verifynumber");
            if (!SWCStringUtils.isNotEmpty((String)verifyNumber)) continue;
            appVerNumRlsMap.put(bizAppNumber, verifyNumber);
        }
        for (DynamicObject entry : entryentitys) {
            Boolean isManualVerify = entry.getBoolean("ismanualverify");
            String bizAppNumber = entry.getString("bizappnumber");
            String verifyNumber = entry.getString("verifynumber");
            if (!isManualVerify.booleanValue() || !SWCStringUtils.isEmpty((String)verifyNumber)) continue;
            String newVerifyNumber = (String)appVerNumRlsMap.get(bizAppNumber);
            if (SWCStringUtils.isEmpty((String)newVerifyNumber)) {
                newVerifyNumber = !(id != null && id != 0L || boid != null && boid != 0L) ? createtimeVerNumber : this.generateVerNumber(new Date());
            }
            entry.set("verifynumber", (Object)newVerifyNumber);
        }
    }

    private Set<String> setAndGetManualVerApps() {
        HashSet<String> appNumbers = new HashSet<String>(16);
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (DynamicObject entry : entryentitys) {
            Boolean isManualVerify = entry.getBoolean("ismanualverify");
            String bizAppNumber = entry.getString("bizappnumber");
            String verifyNumber = entry.getString("verifynumber");
            if (isManualVerify.booleanValue()) {
                appNumbers.add(bizAppNumber);
            }
            if (isManualVerify.booleanValue() || !SWCStringUtils.isNotEmpty((String)verifyNumber)) continue;
            entry.set("verifynumber", (Object)"");
            boolean isHasManual = false;
            for (DynamicObject entry2 : entryentitys) {
                Boolean isManualVerify2 = entry2.getBoolean("ismanualverify");
                String string = entry2.getString("bizappnumber");
                if (!isManualVerify2.booleanValue() || !string.equals(bizAppNumber)) continue;
                isHasManual = true;
                break;
            }
            if (isHasManual) continue;
            Map<String, String> indexVerNumRlsMap = this.getIndexVerNumRlsMap();
            String verIndex = null;
            for (Map.Entry entry2 : indexVerNumRlsMap.entrySet()) {
                if (!verifyNumber.equals(entry2.getValue())) continue;
                verIndex = (String)entry2.getKey();
                break;
            }
            ArrayList<String> apps = new ArrayList<String>(1);
            apps.add(bizAppNumber);
            this.verRemoveApp(verIndex, apps, "deleteapp");
        }
        this.getView().updateView(KEY_ENTRYENTITY);
        this.getPageCache().put(CACHE_MANUALVERAPPS, ((Object)appNumbers).toString());
        return appNumbers;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": {
                this.getPageCache().remove(CACHE_NEWVERFLEXINDEX);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        switch (opKey = formOperate.getOperateKey()) {
            case "donothing_createverifybill": {
                this.createVerifyBill();
                break;
            }
            case "donothing_receiveverifyconfdata": {
                this.receiveVerifyConfData(option);
                break;
            }
            case "deleteentry": {
                this.refreshVerifyBill();
                break;
            }
        }
    }

    private void receiveVerifyConfData(OperateOption option) {
        String verIndex = option.getVariableValue("verIndex", "-1");
        String hsas = option.getVariableValue("hsas", "false");
        String hcdm = option.getVariableValue("hcdm", "false");
        String itc = option.getVariableValue("itc", "false");
        String hcsi = option.getVariableValue("hcsi", "false");
        ArrayList<String> apps = new ArrayList<String>(4);
        if ("true".equals(hsas)) {
            apps.add("hsas");
        }
        if ("true".equals(hcdm)) {
            apps.add("hcdm");
        }
        if ("true".equals(itc)) {
            apps.add("itc");
        }
        if ("true".equals(hcsi)) {
            apps.add("hcsi");
        }
        this.verAddApp(verIndex, apps, "receiveadd");
        for (int i = 1; i <= 4; ++i) {
            if (verIndex.equals(String.valueOf(i))) continue;
            this.verRemoveApp(String.valueOf(i), apps, "receiveaddRemoveOtherApp");
        }
    }

    private void createVerifyBill() {
        int showFlexNum = 0;
        Map<String, String> indexVerNumRlsMap = this.getIndexVerNumRlsMap();
        String newVerFlexIndex = this.getPageCache().get(CACHE_NEWVERFLEXINDEX);
        if (SWCStringUtils.isEmpty((String)newVerFlexIndex)) {
            newVerFlexIndex = "";
        }
        for (int i = 1; i <= 4; ++i) {
            String cacheVisibleApp = this.getPageCache().get("flexverbillcardone_visible" + i);
            if (cacheVisibleApp == null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{VER_PREFIX + i});
                String verNumber = this.generateVerNumber(new Date());
                Label label = (Label)this.getControl(VERNUMBER_PREFIX + i);
                label.setText(verNumber);
                indexVerNumRlsMap.put(String.valueOf(i), verNumber);
                for (int j = 0; j < ALL_APPS.length; ++j) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{VER_APP_PREFIX + ALL_APPS[j] + i});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{VER_APP_ADD_PREFIX + i});
                this.getPageCache().put("flexverbillcardone_visible" + i, " ");
                this.getPageCache().put("flexverbillcardonelbverbillcardoup", SerializationUtils.serializeToBase64(indexVerNumRlsMap));
                newVerFlexIndex = newVerFlexIndex + i;
                this.getPageCache().put(CACHE_NEWVERFLEXINDEX, newVerFlexIndex);
                break;
            }
            ++showFlexNum;
        }
        if (showFlexNum == 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5b9a\u5355\u5df2\u8fbe\u6700\u5927\u4e2a\u6570\uff0c\u7ee7\u7eed\u5728\u6838\u5b9a\u5355\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u5373\u53ef\u3002", (String)"TaskRuleVerConfEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        }
    }

    private String generateVerNumber(Date date) {
        return "HDD-" + SWCDateTimeUtils.format((Date)date, (String)"yyyyMMddHHmmssSSSS");
    }

    private void verAddApp(String verIndex, List<String> apps, String opType) {
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        Map<String, String> indexVerNumRlsMap = this.getIndexVerNumRlsMap();
        String cacheVisibleApp = "";
        for (int j = 0; j < ALL_APPS.length; ++j) {
            String appNumber = ALL_APPS[j];
            if (apps.contains(appNumber)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{VER_APP_PREFIX + appNumber + verIndex});
                cacheVisibleApp = cacheVisibleApp + appNumber;
                if (!"receiveadd".equals(opType)) continue;
                for (DynamicObject entry : entryentitys) {
                    Boolean isManualVerify = entry.getBoolean("ismanualverify");
                    String bizappNumber = entry.getString("bizappnumber");
                    if (!isManualVerify.booleanValue() || !appNumber.equals(bizappNumber)) continue;
                    entry.set("verifynumber", (Object)indexVerNumRlsMap.get(verIndex));
                }
                String newVerFlexIndex = this.getPageCache().get(CACHE_NEWVERFLEXINDEX);
                newVerFlexIndex = newVerFlexIndex == null ? "" : newVerFlexIndex.replaceAll(verIndex, "");
                this.getPageCache().put(CACHE_NEWVERFLEXINDEX, newVerFlexIndex);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{VER_APP_PREFIX + appNumber + verIndex});
        }
        this.getView().updateView(KEY_ENTRYENTITY);
        Set<String> appNumbers = this.setAndGetManualVerApps();
        if (apps.size() == appNumbers.size()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VER_APP_ADD_PREFIX + verIndex});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{VER_APP_ADD_PREFIX + verIndex});
        }
        this.getPageCache().put("flexverbillcardone_visible" + verIndex, cacheVisibleApp);
    }

    private void verRemoveApp(String verIndex, List<String> apps, String opType) {
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        String cacheVisibleApp = this.getPageCache().get("flexverbillcardone_visible" + verIndex);
        if (verIndex == null || cacheVisibleApp == null) {
            return;
        }
        for (String appNumber : apps) {
            if (!cacheVisibleApp.contains(appNumber)) continue;
            cacheVisibleApp = cacheVisibleApp.replace(appNumber, "");
            this.getView().setVisible(Boolean.FALSE, new String[]{VER_APP_PREFIX + appNumber + verIndex});
            if (!"deleteapp".equals(opType)) continue;
            for (DynamicObject entry : entryentitys) {
                String bizappNumber = entry.getString("bizappnumber");
                if (!appNumber.equals(bizappNumber)) continue;
                entry.set("verifynumber", (Object)"");
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{VER_APP_ADD_PREFIX + verIndex});
        this.getView().updateView(KEY_ENTRYENTITY);
        this.getPageCache().put("flexverbillcardone_visible" + verIndex, cacheVisibleApp);
        if (SWCStringUtils.isEmpty((String)cacheVisibleApp.trim())) {
            this.refreshVerifyBill();
        }
    }

    private void refreshVerifyBill() {
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        LinkedHashMap<String, Object> confs = new LinkedHashMap<String, Object>(6);
        ArrayList entryentitysNew = new ArrayList(entryentitys.size());
        entryentitysNew.addAll(entryentitys);
        entryentitysNew.sort((o1, o2) -> {
            String verifyNumber1 = o1.getString("bizappnumber");
            String verifyNumber2 = o2.getString("verifynumber");
            if (SWCStringUtils.isEmpty((String)verifyNumber1) || SWCStringUtils.isEmpty((String)verifyNumber2)) {
                return 0;
            }
            return verifyNumber1.compareTo(verifyNumber2);
        });
        boolean isShowVerConf = false;
        for (DynamicObject entry : entryentitysNew) {
            Boolean isManualVerify = entry.getBoolean("ismanualverify");
            if (isManualVerify.booleanValue()) {
                isShowVerConf = true;
            }
            String bizappNumber = entry.getString("bizappnumber");
            String verifyNumber = entry.getString("verifynumber");
            if (SWCStringUtils.isEmpty((String)verifyNumber)) continue;
            ArrayList<String> apps = (ArrayList<String>)confs.get(verifyNumber);
            if (apps == null) {
                apps = new ArrayList<String>(4);
                confs.put(verifyNumber, apps);
            }
            if (apps.contains(bizappNumber)) continue;
            apps.add(bizappNumber);
        }
        this.getView().setVisible(Boolean.valueOf(isShowVerConf), new String[]{"flexverifybill"});
        Map<String, String> indexVerNumRlsMap = this.getIndexVerNumRlsMap();
        String newVerFlexIndex = this.getPageCache().get(CACHE_NEWVERFLEXINDEX);
        int maxNewVerFlexNum = 4 - confs.size();
        int newVerFlexNum = 0;
        for (int k = 1; k <= 4; ++k) {
            if (newVerFlexIndex == null || !newVerFlexIndex.contains(String.valueOf(k))) continue;
            if (newVerFlexNum + 1 > maxNewVerFlexNum) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VER_PREFIX + k});
                this.getPageCache().remove("flexverbillcardone_visible" + k);
                newVerFlexIndex = newVerFlexIndex.replaceAll(String.valueOf(k), "");
                this.getPageCache().put(CACHE_NEWVERFLEXINDEX, newVerFlexIndex);
                continue;
            }
            ++newVerFlexNum;
        }
        int i = 0;
        for (Map.Entry entry : confs.entrySet()) {
            ++i;
            List apps = (List)entry.getValue();
            if (newVerFlexIndex != null && newVerFlexIndex.contains(String.valueOf(i)) && newVerFlexIndex.contains(String.valueOf(++i)) && newVerFlexIndex.contains(String.valueOf(++i))) {
                ++i;
            }
            if (i > 4) break;
            this.getView().setVisible(Boolean.TRUE, new String[]{VER_PREFIX + i});
            Label label = (Label)this.getControl(VERNUMBER_PREFIX + i);
            label.setText((String)entry.getKey());
            indexVerNumRlsMap.put(String.valueOf(i), (String)entry.getKey());
            this.verAddApp(String.valueOf(i), apps, "refresh");
        }
        for (int k = i + 1; k <= 4; ++k) {
            if (newVerFlexIndex != null && newVerFlexIndex.contains(String.valueOf(k))) continue;
            this.getView().setVisible(Boolean.FALSE, new String[]{VER_PREFIX + k});
            this.getPageCache().remove("flexverbillcardone_visible" + k);
        }
        this.getPageCache().put("flexverbillcardonelbverbillcardoup", SerializationUtils.serializeToBase64(indexVerNumRlsMap));
    }

    private Map<String, String> getIndexVerNumRlsMap() {
        String indexVerNumRlsMapStr = this.getPageCache().get("flexverbillcardonelbverbillcardoup");
        Map<String, String> indexVerNumRlsMap = new HashMap<String, String>(2);
        if (indexVerNumRlsMapStr != null) {
            indexVerNumRlsMap = (Map)SerializationUtils.deSerializeFromBase64((String)indexVerNumRlsMapStr);
        }
        return indexVerNumRlsMap;
    }
}

