/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata.cloudcolla;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class PayRollActGrpEdit
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpEdit.class);
    public static final String RULE_ENGINE_DATA_MODE = "ruleEngineDataMode";
    public static final String CONFIRM_CALLBACK_SCENE_CHANGED = "CONFIRM_CALLBACK_SCENE_CHANGED";
    public static final String CALLBACK_CTRLSTRATEGY_CHANGED = "CALLBACK_CTRLSTRATEGY_CHANGED";
    public static final String CALLBACK_RELOAD_MAP_RULE_TREE = "CALLBACK_RELOAD_MAP_RULE_TREE";
    public static final String PAYROLLACTGTPL = "payrollactgtpl";

    private OperationStatus getPageStatus() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String string = this.getModel().getDataEntity().getString("status");
        boolean isHaveModifyPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)formId, (String)"4715a0df000000ac");
        OperationStatus pageStatus = this.getView().getFormShowParameter().getStatus();
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isChange");
            if (isChange != null && isChange.booleanValue() && (isHaveModifyPerm || OperationStatus.ADDNEW.equals((Object)pageStatus))) {
                return OperationStatus.ADDNEW;
            }
            String dataStatus = this.getModel().getDataEntity().getString("datastatus");
            if ("-3".equals(dataStatus) && (isHaveModifyPerm || OperationStatus.ADDNEW.equals((Object)pageStatus))) {
                return OperationStatus.ADDNEW;
            }
            return OperationStatus.VIEW;
        }
        if (!"A".equalsIgnoreCase(string) || !isHaveModifyPerm && !OperationStatus.ADDNEW.equals((Object)pageStatus)) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.ADDNEW;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        long orgId = RequestContext.getOrCreate().getOrgId();
        this.getModel().setValue("createorg", (Object)orgId);
        this.getModel().setValue("policy", null);
        this.createExePreRuleCache();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.reloadPayRollActgTplData(dataEntity.getDynamicObject(PAYROLLACTGTPL));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.getBoolean((Map)customParams, (Object)"isChange", (Boolean)Boolean.FALSE).booleanValue()) {
            this.createExePreRuleCache();
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getModel().setItemValueByNumber("bizapp", "hsas");
        this.getModel().setDataChanged(false);
        this.reloadExePreRuleDesignCache();
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"msgsubscriber"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("ruledesignstr".equals(key)) {
            evt.setCancel(this.validateBeforePopRuleDesign());
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        try {
            switch (fieldKey) {
                case "payrollactgtpl": {
                    this.payRollActGrpTplPropertyChanged(event);
                    break;
                }
                case "msgsubscriber": {
                    break;
                }
                case "payrollact": {
                    this.abstractSortEntryEntity();
                    break;
                }
                case "ruledesignstr": {
                    this.clearExePreRuleDesignData(event);
                    break;
                }
                case "scene": {
                    this.onScenePropertyChanged(event);
                    break;
                }
                case "ctrlstrategy": {
                    this.onCtrlStrategyPropertyChanged(event);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
    }

    private void onCtrlStrategyPropertyChanged(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        String oldValue = (String)changeData.getOldValue();
        if ("7".equals(newValue) && !"7".equals(oldValue)) {
            IPageCache pageCache = this.getView().getPageCache();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u63a7\u5236\u7b56\u7565\u4e3a\u79c1\u6709\u5c06\u6e05\u7a7a\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u7684\u5b57\u6bb5\u89c4\u5219\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayRollActGrpEdit_13", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACK_CTRLSTRATEGY_CHANGED, (IFormPlugin)this), null, oldValue);
        } else if ("7".equals(oldValue) && !"7".equals(newValue)) {
            Map nodePageMap = (Map)new SWCPageCache(this.getView()).get("CACHE_NODE_PAGE_ID_MAP", Map.class);
            if (CollectionUtils.isEmpty((Map)nodePageMap)) {
                return;
            }
            nodePageMap.forEach((nodePage, pageId) -> {
                IFormView view = this.getView().getView(pageId);
                if (view.getModel().isDataLoaded()) {
                    view.addClientCallBack("CLIENT_CALLBACK_UPDATE_F7_FILTER");
                    this.getView().sendFormAction(view);
                }
            });
        }
    }

    private void onScenePropertyChanged(PropertyChangedArgs event) {
        ChangeData changeSet = event.getChangeSet()[0];
        DynamicObject oldValue = (DynamicObject)changeSet.getOldValue();
        if (oldValue == null) {
            this.sendReloadMessage(true);
            this.clearPolicyAndRuleData();
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u573a\u666f\u5c06\u6e05\u7a7a\u534f\u4f5c\u6d3b\u52a8\u8bbe\u7f6e\u7684\u6267\u884c\u524d\u63d0\u6761\u4ef6\u548c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u7684\u5b57\u6bb5\u89c4\u5219\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayRollActGrpEdit_12", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALLBACK_SCENE_CHANGED, (IFormPlugin)this), null, oldValue.getString("id"));
    }

    private void onSceneChangedCallback(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.clearPolicyAndRuleData();
            this.sendReloadMessage(true);
        }
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            String oldValue = event.getCustomVaule();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("scene", SWCStringUtils.isNotEmpty((String)oldValue) && !"null".equalsIgnoreCase(oldValue) ? Long.valueOf(oldValue) : null);
            model.endInit();
            this.getView().updateView("scene");
        }
    }

    private void clearPolicyAndRuleData() {
        this.clearPolicyAndRuleData(true);
    }

    private void clearPolicyAndRuleData(boolean isClearExePreCondition) {
        this.clearAllFieldRuleData(isClearExePreCondition);
    }

    private void payRollActGrpTplPropertyChanged(PropertyChangedArgs event) throws IOException {
        ChangeData changeData = event.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        if (oldValue == null) {
            Object newValue = changeData.getNewValue();
            this.copyTplEntryEntity(newValue);
            return;
        }
        this.showTplConfirmIfOldNewValDiffer(changeData.getOldValue());
    }

    public void clearAllFieldRuleData(boolean isClearExePreCondition) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        int entryCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryCount; ++i) {
            model.setEntryCurrentRowIndex("entryentity", i);
            if (isClearExePreCondition) {
                model.setValue("ruledesign", null, i);
                model.setValue("ruledesignnumber", null, i);
                model.setValue("ruledesignstr", null, i);
            }
            model.deleteEntryData("fieldrulesubentryentity");
        }
        model.setEntryCurrentRowIndex("entryentity", index);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "CALLABCK_TPL_CONFIRM": {
                this.payrollActGrpTplCallback(messageBoxClosedEvent);
                break;
            }
            case "msgcallback": {
                break;
            }
            case "CONFIRM_CALLBACK_SCENE_CHANGED": {
                this.onSceneChangedCallback(messageBoxClosedEvent);
                break;
            }
            case "CALLBACK_CTRLSTRATEGY_CHANGED": {
                this.onCtrlStrategyCallBack(messageBoxClosedEvent);
                break;
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TextEdit ruleDesign = (TextEdit)this.getView().getControl("ruledesignstr");
        ruleDesign.addButtonClickListener((ClickListener)this);
        Tab fieldMapTab = (Tab)this.getView().getControl("tabap");
        TreeView fieldMapTree = (TreeView)this.getView().getControl("fieldmaptree");
        TreeView fieldRuleTree = (TreeView)this.getView().getControl("fieldruletree");
        Search fieldRuleSearch = (Search)this.getView().getControl("fieldrulesearch");
        Search fieldMapSearch = (Search)this.getView().getControl("fieldmapsearch");
        BasedataEdit payRollAct = (BasedataEdit)this.getView().getControl("payrollact");
        payRollAct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldMapObj = (BasedataEdit)this.getView().getControl("actgfieldmapobjview");
        fieldMapObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldMapView = (BasedataEdit)this.getView().getControl("fieldmapview");
        fieldMapView.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab policyTab = (Tab)this.getView().getControl("policytabap");
        BasedataEdit scene = (BasedataEdit)this.getView().getControl("scene");
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgSub = (BasedataEdit)this.getView().getControl("msgsubscriber");
        msgSub.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollactgtpl = (BasedataEdit)this.getView().getControl(PAYROLLACTGTPL);
        payrollactgtpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void onCtrlStrategyCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.clearPolicyAndRuleData(false);
            this.sendReloadMessage(true);
        } else if (MessageBoxResult.Cancel.equals((Object)result)) {
            this.getModel().setValue("ctrlstrategy", (Object)oldValue);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("EXE_PRE_RULE_POLICY".equals(closedCallBackEvent.getActionId())) {
            this.exePreRuleCallBackHandler(closedCallBackEvent);
        }
        if ("CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE".equals(closedCallBackEvent.getActionId())) {
            this.showPayRollActSettingNewPageCallBackHandler(closedCallBackEvent);
        }
    }

    public void click(EventObject event) {
        super.click(event);
        Control source = (Control)event.getSource();
        String key = source.getKey();
        if ("ruledesignstr".equals(key)) {
            this.showExePreRuleDesignPage();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "scene": {
                this.onBeforeSceneSelected(event);
                break;
            }
            case "msgsubscriber": {
                event.addCustomQFilter(new QFilter("subscribebd", "=", (Object)107010L));
                break;
            }
            case "payrollactgtpl": {
                this.onBeforePayrollactgtplSelected(event);
                break;
            }
        }
    }

    private void onBeforeSceneSelected(BeforeF7SelectEvent event) {
        List<String> appIds = Arrays.asList("/UHMBBGZQ65X", "0NXW1VOPH+QV");
        event.addCustomQFilter(new QFilter("bizappid.id", "in", appIds));
        FormShowParameter formShowParameter = event.getFormShowParameter();
        formShowParameter.setCustomParam("bizappids", (Object)appIds.stream().collect(Collectors.joining("\",\"", "[\"", "\"]")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "deleteentry": {
                if (!this.validateBeforeDeletePayrollactEntry()) break;
                event.setCancel(true);
                break;
            }
            case "donothing_newentryf7": {
                if (!this.validateBeforeNewPayrollactEntry()) break;
                event.setCancel(true);
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if ("refresh".equalsIgnoreCase(name)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "formsubmit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "donothing_confirmchange": 
            case "changesave": {
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().addClientCallBack("refresh");
                break;
            }
            case "auditconfirmchange": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) {
                    return;
                }
                if (!"hpdi_payrollactg".equals(parentView.getEntityId())) {
                    return;
                }
                Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
                if (isChange != null && isChange.booleanValue()) break;
                return;
            }
            case "deleteentry": {
                this.abstractSortEntryEntity();
                break;
            }
            case "donothing_newentryf7": {
                this.showPayRollActSettingNewPage();
                break;
            }
        }
    }

    private void createExePreRuleCache() {
        int count = this.getModel().getEntryRowCount("entryentity");
        HashMap<String, String> exePreRuleCacheMap = new HashMap<String, String>(16);
        this.getModel().setValue("policy", null);
        for (int i = 0; i < count; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
            DynamicObject ruleDesign = entryRowEntity.getDynamicObject("ruledesign");
            if (null == ruleDesign) continue;
            HrRuleDesignEntity hrRule = HrRuleDesignEntity.fromDynamicObject((DynamicObject)ruleDesign);
            hrRule.setId(null);
            hrRule.setRuleNumber(PayRollActGrpHelper.newRuleNumber());
            hrRule.setRuleName(hrRule.getRuleNumber());
            exePreRuleCacheMap.put(hrRule.getRuleNumber(), hrRule.toJson());
            this.getModel().setValue("ruledesign", null, i);
            this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)hrRule.getFilterCondition()), i);
            this.getModel().setValue("ruledesignnumber", (Object)hrRule.getRuleNumber(), i);
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", exePreRuleCacheMap);
    }

    private void showExePreRuleDesignPage() {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u524d\u63d0\u6761\u4ef6\u8bbe\u7f6e", (String)"PayRollActGrpEdit_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParams(this.getRuleParaMap());
        billShowParameter.setFormId("hpdi_ruledesignconfig");
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("600");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "EXE_PRE_RULE_POLICY"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getRuleParaMap() {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("sceneId", PayRollActGrpHelper.getCurrentSceneId((IFormView)this.getView()));
        param.put("hrRule", this.getExePreHrRule());
        param.put("ruleResultVisibility", Boolean.FALSE);
        param.put("dataStatus", this.getPageStatus());
        return param;
    }

    private HrRuleDesignEntity getExePreHrRule() {
        String ruleDesignNumber = (String)this.getModel().getValue("ruledesignnumber");
        return this.getExePreRuleCacheById(ruleDesignNumber);
    }

    private boolean validateBeforePopRuleDesign() {
        if (null == this.getModel().getValue("scene")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u573a\u666f\u3002", (String)"PayRollActGrpEdit_8", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void reloadPayRollActgTplData(DynamicObject payRollActgTplDyobj) {
        if (null != payRollActgTplDyobj) {
            IDataModel model = this.getModel();
            DynamicObjectCollection tplEntryentities = payRollActgTplDyobj.getDynamicObjectCollection("entryentity");
            Table payRollActProps = PayRollActGrpHelper.getPayRollActProps((DynamicObjectCollection)tplEntryentities);
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)tplEntryentities)) {
                return;
            }
            model.beginInit();
            for (int i = 0; i < entryEntity.size() && i < tplEntryentities.size(); ++i) {
                DynamicObject tplEntryentity = (DynamicObject)tplEntryentities.get(i);
                model.setValue("ismustexecute", tplEntryentity.get("ismustexecute"), i);
                String payRollActId = tplEntryentity.getString("payrollact.id");
                Boolean isPayRollActPreset = (Boolean)payRollActProps.get((Object)payRollActId, (Object)"issyspreset");
                if (null == isPayRollActPreset || !isPayRollActPreset.booleanValue()) continue;
                model.setValue("ispayrollactsyspreset", (Object)"1", i);
            }
            model.endInit();
            this.getView().updateView("entryentity");
            this.setIsExecuteEnable(tplEntryentities);
        }
    }

    private void clearExePreRuleDesignData(PropertyChangedArgs event) {
        ChangeData[] changeSet = event.getChangeSet();
        if (null == changeSet || changeSet.length == 0) {
            return;
        }
        for (ChangeData changeData : changeSet) {
            String newValue = String.valueOf(changeData.getNewValue());
            if (!SWCStringUtils.isEmpty((String)newValue)) continue;
            this.getModel().setValue("ruledesignnumber", null);
            this.getModel().setValue("ruledesign", null);
        }
    }

    private boolean showTplConfirmIfOldNewValDiffer(Object oldValObj) {
        if (null != oldValObj) {
            new SWCPageCache(this.getView()).put("tplchangecache", (Object)Boolean.FALSE);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u4fee\u6539\u201c\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201d\uff0c\u201c\u534f\u4f5c\u6d3b\u52a8\u8bbe\u7f6e\u201d\u548c\u201c\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u201d\u5c06\u4f1a\u88ab\u66f4\u65b0\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayRollActGrpEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("CALLABCK_TPL_CONFIRM", (IFormPlugin)this), null, ((DynamicObject)oldValObj).getString("id"));
            return true;
        }
        return false;
    }

    private void payrollActGrpTplCallback(MessageBoxClosedEvent messageBoxClosedEvent) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            pageCache.put("tplchangecache", (Object)Boolean.TRUE);
            this.getPageCache().batchRemove(Arrays.asList("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", "FIELD_MAP_TREE_DATA", "FIELD_RULE_TREE_DATA", "IS_FIELD_MAP_ENABLED_DATA", "CACHE_NODE_PAGE_ID_MAP", "CACHE_FIELD_RULE_POLICY"));
            try {
                this.copyTplEntryEntity(this.getModel().getValue(PAYROLLACTGTPL));
            }
            catch (IOException e) {
                LOGGER.info("copyTplEntryentity error.", (Object)e);
            }
        } else {
            String oldValObj = messageBoxClosedEvent.getCustomVaule();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            this.getModel().setValue(PAYROLLACTGTPL, (Object)(SWCStringUtils.isEmpty((String)oldValObj) ? null : Long.valueOf(oldValObj)));
            model.endInit();
            this.getView().updateView(PAYROLLACTGTPL);
            pageCache.remove("tplchangecache");
        }
        pageCache.saveChanges();
    }

    private void copyTplEntryEntity(Object tplObj) throws IOException {
        IDataModel model = this.getModel();
        if (null != tplObj) {
            model.deleteEntryData("fieldmapviewentryentity");
            model.deleteEntryData("subentryentity");
            model.deleteEntryData("fieldrulesubentryentity");
            model.deleteEntryData("entryentity");
            DynamicObject tplDyObj = (DynamicObject)tplObj;
            DynamicObjectCollection tplEntryEntities = tplDyObj.getDynamicObjectCollection("entryentity");
            if (!tplEntryEntities.isEmpty()) {
                Table payRollActProps = PayRollActGrpHelper.getPayRollActProps((DynamicObjectCollection)tplEntryEntities);
                model.beginInit();
                this.setDataIntoEntryEntity(tplEntryEntities, (Table<String, String, Boolean>)payRollActProps);
                this.getView().updateView("entryentity");
                model.endInit();
                this.setIsExecuteEnable(tplEntryEntities);
            }
        } else {
            model.deleteEntryData("entryentity");
        }
        this.sendReloadMessage(true);
        this.getPageCache().remove("tplchangecache");
        this.refreshEntryButtonState();
    }

    private void sendReloadMessage(boolean isClearAll) {
        this.getView().addClientCallBack(isClearAll ? "CALLBACK_RELOAD_MAP_RULE_TREE#CLEAR" : CALLBACK_RELOAD_MAP_RULE_TREE);
    }

    private void setIsExecuteEnable(DynamicObjectCollection tplEntryEntities) {
        int size = tplEntryEntities.size();
        for (int i = 0; i < size; ++i) {
            if (((DynamicObject)tplEntryEntities.get(i)).getBoolean("ismustexecute")) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isexecute"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"isexecute"});
        }
    }

    private void setDataIntoEntryEntity(DynamicObjectCollection tplEntryEntities, Table<String, String, Boolean> payRollActProps) {
        IDataModel model = this.getModel();
        int size = tplEntryEntities.size();
        for (int i = 0; i < size; ++i) {
            model.insertEntryRow("entryentity", i);
            DynamicObject tplEntryEntity = (DynamicObject)tplEntryEntities.get(i);
            Long payRollActId = tplEntryEntity.getLong("payrollact.id");
            model.setValue("payrollact", (Object)payRollActId, i);
            model.setValue("executeseq", tplEntryEntity.get("executeseq"), i);
            model.setValue("ismustexecute", tplEntryEntity.get("ismustexecute"), i);
            Boolean isPayRollActPreset = (Boolean)payRollActProps.get((Object)String.valueOf(payRollActId), (Object)"issyspreset");
            if (null == isPayRollActPreset || !isPayRollActPreset.booleanValue()) continue;
            model.setValue("ispayrollactsyspreset", (Object)"1", i);
        }
    }

    private void showPayRollActSettingNewPageCallBackHandler(ClosedCallBackEvent event) {
        if (event.getReturnData() != null && SWCStringUtils.equals((String)"CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE", (String)event.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            if (CollectionUtils.isEmpty((Collection)returnData)) {
                return;
            }
            List<Long> payRollActIds = returnData.stream().map(rt -> (Long)rt.getPrimaryKeyValue()).collect(Collectors.toList());
            List fillPayRollActSettingEntry = PayRollActGrpHelper.findPayRollActSettingEntry((IFormView)this.getView(), payRollActIds);
            this.addDataToEntryEntityWithOrder(payRollActIds, fillPayRollActSettingEntry);
        }
    }

    private void addDataToEntryEntityWithOrder(List<Long> payRollActIds, List<DynamicObject> entryEntitys) {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        for (int i = 0; i < entryEntitys.size(); ++i) {
            DynamicObject tempEntryRow = entryEntitys.get(i);
            Long tmpPayRollActId = tempEntryRow.getLong("payrollact.id");
            if (!payRollActIds.contains(tmpPayRollActId)) continue;
            this.getModel().insertEntryRow("entryentity", i);
            this.getModel().setValue("payrollact", (Object)tmpPayRollActId, i);
            this.getModel().setValue("executeseq", (Object)(i + 1), i);
            this.getModel().setValue("ismustexecute", tempEntryRow.get("ismustexecute"), i);
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
        this.abstractSortEntryEntity();
        this.sendReloadMessage(false);
        this.refreshEntryButtonState();
    }

    private void exePreRuleCallBackHandler(ClosedCallBackEvent closedCallBackEvent) {
        HrRuleDesignEntity rule = (HrRuleDesignEntity)closedCallBackEvent.getReturnData();
        if (null == rule) {
            return;
        }
        this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()));
        this.getModel().setValue("ruledesignnumber", (Object)rule.getRuleNumber());
        this.putExePreRuleToCache(rule);
    }

    private void reloadExePreRuleDesignCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map lastCacheMap = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        HashMap<String, String> cacheDataMap = new HashMap<String, String>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject ruleDesignDy = dynamicObject.getDynamicObject("ruledesign");
            String ruleNumber = dynamicObject.getString("ruledesignnumber");
            if (null != ruleDesignDy) {
                HrRuleDesignEntity rule = HrRuleDesignEntity.fromDynamicObject((DynamicObject)ruleDesignDy);
                String number = rule.getRuleNumber();
                cacheDataMap.put(number, rule.toJson());
                if (SWCStringUtils.isEmpty((String)number)) continue;
                this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
                this.getModel().setValue("ruledesignnumber", (Object)number, i);
                this.getModel().setDataChanged(false);
                continue;
            }
            if (SWCStringUtils.isEmpty((String)ruleNumber) || CollectionUtils.isEmpty((Map)lastCacheMap)) continue;
            cacheDataMap.put(ruleNumber, (String)lastCacheMap.get(ruleNumber));
        }
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", cacheDataMap);
    }

    private void showPayRollActSettingNewPage() {
        DynamicObject payRollActGrpTpl = this.getModel().getDataEntity().getDynamicObject(PAYROLLACTGTPL);
        if (null == payRollActGrpTpl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201d\u3002", (String)"PayRollActGrpEdit_9", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_payrollact", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_SHOW_PAY_ROLL_ACT_SETTING_NEW_PAGE"));
        DynamicObjectCollection payRollActCollection = payRollActGrpTpl.getDynamicObjectCollection("entryentity");
        ArrayList<Long> inIds = new ArrayList<Long>(10);
        if (!CollectionUtils.isEmpty((Collection)payRollActCollection)) {
            for (DynamicObject payRollActEntry : payRollActCollection) {
                DynamicObject payRollAct = payRollActEntry.getDynamicObject("payrollact");
                if (null == payRollAct) continue;
                inIds.add((Long)payRollAct.getPkValue());
            }
        }
        if (inIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u4e0d\u5305\u542b\u534f\u4f5c\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollActGrpEdit_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> notInIds = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (DynamicObject entity : entryEntity) {
                DynamicObject payRollAct = entity.getDynamicObject("payrollact");
                if (null == payRollAct) continue;
                notInIds.add((Long)payRollAct.getPkValue());
            }
        }
        if (notInIds.containsAll(inIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201c{0}\u201d\u4e2d\u7684\u6240\u6709\u534f\u4f5c\u6d3b\u52a8\u3002", (String)"PayRollActGrpEdit_5", (String)"swc-hpdi-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("payrollactgtpl.name")}));
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "in", inIds));
        qFilters.add(new QFilter("id", "not in", notInIds));
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, "id");
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private HrRuleDesignEntity getExePreRuleCacheById(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return null;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map map = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return null;
        }
        String ruleStr = (String)map.get(key);
        if (SWCStringUtils.isEmpty((String)ruleStr)) {
            return null;
        }
        HrRuleDesignEntity cast = null;
        try {
            cast = (HrRuleDesignEntity)SWCJSONUtils.cast((String)ruleStr, HrRuleDesignEntity.class);
        }
        catch (IOException e) {
            LOGGER.error("\u89e3\u6790json\u5b57\u7b26\u4e32\u51fa\u73b0\u9519\u8bef.", (Throwable)e);
            throw new KDBizException((Throwable)e, PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
        return cast;
    }

    private void putExePreRuleToCache(HrRuleDesignEntity rule) {
        if (null == rule) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        HashMap<String, String> map = (HashMap<String, String>)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            map = new HashMap<String, String>();
        }
        map.put(rule.getRuleNumber(), rule.toJson());
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", map);
    }

    private Map<String, Object> getFieldRuleCommomValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        return ImmutableMap.of((Object)"sceneId", (Object)dataEntity.getLong("scene.id"), (Object)"createOrgId", (Object)dataEntity.getLong("createorg.id"), (Object)"ctrlStrategy", (Object)"5");
    }

    private List<HRPolicyEntity> preHandlerRuleEngineDataId(List<HRPolicyEntity> policyList) {
        if (policyList == null || policyList.isEmpty()) {
            return policyList;
        }
        String ruleEnginDataMode = (String)this.getView().getFormShowParameter().getCustomParam(RULE_ENGINE_DATA_MODE);
        if (ruleEnginDataMode == null || !"NEW".equals(ruleEnginDataMode)) {
            return policyList;
        }
        for (HRPolicyEntity HRPolicyEntity2 : policyList) {
            List entryBuList;
            HRPolicyEntity2.setId(null);
            List entryRuleList = HRPolicyEntity2.getEntryRuleList();
            if (entryRuleList != null && entryRuleList.size() != 0) {
                entryRuleList.stream().forEach(item -> item.setId(null));
            }
            if ((entryBuList = HRPolicyEntity2.getEntryBuList()) == null || entryBuList.size() == 0) continue;
            entryBuList.stream().forEach(item -> item.setId(null));
        }
        return policyList;
    }

    private void abstractSortEntryEntity() {
        DynamicObjectCollection entryEntityObjs = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntityObjs.size(); ++i) {
            this.getModel().setValue("executeseq", (Object)(i + 1), i);
        }
    }

    private boolean validateBeforeNewPayrollactEntry() {
        DynamicObjectCollection doc = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List existList = doc.stream().map(ee -> ee.getLong("payrollact.id")).collect(Collectors.toList());
        long payrollactgtplId = this.getModel().getDataEntity().getLong("payrollactgtpl.id");
        if (0L == payrollactgtplId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201d\u3002", (String)"PayRollActGrpEdit_9", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject payRollObj = PayRollActGrpHelper.getPayRollActGrpTplById((long)payrollactgtplId);
        DynamicObjectCollection payRollCollections = payRollObj.getDynamicObjectCollection("entryentity");
        if (payRollCollections.size() == existList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u201c{0}\u201d\u4e2d\u7684\u6240\u6709\u534f\u4f5c\u6d3b\u52a8\u3002", (String)"PayRollActGrpEdit_5", (String)"swc-hpdi-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("payrollactgtpl.name")}));
            return true;
        }
        Set idSet = payRollCollections.stream().map(ee -> ee.getLong("payrollact.id")).filter(ee -> !existList.contains(ee)).collect(Collectors.toSet());
        if (idSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u534f\u4f5c\u89c4\u5219\u6a21\u677f\u4e0d\u5305\u542b\u534f\u4f5c\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayRollActGrpEdit_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateBeforeDeletePayrollactEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRowNumber = entryGrid.getSelectRows();
        boolean isMustExecute = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRowNumber[0])).getBoolean("ismustexecute");
        if (isMustExecute) {
            String payrollactName = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRowNumber[0])).getString("payrollact.name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u4f5c\u6d3b\u52a8\u201c{0}\u201d\u5fc5\u987b\u6267\u884c\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"PayRollActGrpEdit_4", (String)"swc-hpdi-formplugin", (Object[])new Object[]{payrollactName}));
        }
        return isMustExecute;
    }

    private void onBeforePayrollactgtplSelected(BeforeF7SelectEvent event) {
        String entityId = this.getView().getEntityId();
        Set<String> appIds = new HashSet(16);
        switch (entityId) {
            case "hpdi_collarulesal": {
                appIds = PayRollActGrpHelper.getAppIds((Long)SWCConstants.BUSINESSTYPE_SAL);
                appIds.add("2AXKDRPJUQ77");
                appIds.add("17/+CT1QBPNP");
                break;
            }
            case "hpdi_collarulecdm": {
                appIds = PayRollActGrpHelper.getAppIds((Long)SWCConstants.BUSINESSTYPE_CDM);
                break;
            }
            case "hpdi_collarulecsi": {
                appIds = PayRollActGrpHelper.getAppIds((Long)SWCConstants.BUSINESSTYPE_CSI);
                break;
            }
            case "hpdi_collaruletax": {
                appIds = PayRollActGrpHelper.getAppIds((Long)SWCConstants.BUSINESSTYPE_TAX);
                break;
            }
        }
        if (!ObjectUtils.isEmpty(appIds)) {
            QFilter filter = new QFilter("bizapp.id", "in", appIds);
            event.addCustomQFilter(filter);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.refreshEntryButtonState();
    }

    private void refreshEntryButtonState() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject tplObject = dataEntity.getDynamicObject(PAYROLLACTGTPL);
        if (tplObject == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar-newentry"});
            return;
        }
        DynamicObjectCollection tplEntry = tplObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
        this.getView().setVisible(Boolean.valueOf(tplEntry.size() > entry.size()), new String[]{"bar-newentry"});
    }
}

