/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata.cloudcolla;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.swc.hpdi.business.cloudcolla.CollaRuleNodeIdHelper;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.business.cloudcolla.ResultControlHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HRPolicyEntityWrapper;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hpdi.common.entity.PayRollActSearchEntity;
import kd.swc.hpdi.common.entity.ResponseDTO;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class PayRollActGrpFieldRuleEdit
extends AbstractFormPlugin
implements TabSelectListener,
TreeNodeClickListener,
SearchEnterListener,
ClickListener,
RowClickEventListener,
PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(PayRollActGrpFieldRuleEdit.class);
    public static final String RULE_ENGINE_DATA_MODE = "ruleEngineDataMode";

    public void afterCreateNewData(EventObject eventObject) {
        this.initRuleEngineDataCache();
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Boolean isCopyInit = (Boolean)swcPageCache.get("CACHE_IS_COPY_INIT", Boolean.class);
        if (isCopy != null && isCopy.booleanValue() && isCopyInit == null) {
            long orgId = RequestContext.getOrCreate().getOrgId();
            this.getModel().setValue("createorg", (Object)orgId);
            this.getModel().setValue("policy", null);
            swcPageCache.put("CACHE_IS_COPY_INIT", (Object)Boolean.TRUE.toString());
        }
    }

    private void initRuleEngineDataCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.isEmpty()) {
            return;
        }
        String status = this.getModel().getDataEntity().getString("status");
        Boolean isCopy = (Boolean)customParams.get("iscopy");
        Boolean isChange = (Boolean)customParams.get("isChange");
        Boolean flag = isCopy != null && isCopy != false || isChange != null && isChange != false;
        if (flag.booleanValue()) {
            this.getView().getFormShowParameter().setCustomParam(RULE_ENGINE_DATA_MODE, (Object)"NEW");
            this.getModel().setValue("policy", null);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initRuleEngineDataCache();
    }

    private HRPolicyEntityWrapper getPolicyByNodeId(String nodeId, Map<String, String> nodePageIdMap) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        if (CollectionUtils.isEmpty(nodePageIdMap)) {
            nodePageIdMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        }
        HRPolicyEntityWrapper wrapper = null;
        if (nodePageIdMap != null && !nodePageIdMap.isEmpty()) {
            IFormView subView;
            LOGGER.info("[payrollactg] nodePageIdMap != null && nodePageIdMap.size() > 0 = {}", (Object)nodePageIdMap);
            String pageId = (String)nodePageIdMap.get(nodeId);
            if (!SWCStringUtils.isEmpty((String)pageId) && null != (subView = this.getView().getView(pageId)) && subView.getModel().isDataLoaded()) {
                wrapper = PayRollActGrpHelper.getFullHrPolicyFromView((IFormView)this.getView(), (String)pageId);
            }
        }
        if (null == wrapper) {
            LOGGER.info("[payrollactg] null == hrPolicy = {}", (Object)nodeId);
            wrapper = PayRollActGrpHelper.getHrPolicyFromSubEntity((IFormView)this.getView(), (String)nodeId);
        }
        return wrapper;
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        try {
            this.reloadMapRuleTreeView(null, true);
        }
        catch (IOException ex) {
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        try {
            switch (fieldKey) {
                case "payrollact": {
                    this.initMapRuleTree(event);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw PayRollActGrpHelper.getDefaultException((Exception)ex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "formsubmit": 
            case "changesave": 
            case "auditconfirmchange": {
                if (event.isCancel() || !this.beforeSaveOperation(formOperate, operateKey)) break;
                event.setCancel(true);
                break;
            }
            case "refresh": {
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.batchRemove(Arrays.asList("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", "CACHE_NODE_PAGE_ID_MAP"));
                pageCache.saveChanges();
                break;
            }
        }
    }

    private boolean beforeSaveOperation(FormOperate formOperate, String operateKey) {
        try {
            List<String> batchValidPolicyResultList = this.getBatchValidPolicyResultList();
            if (!CollectionUtils.isEmpty(batchValidPolicyResultList)) {
                formOperate.getOption().setVariableValue("batchValidPolicyResultMsgList", SWCJSONUtils.toString(batchValidPolicyResultList));
                return false;
            }
            if (!this.savePayRollActGroupPolicy(operateKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PayRollActGrpEdit_10", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        catch (IOException ex) {
            LOGGER.info("json\u5e8f\u5217\u5316\u51fa\u73b0\u9519\u8bef", (Object)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PayRollActGrpEdit_10", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean savePayRollActGroupPolicy(String operationKey) throws IOException {
        HRPolicyEntity exePreRulePolicy = PayRollActGrpHelper.getExePreRulePolicyFromCache((IFormView)this.getView());
        this.afterGetExePreRulePolicy(exePreRulePolicy, operationKey);
        List<HRPolicyEntityWrapper> fieldRulePolicyList = this.getFieldRulePolicyList();
        this.afterGetFiledRulePolicyList(fieldRulePolicyList, operationKey);
        this.preHandlerRuleEngineDataId(exePreRulePolicy);
        ResponseDTO response = PayRollActGrpHelper.batchSaveCollaRulePolicy((HRPolicyEntity)exePreRulePolicy, fieldRulePolicyList);
        if (!response.isSuccess()) {
            LOGGER.info("[colla] batchSaveCollaRulePoliy error : {}", (Object)response.getErrorMsg());
            return false;
        }
        Map result = (Map)response.getResult();
        List fieldRulePolicyListResult = (List)MapUtils.getObject((Map)result, (Object)"fieldRulePolicyList");
        ResponseDTO saveFieldRuleResult = PayRollActGrpHelper.batchSaveFieldRule((List)fieldRulePolicyListResult, (DynamicObject)this.getModel().getDataEntity(true));
        if (!saveFieldRuleResult.isSuccess()) {
            LOGGER.info("[colla] batchSaveCollaRulePoliy error : {}", (Object)saveFieldRuleResult.getErrorMsg());
            return false;
        }
        HRPolicyEntity exePreConditionResult = (HRPolicyEntity)MapUtils.getObject((Map)result, (Object)"exePreCondition");
        PayRollActGrpHelper.writeBackExePreRulePolicyId((IFormView)this.getView(), (HRPolicyEntity)exePreConditionResult);
        this.saveFieldRuleEntry(fieldRulePolicyList);
        return true;
    }

    private void preHandlerRuleEngineDataId(HRPolicyEntity policy) {
        List entryBuList;
        if (policy == null) {
            return;
        }
        String ruleEnginDataMode = (String)this.getView().getFormShowParameter().getCustomParam(RULE_ENGINE_DATA_MODE);
        if (ruleEnginDataMode == null || !"NEW".equals(ruleEnginDataMode)) {
            return;
        }
        policy.setId(null);
        List entryRuleList = policy.getEntryRuleList();
        if (entryRuleList != null && entryRuleList.size() != 0) {
            entryRuleList.forEach(item -> item.setId(null));
        }
        if ((entryBuList = policy.getEntryBuList()) != null && entryBuList.size() != 0) {
            entryBuList.forEach(item -> item.setId(null));
        }
    }

    private void saveFieldRuleEntry(List<HRPolicyEntityWrapper> fieldRuleDyList) {
        if (CollectionUtils.isEmpty(fieldRuleDyList)) {
            return;
        }
        String fieldRuleTreeStr = this.getView().getPageCache().get("FIELD_RULE_TREE_DATA");
        CollaRuleNodeIdHelper nodeIdHelper = CollaRuleNodeIdHelper.getInstance();
        for (HRPolicyEntityWrapper wrapper : fieldRuleDyList) {
            String nodeId = wrapper.getNodeId();
            Map nodeIdParseMap = nodeIdHelper.parseNodeId(nodeId);
            String frPayRollActId = MapUtils.getString((Map)nodeIdParseMap, (Object)"actionId", (String)"");
            String frTriggerCollaId = MapUtils.getString((Map)nodeIdParseMap, (Object)"operateId", (String)"");
            String fieldKey = MapUtils.getString((Map)nodeIdParseMap, (Object)"fieldNumber", (String)"");
            this.getView().updateView("fieldrulesubentryentity");
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            int row = -1;
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
                if (!frPayRollActId.equals(entryRowEntity.getString("payrollact.id"))) continue;
                row = i;
                break;
            }
            if (row == -1) continue;
            AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
            int currentRow = dataModel.getEntryCurrentRowIndex("entryentity");
            Integer ruleRowIndex = PayRollActGrpHelper.isPolicyDataExist((IFormView)this.getView(), (String)frPayRollActId, (String)frTriggerCollaId, (String)fieldKey, (Integer)row);
            if (ruleRowIndex >= 0) {
                this.getModel().setValue("frfieldrule", (Object)wrapper.calRuleId(), ruleRowIndex.intValue(), row);
                continue;
            }
            dataModel.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            setter.addField("frpayrollact", new Object[0]);
            setter.addField("frtriggercolla", new Object[0]);
            setter.addField("frfieldkey", new Object[0]);
            setter.addField("frfieldrule", new Object[0]);
            setter.addRow(new Object[]{frPayRollActId, frTriggerCollaId, fieldKey, wrapper.calRuleId()});
            dataModel.setEntryCurrentRowIndex("entryentity", row);
            dataModel.batchCreateNewEntryRow("fieldrulesubentryentity", setter);
            dataModel.endInit();
            dataModel.setEntryCurrentRowIndex("entryentity", currentRow);
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("fieldrulesubentryentity");
    }

    private void afterGetFiledRulePolicyList(List<HRPolicyEntityWrapper> fieldRulePolicyList, String operationKey) {
        if (CollectionUtils.isEmpty(fieldRulePolicyList) || SWCStringUtils.isEmpty((String)operationKey)) {
            return;
        }
        long[] fieldRuleIds = PayRollActGrpHelper.newFieldRuleIds((int)fieldRulePolicyList.size());
        Boolean policyEnable = this.getPolicyEnable(operationKey);
        for (int i = 0; i < fieldRulePolicyList.size(); ++i) {
            HRPolicyEntityWrapper wrapper = fieldRulePolicyList.get(i);
            if (wrapper.isUseExist()) continue;
            wrapper.setNewFieldRuleId(Long.valueOf(fieldRuleIds[i]));
            HRPolicyEntity policy = wrapper.getPolicy();
            if (policy == null) continue;
            policy.setEnable(policyEnable);
            List entryRuleList = policy.getEntryRuleList();
            if (CollectionUtils.isEmpty((Collection)entryRuleList)) continue;
            for (HrRuleDesignEntity HrRuleDesignEntity2 : entryRuleList) {
                HrRuleDesignEntity2.setRuleEnable(policyEnable);
            }
        }
    }

    private Boolean getPolicyEnable(String operationKey) {
        if (SWCStringUtils.isEmpty((String)operationKey)) {
            return Boolean.FALSE;
        }
        switch (operationKey) {
            case "save": 
            case "formsubmit": 
            case "changesave": {
                return Boolean.FALSE;
            }
            case "auditconfirmchange": 
            case "audit": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private List<HRPolicyEntityWrapper> getFieldRulePolicyList() throws IOException {
        ArrayList<HRPolicyEntityWrapper> resultList = new ArrayList<HRPolicyEntityWrapper>(10);
        String fieldRuleCacheData = this.getPageCache().get("FIELD_RULE_TREE_DATA");
        if (SWCStringUtils.isEmpty((String)fieldRuleCacheData)) {
            return resultList;
        }
        List firstLeverTreeNodes = (List)SWCJSONUtils.cast((String)fieldRuleCacheData, List.class, (Class[])new Class[]{TreeNode.class});
        List secondLeverTreeNodes = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)firstLeverTreeNodes);
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)secondLeverTreeNodes);
        List forthChildrenTreeNodeList = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)thirdChildrenTreeNodeList);
        forthChildrenTreeNodeList.addAll(thirdChildrenTreeNodeList);
        if (CollectionUtils.isEmpty((Collection)forthChildrenTreeNodeList)) {
            return resultList;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map policyPageIdMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        for (TreeNode treeNode : forthChildrenTreeNodeList) {
            String firstName;
            IFormView subView;
            String pageId;
            String nodeId = treeNode.getId();
            HRPolicyEntityWrapper wrapper = new HRPolicyEntityWrapper();
            if (!CollectionUtils.isEmpty((Map)policyPageIdMap) && !SWCStringUtils.isEmpty((String)(pageId = (String)policyPageIdMap.get(nodeId))) && null != (subView = this.getView().getView(pageId)) && subView.getModel().isDataLoaded()) {
                wrapper = PayRollActGrpHelper.getFullHrPolicyFromView((IFormView)this.getView(), (String)pageId);
            }
            if (null == wrapper) continue;
            wrapper.setNodeId(nodeId);
            if (wrapper.isUseExist()) {
                resultList.add(wrapper);
                continue;
            }
            HRPolicyEntity policy = wrapper.getPolicy();
            if (policy == null || SWCStringUtils.isEmpty((String)(firstName = String.valueOf(this.getModel().getValue("name"))))) continue;
            firstName = firstName.substring(0, firstName.length() > 20 ? 19 : firstName.length());
            String secondName = treeNode.getText();
            secondName = secondName.substring(0, secondName.length() > 10 ? 9 : secondName.length());
            String prefixName = ResManager.loadKDString((String)"{0}-{1}", (String)"PayRollActGrpEdit_7", (String)"swc-hpdi-formplugin", (Object[])new Object[]{firstName, secondName});
            policy.setName(prefixName + '-' + policy.getNumber().substring(5));
            policy.setPolicyMode("FirstMatch");
            List defaultEntryBuList = PayRollActGrpHelper.getDefaultEntryBuList((IFormView)this.getView());
            policy.setEntryBuList(defaultEntryBuList);
            policy.setNodeId(nodeId);
            resultList.add(wrapper);
        }
        return resultList;
    }

    private void afterGetExePreRulePolicy(HRPolicyEntity exePreRule, String operationKey) {
        if (null == exePreRule || SWCStringUtils.isEmpty((String)operationKey)) {
            return;
        }
        Boolean policyEnable = this.getPolicyEnable(operationKey);
        exePreRule.setEnable(policyEnable);
        List entryRuleList = exePreRule.getEntryRuleList();
        if (CollectionUtils.isEmpty((Collection)entryRuleList)) {
            return;
        }
        for (HrRuleDesignEntity HrRuleDesignEntity2 : entryRuleList) {
            HrRuleDesignEntity2.setRuleEnable(policyEnable);
        }
    }

    private List<String> getBatchValidPolicyResultList() throws IOException {
        ArrayList<String> result = new ArrayList<String>(10);
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map nodePageMap = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        String fieldRuleTreeStr = this.getView().getPageCache().get("FIELD_RULE_TREE_DATA");
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getAllLeafNodeNodeList((IFormView)this.getView());
        if (CollectionUtils.isEmpty((Map)nodePageMap) || CollectionUtils.isEmpty((Collection)thirdChildrenTreeNodeList)) {
            return result;
        }
        LinkedHashSet<TreeNode> mustInputFieldId = new LinkedHashSet<TreeNode>(16);
        for (TreeNode treeNode : thirdChildrenTreeNodeList) {
            String nodeId = treeNode.getId();
            HRPolicyEntityWrapper wrapper = this.getPolicyByNodeId(nodeId, nodePageMap);
            Map data = (Map)treeNode.getData();
            if (CollectionUtils.isEmpty((Map)data)) continue;
            Boolean isMustInput = data.getOrDefault("isMustInput", Boolean.FALSE);
            if (!isMustInput.booleanValue()) {
                this.validateImMustInputPolicy(result, fieldRuleTreeStr, nodeId, wrapper);
                continue;
            }
            this.validateMustInputPolicy(result, fieldRuleTreeStr, mustInputFieldId, treeNode, wrapper);
        }
        result.addAll(this.parseNotifyString(mustInputFieldId));
        return result;
    }

    private void validateMustInputPolicy(List<String> result, String fieldRuleTreeStr, Set<TreeNode> mustInputFieldId, TreeNode treeNode, HRPolicyEntityWrapper wrapper) {
        if (wrapper == null) {
            mustInputFieldId.add(treeNode);
            return;
        }
        if (wrapper.isUseExist()) {
            if (wrapper.getExistFieldRuleId() == 0L || wrapper.getExistFieldRuleId() == null) {
                mustInputFieldId.add(treeNode);
            }
            return;
        }
        HRPolicyEntity policy = wrapper.getPolicy();
        if (policy == null) {
            mustInputFieldId.add(treeNode);
            return;
        }
        String results = policy.getResults();
        List entryRuleList = policy.getEntryRuleList();
        if (SWCStringUtils.isEmpty((String)results) && CollectionUtils.isEmpty((Collection)entryRuleList)) {
            mustInputFieldId.add(treeNode);
        }
        if (!PayRollActGrpHelper.validPolicyResults((HRPolicyEntity)policy).booleanValue()) {
            List lastChildPath = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)treeNode.getId(), (String)fieldRuleTreeStr);
            if (CollaRuleNodeIdHelper.getInstance().isField(treeNode.getId())) {
                result.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u201c{0}\u201d\u7684\u201c{1}\u201d\u7684\u201c{2}\u201d\u7684\u201c\u9ed8\u8ba4\u503c\u201d\u5b57\u6bb5\u3002", (String)"PayRollActGrpEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[]{((TreeNode)lastChildPath.get(0)).getText(), ((TreeNode)lastChildPath.get(1)).getText(), ((TreeNode)lastChildPath.get(lastChildPath.size() - 1)).getText()}));
            }
        }
    }

    private void validateImMustInputPolicy(List<String> result, String fieldRuleTreeStr, String nodeId, HRPolicyEntityWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        HRPolicyEntity policy = wrapper.getPolicy();
        if (policy == null) {
            return;
        }
        if (!PayRollActGrpHelper.validPolicyResults((HRPolicyEntity)policy).booleanValue()) {
            List lastChildPath = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId, (String)fieldRuleTreeStr);
            if (CollaRuleNodeIdHelper.getInstance().isField(nodeId)) {
                result.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u201c{0}\u201d\u7684\u201c{1}\u201d\u7684\u201c{2}\u201d\u7684\u201c\u9ed8\u8ba4\u503c\u201d\u5b57\u6bb5\u3002", (String)"PayRollActGrpEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[]{((TreeNode)lastChildPath.get(0)).getText(), ((TreeNode)lastChildPath.get(1)).getText(), ((TreeNode)lastChildPath.get(lastChildPath.size() - 1)).getText()}));
            }
        }
    }

    private List<String> parseNotifyString(Set<TreeNode> mustInputFieldId) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (mustInputFieldId == null || mustInputFieldId.isEmpty()) {
            return result;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return result;
        }
        HashMap payRollActMap = new HashMap(entryEntity.size());
        entryEntity.forEach(item -> {
            DynamicObject tempObj = item.getDynamicObject("payrollact");
            payRollActMap.put(tempObj.getString("id"), tempObj);
        });
        HashMap<String, List> tempResult = new HashMap<String, List>(entryEntity.size());
        CollaRuleNodeIdHelper nodeIdHelper = CollaRuleNodeIdHelper.getInstance();
        for (TreeNode treeNode : mustInputFieldId) {
            String temPayRollActGrpId = nodeIdHelper.parseActionId(treeNode.getId()).orElse("");
            ArrayList<String> fieldNames = (ArrayList<String>)tempResult.get(temPayRollActGrpId);
            if (fieldNames == null) {
                fieldNames = new ArrayList<String>(10);
            }
            fieldNames.add(treeNode.getText());
            tempResult.put(temPayRollActGrpId, fieldNames);
        }
        tempResult.forEach((key, value) -> {
            DynamicObject payRollActg = (DynamicObject)payRollActMap.get(key);
            if (payRollActg != null) {
                String payRollActName = payRollActg.getString("name");
                String fileds = value.stream().collect(Collectors.joining("\u201d\u3001\u201c"));
                result.add(ResManager.loadKDString((String)"\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\uff0c\u201c{0}\u201d\u7684\u201c{1}\u201d\u672a\u8bbe\u7f6e\u5b57\u6bb5\u89c4\u5219\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"PayRollActGrpEdit_11", (String)"swc-hpdi-formplugin", (Object[])new Object[]{payRollActName, fileds}));
            }
        });
        return result;
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TextEdit ruleDesign = (TextEdit)this.getView().getControl("ruledesignstr");
        ruleDesign.addButtonClickListener((ClickListener)this);
        Tab fieldMapTab = (Tab)this.getView().getControl("tabap");
        fieldMapTab.addTabSelectListener((TabSelectListener)this);
        TreeView fieldRuleTree = (TreeView)this.getView().getControl("fieldruletree");
        fieldRuleTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search fieldRuleSearch = (Search)this.getView().getControl("fieldrulesearch");
        fieldRuleSearch.addEnterListener((SearchEnterListener)this);
    }

    private void registerListeners() {
        TreeView fieldRuleTree;
        List ruleTreeNodeClickListeners;
        TreeView fieldMapTree;
        List treeNodeClickListeners;
        List batchCloseListeners;
        Tab fieldMapTab = (Tab)this.getView().getControl("tabap");
        List tabSelectListeners = (List)ReflectUtils.getFieldValue((String)"tabSelectListeners", (Object)fieldMapTab);
        if (tabSelectListeners == null || tabSelectListeners.isEmpty() || !tabSelectListeners.contains((Object)this)) {
            fieldMapTab.addTabSelectListener((TabSelectListener)this);
        }
        if ((batchCloseListeners = (List)ReflectUtils.getFieldValue((String)"tabBatchCloseListeners", (Object)fieldMapTab)) == null || batchCloseListeners.isEmpty() || !batchCloseListeners.contains((Object)this)) {
            // empty if block
        }
        if ((treeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)(fieldMapTree = (TreeView)this.getView().getControl("fieldmaptree")))) == null || treeNodeClickListeners.isEmpty() || !treeNodeClickListeners.contains((Object)this)) {
            fieldMapTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((ruleTreeNodeClickListeners = (List)ReflectUtils.getFieldValue((String)"treeNodeClickListeners", (Object)(fieldRuleTree = (TreeView)this.getView().getControl("fieldruletree")))) == null || ruleTreeNodeClickListeners.isEmpty() || !ruleTreeNodeClickListeners.contains((Object)this)) {
            fieldRuleTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        if (SWCStringUtils.isEmpty((String)tabKey)) {
            return;
        }
        switch (tabKey) {
            case "fieldruletabpageap": {
                this.selectFieldRuleTabPage();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent event) {
        super.treeNodeClick(event);
        TreeView treeView = (TreeView)event.getSource();
        String key = treeView.getKey();
        String nodeId = (String)event.getNodeId();
        switch (key) {
            case "fieldruletree": {
                this.clickFieldRuleTree(nodeId);
                break;
            }
        }
    }

    public void search(SearchEnterEvent event) {
        Search source = (Search)event.getSource();
        String key = source.getKey();
        if (SWCStringUtils.isEmpty((String)key)) {
            return;
        }
        switch (key) {
            case "fieldrulesearch": {
                this.searchFieldRule(event.getText());
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent event) {
        super.clientCallBack(event);
        String name = event.getName();
        if (name.startsWith("CALLBACK_RELOAD_MAP_RULE_TREE")) {
            try {
                this.reloadMapRuleTreeView(null, name.endsWith("CLEAR"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs event) {
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            // empty if block
        }
        if (SWCStringUtils.equals((String)"entryentity", (String)event.getEntryProp().getName())) {
            // empty if block
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs event) {
        this.registerListeners();
        if (SWCStringUtils.equals((String)"fieldmapviewentryentity", (String)event.getEntryProp().getName())) {
            return;
        }
        if (SWCStringUtils.equals((String)"entryentity", (String)event.getEntryProp().getName())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            try {
                this.reloadMapRuleTreeView(entryEntity, true);
            }
            catch (IOException ex) {
                throw PayRollActGrpHelper.getDefaultException((Exception)ex);
            }
        }
    }

    protected void createFieldRulePolicyCache() {
    }

    private OperationStatus getPageStatus() {
        String string = this.getModel().getDataEntity().getString("status");
        String formId = this.getView().getFormShowParameter().getFormId();
        boolean isHaveModifyPerm = SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)formId, (String)"4715a0df000000ac");
        OperationStatus pageStatus = this.getView().getFormShowParameter().getStatus();
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("isChange");
            if (isChange != null && isChange.booleanValue() && (isHaveModifyPerm || OperationStatus.ADDNEW.equals((Object)pageStatus))) {
                return OperationStatus.ADDNEW;
            }
            String dataStatus = this.getModel().getDataEntity().getString("datastatus");
            if ("-3".equals(dataStatus) && (isHaveModifyPerm || OperationStatus.ADDNEW.equals((Object)pageStatus))) {
                return OperationStatus.ADDNEW;
            }
            return OperationStatus.VIEW;
        }
        if (!"A".equalsIgnoreCase(string) || !isHaveModifyPerm && !OperationStatus.ADDNEW.equals((Object)pageStatus)) {
            return OperationStatus.VIEW;
        }
        return OperationStatus.ADDNEW;
    }

    private void selectFieldRuleTabPage() {
        TreeView ruleView = (TreeView)this.getControl("fieldruletree");
        Tab setDetail = (Tab)this.getControl("setdetail");
        setDetail.selectTab("ruledetail");
        setDetail.activeTab("ruledetail");
        String focusNodeId = ruleView.getTreeState().getFocusNodeId();
        this.focusFieldRuleNodeById(focusNodeId, Boolean.TRUE);
    }

    private void reloadMapRuleTreeView(DynamicObjectCollection entryEntity, boolean isForce) throws IOException {
        this.registerListeners();
        DynamicObjectCollection reloadData = entryEntity;
        if (CollectionUtils.isEmpty((Collection)reloadData)) {
            reloadData = this.getModel().getEntryEntity("entryentity");
        }
        Map fieldMap = PayRollActGrpHelper.getAllTriggerCollaIsFiledMaps((DynamicObjectCollection)reloadData);
        this.reloadFieldRuleTree(reloadData, fieldMap);
        List<String> fieldRuleThirdNodeList = this.getFieldRuleThirdNodeList();
        this.clearPolicyTabPages(fieldRuleThirdNodeList, isForce);
        Tab control = (Tab)this.getView().getControl("tabap");
        String currentTab = control.getCurrentTab();
        if (!"fieldruletabpageap".equalsIgnoreCase(currentTab)) {
            control.activeTab("fieldruletabpageap");
        }
        control.selectTab("fieldruletabpageap");
    }

    private void clearPolicyTabPages(List<String> nodeIdList, boolean isForce) {
        if (isForce) {
            this.getPageCache().remove("CACHE_NODE_PAGE_ID_MAP");
            return;
        }
        Tab policyTab = (Tab)this.getView().getControl("policytabap");
        List items = policyTab.getItems();
        if (CollectionUtils.isEmpty((Collection)items) || CollectionUtils.isEmpty(nodeIdList)) {
            this.getPageCache().remove("CACHE_NODE_PAGE_ID_MAP");
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map map = (Map)swcPageCache.get("CACHE_NODE_PAGE_ID_MAP", Map.class);
        if (CollectionUtils.isEmpty(nodeIdList) && !CollectionUtils.isEmpty((Map)map)) {
            map.clear();
        }
        if (!CollectionUtils.isEmpty((Map)map) && !CollectionUtils.isEmpty(nodeIdList)) {
            for (String nodeId : nodeIdList) {
                if (map.containsKey(nodeId)) continue;
                map.remove(nodeId);
            }
        }
        swcPageCache.put("CACHE_NODE_PAGE_ID_MAP", (Object)map);
    }

    private List<String> getFieldRuleThirdNodeList() throws IOException {
        List<String> nodeIdList = new ArrayList<String>(10);
        String fieldRuleCacheData = this.getPageCache().get("FIELD_RULE_TREE_DATA");
        if (SWCStringUtils.isEmpty((String)fieldRuleCacheData)) {
            return null;
        }
        List firstLeverTreeNodes = (List)SWCJSONUtils.cast((String)fieldRuleCacheData, List.class, (Class[])new Class[]{TreeNode.class});
        List secondLeverTreeNodes = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)firstLeverTreeNodes);
        List thirdChildrenTreeNodeList = PayRollActGrpHelper.getAllChildrenTreeNodeList((List)secondLeverTreeNodes);
        if (!CollectionUtils.isEmpty((Collection)thirdChildrenTreeNodeList)) {
            nodeIdList = thirdChildrenTreeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
        }
        return nodeIdList;
    }

    private void initMapRuleTree(PropertyChangedArgs args) throws IOException {
        ChangeData[] changeSet = args.getChangeSet();
        if (null == changeSet || changeSet.length < 1) {
            return;
        }
        this.reloadMapRuleTreeView(null, true);
    }

    private void reloadExePreRuleDesignCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map lastCacheMap = (Map)swcPageCache.get("CACHE_RULE_DESIGN_DATA", Map.class);
        HashMap<String, String> cacheDataMap = new HashMap<String, String>(16);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            DynamicObject ruleDesignDy = dynamicObject.getDynamicObject("ruledesign");
            String ruleNumber = dynamicObject.getString("ruledesignnumber");
            if (null != ruleDesignDy) {
                HrRuleDesignEntity rule = HrRuleDesignEntity.fromDynamicObject((DynamicObject)ruleDesignDy);
                String number = rule.getRuleNumber();
                cacheDataMap.put(number, rule.toJson());
                if (SWCStringUtils.isEmpty((String)number)) continue;
                this.getModel().setValue("ruledesignstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
                this.getModel().setValue("ruledesignnumber", (Object)number, i);
                this.getModel().setDataChanged(false);
                continue;
            }
            if (SWCStringUtils.isEmpty((String)ruleNumber) || CollectionUtils.isEmpty((Map)lastCacheMap)) continue;
            cacheDataMap.put(ruleNumber, (String)lastCacheMap.get(ruleNumber));
        }
        swcPageCache.put("CACHE_RULE_DESIGN_DATA", cacheDataMap);
    }

    private void reloadFieldRuleTree(DynamicObjectCollection dyList, Map<Long, Map<Long, Map<String, Object>>> fieldMap) throws IOException {
        TreeView filedRuleTreeView = (TreeView)this.getView().getControl("fieldruletree");
        filedRuleTreeView.deleteAllNodes();
        if (CollectionUtils.isEmpty((Collection)dyList) || CollectionUtils.isEmpty(fieldMap) || PayRollActGrpHelper.isValueNull((IFormView)this.getView(), (String)"scene") || PayRollActGrpHelper.isValueNull((IFormView)this.getView(), (String)"payrollactgtpl")) {
            this.getView().getPageCache().put("FIELD_RULE_TREE_DATA", null);
            return;
        }
        List triggerIds = dyList.stream().filter(dy -> !CollectionUtils.isEmpty((Collection)dy.getDynamicObjectCollection("payrollact.entryentity"))).flatMap(dy -> dy.getDynamicObjectCollection("payrollact.entryentity").stream().map(en -> en.getLong("triggercolla.id"))).distinct().collect(Collectors.toList());
        DynamicObject[] query = PayRollActGrpHelper.getTriggerListByIds(triggerIds);
        HashMap<Long, DynamicObject> triggerMap = new HashMap<Long, DynamicObject>();
        if (null != query && query.length > 0) {
            for (DynamicObject temp : query) {
                triggerMap.put(temp.getLong("id"), temp);
            }
        }
        TreeNode focusNode = null;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        CollaRuleNodeIdHelper nodeIdHelper = CollaRuleNodeIdHelper.getInstance();
        for (DynamicObject newValue : dyList) {
            Long payRollActId = newValue.getLong("payrollact.id");
            Map<Long, Map<String, Object>> map = fieldMap.get(payRollActId);
            if (map == null || !this.isFieldRule(map).booleanValue()) continue;
            TreeNode firstLevelTreeNode = new TreeNode(null, nodeIdHelper.genActionNodeId(payRollActId), newValue.getString("payrollact.name"));
            firstLevelTreeNode.setDisabled(true);
            firstLevelTreeNode.setColor("black");
            firstLevelTreeNode.setData((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)newValue.getDynamicObject("payrollact")));
            firstLevelTreeNode.setIsOpened(true);
            DynamicObjectCollection secondLever = newValue.getDynamicObjectCollection("payrollact.entryentity");
            if (CollectionUtils.isEmpty((Collection)secondLever)) continue;
            for (DynamicObject dynamicObject : secondLever) {
                DynamicObject dyobj;
                Long triggerCollaId = dynamicObject.getLong("triggercolla.id");
                if (map.get(triggerCollaId) == null || ((Boolean)map.get(triggerCollaId).get("isMust")).booleanValue()) continue;
                dynamicObject.getDataEntityType();
                DynamicObject queryOne = (DynamicObject)triggerMap.get(triggerCollaId);
                if (null == queryOne || null == (dyobj = queryOne.getDynamicObject("entityobject"))) continue;
                Object objeId = dyobj.getPkValue();
                String objectNumber = String.valueOf(objeId);
                String name = dyobj.getString("name");
                TreeNode secondLevelTreeNode = new TreeNode(firstLevelTreeNode.getId(), nodeIdHelper.genOperateObjectNodeId(payRollActId, triggerCollaId, objectNumber), name);
                secondLevelTreeNode.setDisabled(true);
                secondLevelTreeNode.setColor("black");
                secondLevelTreeNode.setIsOpened(true);
                secondLevelTreeNode.setData((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)dyobj));
                DynamicObjectCollection exeParamEntryEntity = queryOne.getDynamicObjectCollection("exeparamentryentity");
                for (DynamicObject exeParam : exeParamEntryEntity) {
                    String pFieldKey = exeParam.getString("pfieldkey");
                    String pFieldName = exeParam.getString("pfieldname");
                    String pFieldType = exeParam.getString("pfieldtype");
                    boolean pIsMustInput = exeParam.getBoolean("pismustinput");
                    boolean pIsSetRule = exeParam.getBoolean("pissetrule");
                    String thirdLevelNodeId = nodeIdHelper.genExeParamNodeId(payRollActId, triggerCollaId, objectNumber, pFieldKey, Boolean.valueOf(pIsMustInput));
                    TreeNode fieldNode = new TreeNode(secondLevelTreeNode.getId(), thirdLevelNodeId, pFieldName);
                    HashMap<String, Object> thirdLevelData = new HashMap<String, Object>(16);
                    fieldNode.setData(thirdLevelData);
                    thirdLevelData.put("property", pFieldKey);
                    thirdLevelData.put("isShowRuleList", pIsSetRule);
                    thirdLevelData.put("isExeParam", Boolean.TRUE);
                    if (pIsMustInput) {
                        thirdLevelData.put("isMustInput", Boolean.TRUE);
                        fieldNode.setIcon("mustinput");
                    } else {
                        thirdLevelData.put("isMustInput", Boolean.FALSE);
                        fieldNode.setIcon("notmustinput");
                    }
                    if (focusNode == null) {
                        focusNode = fieldNode;
                    }
                    secondLevelTreeNode.addChild(fieldNode);
                }
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dyobj.getString("number"));
                DataEntityPropertyCollection properties = entityType.getProperties();
                DynamicObjectCollection object = queryOne.getDynamicObjectCollection("paramentryentity");
                ArrayList<TreeNode> keyTreeNodeList = new ArrayList<TreeNode>(10);
                ArrayList<TreeNode> normalTreeNodeList = new ArrayList<TreeNode>(10);
                ArrayList<TreeNode> otherTreeNodeList = new ArrayList<TreeNode>(10);
                TreeNode normalNode = new TreeNode(secondLevelTreeNode.getId(), nodeIdHelper.genNormalFieldNodeId(payRollActId, triggerCollaId, objectNumber), ResManager.loadKDString((String)"\u5176\u4ed6\u5b57\u6bb5", (String)"PayRollActGrpEdit_15", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                TreeNode keyNode = new TreeNode(secondLevelTreeNode.getId(), nodeIdHelper.genKeyFieldNodeId(payRollActId, triggerCollaId, objectNumber), ResManager.loadKDString((String)"\u5173\u952e\u5b57\u6bb5", (String)"PayRollActGrpEdit_14", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                for (DynamicObject dyo : object) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)dyo.getString("fieldkey"));
                    if (property == null) continue;
                    String fieldGroup = dyo.getString("fieldgroup");
                    String fieldNumber = property.getName();
                    String displayName = Optional.ofNullable(property.getDisplayName()).orElseGet(() -> new LocaleString("")).toString();
                    boolean isMustInput = property instanceof FieldProp && ((FieldProp)property).isMustInput() || property instanceof BasedataProp && ((BasedataProp)property).isMustInput();
                    String thirdLevelNodeId = nodeIdHelper.genObjectFieldNodeId("L3", payRollActId, triggerCollaId, objectNumber, fieldNumber, Boolean.valueOf(isMustInput));
                    TreeNode fieldNode = new TreeNode(secondLevelTreeNode.getId(), thirdLevelNodeId, displayName);
                    HashMap<String, Object> thirdLevelData = new HashMap<String, Object>(16);
                    fieldNode.setData(thirdLevelData);
                    thirdLevelData.put("property", property.getName());
                    if (isMustInput) {
                        thirdLevelData.put("isMustInput", Boolean.TRUE);
                        fieldNode.setIcon("mustinput");
                    } else {
                        thirdLevelData.put("isMustInput", Boolean.FALSE);
                        fieldNode.setIcon("notmustinput");
                    }
                    if (focusNode == null) {
                        focusNode = fieldNode;
                    }
                    if ("1".equalsIgnoreCase(fieldGroup)) {
                        fieldNode.setId(nodeIdHelper.reGen(thirdLevelNodeId, "L4").orElse(thirdLevelNodeId));
                        fieldNode.setParentid(keyNode.getId());
                        keyNode.setIsOpened(true);
                        keyNode.setDisabled(true);
                        keyNode.setColor("black");
                        keyTreeNodeList.add(fieldNode);
                        continue;
                    }
                    if ("2".equalsIgnoreCase(fieldGroup)) {
                        fieldNode.setId(nodeIdHelper.reGen(thirdLevelNodeId, "L4").orElse(thirdLevelNodeId));
                        fieldNode.setParentid(normalNode.getParentid());
                        normalNode.setIsOpened(true);
                        normalNode.setDisabled(true);
                        normalNode.setColor("black");
                        normalTreeNodeList.add(fieldNode);
                        continue;
                    }
                    otherTreeNodeList.add(fieldNode);
                }
                if (!CollectionUtils.isEmpty(keyTreeNodeList)) {
                    keyNode.addChildren(keyTreeNodeList);
                    secondLevelTreeNode.addChild(keyNode);
                }
                if (!CollectionUtils.isEmpty(normalTreeNodeList)) {
                    normalNode.addChildren(normalTreeNodeList);
                    secondLevelTreeNode.addChild(normalNode);
                }
                if (!CollectionUtils.isEmpty(otherTreeNodeList)) {
                    secondLevelTreeNode.addChildren(otherTreeNodeList);
                }
                if (CollectionUtils.isEmpty((Collection)secondLevelTreeNode.getChildren())) continue;
                firstLevelTreeNode.addChild(secondLevelTreeNode);
            }
            if (CollectionUtils.isEmpty((Collection)firstLevelTreeNode.getChildren())) continue;
            nodes.add(firstLevelTreeNode);
        }
        this.getView().getPageCache().put("FIELD_RULE_TREE_DATA", SWCJSONUtils.toString(nodes));
        filedRuleTreeView.addNodes(nodes);
        filedRuleTreeView.focusNode(focusNode);
    }

    private Boolean isFieldRule(Map<Long, Map<String, Object>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Boolean.FALSE;
        }
        long count = map.entrySet().stream().filter(ma -> MapUtils.getBoolean((Map)((Map)ma.getValue()), (Object)"isMust", (Boolean)Boolean.TRUE) == false).count();
        return count > 0L ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean validPolicyResultsAndNotify(String nodeId) {
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return true;
        }
        HRPolicyEntityWrapper wrapper = this.getPolicyByNodeId(nodeId, null);
        if (wrapper == null) {
            return true;
        }
        if (!PayRollActGrpHelper.validPolicyResults((HRPolicyEntity)wrapper.getPolicy()).booleanValue()) {
            List lastChildPath = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId);
            if (CollaRuleNodeIdHelper.getInstance().isField(nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5b57\u6bb5\u53d6\u503c\u8bbe\u7f6e\u4e2d\u201c{0}\u201d\u7684\u201c{1}\u201d\u7684\u201c{2}\u201d\u7684\u201c\u9ed8\u8ba4\u503c\u201d\u5b57\u6bb5\u3002", (String)"PayRollActGrpFieldRuleEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[]{((TreeNode)lastChildPath.get(0)).getText(), ((TreeNode)lastChildPath.get(1)).getText(), ((TreeNode)lastChildPath.get(lastChildPath.size() - 1)).getText()}));
                return false;
            }
        }
        return true;
    }

    private void clickFieldRuleTree(String nodeId) {
        LOGGER.info("AbstractPayRollActGrpEdit.clickFieldRuleTree,nodeId = {}", (Object)nodeId);
        if (SWCStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        Integer index = PayRollActGrpHelper.getRowIndexByPayRollActId((IFormView)this.getView(), (String)CollaRuleNodeIdHelper.getInstance().parseActionId(nodeId).orElse(""));
        if (index == null) {
            return;
        }
        String lastNodeId = this.getPageCache().get("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID");
        if (!nodeId.equals(lastNodeId) && !this.validPolicyResultsAndNotify(lastNodeId)) {
            this.focusFieldRuleNodeById(lastNodeId, Boolean.FALSE);
            return;
        }
        if (!CollaRuleNodeIdHelper.getInstance().isField(nodeId)) {
            return;
        }
        this.getPageCache().put("CACHE_CURRENT_FIELD_RULE_FOCUS_NODE_ID", nodeId);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index.intValue());
        if (null == entryRowEntity) {
            return;
        }
        this.filedRulePageFlexShowPage(nodeId);
    }

    private void searchFieldRule(String searchText) {
        PayRollActSearchEntity search = this.beforeDoTreeSearch(searchText, "FIELD_RULE_TREE_DATA", "CACHE_FIELD_RULE_SEARCH_DATA", "fieldruletree");
        Integer resultindex = this.doTreeSearch(search);
        this.afterDoTreeSearch(search, resultindex, "CACHE_FIELD_RULE_SEARCH_DATA");
    }

    private void afterDoTreeSearch(PayRollActSearchEntity search, Integer resultindex, String cacheName) {
        if (null == resultindex) {
            this.clearTreeNodeSearchCache(cacheName);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u66f4\u591a\u641c\u7d22\u7ed3\u679c\u3002", (String)"PayRollActGrpFieldRuleEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode treeNode = (TreeNode)search.getTreeNodeList().get(resultindex);
        TreeView treeView = (TreeView)this.getView().getControl(search.getTreeName());
        treeView.focusNode(treeNode);
        treeView.expand(treeNode.getId());
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        this.setTreeNodeSearchCache(cacheName, search.getSearchText(), resultindex);
    }

    private void setTreeNodeSearchCache(String cahceName, String searchText, Integer currentResultIndex) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        cacheMap.put("lastSearchText", searchText);
        cacheMap.put("currentResultIndex", currentResultIndex);
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(cahceName, cacheMap);
    }

    private void clearTreeNodeSearchCache(String cahceName) {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        swcPageCache.put(cahceName, null);
    }

    private PayRollActSearchEntity beforeDoTreeSearch(String searchText, String treeDataCacheName, String searchDataCacheName, String treeName) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        List treeNodes = null;
        PayRollActSearchEntity search = new PayRollActSearchEntity();
        try {
            String treeDataCache = this.getView().getPageCache().get(treeDataCacheName);
            if (!SWCStringUtils.isEmpty((String)treeDataCache)) {
                treeNodes = (List)SWCJSONUtils.cast((String)treeDataCache, List.class, (Class[])new Class[]{TreeNode.class});
                List allTreeNodes = PayRollActGrpHelper.getAllTreeNodes((List)treeNodes);
                search.setTreeNodeList(allTreeNodes);
            }
        }
        catch (IOException e) {
            LOGGER.error("json\u5e8f\u5217\u5316\u9519\u8bef", (Throwable)e);
            throw new KDBizException((Throwable)e, PayRollActGrpHelper.getDefaultErrorCode(), new Object[0]);
        }
        search.setTreeName(treeName);
        search.setSearchText(searchText);
        Map fieldMapSearchCache = (Map)pageCache.get(searchDataCacheName, Map.class);
        if (!CollectionUtils.isEmpty((Map)fieldMapSearchCache)) {
            search.setLastSearchText((String)fieldMapSearchCache.get("lastSearchText"));
            search.setCurrentResultIndex((Integer)fieldMapSearchCache.get("currentResultIndex"));
        }
        return search;
    }

    private Integer doTreeSearch(PayRollActSearchEntity search) {
        String searchText = search.getSearchText();
        String lastSearchText = search.getLastSearchText();
        List treeNodeList = search.getTreeNodeList();
        if (CollectionUtils.isEmpty((Collection)treeNodeList)) {
            return null;
        }
        if (!SWCStringUtils.equalsIgnoreCase((String)lastSearchText, (String)searchText)) {
            search.setCurrentResultIndex(Integer.valueOf(-1));
        }
        for (int i = search.getCurrentResultIndex() + 1; i < treeNodeList.size(); ++i) {
            TreeNode tempTreeNode = (TreeNode)treeNodeList.get(i);
            if (!tempTreeNode.getText().contains(searchText)) continue;
            return i;
        }
        return null;
    }

    private boolean focusNodeById(TreeView treeView, String treeNodeCacheName, String nodeId, Boolean isClick) throws IOException {
        String fieldRuleTreeStr = this.getView().getPageCache().get(treeNodeCacheName);
        if (SWCStringUtils.isEmpty((String)fieldRuleTreeStr)) {
            return false;
        }
        List treeNodes = (List)SWCJSONUtils.cast((String)fieldRuleTreeStr, List.class, (Class[])new Class[]{TreeNode.class});
        if (CollectionUtils.isEmpty((Collection)treeNodes)) {
            return false;
        }
        for (TreeNode treeNode : treeNodes) {
            if (SWCStringUtils.isEmpty((String)nodeId)) {
                TreeNode leafChild = this.getFirstLeafChild(treeNode);
                if (isClick.booleanValue() && leafChild != null) {
                    treeView.focusNode(leafChild);
                    treeView.treeNodeClick(SWCStringUtils.isEmpty((String)leafChild.getParentid()) ? null : leafChild.getParentid(), leafChild.getId());
                }
                return true;
            }
            TreeNode tmpNode = treeNode.getTreeNode(nodeId, 3);
            if (null == tmpNode) continue;
            treeView.focusNode(tmpNode);
            if (isClick.booleanValue()) {
                treeView.treeNodeClick(tmpNode.getParentid(), nodeId);
            }
            return true;
        }
        return false;
    }

    public TreeNode getFirstLeafChild(TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (children == null || children.isEmpty()) {
            return treeNode;
        }
        return this.getFirstLeafChild((TreeNode)children.get(0));
    }

    private void focusFieldRuleNodeById(String nodeId, Boolean isClick) {
        try {
            boolean result = this.focusNodeById((TreeView)this.getControl("fieldruletree"), "FIELD_RULE_TREE_DATA", nodeId, isClick);
            boolean visible = result && !SWCStringUtils.isEmpty((String)nodeId) && CollaRuleNodeIdHelper.getInstance().isField(nodeId);
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"fieldruleflex"});
        }
        catch (IOException ex) {
            LOGGER.info("parse json error", (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    private String filedRulePageFlexShowPage(String nodeId) {
        String pageId = PayRollActGrpHelper.getPageIdByNodeIdFromCache((IFormView)this.getView(), (String)nodeId);
        Tab tab = (Tab)this.getView().getControl("policytabap");
        List items = tab.getItems();
        Set keySet = items.stream().map(Control::getKey).collect(Collectors.toSet());
        if (!SWCStringUtils.isEmpty((String)pageId) && keySet.contains(pageId)) {
            tab.activeTab(pageId);
            return pageId;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setSendToClient(true);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey("policytabap");
        showParameter.setFormId("hpdi_policyconfig");
        showParameter.setStatus(this.getPageStatus());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "HPDI_RULE_POLICY"));
        showParameter.setCustomParams(this.getPolicyParaMap(nodeId));
        this.getView().showForm((FormShowParameter)showParameter);
        String subPageId = showParameter.getPageId();
        PayRollActGrpHelper.putPolicyPageMapCache((IFormView)this.getView(), (String)nodeId, (String)subPageId);
        return subPageId;
    }

    private Map<String, Object> getPolicyParaMap(String nodeId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        paraMap.put("frfieldrule", PayRollActGrpHelper.getFieldRuleIdFromSubEntity((IFormView)this.getView(), (String)nodeId).map(String::valueOf).orElse(null));
        paraMap.put("sceneId", PayRollActGrpHelper.getCurrentSceneId((IFormView)this.getView()));
        paraMap.put("createOrg", this.getModel().getDataEntity().getString("createorg.id"));
        List childPathNodes = PayRollActGrpHelper.getChildPathNodesByNodeId((IFormView)this.getView(), (String)nodeId);
        String type = CollaRuleNodeIdHelper.getInstance().parseType(nodeId).orElse("");
        if (CollaRuleNodeIdHelper.getInstance().isField(nodeId)) {
            Optional<TreeNode> any = childPathNodes.stream().filter(item -> item.getId().equalsIgnoreCase(nodeId)).findAny();
            if (!any.isPresent()) {
                return paraMap;
            }
            TreeNode treeNode = any.get();
            CollaRuleNodeIdHelper nodeIdHelper = CollaRuleNodeIdHelper.getInstance();
            String actionId = nodeIdHelper.parseActionId(nodeId).orElse("0");
            String operateId = nodeIdHelper.parseOperateId(nodeId).orElse("0");
            String entityNumber = nodeIdHelper.parseEntityNumber(nodeId).orElse("");
            String fieldNumber = nodeIdHelper.parseFieldNumber(nodeId).orElse("");
            String isMustInput = nodeIdHelper.parseIsMustInput(nodeId).orElse("false");
            paraMap.put("resultParamStr", this.getResultParamValue(entityNumber, fieldNumber, type));
            paraMap.put("resultSchemaStr", this.getResultParamStr(entityNumber, fieldNumber, type));
            paraMap.put("isShowRuleList", this.getIsSetRuleValue(treeNode));
            paraMap.put("payRollActId", actionId);
            paraMap.put("triggerId", operateId);
            paraMap.put("entityObject", entityNumber);
            paraMap.put("fieldNumber", fieldNumber);
            paraMap.put("isMustInput", isMustInput);
        }
        return paraMap;
    }

    private String getResultParamStr(String entityNumber, String fieldNumber, String type) {
        long sceneId = this.getModel().getDataEntity().getLong("scene.id");
        ResultControlHelper controlHelper = ResultControlHelper.getInstance();
        return JSON.toJSONString((Object)controlHelper.getFilterResult(Long.valueOf(sceneId), entityNumber, fieldNumber, type));
    }

    private Boolean getIsSetRuleValue(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Map data = (Map)treeNode.getData();
        return (Boolean)data.get("isShowRuleList");
    }

    private String getResultParamValue(String entityNumber, String fieldNumber, String type) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("scene");
        DynamicObjectCollection outputParams = dynamicObject.getDynamicObjectCollection("sceneoutputparams");
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            return null;
        }
        if ("03".equalsIgnoreCase(type)) {
            return this.generateExeParamResult(outputParams, entityNumber, fieldNumber);
        }
        return this.generateResult(entityNumber, fieldNumber);
    }

    private String generateExeParamResult(DynamicObjectCollection outputParams, String objectName, String propertyName) {
        MainEntityType dataEntityType;
        ISimpleProperty primaryKey;
        String objectId;
        if (CollectionUtils.isEmpty((Collection)outputParams)) {
            return null;
        }
        HashMap outputMap = new HashMap(16);
        for (DynamicObject outputParam : outputParams) {
            String otNumber = outputParam.getString("outputnumber");
            if (SWCStringUtils.isEmpty((String)otNumber)) continue;
            Map tempValue = outputMap.computeIfAbsent(otNumber, item -> new HashMap(16));
            tempValue.put("outputName", outputParam.getString("outputname"));
            tempValue.put("outputObjectName", outputParam.getString("outputobject.name"));
            tempValue.put("outputObjectId", outputParam.getString("outputobject.id"));
            tempValue.put("outputParamsType", outputParam.getString("outputparamstype"));
        }
        String param = objectName + "_" + propertyName;
        Map rowMap = outputMap.getOrDefault(param, Collections.emptyMap());
        String outputParamsType = MapUtils.getString(rowMap, (Object)"outputParamsType");
        if ("basedata".equalsIgnoreCase(outputParamsType) && !SWCStringUtils.isEmpty((String)(objectId = MapUtils.getString(rowMap, (Object)"outputObjectId"))) && (primaryKey = (dataEntityType = EntityMetadataCache.getDataEntityType((String)objectName)).getPrimaryKey()) != null) {
            String pk = primaryKey.getName();
            param = param + "." + objectId + "." + pk;
        }
        try {
            return this.getResultJson(objectName + "_" + propertyName, param);
        }
        catch (IOException e) {
            LOGGER.info("[payrollactg] parse json erro", (Object)e);
            return null;
        }
    }

    private String generateResult(String objectName, String propertyName) {
        ISimpleProperty primaryKey;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)objectName);
        DynamicProperty property = dataEntityType.getProperty(propertyName);
        String displayParam = dataEntityType.getDisplayName().getLocaleValue() + "." + Optional.ofNullable(property.getDisplayName()).orElseGet(() -> new LocaleString("")).getLocaleValue();
        String param = objectName + "." + objectName + "." + propertyName;
        if (property.getPropertyType().equals(DynamicObject.class) && (primaryKey = dataEntityType.getPrimaryKey()) != null) {
            param = param + "." + primaryKey.getName();
        }
        String resultJson = "";
        try {
            resultJson = this.getResultJson(displayParam, param);
        }
        catch (IOException e) {
            LOGGER.error("\u8bbe\u7f6e\u9ed8\u8ba4\u7ed3\u679c\u5b57\u6bb5\u51fa\u9519.", (Throwable)e);
            return null;
        }
        return resultJson;
    }

    private String getResultJson(String displayParam, String param) throws IOException {
        RuleResultInfo ruleResultInfo = new RuleResultInfo();
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setDisplayParam(displayParam);
        resultInfo.setParam(param);
        resultInfo.setOperators("==");
        resultInfo.setValueType("2");
        resultInfo.setIndex(0);
        ArrayList<ResultInfo> resultDataList = new ArrayList<ResultInfo>();
        resultDataList.add(resultInfo);
        ruleResultInfo.setResultList(resultDataList);
        return SWCJSONUtils.toString((Object)ruleResultInfo);
    }
}

