/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata.cloudcolla;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.business.cloudcolla.ResultControlHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PayRollActPolicyEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
PayRollActGrpConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PayRollActPolicyEdit.class);
    public static final String CTRL_STRATEGY_PRIVATE = "7";
    public static final String FIELD_SET_TYPE = "settype";
    public static final String ENTITY_HPDI_PAYROLLACTG_TIPS = "hpdi_payrollactgtips";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"ruletoolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryrulelist");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit fieldRule = (BasedataEdit)this.getControl("fieldrule");
        fieldRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baraddrule": {
                this.showRuleDesignPage(null);
                break;
            }
            case "btndeleterule": {
                this.deleteRuleEntry();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "retrundefault": {
                boolean newValue = (Boolean)event.getChangeSet()[0].getNewValue();
                this.updateReturnDefaultValue(newValue);
                break;
            }
            case "ruledate": {
                Object newDate = event.getChangeSet()[0].getNewValue();
                if (!(newDate instanceof Date)) break;
                DefaultResult control = this.getDefaultResultControl();
                this.updateRuleDate((Date)newDate, new RuleControl[]{control});
                this.getModel().setValue("ruledate", null);
                break;
            }
            case "settype": {
                this.onSetTypeChanged(event);
                break;
            }
            case "fieldrule": {
                long policyId = this.getModel().getDataEntity().getLong("fieldrule.policy.id");
                this.getModel().setValue("policy", (Object)(policyId == 0L ? null : Long.valueOf(policyId)));
                break;
            }
            case "policy": {
                this.initPageValue(null);
                break;
            }
        }
    }

    private void onSetTypeChanged(PropertyChangedArgs event) {
        ChangeData changeData = event.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("exist".equalsIgnoreCase(newValue)) {
            boolean returnDefault = dataEntity.getBoolean("retrundefault");
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryrulelist");
            if (!returnDefault && CollectionUtils.isEmpty((Collection)entry)) {
                this.clearFieldRuleData();
                return;
            }
        }
        if ("new".equalsIgnoreCase(newValue) && dataEntity.getDynamicObject("fieldrule") == null) {
            this.clearFieldRuleData();
            return;
        }
        String oldValue = (String)changeData.getOldValue();
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u201c\u914d\u7f6e\u65b9\u5f0f\u201d\u540e\uff0c\u5c06\u6e05\u7a7a\u201c\u9ed8\u8ba4\u7ed3\u679c\u201d\u548c\u201c\u89c4\u5219\u4fe1\u606f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayRollActPolicyEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("CALLBACK_SETTYPE_CHANGED", (IFormPlugin)this), null, oldValue);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("CALLBACK_SETTYPE_CHANGED".equalsIgnoreCase(callBackId)) {
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.clearFieldRuleData();
            } else {
                String oldValue = event.getCustomVaule();
                IDataModel model = this.getModel();
                model.beginInit();
                model.setValue(FIELD_SET_TYPE, (Object)oldValue);
                model.endInit();
                this.getView().updateView(FIELD_SET_TYPE);
            }
        }
    }

    private void clearFieldRuleData() {
        IDataModel model = this.getModel();
        String setType = model.getDataEntity().getString(FIELD_SET_TYPE);
        model.beginInit();
        model.setValue("fieldrule", null);
        model.setValue("policy", null);
        model.deleteEntryData("entryrulelist");
        if ("new".equalsIgnoreCase(String.valueOf(setType))) {
            String newPolicyNumber = PayRollActGrpHelper.newPolicyNumber();
            model.setValue("number", (Object)newPolicyNumber);
            model.setValue("name", (Object)newPolicyNumber);
        }
        model.endInit();
        this.getView().updateView("fieldrule");
        this.getView().updateView("policy");
        this.getView().updateView("entryrulelist");
        this.initPageLayout(null);
        model.setValue("retrundefault", (Object)Boolean.FALSE);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int row = evt.getRowIndex();
        if (HRStringUtils.equals((String)fieldName, (String)"rulenumber")) {
            this.showRuleDesignPage(row);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject customParams = (JSONObject)formShowParameter.getCustomParams();
        String policyObjectStr = customParams.getString("hrPolicy");
        String fieldRuleId = customParams.getString("frfieldrule");
        this.getModel().setValue("fieldrule", (Object)(SWCStringUtils.isEmpty((String)fieldRuleId) ? null : Long.valueOf(fieldRuleId)));
        this.getModel().setValue("policy", (Object)this.getModel().getDataEntity().getLong("fieldrule.policy.id"));
        this.getDefaultResultControl().setScene(String.valueOf(this.getSceneId()));
        this.initPageLayout(null);
        this.initPageValue(null);
        this.setRuleTips();
    }

    public void afterCreateNewData(EventObject e) {
    }

    private void initDefaultResultControl(String value, String pageState) {
        String resultSchemaStr = MapUtils.getString((Map)this.getView().getFormShowParameter().getCustomParams(), (Object)"resultSchemaStr", (String)JSON.toJSONString(Collections.singleton(ImmutableMap.of())));
        ResultControlHelper.getInstance().updateResultControlData(this.getView(), "defaultresultap", JSON.parse((String)resultSchemaStr), (Object)ParamsUtil.getInputValueParamMap((Long)this.getSceneId()), value, pageState);
    }

    private void initRuleEntryVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean isSetRule = MapUtils.getBoolean((Map)customParams, (Object)"isShowRuleList", (Boolean)Boolean.TRUE);
        this.getView().setVisible(isSetRule, new String[]{"ruleinfo"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("CALLBACK_ADD_RULE".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) instanceof HrRuleDesignEntity && !StringUtils.isEmpty((CharSequence)((HrRuleDesignEntity)returnData).getRuleNumber())) {
            HrRuleDesignEntity rule = (HrRuleDesignEntity)returnData;
            Integer index = this.isRuleNumberExist(rule.getRuleNumber());
            IDataModel dataModel = this.getModel();
            if (index < 0) {
                index = dataModel.createNewEntryRow("entryrulelist");
            }
            dataModel.setValue("rulenumber", (Object)rule.getRuleNumber(), index.intValue());
            dataModel.setValue("rulename", (Object)rule.getRuleName(), index.intValue());
            dataModel.setValue("filtercondition", (Object)rule.getFilterCondition(), index.intValue());
            dataModel.setValue("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), index.intValue());
            dataModel.setValue("filterresult", (Object)rule.getFilterResult(), index.intValue());
            dataModel.setValue("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), index.intValue());
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        DefaultResult defaultResultControl;
        super.clientCallBack(e);
        String name = e.getName();
        if ("CLIENT_CALLBACK_UPDATE_F7_FILTER".equalsIgnoreCase(name) && (defaultResultControl = this.getDefaultResultControl()) != null) {
            String value = defaultResultControl.getValue();
            String filterStr = this.addFilterToResult(value);
            String setType = this.getModel().getDataEntity().getString(FIELD_SET_TYPE);
            this.initDefaultResultControl(filterStr, "exist".equalsIgnoreCase(setType) ? "view" : "edit");
        }
        if ("UPDATE_RESULT_STATE".equalsIgnoreCase(name)) {
            // empty if block
        }
    }

    private void updateRuleDate(Date date, RuleControl ... controls) {
        if (controls == null || controls.length < 1 || null == date) {
            return;
        }
        String dateFormat = this.getView().getPageCache().get("ruleDateFormat");
        String value = SWCStringUtils.isEmpty((String)dateFormat) ? SWCDateTimeUtils.formatDate((Date)date) : SWCDateTimeUtils.format((Date)date, (String)dateFormat);
        for (RuleControl ruleControl : controls) {
            ruleControl.setDate(value);
        }
    }

    private void updateReturnDefaultValue(boolean newValue) {
        String controlValue = "";
        if (newValue) {
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("resultParamStr");
            String policyResult = this.getModel().getDataEntity().getString("policy.results");
            if (!SWCStringUtils.isEmpty((String)policyResult)) {
                customParam = policyResult;
            }
            if (!SWCStringUtils.isEmpty((String)customParam)) {
                controlValue = this.addFilterToResult(customParam);
            }
        }
        this.setReturnDefaultVisible(newValue, controlValue);
    }

    private String addFilterToResult(String customParam) {
        if (SWCStringUtils.isEmpty((String)customParam)) {
            return customParam;
        }
        try {
            RuleResultInfo cast = (RuleResultInfo)SWCJSONUtils.cast((String)customParam, RuleResultInfo.class, (boolean)true);
            List resultList = cast.getResultList();
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return customParam;
            }
            for (ResultInfo resultInfo : resultList) {
                List<QFilter> qFilterByResultInfo = this.getQFilterByResultInfo(resultInfo);
                if (CollectionUtils.isEmpty(qFilterByResultInfo)) continue;
                resultInfo.setFilters(SWCJSONUtils.toString(qFilterByResultInfo));
            }
            return SWCJSONUtils.toString((Object)cast);
        }
        catch (IOException e) {
            LOGGER.info("[payrollacttpl] parse json error.", (Object)e);
            return customParam;
        }
    }

    private List<QFilter> getQFilterByResultInfo(ResultInfo resultInfo) {
        String param = resultInfo.getParam();
        if (SWCStringUtils.isEmpty((String)param)) {
            return Collections.emptyList();
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgIdStr = (String)customParams.get("createOrg");
        Long orgId = Long.valueOf(orgIdStr);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return Collections.emptyList();
        }
        String formId = parentView.getFormShowParameter().getFormId();
        String ctrlStrategy = CTRL_STRATEGY_PRIVATE;
        if (this.allCollaRuleEntityNumber().contains(formId)) {
            ctrlStrategy = parentView.getModel().getDataEntity().getString("ctrlstrategy");
        }
        List<QFilter> result = CTRL_STRATEGY_PRIVATE.equals(ctrlStrategy) ? this.getPrivateFilter(param, orgId) : this.getNonPrivateFilter(param, orgId);
        return result;
    }

    private Set<String> allCollaRuleEntityNumber() {
        return ImmutableSet.of((Object)"hpdi_collarulecdm", (Object)"hpdi_collarulecsi", (Object)"hpdi_collarulesal", (Object)"hpdi_collaruletax");
    }

    private String getParentPageFormId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        return parentView.getFormShowParameter().getFormId();
    }

    private List<QFilter> getPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hsas", (String)this.getParentPageFormId());
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                return Arrays.asList(new QFilter("org", "=", (Object)orgId), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hsas"));
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (Long)orgId), this.getEnableQFilter(), this.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("itc"));
            }
            case "hcdm_adjfileinfo.hcdm_adjfileinfo.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hcdm"));
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hcsi"));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
        }
        return Collections.emptyList();
    }

    private QFilter getEmpGroupQfilter(String appNumber) {
        List empGroupByAppNumber = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)appNumber);
        if (CollectionUtils.isEmpty((Collection)empGroupByAppNumber)) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        return new QFilter("id", "in", (Object)empGroupByAppNumber);
    }

    private List<QFilter> getNonPrivateFilter(String param, Long orgId) {
        LOGGER.info("[payrollactg] policy page get createOrg = {} ", (Object)orgId);
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"hpdi", (String)this.getParentPageFormId());
        boolean isAllOrgPermission = permOrgs.hasAllOrgPerm();
        QFilter all = new QFilter("1", "=", (Object)1);
        switch (param.toLowerCase(Locale.ROOT)) {
            case "hsas_salaryfile.hsas_salaryfile.payrollgroup.id": {
                isAllOrgPermission = permOrgs.hasAllOrgPerm();
                return Arrays.asList(isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107010L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hsas_salaryfile.hsas_salaryfile.salarycalcstyle.id": {
                SWCDataServiceHelper orm = new SWCDataServiceHelper("hsas_salarycalcstyle");
                DynamicObject[] dynamicObjects = orm.queryOriginalArray("id", new QFilter[]{isAllOrgPermission ? all : SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (List)permOrgs.getHasPermOrgs(), (boolean)true), this.getEnableQFilter(), this.getStatusQFilter()});
                if (dynamicObjects == null) {
                    return Collections.singletonList(new QFilter("1", "=", (Object)2));
                }
                return Collections.singletonList(new QFilter("id", "in", Arrays.stream(dynamicObjects).map(item -> item.getLong("id")).collect(Collectors.toList())));
            }
            case "itc_taxfile.itc_taxfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107030L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.taxunit.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "itc_taxfile.itc_taxfile.org.id": {
                return Arrays.asList(new QFilter("fishrtax", "=", (Object)"1"), isAllOrgPermission ? all : new QFilter("id", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.empgroup.id": {
                return Arrays.asList(new QFilter("bussinessfield", "=", (Object)107050L), this.getEnableQFilter(), this.getStatusQFilter());
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayer.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hcsi_sinsurfile.hcsi_sinsurfile.welfarepayertheory.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), isAllOrgPermission ? all : new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
            }
            case "hsas_personchange.hsas_personchange.changereason.id": {
                return Arrays.asList(this.getEnableQFilter(), this.getStatusQFilter(), new QFilter("bussinessfield.id", "!=", (Object)107010L));
            }
            case "hcdm_adjfileinfo.hcdm_adjfileinfo.empgroup.id": {
                return Collections.singletonList(this.getEmpGroupQfilter("hcdm"));
            }
        }
        return Collections.emptyList();
    }

    private QFilter getEnableQFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    private QFilter getStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    private void deleteRuleEntry() {
        EntryGrid control = (EntryGrid)this.getControl("entryrulelist");
        int[] selectRows = control.getSelectRows();
        this.getView().getModel().deleteEntryRows("entryrulelist", selectRows);
    }

    private void showRuleDesignPage(Integer row) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u8bbe\u7f6e", (String)"PayRollActPolicyEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParams(this.getParaMap(row));
        billShowParameter.setFormId("hpdi_ruledesignconfig");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String setType = this.getModel().getDataEntity().getString(FIELD_SET_TYPE);
        if ("exist".equalsIgnoreCase(setType)) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            billShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        }
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_RULE"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getParaMap(Integer row) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sceneId", this.getSceneId());
        param.put("hrRule", this.getRule(row));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String resultParamStr = MapUtils.getString((Map)customParams, (Object)"resultParamStr");
        String resultSchemaStr = MapUtils.getString((Map)customParams, (Object)"resultSchemaStr");
        param.put("resultParamStr", this.addFilterToResult(resultParamStr));
        param.put("resultSchemaStr", resultSchemaStr);
        return param;
    }

    private HrRuleDesignEntity getRule(Integer row) {
        HrRuleDesignEntity HrRuleDesignEntity2 = new HrRuleDesignEntity();
        if (null != row) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryrulelist", row.intValue());
            HrRuleDesignEntity2.setRuleNumber(entryRowEntity.getString("rulenumber"));
            HrRuleDesignEntity2.setRuleName(entryRowEntity.getString("rulename"));
            HrRuleDesignEntity2.setFilterCondition(entryRowEntity.getString("filtercondition"));
            HrRuleDesignEntity2.setFilterResult(this.addFilterToResult(entryRowEntity.getString("filterresult")));
        }
        return HrRuleDesignEntity2;
    }

    private Integer isRuleNumberExist(String ruleNumber) {
        Integer result = -1;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryrulelist");
        if (StringUtils.isEmpty((CharSequence)ruleNumber) || CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!ruleNumber.equals(dynamicObject.getString("rulenumber"))) continue;
            return i;
        }
        return result;
    }

    private void setReturnDefaultVisible(boolean visible, String controlValue) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexreturndefault"});
        String setType = this.getModel().getDataEntity().getString(FIELD_SET_TYPE);
        this.initDefaultResultControl(controlValue, "exist".equalsIgnoreCase(setType) ? "view" : "edit");
    }

    private void initPageLayout(HRPolicyEntity policyObject) {
        this.initRuleEntryVisible();
        String setType = this.getModel().getDataEntity().getString(FIELD_SET_TYPE);
        if ("new".equalsIgnoreCase(setType)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexfieldrule"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ruletoolbar"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldrule"});
            BasedataEdit fieldRuleControl = (BasedataEdit)this.getControl("fieldrule");
            fieldRuleControl.setMustInput(false);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexfieldrule"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ruletoolbar"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldrule"});
            BasedataEdit fieldRuleControl = (BasedataEdit)this.getControl("fieldrule");
            Boolean isMustInput = Boolean.valueOf((String)this.getView().getFormShowParameter().getCustomParam("isMustInput"));
            fieldRuleControl.setMustInput(isMustInput.booleanValue());
        }
    }

    private void resetLayoutAndValue(String setType) {
    }

    private void initPageValue(HRPolicyEntity policyObject) {
        if (policyObject == null) {
            DynamicObject policy = this.getModel().getDataEntity().getDynamicObject("policy");
            policyObject = PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy((DynamicObject)policy);
        }
        if (policyObject == null) {
            this.setNewPageValue();
        } else {
            this.setUpdatePageValue(policyObject);
        }
    }

    private void setRuleTips() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityObjectId = (String)customParams.get("entityObject");
        String fieldNumber = (String)customParams.get("fieldNumber");
        if (SWCStringUtils.isEmpty((String)entityObjectId) || SWCStringUtils.isEmpty((String)fieldNumber)) {
            return;
        }
        SWCDataServiceHelper orm = new SWCDataServiceHelper(ENTITY_HPDI_PAYROLLACTG_TIPS);
        SWCDataServiceHelper bosEntityOrm = new SWCDataServiceHelper("bos_entityobject");
        DynamicObject entityObject = bosEntityOrm.queryOne((Object)entityObjectId);
        DynamicObject tipsObject = orm.generateEmptyDynamicObject();
        tipsObject.set("entityobject", (Object)entityObject);
        tipsObject.set("fieldnumber", (Object)fieldNumber);
        List tipsResult = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptContent", (Object[])new Object[]{ENTITY_HPDI_PAYROLLACTG_TIPS, ENTITY_HPDI_PAYROLLACTG_TIPS, tipsObject});
        Hint hintAp = (Hint)this.getControl("ruletips");
        if (CollectionUtils.isEmpty((Collection)tipsResult)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ruletips", "tipsflex"});
            return;
        }
        String tips = tipsResult.stream().filter(SWCStringUtils::isNotEmpty).collect(Collectors.joining(System.lineSeparator()));
        this.getView().setVisible(Boolean.valueOf(!SWCStringUtils.isEmpty((String)tips)), new String[]{"ruletips", "tipsflex"});
        if (!SWCStringUtils.isEmpty((String)tips)) {
            hintAp.setConent(tips);
        }
    }

    private void setNewPageValue() {
        DefaultResult defaultResultControl = this.getDefaultResultControl();
        String newPolicyNumber = PayRollActGrpHelper.newPolicyNumber();
        IDataModel model = this.getModel();
        model.beginInit();
        this.getModel().setValue("number", (Object)newPolicyNumber);
        this.getModel().setValue("name", (Object)newPolicyNumber);
        model.endInit();
        this.getModel().deleteEntryData("entryrulelist");
        this.getModel().setValue("retrundefault", (Object)Boolean.FALSE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexreturndefault"});
    }

    private void setUpdatePageValue(HRPolicyEntity policyObject) {
        DefaultResult defaultResultControl = this.getDefaultResultControl();
        IDataModel model = this.getModel();
        model.setValue("name", (Object)policyObject.getName());
        model.setValue("number", (Object)policyObject.getNumber());
        this.getModel().setValue("retrundefault", (Object)(policyObject.getIsDefaultResult() == false ? 1 : 0));
        model.endInit();
        this.initEntryRuleList(policyObject);
        boolean lastValue = this.getModel().getDataEntity().getBoolean("retrundefault");
        Boolean isDefaultResult = policyObject.getIsDefaultResult();
        this.getModel().setValue("retrundefault", (Object)policyObject.getIsDefaultResult());
        this.getView().setVisible(policyObject.getIsDefaultResult(), new String[]{"flexreturndefault"});
    }

    private DefaultResult getDefaultResultControl() {
        return (DefaultResult)this.getControl("defaultresultap");
    }

    private Long getSceneId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("sceneId");
    }

    private void initEntryRuleList(HRPolicyEntity policy) {
        this.getModel().deleteEntryData("entryrulelist");
        List entryRuleList = policy.getEntryRuleList();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (int i = 0; i < entryRuleList.size(); ++i) {
            HrRuleDesignEntity rule = (HrRuleDesignEntity)entryRuleList.get(i);
            setter.set("filtercondition", (Object)rule.getFilterCondition(), i);
            setter.set("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
            setter.set("filterresult", (Object)rule.getFilterResult(), i);
            setter.set("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), i);
            setter.set("rulename", (Object)rule.getRuleName(), i);
            setter.set("rulenumber", (Object)rule.getRuleNumber(), i);
            setter.set("seq", (Object)rule.getRuleOrder(), i);
        }
        dataModel.batchCreateNewEntryRow("entryrulelist", setter);
        dataModel.endInit();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("fieldrule".equalsIgnoreCase(name)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long createOrg = MapUtils.getLong((Map)customParams, (Object)"createOrg");
            QFilter sceneFilter = new QFilter("scene.id", "=", (Object)MapUtils.getLong((Map)customParams, (Object)"sceneId"));
            QFilter triggerFilter = new QFilter("triggercolla.id", "=", (Object)MapUtils.getLong((Map)customParams, (Object)"triggerId"));
            QFilter payRollActFilter = new QFilter("payrollact.id", "=", (Object)MapUtils.getLong((Map)customParams, (Object)"payRollActId"));
            QFilter fieldNumberFilter = new QFilter("fieldkey", "=", (Object)MapUtils.getString((Map)customParams, (Object)"fieldNumber"));
            QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hpdi_fieldrule", (Long)createOrg);
            event.addCustomQFilter(sceneFilter.and(triggerFilter).and(fieldNumberFilter).and(orgFilter).and(payRollActFilter));
        }
    }
}

