/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata.fieldrule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.ruleengine.controls.DefaultResult;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hpdi.business.cloudcolla.PayRollActGrpHelper;
import kd.swc.hpdi.business.cloudcolla.ResultControlHelper;
import kd.swc.hpdi.business.cloudcolla.fieldrule.FieldRuleHelper;
import kd.swc.hpdi.business.cloudcolla.fieldrule.PolicyHelper;
import kd.swc.hpdi.common.constants.PayRollActGrpConstants;
import kd.swc.hpdi.common.entity.HRPolicyEntity;
import kd.swc.hpdi.common.entity.HrRuleDesignEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FieldRuleEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
PayRollActGrpConstants {
    private static final Log LOGGER = LogFactory.getLog(FieldRuleEdit.class);
    public static final String CACHE_CHANGED_DATA_PAYROLLACT = "CACHE_CHANGED_DATA_PAYROLLACT";
    public static final String CACHE_CHANGED_DATA_SCENE = "CACHE_CHANGED_DATA_SCENE";
    public static final String CACHE_CHANGED_DATA_SHOWFIELDNAME = "CACHE_CHANGED_DATA_SHOWFIELDNAME";
    public static final String CONFIRM_CALLBACK_CHANGED_PAYROLLACT = "CONFIRM_CALLBACK_CHANGED_PAYROLLACT";
    public static final String CONFIRM_CALLBACK_CHANGED_SCENE = "CONFIRM_CALLBACK_CHANGED_SCENE";
    public static final String CONFIRM_CALLBACK_CHANGED_SHOWFIELDNAME = "CONFIRM_CALLBACK_CHANGED_SHOWFIELDNAME ";
    public static final String CALLBACK_SELECTFIELDKEY = "CALLBACK_SELECTFIELDKEY";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit scene = (BasedataEdit)this.getView().getControl("scene");
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"ruletoolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryrulelist");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"showfieldname"});
    }

    public void beforeBindData(EventObject e) {
        this.initFieldName();
    }

    private void initFieldName() {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("showfieldname");
        fieldEdit.setMustInput(true);
        IDataModel model = this.getModel();
        DynamicObject fieldRuleDyn = model.getDataEntity();
        String fieldName = fieldRuleDyn.getString("fieldname");
        String showFieldName = fieldRuleDyn.getString("showfieldname");
        if (!StringUtils.isEmpty((CharSequence)showFieldName) || StringUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        model.beginInit();
        model.setValue("showfieldname", (Object)fieldName);
        model.endInit();
    }

    public void afterBindData(EventObject e) {
        this.initPolicyPage();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if (SWCStringUtils.equals((String)"showfieldname", (String)operateKey)) {
            this.showTriggerFieldsF7();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "baraddrule": {
                this.showRuleDesignPage(null);
                break;
            }
            case "btndeleterule": {
                this.deleteRuleEntry();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "scene": {
                this.onBeforeSceneSelected(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        ChangeData changeSet = event.getChangeSet()[0];
        Object oldValue = changeSet.getOldValue();
        switch (fieldKey) {
            case "payrollact": {
                this.payrollActPropertyChanged((DynamicObject)oldValue);
                break;
            }
            case "scene": {
                this.scenePropertyChanged((DynamicObject)oldValue);
                break;
            }
            case "showfieldname": {
                this.fieldKeyPropertyChanged((String)oldValue);
                break;
            }
            case "retrundefault": {
                boolean isOpen = (Boolean)event.getChangeSet()[0].getNewValue();
                String controlValue = PolicyHelper.buildDefaultResultValue((DynamicObject)this.getModel().getDataEntity());
                this.updateReturnDefaultValue(isOpen, controlValue);
                break;
            }
            case "ruledate": {
                Object newDate = event.getChangeSet()[0].getNewValue();
                if (!(newDate instanceof Date)) break;
                DefaultResult control = this.getDefaultResultControl();
                PolicyHelper.updateRuleDate((IFormView)this.getView(), (Date)((Date)newDate), (RuleControl[])new RuleControl[]{control});
                this.getModel().setValue("ruledate", null);
                break;
            }
            case "ctrlstrategy": {
                DefaultResult defaultResultControl = this.getDefaultResultControl();
                if (defaultResultControl == null) break;
                String filterStr = PolicyHelper.buildDefaultResultValue((DynamicObject)this.getModel().getDataEntity());
                defaultResultControl.setValueAndUpdateControl(filterStr);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int row = evt.getRowIndex();
        if (HRStringUtils.equals((String)fieldName, (String)"rulenumber")) {
            this.showRuleDesignPage(row);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                if (this.needConfirm(formOperate) || !event.isCancel() && !this.beforeSaveOperation(operateKey)) {
                    event.setCancel(true);
                    return;
                }
                Long oldPolicyId = 0L;
                String oldPolicyIdStr = this.getView().getPageCache().get("oldPolicyId");
                if (!StringUtils.isEmpty((CharSequence)oldPolicyIdStr)) {
                    oldPolicyId = Long.parseLong(oldPolicyIdStr);
                }
                formOperate.getOption().setVariableValue("oldPolicyId", String.valueOf(oldPolicyId));
                break;
            }
        }
    }

    private boolean needConfirm(FormOperate formOperate) {
        String confirmUpdate = formOperate.getOption().getVariableValue("confirmUpdate", "0");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)confirmUpdate)) {
            return false;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String msg = FieldRuleHelper.validCiteInfo((DynamicObject)dataEntity);
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return false;
        }
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmUpdate"));
        this.getPageCache().put("formOperate", formOperate.getOperateKey());
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        FormOperate formOperate = (FormOperate)event.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "unsubmit": 
            case "unaudit": {
                this.getView().updateView();
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = event.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.getView().updateView();
                this.getView().getPageCache().remove("oldPolicyId");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        switch (event.getCallBackId()) {
            case "CONFIRM_CALLBACK_CHANGED_PAYROLLACT": {
                this.changedConfirmCallback(event, "payrollact", CACHE_CHANGED_DATA_PAYROLLACT);
                break;
            }
            case "CONFIRM_CALLBACK_CHANGED_SCENE": {
                this.changedConfirmCallback(event, "scene", CACHE_CHANGED_DATA_SCENE);
                break;
            }
            case "CONFIRM_CALLBACK_CHANGED_SHOWFIELDNAME ": {
                this.changedConfirmCallback(event, "showfieldname", CACHE_CHANGED_DATA_SHOWFIELDNAME);
                break;
            }
            case "confirmUpdate": {
                String formOperate = this.getPageCache().get("formOperate");
                this.getPageCache().remove("formOperate");
                if (!MessageBoxResult.Yes.equals((Object)event.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("confirmUpdate", "1");
                this.getView().invokeOperation(formOperate, operateOption);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "CALLBACK_SELECTFIELDKEY": {
                if (returnData == null) break;
                Map keyInfo = (Map)returnData;
                IDataModel model = this.getModel();
                model.setValue("triggercolla", keyInfo.get("triggercolla"));
                model.setValue("entrytype", keyInfo.get("entrytype"));
                model.setValue("fieldkey", keyInfo.get("fieldkey"));
                model.setValue("showfieldname", keyInfo.get("fieldname"));
                model.setValue("fieldname", keyInfo.get("fieldname"));
                this.getView().updateView("showfieldname");
                this.getView().updateView("triggercolla");
                break;
            }
            case "CALLBACK_ADD_RULE": {
                if (!(returnData instanceof HrRuleDesignEntity) || StringUtils.isEmpty((CharSequence)((HrRuleDesignEntity)returnData).getRuleNumber())) break;
                HrRuleDesignEntity rule = (HrRuleDesignEntity)returnData;
                Integer index = this.isRuleNumberExist(rule.getRuleNumber());
                IDataModel dataModel = this.getModel();
                if (index < 0) {
                    index = dataModel.createNewEntryRow("entryrulelist");
                }
                dataModel.setValue("rulenumber", (Object)rule.getRuleNumber(), index.intValue());
                dataModel.setValue("rulename", (Object)rule.getRuleName(), index.intValue());
                dataModel.setValue("filtercondition", (Object)rule.getFilterCondition(), index.intValue());
                dataModel.setValue("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), index.intValue());
                dataModel.setValue("filterresult", (Object)rule.getFilterResult(), index.intValue());
                dataModel.setValue("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), index.intValue());
                break;
            }
        }
    }

    private void initPolicyPage() {
        DynamicObject fieldRuleDyn = this.getModel().getDataEntity(true);
        String status = fieldRuleDyn.getString("status");
        DynamicObject policy = fieldRuleDyn.getDynamicObject("policy");
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
            this.setCanEditPolicyInfo(Boolean.FALSE);
            this.updatePolicyRuleInfo(PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy((DynamicObject)policy));
            this.getDefaultResultControl().setPageState("view");
        } else if (!FieldRuleHelper.isCanEditFieldRule((DynamicObject)fieldRuleDyn)) {
            this.setCanEditPolicyInfo(Boolean.FALSE);
            this.setEmptyPolicyInfo();
        } else {
            this.setCanEditPolicyInfo(Boolean.TRUE);
            if (policy != null) {
                this.updatePolicyRuleInfo(PayRollActGrpHelper.convertBrmPolicyDynamicToHrPolicy((DynamicObject)policy));
            }
        }
    }

    private void setCanEditPolicyInfo(Boolean isCanEdit) {
        this.getView().setEnable(isCanEdit, new String[]{"fieldruleset"});
        this.getView().setVisible(isCanEdit, new String[]{"ruletoolbar"});
    }

    private void setEmptyPolicyInfo() {
        IDataModel model = this.getModel();
        Long oldPolicyId = model.getDataEntity().getLong("policy.id");
        if (oldPolicyId != null && oldPolicyId != 0L) {
            this.getView().getPageCache().put("oldPolicyId", String.valueOf(oldPolicyId));
        }
        model.setValue("policy", null);
        DefaultResult defaultResultControl = this.getDefaultResultControl();
        model.deleteEntryData("entryrulelist");
        defaultResultControl.setValueAndUpdateControl(null);
        model.setValue("retrundefault", (Object)Boolean.FALSE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexreturndefault"});
    }

    private void updatePolicyRuleInfo(HRPolicyEntity policyObject) {
        if (policyObject == null) {
            LOGGER.info("FieldRulePolicyEdit setUpdatePageValue policyObject is null");
            return;
        }
        this.initEntryRuleList(policyObject);
        Boolean isDefaultResult = policyObject.getIsDefaultResult();
        IDataModel model = this.getModel();
        if (isDefaultResult.booleanValue()) {
            String controlValue = PolicyHelper.addFilterToResult((String)policyObject.getResults(), (DynamicObject)model.getDataEntity());
            this.updateReturnDefaultValue(isDefaultResult, controlValue);
        } else {
            this.updateReturnDefaultValue(isDefaultResult, null);
        }
        model.beginInit();
        model.setValue("retrundefault", (Object)isDefaultResult);
        model.endInit();
        this.getView().updateView("retrundefault");
    }

    private void initEntryRuleList(HRPolicyEntity policy) {
        List entryRuleList = policy.getEntryRuleList();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.deleteEntryData("entryrulelist");
        TableValueSetter setter = new TableValueSetter(new String[0]);
        for (int i = 0; i < entryRuleList.size(); ++i) {
            HrRuleDesignEntity rule = (HrRuleDesignEntity)entryRuleList.get(i);
            setter.set("filtercondition", (Object)rule.getFilterCondition(), i);
            setter.set("filterconditionstr", (Object)PayRollActGrpHelper.formatRuleConditionInfo((String)rule.getFilterCondition()), i);
            setter.set("filterresult", (Object)rule.getFilterResult(), i);
            setter.set("filterresultstr", (Object)PayRollActGrpHelper.formatRuleResultInfo((String)rule.getFilterResult()), i);
            setter.set("rulename", (Object)rule.getRuleName(), i);
            setter.set("rulenumber", (Object)rule.getRuleNumber(), i);
            setter.set("seq", (Object)rule.getRuleOrder(), i);
        }
        dataModel.batchCreateNewEntryRow("entryrulelist", setter);
    }

    private boolean beforeSaveOperation(String operateKey) {
        String defaultValue;
        DynamicObject fieldRuleDyn = this.getModel().getDataEntity(true);
        String msg = FieldRuleHelper.validPolicyEntity((DynamicObject)fieldRuleDyn, (String)(defaultValue = this.getDefaultResultValue()));
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return false;
        }
        msg = FieldRuleHelper.savePolicyEntity((DynamicObject)fieldRuleDyn, (String)defaultValue, (String)operateKey);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    private String getDefaultResultValue() {
        DynamicObject fieldRuleDyn = this.getModel().getDataEntity();
        if (!fieldRuleDyn.getBoolean("retrundefault")) {
            return null;
        }
        DefaultResult defaultResult = (DefaultResult)this.getControl("defaultresultap");
        String defaultValue = defaultResult.getValue();
        if (!PayRollActGrpHelper.isNullParamOfResult((String)defaultValue).booleanValue()) {
            return defaultValue;
        }
        return fieldRuleDyn.getString("policy.results");
    }

    private void showTriggerFieldsF7() {
        DynamicObject payrollActDyn = this.getModel().getDataEntity().getDynamicObject("payrollact");
        if (payrollActDyn == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u6d3b\u52a8\u201d\u3002", (String)"FieldRuleEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection triggerEntrys = payrollActDyn.getDynamicObjectCollection("entryentity");
        if (triggerEntrys == null || triggerEntrys.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u534f\u4f5c\u6d3b\u52a8\u4e2d\u65e0\u534f\u4f5c\u64cd\u4f5c\u3002", (String)"FieldRuleEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        List triggerCollaIds = triggerEntrys.stream().map(obj -> obj.getLong("triggercolla.id")).collect(Collectors.toList());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hpdi_triggerfieldsf7");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SELECTFIELDKEY));
        formShowParameter.setCustomParam("triggerCollaIds", triggerCollaIds);
        this.getView().showForm(formShowParameter);
    }

    private void fieldKeyPropertyChanged(String oldValue) {
        if (oldValue == null || !FieldRuleHelper.isEditPolicyRule((DynamicObject)this.getModel().getDataEntity(true))) {
            this.initPolicyPage();
            this.clearFieldInfo(false);
            return;
        }
        this.getView().getPageCache().put(CACHE_CHANGED_DATA_SHOWFIELDNAME, oldValue);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5b57\u6bb5\u540e\uff0c\u5c06\u6e05\u7a7a\u5b57\u6bb5\u89c4\u5219\u8bbe\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FieldRuleEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_CHANGED_SHOWFIELDNAME, (IFormPlugin)this));
    }

    private void changedConfirmCallback(MessageBoxClosedEvent event, String field, String cacheKey) {
        String oldValue = this.getView().getPageCache().get(cacheKey);
        this.getView().getPageCache().remove(cacheKey);
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (field) {
                case "payrollact": {
                    this.clearFieldInfo(true);
                    break;
                }
                case "scene": {
                    this.setEmptyPolicyInfo();
                    if (FieldRuleHelper.isCanEditFieldRule((DynamicObject)this.getModel().getDataEntity())) break;
                    this.setCanEditPolicyInfo(Boolean.FALSE);
                    break;
                }
                case "showfieldname": {
                    this.setEmptyPolicyInfo();
                    this.clearFieldInfo(false);
                    break;
                }
            }
        }
        if (MessageBoxResult.Cancel.equals((Object)result)) {
            this.resetFieldValue(field, oldValue);
        }
    }

    private void clearFieldInfo(boolean isClearFieldName) {
        String fieldName = null;
        IDataModel model = this.getModel();
        if (isClearFieldName) {
            model.beginInit();
            model.setValue("showfieldname", null);
            model.endInit();
            this.getView().updateView("showfieldname");
            this.setEmptyPolicyInfo();
        } else {
            fieldName = model.getDataEntity().getString("showfieldname");
        }
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            this.setCanEditPolicyInfo(Boolean.FALSE);
            model.setValue("triggercolla", null);
            model.setValue("entrytype", null);
            model.setValue("fieldkey", null);
            model.setValue("fieldname", null);
            this.getView().updateView("triggercolla");
        }
    }

    private void resetFieldValue(String field, String oldValue) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.setValue(field, SWCStringUtils.isNotEmpty((String)oldValue) && !"null".equalsIgnoreCase(oldValue) ? oldValue : null);
        model.endInit();
        this.getView().updateView(field);
    }

    private void payrollActPropertyChanged(DynamicObject oldValue) {
        String showFieldName = this.getModel().getDataEntity().getString("showfieldname");
        if (oldValue == null || StringUtils.isEmpty((CharSequence)showFieldName)) {
            return;
        }
        this.getView().getPageCache().put(CACHE_CHANGED_DATA_PAYROLLACT, String.valueOf(oldValue.getLong("id")));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u534f\u4f5c\u6d3b\u52a8\u201d\u540e\uff0c\u5c06\u6e05\u7a7a\u57fa\u672c\u4fe1\u606f\u7684\u201c\u5b57\u6bb5\u201d\u548c\u201c\u5b57\u6bb5\u89c4\u5219\u8bbe\u7f6e\u201d\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FieldRuleEdit_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_CHANGED_PAYROLLACT, (IFormPlugin)this));
    }

    private void scenePropertyChanged(DynamicObject oldValue) {
        this.getModel().getDataEntity(true);
        if (oldValue == null || !FieldRuleHelper.isEditPolicyRule((DynamicObject)this.getModel().getDataEntity(true))) {
            this.initPolicyPage();
            return;
        }
        this.getView().getPageCache().put(CACHE_CHANGED_DATA_SCENE, String.valueOf(oldValue.getLong("id")));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u573a\u666f\u201d\u540e\uff0c\u5b57\u6bb5\u89c4\u5219\u8bbe\u7f6e\u5c06\u88ab\u6e05\u7a7a\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FieldRuleEdit_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_CHANGED_SCENE, (IFormPlugin)this));
    }

    private void onBeforeSceneSelected(BeforeF7SelectEvent event) {
        List<String> appIds = Arrays.asList("/UHMBBGZQ65X", "0NXW1VOPH+QV");
        event.addCustomQFilter(new QFilter("bizappid.id", "in", appIds));
        FormShowParameter formShowParameter = event.getFormShowParameter();
        formShowParameter.setCustomParam("bizappids", (Object)appIds.stream().collect(Collectors.joining("\",\"", "[\"", "\"]")));
    }

    private void updateReturnDefaultValue(boolean isOpen, String controlValue) {
        DynamicObject fieldRuleDyn = this.getModel().getDataEntity();
        DefaultResult defaultResult = this.getDefaultResultControl();
        defaultResult.setScene(fieldRuleDyn.getString("scene.id"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long sceneId = dataEntity.getLong("scene.id");
        String entityNumber = dataEntity.getString("triggercolla.entityobject.id");
        String fieldNumber = dataEntity.getString("fieldkey");
        String entryType = dataEntity.getString("entrytype");
        String type = "2".equalsIgnoreCase(entryType) ? "03" : "04";
        ResultControlHelper controlHelper = ResultControlHelper.getInstance();
        controlHelper.updateResultControlData(this.getView(), "defaultresultap", (Object)controlHelper.getFilterResult(Long.valueOf(sceneId), entityNumber, fieldNumber, type), (Object)controlHelper.getSchemeParamValue(Long.valueOf(sceneId)), null, null);
        if (isOpen) {
            String status = this.getModel().getDataEntity().getString("status");
            if (StringUtils.equals((CharSequence)status, (CharSequence)"A")) {
                defaultResult.setPageState("edit");
            } else {
                defaultResult.setPageState("view");
            }
            defaultResult.setValueAndUpdateControl(controlValue);
        } else {
            defaultResult.setValueAndUpdateControl(null);
        }
        this.getView().setVisible(Boolean.valueOf(isOpen), new String[]{"flexreturndefault"});
    }

    private void deleteRuleEntry() {
        EntryGrid control = (EntryGrid)this.getControl("entryrulelist");
        int[] selectRows = control.getSelectRows();
        this.getView().getModel().deleteEntryRows("entryrulelist", selectRows);
    }

    private void showRuleDesignPage(Integer row) {
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"hpdi_ruledesignconfig", (DynamicObject)new HRBaseServiceHelper("hpdi_ruledesignconfig").generateEmptyDynamicObject(), null);
        if (codeRule == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u4fe1\u606f\u65e0\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"FieldRuleEdit_5", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject fieldRuleDyn = this.getModel().getDataEntity(true);
        DynamicObject ruleEntryRowDyn = null;
        if (null != row) {
            ruleEntryRowDyn = this.getModel().getEntryRowEntity("entryrulelist", row.intValue());
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u8bbe\u7f6e", (String)"FieldRuleEdit_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        billShowParameter.setCustomParams(this.getRuleDesignParaMap(fieldRuleDyn, ruleEntryRowDyn));
        billShowParameter.setFormId("hpdi_ruledesignconfig");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String status = fieldRuleDyn.getString("status");
        if (!StringUtils.equals((CharSequence)status, (CharSequence)"A")) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_RULE"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private Map<String, Object> getRuleDesignParaMap(DynamicObject fieldRuleDyn, DynamicObject ruleEntryRowDyn) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sceneId", fieldRuleDyn.getLong("scene.id"));
        param.put("hrRule", PolicyHelper.getRule((DynamicObject)fieldRuleDyn, (DynamicObject)ruleEntryRowDyn));
        param.put("resultParamStr", PolicyHelper.addFilterToResult((String)PolicyHelper.getResultParamValue((DynamicObject)fieldRuleDyn), (DynamicObject)fieldRuleDyn));
        long sceneId = fieldRuleDyn.getLong("scene.id");
        String entityNumber = fieldRuleDyn.getString("triggercolla.entityobject.id");
        String fieldNumber = fieldRuleDyn.getString("fieldkey");
        String entryType = fieldRuleDyn.getString("entrytype");
        String type = "2".equalsIgnoreCase(entryType) ? "03" : "04";
        param.put("resultSchemaStr", ResultControlHelper.getInstance().getFilterResult(Long.valueOf(sceneId), entityNumber, fieldNumber, type));
        return param;
    }

    private Integer isRuleNumberExist(String ruleNumber) {
        Integer result = -1;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryrulelist");
        if (StringUtils.isEmpty((CharSequence)ruleNumber) || CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!ruleNumber.equals(dynamicObject.getString("rulenumber"))) continue;
            return i;
        }
        return result;
    }

    private DefaultResult getDefaultResultControl() {
        return (DefaultResult)this.getControl("defaultresultap");
    }
}

