/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.basedata.fieldrule;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.swc.hpdi.business.cloudcolla.fieldrule.TriggerFieldHelper;
import org.apache.commons.lang3.StringUtils;

public class TriggerFieldsF7Plugin
extends AbstractFormPlugin {
    private static final String FIELD_KEY = "fieldkey";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_TRIGGERCOLLANAME = "triggercolla";
    private static final String FIELD_ENTITYOBJECT = "entityobject";
    private static final String FIELD_TRIGGERCOLLAID = "triggercollaid";
    private static final String FIELD_ENTRYTYPE = "entrytype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List triggerCollaIds = (List)params.get("triggerCollaIds");
        this.initEntryRow(triggerCollaIds);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Button && "btnok".equals(key = ((Button)evt.getSource()).getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRowIndexArray = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
            if (null == selectRowIndexArray || selectRowIndexArray.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TriggerFieldsF7Plugin_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            IPageCache pageCache = this.getView().getPageCache();
            String triggerDynMapStr = pageCache.get("cache_triggerDynMap");
            if (StringUtil.isEmptyString((String)triggerDynMapStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u534f\u4f5c\u64cd\u4f5c\u6570\u636e\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TriggerFieldsF7Plugin_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            Map triggerDynMap = (Map)SerializationUtils.deSerializeFromBase64((String)triggerDynMapStr);
            HashMap fieldKeyInfo = Maps.newHashMapWithExpectedSize((int)4);
            DynamicObject selectDyn = (DynamicObject)entryEntities.get(selectRowIndexArray[0]);
            fieldKeyInfo.put(FIELD_KEY, selectDyn.getString(FIELD_KEY));
            fieldKeyInfo.put(FIELD_NAME, selectDyn.getString(FIELD_NAME));
            fieldKeyInfo.put(FIELD_ENTRYTYPE, selectDyn.getString(FIELD_ENTRYTYPE));
            fieldKeyInfo.put(FIELD_TRIGGERCOLLANAME, triggerDynMap == null ? null : (Object)triggerDynMap.get(selectDyn.getLong(FIELD_TRIGGERCOLLAID)));
            this.getView().returnDataToParent((Object)fieldKeyInfo);
            this.getView().close();
        }
    }

    private void initEntryRow(List<Long> triggerCollaIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.setEntry(triggerCollaIds, setter);
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setEntry(List<Long> triggerCollaIds, TableValueSetter setter) {
        DynamicObject[] triggerDyns = TriggerFieldHelper.getTriggerListByIds(triggerCollaIds);
        if (triggerDyns == null || triggerDyns.length == 0) {
            return;
        }
        Map<Long, DynamicObject> triggerDynMap = Arrays.stream(triggerDyns).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        this.getView().getPageCache().put("cache_triggerDynMap", SerializationUtils.serializeToBase64(triggerDynMap));
        int i = 0;
        for (Long triggerCollaId : triggerCollaIds) {
            DynamicObjectCollection exeParamEntry;
            DynamicObject triggerDyn = triggerDynMap.get(triggerCollaId);
            String isMustFieldMapping = triggerDyn.getString("ismustfieldmapping");
            if (!StringUtils.equals((CharSequence)isMustFieldMapping, (CharSequence)"0")) continue;
            String triggerName = triggerDyn.getString("name");
            String entityName = triggerDyn.getString("entityobject.name");
            String entityNumber = triggerDyn.getString("entityobject.number");
            DynamicObjectCollection paramEntry = triggerDyn.getDynamicObjectCollection("paramentryentity");
            if (paramEntry != null && paramEntry.size() != 0) {
                MainEntityType personEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                Map fieldMap = personEntityType.getAllFields();
                for (DynamicObject paramDyn : paramEntry) {
                    String fieldKey = paramDyn.getString(FIELD_KEY);
                    IDataEntityProperty property = (IDataEntityProperty)fieldMap.get(fieldKey);
                    if (property == null) continue;
                    setter.set("id", (Object)("1" + paramDyn.getString("id")), i);
                    setter.set(FIELD_KEY, (Object)fieldKey, i);
                    setter.set(FIELD_NAME, (Object)property.getDisplayName().toString(), i);
                    setter.set(FIELD_TRIGGERCOLLANAME, (Object)triggerName, i);
                    setter.set(FIELD_ENTITYOBJECT, (Object)entityName, i);
                    setter.set(FIELD_TRIGGERCOLLAID, (Object)triggerCollaId, i);
                    setter.set(FIELD_ENTRYTYPE, (Object)"1", i);
                    ++i;
                }
            }
            if ((exeParamEntry = triggerDyn.getDynamicObjectCollection("exeparamentryentity")) == null || exeParamEntry.size() == 0) continue;
            for (DynamicObject exeParamDyn : exeParamEntry) {
                boolean isSetRule = exeParamDyn.getBoolean("pissetrule");
                if (!isSetRule) continue;
                setter.set("id", (Object)("1" + exeParamDyn.getString("id")), i);
                setter.set(FIELD_KEY, (Object)exeParamDyn.getString("pfieldkey"), i);
                setter.set(FIELD_NAME, (Object)exeParamDyn.getString("pfieldname"), i);
                setter.set(FIELD_TRIGGERCOLLANAME, (Object)triggerName, i);
                setter.set(FIELD_ENTITYOBJECT, (Object)entityName, i);
                setter.set(FIELD_TRIGGERCOLLAID, (Object)triggerCollaId, i);
                setter.set(FIELD_ENTRYTYPE, (Object)"2", i);
                ++i;
            }
        }
    }
}

