/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryCheckingHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataBillAddEntryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public final Log log = LogFactory.getLog(BizDataBillAddEntryPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("id", params.get("id"));
        this.getModel().setValue("billno", params.get("billno"));
        String billType = MapUtils.getString((Map)params, (Object)"billtype");
        this.getModel().setValue("billtype", (Object)billType);
        this.getModel().setValue("billstatus", params.get("billstatus"));
        this.getModel().setValue("bizitemgroup", params.get("bizItemGroupId"));
        this.getModel().setValue("calperiod", params.get("calperiodId"));
        this.getModel().setValue("org", params.get("org"));
        List mulBizItemIds = (List)params.get("mulBizItemIds");
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)mulBizItemIds)) {
            this.getModel().setValue("mulbizitem", (Object)mulBizItemIds.toArray());
        }
        List primaryKeyValues = (List)params.get("primaryKeyValues");
        List primaryKeyMapList = (List)params.get("depempMappingList");
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)primaryKeyMapList)) {
            primaryKeyMapList = null == primaryKeyMapList ? new ArrayList(10) : primaryKeyMapList;
            String primaryKey = this.getPrimaryKey();
            for (Object primaryKeyValue : primaryKeyValues) {
                HashMap map = new HashMap(16);
                map.put(primaryKey, primaryKeyValue);
                primaryKeyMapList.add(map);
            }
        }
        this.handleSelectedEmpData((String)params.get("billtype"), primaryKeyMapList);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        BizDataBillEntryHelper.showEntryCol((IFormView)this.getView());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String curNode = String.valueOf(customParams.get("CURNODE"));
        boolean isApproveNode = StringUtils.isNotEmpty((String)curNode) && curNode.startsWith("AuditTask");
        BizDataBillEntryHelper.setEntryFieldDisplay((IFormView)this.getView(), (boolean)isApproveNode);
        BizDataBillEntryHelper.setEntityFieldVisible((IFormView)this.getView());
        this.setEntityFieldInvisible();
    }

    public void afterBindData(EventObject evt) {
        BizDataBillEntryHelper.setMustInputForUpdateExpiryDate((IFormView)this.getView());
        BizDataBillEntryHelper.setMatchRuleFieldsMustInput((IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        if (SWCStringUtils.equals((String)"donothing_newentry", (String)operateKey)) {
            switch (billType) {
                case "1": {
                    this.showPersonF7();
                    break;
                }
                case "2": {
                    this.showBizDataF7();
                    break;
                }
            }
        } else if (SWCStringUtils.equals((String)"ok", (String)operateKey)) {
            List<String> errorInfos = this.checkBeforeEntryConvertData();
            if (!kd.bos.util.CollectionUtils.isEmpty(errorInfos)) {
                this.getView().showErrorNotification(errorInfos.stream().collect(Collectors.joining(System.lineSeparator())));
                args.setCancel(true);
            }
        } else if (SWCStringUtils.equals((String)"donothing_addentry", (String)operateKey)) {
            this.handlerForDoNothingAddEntry(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("ok".equals(key)) {
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            ArrayList<DynamicObject> waitSaveEntrys = new ArrayList<DynamicObject>(10);
            for (DynamicObject entry : entryEntities) {
                DynamicObject dbEntry = BizDataBillEntryHelper.dealEntry((Long)((Long)this.getView().getFormShowParameter().getCustomParam("bizdatabillid")), (DynamicObject)entry, null);
                BizDataBillEntryHelper.dealDetail((DynamicObject)entry, (DynamicObject)dbEntry, (DynamicObject)this.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
                waitSaveEntrys.add(dbEntry);
            }
            OperateOption opOption = OperateOption.create();
            opOption.setVariableValue("notValidatePeriod", "1");
            opOption.setVariableValue("modal_add", "1");
            BizDataBillEntryHelper.invokeOperation((String)"save_validate", (OperateOption)opOption, (DynamicObject[])waitSaveEntrys.toArray(new DynamicObject[0]));
            BizDataBillEntryHelper.invokeOperation((String)"save", (DynamicObject[])waitSaveEntrys.toArray(new DynamicObject[0]));
            List entryIds = waitSaveEntrys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            if (kd.bos.util.CollectionUtils.isNotEmpty(entryIds)) {
                BizDataHelper.refreshRelationDataPart((DynamicObject)this.getView().getParentView().getModel().getDataEntity(), entryIds);
            }
            this.getView().getPageCache().remove("newentryoperation");
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Map bizItemMap;
        String fieldKey = args.getProperty().getName();
        DynamicObject rowData = args.getChangeSet()[0].getDataEntity();
        if (SWCObjectUtils.isEmpty((Object)rowData.getDynamicObject("empposorgrel"))) {
            return;
        }
        if (BizDataBillEntryHelper.isHorizontalTable((IFormView)this.getView()) && (bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap((DynamicObject)this.getModel().getDataEntity().getDynamicObject("bizitemgroup"))).containsKey(fieldKey)) {
            ChangeData itemData = args.getChangeSet()[0];
            if (itemData.getNewValue() instanceof Date) {
                return;
            }
            String newValue = (String)itemData.getNewValue();
            if (!SWCStringUtils.isEmpty((String)newValue)) {
                BizDataBillEntryCheckingHelper.checkValue((IFormView)this.getView(), (ChangeData)itemData, (String)newValue, (String)fieldKey);
            }
            return;
        }
        switch (fieldKey) {
            case "bizitem": {
                Long dataTypeId;
                ChangeData[] changeData = args.getChangeSet();
                int rowIndex = changeData[0].getRowIndex();
                DynamicObject newBizItemObj = (DynamicObject)changeData[0].getNewValue();
                DynamicObject oldBizItemObj = (DynamicObject)changeData[0].getOldValue();
                Long l = dataTypeId = SWCObjectUtils.isEmpty((Object)newBizItemObj) ? null : Long.valueOf(newBizItemObj.getLong("datatype.id"));
                if (!SWCObjectUtils.isEmpty((Object)oldBizItemObj) && !SWCObjectUtils.equals((Object)newBizItemObj, (Object)oldBizItemObj)) {
                    HashMap<String, Number> customMap = new HashMap<String, Number>(4);
                    customMap.put("rowIndex", rowIndex);
                    customMap.put("datatypeid", dataTypeId);
                    if (!SWCObjectUtils.isEmpty((Object)oldBizItemObj)) {
                        customMap.put("oldBizItemId", oldBizItemObj.getLong("id"));
                    }
                    String customValue = JSON.toJSONString(customMap);
                    this.changeBizItemConfirm(customValue);
                    break;
                }
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                BizDataBillEntryHelper.setEntryCurrency((IFormView)this.getView(), (Long)dataTypeId, (int)rowIndex);
                break;
            }
            case "effectivedate": {
                ChangeData effectiveDateChangeData = args.getChangeSet()[0];
                Date effectiveDate = (Date)effectiveDateChangeData.getNewValue();
                if (effectiveDate == null) break;
                BizDataBillEntryCheckingHelper.checkEffectiveDate((IFormView)this.getView(), (ChangeData)effectiveDateChangeData, (Date)effectiveDate);
                break;
            }
            case "expirydate": {
                ChangeData expiryDateChangeData = args.getChangeSet()[0];
                Date expiryDate = (Date)expiryDateChangeData.getNewValue();
                if (expiryDate == null) break;
                BizDataBillEntryCheckingHelper.checkExpiryDate((IFormView)this.getView(), (ChangeData)expiryDateChangeData, (Date)expiryDate);
                break;
            }
            case "value": {
                ChangeData valueData = args.getChangeSet()[0];
                String newValue = (String)valueData.getNewValue();
                if (SWCStringUtils.isEmpty((String)newValue)) break;
                BizDataBillEntryCheckingHelper.checkValue((IFormView)this.getView(), (ChangeData)valueData, (String)newValue, (String)fieldKey);
                break;
            }
            case "currency": {
                ChangeData currencyChangeData = args.getChangeSet()[0];
                DynamicObject currencyValue = (DynamicObject)currencyChangeData.getNewValue();
                if (SWCObjectUtils.isEmpty((Object)currencyValue)) break;
                BizDataBillEntryCheckingHelper.checkCurrencyPrecision((IFormView)this.getView(), (ChangeData)currencyChangeData, (DynamicObject)currencyValue);
                break;
            }
            case "updateexpirydate": {
                ChangeData updateExpiryDateChangeData = args.getChangeSet()[0];
                Date updateExpiryDate = (Date)updateExpiryDateChangeData.getNewValue();
                if (updateExpiryDate == null) break;
                DynamicObject dataEntity = updateExpiryDateChangeData.getDataEntity();
                DynamicObject bizItemGroup = (DynamicObject)this.getModel().getValue("bizitemgroup");
                Map responses = BizDataBillEntryCheckingHelper.checkUpdateExpiryDate((DynamicObject)bizItemGroup, (List)Lists.newArrayList((Object[])new DynamicObject[]{dataEntity}), (String)"1");
                if (responses.isEmpty()) {
                    return;
                }
                String bizDataCode = dataEntity.getString("bizdatacode");
                Map responseMap = (Map)responses.get(bizDataCode);
                if (MapUtils.isEmpty((Map)responseMap)) {
                    return;
                }
                Object response = responseMap.get("key_result_error_msg");
                if (SWCObjectUtils.isEmpty(response) || !SWCStringUtils.isNotEmpty((String)((String)response))) break;
                this.getView().showErrorNotification((String)response);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "change_bizitem_confirm": {
                BizDataBillEntryHelper.modifyEntryByChangeBizItem((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent);
                BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
                BizDataBillEntryHelper.setMatchRuleFieldsMustInput((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = null;
        switch (fieldKey) {
            case "currency": {
                qFilter = BizDataBillEntryHelper.getCurrencyFilter((IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent);
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String acctionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (acctionId) {
            case "newentry": {
                Object[] primaryKeyValues;
                if (null == returnData || !Objects.nonNull(primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues())) break;
                ArrayList<Map<Object, Object>> primaryKeyMapList = new ArrayList<Map<Object, Object>>(primaryKeyValues.length);
                String primaryKey = this.getPrimaryKey();
                for (Object primaryKeyValue : primaryKeyValues) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    map.put(primaryKey, primaryKeyValue);
                    primaryKeyMapList.add(map);
                }
                this.handleSelectedEmpData((String)this.getView().getFormShowParameter().getCustomParam("billtype"), primaryKeyMapList);
                BizDataBillEntryHelper.setFieldsNotQuickAddNew((IFormView)this.getView());
                BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
                break;
            }
        }
    }

    private void handleSelectedEmpData(String billType, List<Map<Object, Object>> primaryKeyMapList) {
        if (null == primaryKeyMapList || primaryKeyMapList.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        switch (billType) {
            case "1": {
                BizDataBillEntryHelper.setAddTypeEntry((IFormView)this.getView(), primaryKeyMapList, (TableValueSetter)setter);
                break;
            }
            case "2": {
                String primaryKey = this.getPrimaryKey();
                List primaryKeyValues = primaryKeyMapList.stream().map(item -> MapUtils.getLong((Map)item, (Object)primaryKey)).collect(Collectors.toList());
                DynamicObject[] bizDatasets = BizDataBillEntryHelper.getBizDataById((Object[])primaryKeyValues.toArray());
                DynamicObjectCollection entryEntity = Arrays.stream(bizDatasets).collect(Collectors.toCollection(DynamicObjectCollection::new));
                BizDataBillEntryHelper.setUpdateTypeEntry((IFormView)this.getView(), (DynamicObjectCollection)entryEntity, (TableValueSetter)setter, null, (Long)this.getModel().getDataEntity().getLong("bizitemgroup.id"));
                break;
            }
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        this.getView().getPageCache().put("newentryoperation", "ADD");
        model.endInit();
        this.getView().updateView("entryentity");
        BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
        BizDataBillEntryHelper.setMustInputForUpdateExpiryDate((IFormView)this.getView());
        BizDataBillEntryHelper.setMatchRuleFieldsMustInput((IFormView)this.getView());
    }

    private void changeBizItemConfirm(String customValue) {
        String message = ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u9879\u76ee\u5c06\u6e05\u7a7a\u8be5\u884c\u5df2\u5f55\u5165\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillEdit_19", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(null, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("change_bizitem_confirm", (IFormPlugin)this), new HashMap(0), customValue);
    }

    private void showPersonF7() {
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructPersonF7();
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showBizDataF7() {
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructBizDataF7((IFormView)this.getView());
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setEntityFieldInvisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"relationdata"});
    }

    private List<String> checkBeforeEntryConvertData() {
        ArrayList<String> errorInfos = new ArrayList<String>(10);
        DynamicObject bizDataBill = this.getModel().getDataEntity();
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        if (kd.bos.util.CollectionUtils.isEmpty((Collection)entryEntities)) {
            return errorInfos;
        }
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable((IFormView)this.getView());
        Set<Object> currentBizItemKeys = new HashSet(16);
        if (isHorizontal) {
            IPageCache pageCache = BizDataBillEntryHelper.getBizDataBillPageCache((IFormView)this.getView());
            String bizItemsStr = pageCache.get("bizItems");
            ArrayList bizItems = new ArrayList(10);
            if (SWCStringUtils.isNotEmpty((String)bizItemsStr)) {
                bizItems.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)bizItemsStr));
                currentBizItemKeys = bizItems.stream().map(bizItem -> bizItem.getString("bizitem.number").toLowerCase()).collect(Collectors.toSet());
            }
        }
        Map bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap((DynamicObject)bizDataBill.getDynamicObject("bizitemgroup"));
        Set effectiveBizItemKeys = bizItemMap.keySet();
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(i);
            String msg = BizDataBillEntryHelper.checkBizItemInvalid((DynamicObject)entryEntity, (int)(i + 1), (boolean)isHorizontal, effectiveBizItemKeys, currentBizItemKeys);
            if (!SWCStringUtils.isNotEmpty((String)msg)) continue;
            if (isHorizontal) {
                errorInfos.add(msg);
                break;
            }
            errorInfos.add(msg);
        }
        return errorInfos;
    }

    private void handlerForDoNothingAddEntry(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String depempMappingListStr = option.getVariableValue("depempMappingList", null);
        if (SWCStringUtils.isEmpty((String)depempMappingListStr)) {
            return;
        }
        List depempMappingList = SerializationUtils.fromJsonStringToList((String)depempMappingListStr, Map.class);
        if (CollectionUtils.isEmpty((Collection)depempMappingList)) {
            return;
        }
        this.handleSelectedEmpData((String)this.getView().getFormShowParameter().getCustomParam("billtype"), depempMappingList);
        BizDataBillEntryHelper.setFieldsNotQuickAddNew((IFormView)this.getView());
        BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
    }

    private String getPrimaryKey() {
        String billType = MapUtils.getString((Map)this.getView().getFormShowParameter().getCustomParams(), (Object)"billtype");
        String primaryKey = "depempId";
        if ("2".equals(billType)) {
            primaryKey = "bizDataId";
        }
        return primaryKey;
    }
}

