/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.formplugin.web.HPDIResMgrFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataBillChoiceTplPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_SUBMISSION_SCOPE = "submissionscope";
    private static final String KEY_SUBMISSION_FLEX = "submissionflex";
    private static final String KEY_BIZITEMS = "bizitems";

    public void preOpenForm(PreOpenFormEventArgs evt) {
        SWCSecurityServiceHelper.checkSwcSecurityFlag((PreOpenFormEventArgs)evt);
        super.preOpenForm(evt);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit bizItemGroupEdit = (BasedataEdit)this.getControl("bizitemgroup");
        bizItemGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit bizItemsEdit = (MulBasedataEdit)this.getControl(KEY_BIZITEMS);
        bizItemsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SUBMISSION_FLEX, KEY_BIZITEMS});
        Long orgId = SWCPermissionServiceHelper.getCurUserHasPermOrg((String)"29", (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org");
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject org = serviceHelper.loadDynamicObject(qFilters);
        this.getModel().getDataEntity().set("org", (Object)org);
        Long groupId = (Long)this.getView().getFormShowParameter().getCustomParam("bizitemgroup");
        if (!SWCObjectUtils.isEmpty((Object)groupId)) {
            this.getModel().setValue("bizitemgroup", (Object)groupId);
            this.setSubmissionScope(this.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        boolean isAddType = "1".equals(billType);
        switch (fieldKey) {
            case "org": {
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                if (!SWCObjectUtils.isEmpty((Object)oldValue) && SWCObjectUtils.isEmpty((Object)newValue)) {
                    this.getModel().getDataEntity().set("org", (Object)oldValue);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"BizDataBillChoiceTplPlugin_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (SWCObjectUtils.isEmpty((Object)oldValue)) break;
                this.getModel().getDataEntity().set("bizitemgroup", null);
                this.getView().updateView("bizitemgroup");
                break;
            }
            case "bizitemgroup": {
                if (!isAddType) {
                    return;
                }
                DynamicObject bizItemGroupNew = (DynamicObject)changeData.getNewValue();
                this.setSubmissionScope(bizItemGroupNew);
                break;
            }
            case "submissionscope": {
                String submissionScope = (String)changeData.getNewValue();
                MulBasedataEdit bizItemsEdit = (MulBasedataEdit)this.getControl(KEY_BIZITEMS);
                if ("2".equals(submissionScope)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BIZITEMS});
                    bizItemsEdit.setMustInput(true);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BIZITEMS});
                bizItemsEdit.setMustInput(false);
                break;
            }
        }
    }

    private void setSubmissionScope(DynamicObject bizItemGroupNew) {
        if (bizItemGroupNew != null && "2".equals(bizItemGroupNew.getString("modeltype"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SUBMISSION_FLEX});
            String submissionScope = this.getModel().getDataEntity().getString(KEY_SUBMISSION_SCOPE);
            if ("2".equals(submissionScope)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BIZITEMS});
            } else {
                this.getModel().setValue(KEY_SUBMISSION_SCOPE, (Object)"1");
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SUBMISSION_FLEX, KEY_BIZITEMS});
        }
        this.getModel().getDataEntity().set(KEY_BIZITEMS, null);
        this.getView().updateView(KEY_BIZITEMS);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if ("ok".equals(key)) {
            boolean isContainLoopItem;
            Object billType;
            long bizItemGroupId = this.getModel().getDataEntity().getLong("bizitemgroup.id");
            if (0L == bizItemGroupId) {
                this.getView().showTipNotification(HPDIResMgrFormPlugin.getMsgOfSelectBizItemGroupFirst());
                args.setCancel(true);
            }
            if (null != (billType = this.getView().getFormShowParameter().getCustomParams().get("billtype")) && SWCStringUtils.equals((String)((String)billType), (String)"1")) {
                String modelType = this.getModel().getDataEntity().getString("bizitemgroup.modeltype");
                String submissionScope = this.getModel().getDataEntity().getString(KEY_SUBMISSION_SCOPE);
                MulBasedataDynamicObjectCollection bizItemColl = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get(KEY_BIZITEMS);
                if (SWCStringUtils.equals((String)modelType, (String)"2") && SWCStringUtils.equals((String)submissionScope, (String)"2") && CollectionUtils.isEmpty((Collection)bizItemColl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6307\u5b9a\u4e1a\u52a1\u9879\u76ee\u201d\u3002", (String)"BizDataBillChoiceTplPlugin_5", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            if (billType != null && SWCStringUtils.equals((String)((String)billType), (String)"2") && 0L != bizItemGroupId && !(isContainLoopItem = BizDataHelper.isContainLoopItem((long)bizItemGroupId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u6548\u65e5\u671f\u4ec5\u652f\u6301\u5faa\u73af\u9879\u4e1a\u52a1\u6570\u636e\u63d0\u62a5\u3002\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4e2d\u65e0\u6709\u6548\u7684\u5faa\u73af\u4e1a\u52a1\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6a21\u677f\u3002", (String)"BizDataBillEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("ok".equals(key)) {
            Long bizItemGroupId = this.getModel().getDataEntity().getLong("bizitemgroup.id");
            String billType = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
            Long orgId = this.getModel().getDataEntity().getLong("org.id");
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("bizItemGroupId", bizItemGroupId);
            returnData.put("billtype", billType);
            returnData.put("orgId", orgId);
            BillShowParameter show = new BillShowParameter();
            String modelType = this.getModel().getDataEntity().getString("bizitemgroup.modeltype");
            if (SWCStringUtils.equals((String)billType, (String)"1") && SWCStringUtils.equals((String)modelType, (String)"2")) {
                List<Long> bizItemIds = this.getBizItemIds();
                if (CollectionUtils.isEmpty(bizItemIds)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u65e0\u53ef\u7528\u7684\u4e1a\u52a1\u9879\u76ee\uff08\u6570\u636e\u72b6\u6001=\u5df2\u5ba1\u6838\uff0c\u4f7f\u7528\u72b6\u6001=\u53ef\u7528\uff09\u3002", (String)"BizDataBillChoiceTplPlugin_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    return;
                }
                returnData.put("mulBizItemIds", bizItemIds);
                show.setCustomParam("mulBizItemIds", bizItemIds);
            }
            if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("appid"))) {
                show.setFormId("hpdi_bizdatabill");
                show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                show.setCustomParam("billtype", returnData.get("billtype"));
                show.setCustomParam("bizItemGroupId", (Object)bizItemGroupId);
                show.setCustomParam("orgId", (Object)orgId);
                this.getView().getParentView().showForm((FormShowParameter)show);
            } else {
                this.getView().returnDataToParent(returnData);
            }
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "bizitemgroup": {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                if (SWCObjectUtils.isEmpty((Object)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"BizDataBillChoiceTplPlugin_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                Long orgId = org.getLong("id");
                QFilter filter = this.getFilterByOrg("hsbs_bizitemgroup", orgId);
                evt.addCustomQFilter(filter);
                break;
            }
            case "bizitems": {
                DynamicObject bizItemGroup = this.getModel().getDataEntity().getDynamicObject("bizitemgroup");
                if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u201d\u3002", (String)"BizDataBillChoiceTplPlugin_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                DynamicObjectCollection entryEntities = bizItemGroup.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                    evt.addCustomQFilter(new QFilter("1", "!=", (Object)1));
                    break;
                }
                List bizItemIds = entryEntities.stream().map(entity -> entity.getLong("bizitem.id")).collect(Collectors.toList());
                QFilter bizItemFilter = new QFilter("id", "in", bizItemIds);
                bizItemFilter.and("status", "=", (Object)"C");
                bizItemFilter.and("enable", "=", (Object)"1");
                evt.addCustomQFilter(bizItemFilter);
                evt.getFormShowParameter().setCustomParam("filterLeftTree", (Object)"1");
                break;
            }
        }
    }

    private QFilter getFilterByOrg(String entityID, Long orgId) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and(SWCPermissionServiceHelper.getBaseDataFilter((String)entityID, (Long)orgId));
        return filter;
    }

    private List<Long> getBizItemIds() {
        ArrayList<Long> bizItemIds = new ArrayList(10);
        String submissionScope = this.getModel().getDataEntity().getString(KEY_SUBMISSION_SCOPE);
        if (SWCStringUtils.equals((String)submissionScope, (String)"2")) {
            MulBasedataDynamicObjectCollection bizItemColl = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get(KEY_BIZITEMS);
            bizItemIds = bizItemColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
        } else {
            Map bizItemGroupMap = BizDataHelper.getBizItemGroupMapById((DynamicObject)this.getModel().getDataEntity().getDynamicObject("bizitemgroup"));
            List resultList = (List)bizItemGroupMap.get("result");
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return bizItemIds;
            }
            for (Map bizItemMap : resultList) {
                List itemList = (List)bizItemMap.get("bizitem");
                for (Map item2 : itemList) {
                    Long bizItemId;
                    if (!"1".equals(MapUtils.getString((Map)item2, (Object)"enable")) || !"C".equals(MapUtils.getString((Map)item2, (Object)"status")) || null == (bizItemId = MapUtils.getLong((Map)item2, (Object)"bizitemid")) || 0L == bizItemId) continue;
                    bizItemIds.add(bizItemId);
                }
            }
        }
        return bizItemIds;
    }
}

