/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.StringUtils;
import kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum;
import kd.swc.hpdi.business.helper.BizDataBillCalSumHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryCheckingHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.common.constants.BillTypeEnum;
import kd.swc.hpdi.common.constants.BizDataConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(BizDataBillEdit.class);
    private static final String BILL_NO_LABEL = "billnolabel";
    private static final String SUMMARY_CREATOR = "summarycreator";
    private static final String SUMMARY_CREATE_TIME = "summarycreatetime";
    private static final String HEAD_PANEL_VIEW = "headpanelview";
    private static final String OVER_ALL_VIEW = "overallview";
    private static final String EXPORT_ENTRY = "exportentry";
    private static final String ENTRY_PANEL = "advcontoolbarap";
    private static final Map<String, String> BILL_STATUS_COLOR_MAP = new HashMap<String, String>(16);
    private static final String LABEL_TMP_SAVE = "labeltmpsave";
    private static final String LABEL_SUBMIT = "labelsubmit";
    private static final String LABEL_APPROVE_PASS = "labelapprovepass";
    private static final String LABEL_APPROVING = "labelapproving";
    private static final String LABEL_APPROVE_NOT_PASS = "labelapprovenotpass";
    private static final String LABEL_RESUBMIT = "labelresubmit";
    private static final String LABEL_ABANDON = "labelabandon";
    private static final String CACHE_BIZITEM_GROUP_ID = "cache_bizitemgroupid";
    private static final String RESET_VALUE = "resetvalue";
    private static final String KEY_BILL_TYPE_LABEL = "billtypelabel";
    private static final String KEY_START_TIME = "starttime";
    private static final String KEY_END_TIME = "endtime";
    private static final String KEY_IS_RESET_VAL = "isReSetVal";
    public static final String CHANGE_BIZITEM_CONFIRM = "change_bizitem_confirm";
    public static final String INITPRECISION = "0.0000000000";
    private static final Set<String> EXCLUDE_ENTRY_FIELD_SET = new HashSet<String>(16);
    private Map<String, DynamicObject> cacheBizItemMap = new HashMap<String, DynamicObject>(16);

    public void createNewData(BizDataEventArgs args) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)false);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if ("hstc".equals(args.getFormShowParameter().getCustomParam("showway")) && ((Boolean)args.getFormShowParameter().getCustomParam("ifProcessing")).booleanValue() && args.getFormShowParameter().getCustomParam("pooltype-mytask") != null) {
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hpdi_bizdatabill");
            String billID = (String)args.getFormShowParameter().getCustomParam("billID");
            DynamicObject bizData = bizDataHelper.queryOne((Object)billID);
            args.getFormShowParameter().setCustomParam("modelbillno", bizData.get("billno"));
        }
    }

    public void loadData(LoadDataEventArgs args) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)false);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        BillModel billModel = (BillModel)eventObject.getSource();
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        if (SWCStringUtils.equals((String)customParam, (String)"2")) {
            billModel.getDataEntity().set("billtype", (Object)"2");
        }
        BizDataBillEntryHelper.setEntityFieldVisible((IFormView)this.getView());
        Long bizItemGroupId = (Long)this.getView().getFormShowParameter().getCustomParam("bizItemGroupId");
        this.getModel().setValue("bizitemgroup", (Object)bizItemGroupId);
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgId");
        this.getModel().setValue("org", orgId);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
        BizDataBillEntryHelper.setEntityFieldVisible((IFormView)this.getView());
        this.initGridConfig();
        this.initBizItemGroup();
        this.initMulBizItem();
        UpdateTabNameHelper.updateTabName((IFormView)this.getView(), (String)"billno");
    }

    public void clientCallBack(ClientCallBackEvent evt) {
        if ("calSummary".equals(evt.getName())) {
            BizDataBillCalSumHelper.getInstance().doCalculate(this.getView());
        }
    }

    public void afterBindData(EventObject eventObject) {
        BizDataBillEntryHelper.setMustInputForUpdateExpiryDate((IFormView)this.getView());
        BizDataBillEntryHelper.setMatchRuleFieldsMustInput((IFormView)this.getView());
        this.setUserDefinedColor();
        this.updateSummary();
        this.getView().addClientCallBack("calSummary");
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizItemGroup = (BasedataEdit)this.getView().getControl("bizitemgroup");
        bizItemGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String billType = this.getModel().getDataEntity().getString("billtype");
        if ("2".equals(billType)) {
            return;
        }
        BasedataEdit calPeriod = (BasedataEdit)this.getView().getControl("calperiod");
        calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (!BizDataBillEntryHelper.isHorizontalTable((IFormView)this.getView())) {
            BasedataEdit bizItem = (BasedataEdit)this.getView().getControl("bizitem");
            bizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit currency = (BasedataEdit)this.getView().getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Map bizItemMap;
        DynamicObject bizItemGroup;
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        String parentName = args.getProperty().getParent().getName();
        if ("entryentity".equals(parentName) && !EXCLUDE_ENTRY_FIELD_SET.contains(fieldKey)) {
            this.saveChangedRowCache(changeData[0].getDataEntity());
        }
        if (null != (bizItemGroup = this.getModel().getDataEntity().getDynamicObject("bizitemgroup")) && BizDataBillEntryHelper.isHorizontalTable((IFormView)this.getView()) && (bizItemMap = BizDataBillEntryHelper.getHorizontalBizItemMap((DynamicObject)this.getModel().getDataEntity().getDynamicObject("bizitemgroup"))).containsKey(fieldKey)) {
            ChangeData itemData = args.getChangeSet()[0];
            if (itemData.getNewValue() instanceof Date) {
                return;
            }
            String newValue = (String)itemData.getNewValue();
            if (!SWCStringUtils.isEmpty((String)newValue)) {
                BizDataBillEntryCheckingHelper.checkValue((IFormView)this.getView(), (ChangeData)itemData, (String)newValue, (String)fieldKey);
            }
            return;
        }
        switch (fieldKey) {
            case "bizitemgroup": {
                break;
            }
            case "calperiod": {
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                if (pageCache.get(KEY_IS_RESET_VAL) != null) {
                    pageCache.put(KEY_IS_RESET_VAL, null);
                    return;
                }
                DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
                DynamicObject oldPeriodObj = (DynamicObject)changeData[0].getOldValue();
                pageCache.put("oldPeriod", String.valueOf(oldPeriodObj == null ? 0L : oldPeriodObj.getLong("id")));
                if (!CollectionUtils.isEmpty((Collection)entryEntities) && pageCache.get(KEY_IS_RESET_VAL) == null) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u85aa\u8d44\u671f\u95f4\uff0c\u5c06\u6e05\u7a7a\u5df2\u6dfb\u52a0\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillEdit_9", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeperiodconfirm"));
                    break;
                }
                this.setCountDownVal();
                break;
            }
            case "bizitem": {
                Long dataTypeId;
                int rowIndex = changeData[0].getRowIndex();
                DynamicObject newBizItemObj = (DynamicObject)changeData[0].getNewValue();
                DynamicObject oldBizItemObj = (DynamicObject)changeData[0].getOldValue();
                Long l = dataTypeId = SWCObjectUtils.isEmpty((Object)newBizItemObj) ? null : Long.valueOf(newBizItemObj.getLong("datatype.id"));
                if (!SWCObjectUtils.isEmpty((Object)oldBizItemObj) && !SWCObjectUtils.equals((Object)newBizItemObj, (Object)oldBizItemObj)) {
                    HashMap<String, Number> customMap = new HashMap<String, Number>(4);
                    customMap.put("rowIndex", rowIndex);
                    customMap.put("datatypeid", dataTypeId);
                    if (!SWCObjectUtils.isEmpty((Object)oldBizItemObj)) {
                        customMap.put("oldBizItemId", oldBizItemObj.getLong("id"));
                    }
                    if (!SWCObjectUtils.isEmpty((Object)newBizItemObj)) {
                        customMap.put("bizitem.id", newBizItemObj.getLong("id"));
                    }
                    String customValue = JSON.toJSONString(customMap);
                    this.changeBizItemConfirm(customValue);
                    break;
                }
                this.saveChangedRowCache(changeData[0].getDataEntity());
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                BizDataBillEntryHelper.setEntryCurrency((IFormView)this.getView(), (Long)dataTypeId, (int)rowIndex);
                break;
            }
            case "effectivedate": {
                ChangeData effectiveDateChangeData = args.getChangeSet()[0];
                Date effectiveDate = (Date)effectiveDateChangeData.getNewValue();
                if (effectiveDate == null) break;
                boolean bl = BizDataBillEntryCheckingHelper.checkEffectiveDate((IFormView)this.getView(), (ChangeData)effectiveDateChangeData, (Date)effectiveDate);
                break;
            }
            case "expirydate": {
                ChangeData expiryDateChangeData = args.getChangeSet()[0];
                Date expiryDate = (Date)expiryDateChangeData.getNewValue();
                if (expiryDate == null) break;
                boolean bl = BizDataBillEntryCheckingHelper.checkExpiryDate((IFormView)this.getView(), (ChangeData)expiryDateChangeData, (Date)expiryDate);
                break;
            }
            case "value": {
                ChangeData valueData = args.getChangeSet()[0];
                String newValue = (String)valueData.getNewValue();
                if (SWCStringUtils.isEmpty((String)newValue)) break;
                boolean bl = BizDataBillEntryCheckingHelper.checkValue((IFormView)this.getView(), (ChangeData)valueData, (String)newValue, (String)fieldKey);
                break;
            }
            case "currency": {
                ChangeData currencyChangeData = args.getChangeSet()[0];
                DynamicObject currencyValue = (DynamicObject)currencyChangeData.getNewValue();
                if (SWCObjectUtils.isEmpty((Object)currencyValue)) break;
                BizDataBillEntryCheckingHelper.checkCurrencyPrecision((IFormView)this.getView(), (ChangeData)currencyChangeData, (DynamicObject)currencyValue);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "save": {
                String ruleVersionStr = (String)this.getModel().getValue("bizdataruleversion");
                if (!SWCStringUtils.isEmpty((String)ruleVersionStr)) break;
                ruleVersionStr = BizDataHelper.getRuleVersionByBizItemGroup((IFormView)this.getView());
                this.getModel().setValue("bizdataruleversion", (Object)ruleVersionStr);
                break;
            }
            case "submit": 
            case "submitandeffect": 
            case "dosubmit": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (entryEntity != null && entryEntity.size() > 0) {
                    EntryType entryType = (EntryType)this.getModel().getDataEntity().getDynamicObjectCollection("entryentity").getDynamicObjectType();
                    entryType.setKeyField("person");
                    break;
                }
                this.checkEntryData(args);
                break;
            }
            case "dofail": {
                this.beforeDoFail();
                break;
            }
            case "docancel": {
                this.beforeDoCancel();
                break;
            }
            case "abandon": {
                BizDataHelper.abandonBeforeDo((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = null;
        switch (fieldKey) {
            case "calperiod": {
                DynamicObject bizItemGroup = (DynamicObject)this.getModel().getValue("bizitemgroup");
                DynamicObject calperiodType = bizItemGroup.getDynamicObject("calperiodtype");
                ArrayList idList = new ArrayList(10);
                if (!SWCObjectUtils.isEmpty((Object)calperiodType)) {
                    SWCDataServiceHelper swcDataServiceHelper = HPDIDataServiceHelper.HSBS_CALPERIODTYPE_HELPER;
                    DynamicObject calperiodTypeDetail = swcDataServiceHelper.queryOne("id,entryentity", calperiodType.getPkValue());
                    DynamicObjectCollection entryEntities = calperiodTypeDetail.getDynamicObjectCollection("entryentity");
                    entryEntities.forEach(obj -> idList.add(obj.getLong("id")));
                }
                qFilter = new QFilter("id", "in", idList);
                break;
            }
            case "currency": {
                qFilter = BizDataBillEntryHelper.getCurrencyFilter((IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent);
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "abandon_confirm": {
                BizDataHelper.abandonCheckClose((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent);
                break;
            }
            case "delete_entry_confirm": {
                if ("Cancel".equals(messageBoxClosedEvent.getResult().name())) {
                    IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                    String oldID = pageCache.get(CACHE_BIZITEM_GROUP_ID);
                    if ("".equals(oldID) || oldID != null) {
                        pageCache.put(RESET_VALUE, "1");
                        this.getView().getModel().setValue("bizitemgroup", (Object)Long.valueOf(oldID));
                        this.setPromptView(Boolean.FALSE);
                        this.setCycleItemView(Boolean.FALSE);
                        if (BizDataHelper.isContainLoopItem((long)this.getModel().getDataEntity().getLong("bizitemgroup.id"))) {
                            this.setPromptView(Boolean.TRUE);
                            this.setCycleItemView(Boolean.TRUE);
                        }
                    }
                    pageCache.put(CACHE_BIZITEM_GROUP_ID, null);
                    break;
                }
                this.deleteEntryConfirm(messageBoxClosedEvent);
                this.getModel().setValue("calperiod", null);
                break;
            }
            case "changeperiodconfirm": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    BizDataBillEntryHelper.deleteEntryData((IFormView)this.getView());
                    String modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno");
                    if (SWCStringUtils.isEmpty((String)modelBillNo)) break;
                    this.getView().invokeOperation("modify");
                    break;
                }
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                pageCache.put(KEY_IS_RESET_VAL, "1");
                this.getModel().setValue("calperiod", (Object)pageCache.get("oldPeriod"));
                break;
            }
            case "change_bizitem_confirm": {
                this.getView().updateView("entryentity");
                Map customMap = (Map)JSON.parseObject((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
                Integer rowIndex = (Integer)customMap.computeIfAbsent("rowIndex", item -> Integer.class);
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    boolean sysFillCurrency;
                    Long bizItemId = (Long)customMap.get("bizitem.id");
                    if (!this.cacheBizItemMap.containsKey(String.valueOf(bizItemId))) {
                        DynamicObjectCollection bizItemEntries = this.getModel().getDataEntity().getDynamicObject("bizitemgroup").getDynamicObjectCollection("entryentity");
                        this.cacheBizItemMap = bizItemEntries.stream().collect(Collectors.toMap(entry -> entry.getString("bizitem.id"), entry -> entry.getDynamicObject("bizitem"), (k1, k2) -> k1));
                    }
                    DynamicObject bizItem = this.cacheBizItemMap.get(String.valueOf(bizItemId));
                    Long dataTypeId = MapUtils.getLong((Map)customMap, (Object)"datatypeid");
                    int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex((IFormView)this.getView());
                    this.getModel().setValue("bizitem_id", (Object)bizItemId, rowIndex.intValue());
                    this.getModel().setValue("bizitem", (Object)bizItem, rowIndex.intValue());
                    this.getModel().setValue("value", null, rowIndex.intValue());
                    this.getModel().setValue("currency", null, rowIndex.intValue());
                    this.getModel().setValue("effectivedate", null, rowIndex.intValue());
                    this.getModel().setValue("expirydate", null, rowIndex.intValue());
                    this.getModel().setValue("remark", null, rowIndex.intValue());
                    this.getModel().setValue("relationdata", null, rowIndex.intValue());
                    DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex - startRowIndex);
                    row.set("bizitem_id", (Object)bizItemId);
                    row.set("bizitem", (Object)bizItem);
                    row.set("value", null);
                    row.set("currency", null);
                    row.set("effectivedate", null);
                    row.set("expirydate", null);
                    row.set("remark", null);
                    row.set("relationdata", null);
                    row.set("seq", (Object)(rowIndex + 1));
                    if (null != dataTypeId && 1020L == dataTypeId && (sysFillCurrency = "2".equals(this.getModel().getDataEntity().getString("bizitemgroup.currencyfilltype")))) {
                        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("bizitemgroup.sysfillcurrency");
                        row.set("currency", (Object)currency);
                        this.getModel().setValue("currency", (Object)currency, rowIndex.intValue());
                    }
                    this.saveChangedRowCache(row);
                } else {
                    Long oldBizItemId = (Long)customMap.computeIfAbsent("oldBizItemId", item -> Long.class);
                    this.getModel().setValue("bizitem", (Object)oldBizItemId, rowIndex.intValue());
                }
                model.endInit();
                this.getView().updateView("entryentity");
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                BizDataBillEntryHelper.setEntryFieldMustInput((IFormView)this.getView());
                BizDataBillEntryHelper.setFieldsNotQuickAddNew((IFormView)this.getView());
                break;
            }
        }
        BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
        BizDataBillEntryHelper.setMatchRuleFieldsMustInput((IFormView)this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        String billNo = (String)this.getView().getModel().getValue("billno");
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        String modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno");
        OperationResult opResult = args.getOperationResult();
        switch (key) {
            case "save": {
                boolean saveSuccess;
                boolean isSelfSave = Boolean.parseBoolean(formOperate.getOption().getVariableValue("is_self_save", String.valueOf(false)));
                this.afterSaveDo(args, formOperate);
                BizDataHelper.refreshEntryEntity((IDataModel)this.getModel());
                this.getView().getPageCache().remove("newentryoperation");
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                boolean bl = saveSuccess = opResult != null && opResult.isSuccess();
                if (saveSuccess) {
                    this.getView().invokeOperation("refresh");
                    if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway"))) {
                        this.getView().getParentView().sendFormAction(this.getView());
                    }
                    if (!isSelfSave && !SWCStringUtils.isEmpty((String)modelBillNo) && SWCStringUtils.equals((String)billStatus, (String)"D")) {
                        this.changeViewStatus(args);
                        this.getPageCache().put("bizdatabill_operationstatus", "VIEW");
                    }
                    BizDataBillEntryHelper.removeEntryDataCache((boolean)true, (Long)this.getModel().getDataEntity().getLong("id"), null);
                }
                this.getView().invokeOperation("refresh");
                if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway"))) {
                    this.getView().getParentView().sendFormAction(this.getView());
                }
                if (SWCStringUtils.isEmpty((String)modelBillNo) || saveSuccess) break;
                this.getView().invokeOperation("modify");
                break;
            }
            case "submit": {
                this.afterSubmitDo(args);
                if (opResult != null && opResult.isSuccess()) {
                    BizDataBillEntryHelper.removeEntryDataCache((boolean)true, (Long)this.getModel().getDataEntity().getLong("id"), null);
                }
                this.getView().invokeOperation("refresh");
                BizDataHelper.refreshEntryEntity((IDataModel)this.getModel());
                break;
            }
            case "modify": {
                this.changeEditBar(args);
                if (opResult == null || !opResult.isSuccess()) break;
                IPageCache pageCache = this.getPageCache();
                pageCache.put("pagerows", null);
                pageCache.put("pageindex", null);
                break;
            }
            case "submitandeffect": {
                this.afterSubmitAndEffect(args);
                if (opResult != null && opResult.isSuccess()) {
                    BizDataBillEntryHelper.removeEntryDataCache((boolean)true, (Long)this.getModel().getDataEntity().getLong("id"), null);
                }
                BizDataHelper.refreshEntryEntity((IDataModel)this.getModel());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "showeditview": {
                this.showEditView(args);
                break;
            }
            case "dosubmit": {
                this.getView().invokeOperation("refresh");
                if (opResult != null && opResult.isSuccess()) break;
                this.getView().invokeOperation("modify");
                break;
            }
            case "unsubmit": {
                this.afterUnSubmit(args);
                break;
            }
            case "doabandon": {
                BizDataHelper.afterDoAbandon((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "refreshcountdown": {
                this.setCountDownVal();
                break;
            }
            case "refresh": {
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hpdi_bizdatacancelflag": {
                this.cancelFlag(event);
                break;
            }
            case "hpdi_bizdatafailflag": {
                this.failFlag(event);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
    }

    public void pageRelease(EventObject evt) {
        Long bizDataBillId;
        super.pageRelease(evt);
        Object pkId = ((BillShowParameter)((BillView)evt.getSource()).getFormShowParameter()).getPkId();
        logger.info("...BizDataBillEdit.pageRelease pkId is: {}", pkId);
        if (pkId instanceof Long) {
            bizDataBillId = (Long)pkId;
        } else if (pkId instanceof String) {
            bizDataBillId = Long.parseLong(pkId.toString());
        } else {
            return;
        }
        BizDataBillEntryHelper.removeEntryDataCache((boolean)true, (Long)bizDataBillId, null);
    }

    private void initBizItemGroup() {
        Long calperiodId;
        Long groupId = (Long)this.getView().getFormShowParameter().getCustomParam("bizitemgroup");
        if (!SWCObjectUtils.isEmpty((Object)groupId)) {
            this.getModel().setValue("bizitemgroup", (Object)groupId);
        }
        if (!SWCObjectUtils.isEmpty((Object)(calperiodId = (Long)this.getView().getFormShowParameter().getCustomParam("calperiod")))) {
            this.getModel().setValue("calperiod", (Object)calperiodId);
        }
        if (!this.getView().getFormShowParameter().getCustomParams().containsKey("orgId") && SWCObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDynamicObject("org"))) {
            Long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            if (!(permOrgResult.hasAllOrgPerm() || CollectionUtils.isEmpty((Collection)hasPermOrgs) || hasPermOrgs.contains(orgId))) {
                orgId = (Long)permOrgResult.getHasPermOrgs().get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
        }
    }

    private void initGridConfig() {
        String entryId = this.getView().getEntityId();
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        String formId = this.getView().getFormShowParameter().getFormId();
        List gridConfigByDB = gridConfigDAO.getGridConfig(formId, entryId);
        if (gridConfigByDB.isEmpty()) {
            gridConfigByDB = GridConfigRenderUtils.getFieldApInfo((IFormView)this.getView(), (String)entryId, (String)"entryentity");
        }
        boolean isSave = false;
        for (GridConfigurationRow configurationRow : gridConfigByDB) {
            if (!"personnumber".equals(configurationRow.getFieldKey()) && !"personname".equals(configurationRow.getFieldKey()) || configurationRow.isFreeze()) continue;
            configurationRow.setFreeze(true);
            isSave = true;
        }
        if (isSave) {
            gridConfigDAO.saveGridConfig(formId, "entryentity", gridConfigByDB);
        }
    }

    private void updateSummary() {
        IDataModel model = this.getModel();
        Object summaryBillNo = model.getValue("billno");
        DynamicObject summaryCreator = (DynamicObject)model.getValue("creator");
        Object summaryCreatetime = model.getValue("createtime");
        model.beginInit();
        Label label = (Label)this.getControl(BILL_NO_LABEL);
        label.setText((String)summaryBillNo);
        if (summaryCreator != null) {
            model.setValue(SUMMARY_CREATOR, (Object)summaryCreator.getString("name"));
        }
        model.setValue(SUMMARY_CREATE_TIME, summaryCreatetime);
        model.endInit();
        this.getView().updateView(HEAD_PANEL_VIEW);
        this.getView().updateView(OVER_ALL_VIEW);
        model.setDataChanged(false);
    }

    private void setCountDownVal() {
        String billType = this.getModel().getDataEntity().getString("billtype");
        if ("2".equals(billType)) {
            return;
        }
        this.getModel().setValue("countdown", (Object)"-");
        DynamicObject bizItemGroup = this.getModel().getDataEntity().getDynamicObject("bizitemgroup");
        DynamicObject calPeriod = this.getModel().getDataEntity().getDynamicObject("calperiod");
        if (!SWCObjectUtils.isEmpty((Object)bizItemGroup) && !SWCObjectUtils.isEmpty((Object)calPeriod)) {
            Long bizItemGroupId = bizItemGroup.getLong("id");
            String calperiodNumber = calPeriod.getString("number");
            if (bizItemGroupId == null || bizItemGroupId == 0L || SWCObjectUtils.isEmpty((Object)calperiodNumber)) {
                return;
            }
            this.getModel().setValue("countdown", (Object)this.getCountDownByPeriod(bizItemGroupId, calperiodNumber));
        }
    }

    private String getCountDownByPeriod(Long bizItemGroupId, String calperiodNumber) {
        Map<String, Object> codResult = this.getCodResult(bizItemGroupId, calperiodNumber);
        logger.info(MessageFormat.format("result date is {0},{1}", codResult.get(KEY_START_TIME), codResult.get(KEY_END_TIME)));
        Date endTime = (Date)codResult.get(KEY_END_TIME);
        Date nowDate = new Date();
        return BizDataHelper.getCountDownByTime((Date)endTime, (Date)nowDate);
    }

    private boolean isOutTime(Long bizItemGroupId, String calperiodNumber) {
        boolean result = false;
        Map<String, Object> codResult = this.getCodResult(bizItemGroupId, calperiodNumber);
        logger.info(MessageFormat.format("result date is {0},{1}", codResult.get(KEY_START_TIME), codResult.get(KEY_END_TIME)));
        Date endTime = (Date)codResult.get(KEY_END_TIME);
        Date nowDate = new Date();
        if (!SWCObjectUtils.isEmpty((Object)endTime) && nowDate.after(endTime)) {
            result = true;
        }
        return result;
    }

    private Map<String, Object> getCodResult(Long bizItemGroupId, String calperiodNumber) {
        Long orgId = this.getModel().getDataEntity().getLong("bizitemgroup.createorg.id");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(16);
        parameterMap.put("bizitemgroupid", bizItemGroupId);
        parameterMap.put("periodnumber", calperiodNumber);
        parameterMap.put("org", orgId);
        logger.info(MessageFormat.format("bizitemgroupid is {0} periodnumber is {1} org is {2}", bizItemGroupId, calperiodNumber, orgId));
        Map result = HPDIServiceUtils.queryPayNodeTime(parameterMap);
        logger.info(MessageFormat.format("result date is {0},{1}", result.get(KEY_START_TIME), result.get(KEY_END_TIME)));
        return result;
    }

    private void init() {
        boolean isApproveNode;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
        String modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno");
        boolean isPersonNode = false;
        if (StringUtils.isEmpty((String)modelBillNo)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dosubmit"});
        } else {
            isPersonNode = true;
            this.getView().setVisible(Boolean.TRUE, new String[]{"dosubmit"});
        }
        if (!isPersonNode && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
        }
        this.setMainBar(isPersonNode);
        BizDataBillEntryHelper.showEntryCol((IFormView)this.getView());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String curNode = String.valueOf(customParams.get("CURNODE"));
        logger.info(MessageFormat.format("========================customParams is {0}", JSON.toJSONString((Object)customParams)));
        boolean bl = isApproveNode = StringUtils.isNotEmpty((String)curNode) && curNode.startsWith("AuditTask") || customParams.containsKey("sscId");
        if (isApproveNode) {
            if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flagpanel"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flagpanel"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_PANEL});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flagpanel"});
        }
        BizDataBillEntryHelper.setEntryFieldDisplay((IFormView)this.getView(), (boolean)isApproveNode);
        this.setUserDefinedColor();
        this.setBillStatusColor();
        this.setBillTypeLabel();
        this.setPromptView(Boolean.FALSE);
        this.setCycleItemViewByGroupId();
        this.setCalPeriodStatus();
        this.setCountDownVal();
        this.setEntryDisable();
    }

    private void setCalPeriodStatus() {
        DynamicObject bizItemGroup = this.getModel().getDataEntity().getDynamicObject("bizitemgroup");
        this.getView().setEnable(Boolean.TRUE, new String[]{"calperiod"});
        String billType = this.getModel().getDataEntity().getString("billtype");
        if ("2".equals(billType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calperiod"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"handletype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldgrouppanelap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"calperiod"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"handletype"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fieldgrouppanelap"});
        FieldEdit fieldEdit = (FieldEdit)this.getControl("calperiod");
        fieldEdit.setMustInput(true);
    }

    private void setPromptView(Boolean flag) {
        this.getView().setVisible(flag, new String[]{"iconandhintapflex"});
    }

    private void setCycleItemView(Boolean flag) {
        this.getView().setVisible(flag, new String[]{"iscycle", "relationdata", "viewrelationdata", "refreshrelationdata"});
        if (!flag.booleanValue()) {
            BizDataBillEntryHelper.setCustomParamHideenEntryField((IFormView)this.getView(), (String)"relationdata");
        }
        DynamicObject billObj = this.getModel().getDataEntity();
        if (!BizDataStatusEnum.NOT_PRESENT.getCode().equals(billObj.getString("datastatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"refreshrelationdata"});
        }
    }

    private void setCycleItemViewByGroupId() {
        this.setCycleItemView(Boolean.FALSE);
        Long bizItemGroupId = this.getModel().getDataEntity().getLong("bizitemgroup.id");
        String billType = this.getModel().getDataEntity().getString("billtype");
        if (bizItemGroupId != null && bizItemGroupId != 0L && BizDataHelper.isContainLoopItem((long)bizItemGroupId) && !"2".equals(billType)) {
            this.setCycleItemView(Boolean.TRUE);
            this.setPromptView(Boolean.TRUE);
        }
    }

    private void setMainBar(boolean isPersonNode) {
        String billStatus;
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("showway")) && ((Boolean)this.getView().getFormShowParameter().getCustomParam("ifProcessing")).booleanValue() && this.getView().getFormShowParameter().getCustomParam("pooltype-mytask") != null) {
            this.getPageCache().put("bizdatabill_operationstatus", "edit");
            this.getView().invokeOperation("modify");
        }
        if ("A".equals(billStatus = this.getModel().getDataEntity().getString("billstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unsubmit", "viewflow"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modify", "doabandon"});
        } else if ("G".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unsubmit"});
        } else if ("B".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "doabandon"});
        } else if (isPersonNode && "D".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "submitandeffect", "unsubmit", "doabandon"});
            String status = this.getPageCache().get("bizdatabill_operationstatus");
            if (status == null && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                this.getView().setStatus(OperationStatus.VIEW);
            }
            if (status == null) {
                this.getPageCache().put("bizdatabill_operationstatus", "VIEW");
            }
        } else if ("E".equals(billStatus) || "C".equals(billStatus) || "D".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "unsubmit", "doabandon"});
        } else if ("F".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "unsubmit", "viewflow", "doabandon"});
        }
    }

    private void beforeDoFail() {
        int[] selectRows = BizDataHelper.getEntryIndexArrByEntryName((IFormView)this.getView(), (String)"entryentity");
        if (selectRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u201d\u3002", (String)"BizDataBillEdit_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hpdi_bizdatafailflag");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hpdi_bizdatafailflag"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void beforeDoCancel() {
        int[] selectRows = BizDataHelper.getEntryIndexArrByEntryName((IFormView)this.getView(), (String)"entryentity");
        if (selectRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u201d\u3002", (String)"BizDataBillEdit_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hpdi_bizdatacancelflag");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)parameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hpdi_bizdatacancelflag"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void checkEntryData(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u518d\u63d0\u4ea4\u3002", (String)"BizDataBillEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void afterSaveDo(AfterDoOperationEventArgs args, FormOperate formOperate) {
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        boolean isSelfSave = Boolean.parseBoolean(formOperate.getOption().getVariableValue("is_self_save", String.valueOf(false)));
        OperationResult operationResult = args.getOperationResult();
        if (isSelfSave) {
            operationResult.setShowMessage(false);
            return;
        }
        String doSubmit = formOperate.getOption().getVariableValue("dosubmit", "");
        if (StringUtils.isNotEmpty((String)doSubmit)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizDataBillEdit_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        }
        this.changeViewStatus(args);
    }

    private void afterSubmitDo(AfterDoOperationEventArgs args) {
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "doabandon"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"unsubmit", "viewflow"});
        this.getView().invokeOperation("refresh");
    }

    private void changeEditBar(AfterDoOperationEventArgs args) {
        String modelBillNo;
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"modify", "doabandon", "unsubmit", "viewflow"});
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("G".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"viewflow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"doabandon"});
        }
        if (!StringUtils.isEmpty((String)(modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"viewflow"});
            ((BillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getPageCache().put("bizdatabill_operationstatus", "edit");
        }
        BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
    }

    private void changeViewStatus(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"modify"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if ("A".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"doabandon"});
        }
    }

    private void afterSubmitAndEffect(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            OperationResult operationResult = args.getOperationResult();
            operationResult.setShowMessage(false);
            this.getModel().setValue("billstatus", (Object)"C");
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("is_self_save", "true");
            this.getView().getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "doabandon", "refreshrelationdata"});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizDataBillEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        }
    }

    private void showEditView(AfterDoOperationEventArgs args) {
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        String modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno");
        if (!StringUtils.isEmpty((String)modelBillNo)) {
            return;
        }
        this.changeEditBar(args);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "doabandon"});
        this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
    }

    private void afterUnSubmit(AfterDoOperationEventArgs args) {
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"unsubmit", "viewflow"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"modify", "bar_submit", "submitandeffect", "doabandon"});
        this.getView().setStatus(OperationStatus.VIEW);
    }

    private void cancelFlag(ClosedCallBackEvent event) {
        String returnData = (String)event.getReturnData();
        if (null == returnData) {
            return;
        }
        DynamicObjectCollection bizDataBillEntry = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = BizDataHelper.getEntryIndexArrByEntryName((IFormView)this.getView(), (String)"entryentity");
        ArrayList<Long> entryIds = new ArrayList<Long>(selectRows.length);
        for (int row : selectRows) {
            DynamicObject bizDataDy = (DynamicObject)bizDataBillEntry.get(row);
            String bizDataStatus = bizDataDy.getString("bizdatastatus");
            int rowIndex = bizDataDy.getInt("seq") - 1;
            if ("1".equals(bizDataStatus)) continue;
            this.getModel().setValue("approvedesc", (Object)"", rowIndex);
            this.getModel().setValue("errormsg", (Object)"", rowIndex);
            this.getModel().setValue("dataapprovestatus", (Object)"2", rowIndex);
            this.getModel().setValue("submiterror", null, rowIndex);
            entryIds.add(bizDataDy.getLong("id"));
        }
        this.setUserDefinedColor();
        this.cancelFlagUpdateEntry(entryIds);
    }

    private void failFlag(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        DynamicObjectCollection bizDataBillEntry = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = BizDataHelper.getEntryIndexArrByEntryName((IFormView)this.getView(), (String)"entryentity");
        ArrayList<Long> entryIds = new ArrayList<Long>(selectRows.length);
        for (int row : selectRows) {
            DynamicObject bizDataDy = (DynamicObject)bizDataBillEntry.get(row);
            String bizDataStatus = bizDataDy.getString("bizdatastatus");
            int rowIndex = bizDataDy.getInt("seq") - 1;
            if ("1".equals(bizDataStatus)) continue;
            this.getModel().setValue("approvedesc", returnData.get("approvedesc"), rowIndex);
            this.getModel().setValue("dataapprovestatus", (Object)"1", rowIndex);
            entryIds.add(bizDataDy.getLong("id"));
        }
        this.setUserDefinedColor();
        this.failFlagUpdateEntry(entryIds, String.valueOf(returnData.get("approvedesc")));
    }

    private void setUserDefinedColor() {
        DynamicObjectCollection bizDataBillEntry = this.getModel().getEntryEntity("entryentity");
        int count = 0;
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (DynamicObject bizDataDy : bizDataBillEntry) {
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)count, (String)"dataapprovestatus", (String)"#FD6C6A");
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)count, (String)"errormsg", (String)"#FD6C6A");
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)count, (String)"submiterror", (String)"#FD6C6A");
            String bizDataStatus = bizDataDy.getString("bizdatastatus");
            if ("2".equals(bizDataStatus)) {
                SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)count, (String)"bizdatastatus", (String)"#FD6C6A");
            }
            ++count;
        }
    }

    private void setBillStatusColor() {
        String billStatus;
        Iterator<String> iterator = BILL_STATUS_COLOR_MAP.keySet().iterator();
        while (iterator.hasNext()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BILL_STATUS_COLOR_MAP.get(iterator.next())});
        }
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && !SWCStringUtils.isEmpty((String)(billStatus = this.getModel().getDataEntity().getString("billstatus")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BILL_STATUS_COLOR_MAP.get(billStatus)});
        }
    }

    private void deleteEntryConfirm(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            this.getModel().setValue("personcount", null);
            this.getModel().setValue("bizitemcount", null);
            this.getModel().setValue("bizdatacount", null);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("is_self_save", "true");
            BizDataHelper.setRuleVersionCaseSaveBizItemGroup((IFormView)this.getView());
            if (this.getModel().getDataEntity().getDynamicObject("bizitemgroup") == null) {
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                pageCache.put("delGroup", "1");
                this.updateBillObjCaseNullBizItemGroup();
            } else {
                this.getView().invokeOperation("save", operateOption);
            }
            this.getView().invokeOperation("refresh");
        } else {
            Long oldBizItemGroupId = Long.parseLong(this.getView().getPageCache().get("old_bizitemgroup"));
            IDataModel dataModel = this.getModel();
            dataModel.beginInit();
            this.getModel().setValue("bizitemgroup", (Object)oldBizItemGroupId);
            this.getView().updateView("bizitemgroup");
            dataModel.endInit();
        }
    }

    private void updateBillObjCaseNullBizItemGroup() {
        String billNo = (String)this.getModel().getValue("billno");
        DynamicObject billObj = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("bizitemgroup,entryentity,personcount,bizitemcount,bizdatacount,bizdataruleversion,calperiod", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (billObj != null) {
            billObj.set("bizitemgroup", null);
            billObj.set("entryentity", null);
            billObj.set("personcount", null);
            billObj.set("bizitemcount", null);
            billObj.set("bizdatacount", null);
            billObj.set("bizdataruleversion", null);
            billObj.set("calperiod", null);
            HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.updateOne(billObj);
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("delGroup", "1");
        }
    }

    private void setBillTypeLabel() {
        Label billTypeLabel = (Label)this.getView().getControl(KEY_BILL_TYPE_LABEL);
        Object billTypeObj = this.getModel().getValue("billtype");
        if (billTypeObj != null) {
            String billType = (String)billTypeObj;
            if (SWCStringUtils.equals((String)billType, (String)"1")) {
                billTypeLabel.setText(BillTypeEnum.ADDING_SERVICE_DATA.getDesc());
            } else if (SWCStringUtils.equals((String)billType, (String)"2")) {
                billTypeLabel.setText(BillTypeEnum.UPDATE_EXPIRY_DATE.getDesc());
                DynamicObjectCollection entity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                entity.forEach(data -> data.set("originalbizdatacode", (Object)data.getString("bizdatacode")));
            }
        }
    }

    protected void setEntryDisable() {
        this.getView().setEnable(Boolean.FALSE, BizDataConstants.DEFAULT_DISABLE_BIZDATABILL_ENTRY_FIELDS);
    }

    private void changeBizItemConfirm(String customValue) {
        String message = ResManager.loadKDString((String)"\u91cd\u65b0\u9009\u62e9\u4e1a\u52a1\u9879\u76ee\u5c06\u6e05\u7a7a\u8be5\u884c\u5df2\u5f55\u5165\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillEdit_19", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(null, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CHANGE_BIZITEM_CONFIRM, (IFormPlugin)this), new HashMap(0), customValue);
    }

    private void failFlagUpdateEntry(List<Long> entryIds, String approveDesc) {
        DynamicObject[] objects;
        for (DynamicObject object : objects = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(entryIds.toArray())) {
            object.set("approvedesc", (Object)approveDesc);
            object.set("dataapprovestatus", (Object)"1");
        }
        this.executeOp("save", objects);
    }

    private void cancelFlagUpdateEntry(List<Long> entryIds) {
        DynamicObject[] objects;
        for (DynamicObject object : objects = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query(entryIds.toArray())) {
            object.set("approvedesc", (Object)"");
            object.set("errormsg", (Object)"");
            object.set("dataapprovestatus", (Object)"2");
            object.set("submiterror", null);
        }
        this.executeOp("save", objects);
    }

    private void executeOp(String opName, DynamicObject[] dys) {
        if (null == dys || 0 == dys.length) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        OperationServiceImpl opImpl = new OperationServiceImpl();
        opImpl.localInvokeOperation(opName, dys, operateOption);
        this.getView().invokeOperation("refresh");
    }

    private void saveChangedRowCache(DynamicObject changedDy) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", this.getModel().getDataEntity().getPkValue()));
        HashSet<Long> changedEntryIds = (HashSet<Long>)appCache.get("changed_entry_id_collection", HashSet.class);
        HashMap<String, Integer> changedEntryMap = (HashMap<String, Integer>)appCache.get("changed_entry_map", HashMap.class);
        Long entryId = changedDy.getLong("id");
        if (entryId == 0L) {
            return;
        }
        if (null == changedEntryIds) {
            changedEntryIds = new HashSet<Long>(16);
        }
        if (null == changedEntryMap) {
            changedEntryMap = new HashMap<String, Integer>(16);
        }
        if (changedEntryIds.add(entryId)) {
            appCache.put("changed_entry_id_collection", changedEntryIds);
        }
        changedEntryMap.put(String.valueOf(entryId), changedDy.getInt("seq"));
        appCache.put("changed_entry_map", changedEntryMap);
        appCache.put(String.valueOf(entryId), (Object)SerializationUtils.serializeToBase64((Object)changedDy));
    }

    private void initMulBizItem() {
        MulBasedataDynamicObjectCollection bizItems = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get("mulbizitem");
        if (!CollectionUtils.isEmpty((Collection)bizItems)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List mulBizItemIds = (List)customParams.get("mulBizItemIds");
        if (CollectionUtils.isEmpty((Collection)mulBizItemIds)) {
            return;
        }
        this.getModel().setValue("mulbizitem", (Object)mulBizItemIds.toArray());
    }

    static {
        BILL_STATUS_COLOR_MAP.put("A", LABEL_TMP_SAVE);
        BILL_STATUS_COLOR_MAP.put("B", LABEL_SUBMIT);
        BILL_STATUS_COLOR_MAP.put("C", LABEL_APPROVE_PASS);
        BILL_STATUS_COLOR_MAP.put("D", LABEL_APPROVING);
        BILL_STATUS_COLOR_MAP.put("E", LABEL_APPROVE_NOT_PASS);
        BILL_STATUS_COLOR_MAP.put("G", LABEL_RESUBMIT);
        BILL_STATUS_COLOR_MAP.put("F", LABEL_ABANDON);
        EXCLUDE_ENTRY_FIELD_SET.add("bizitem");
        EXCLUDE_ENTRY_FIELD_SET.add("approvedesc");
        EXCLUDE_ENTRY_FIELD_SET.add("dataapprovestatus");
        EXCLUDE_ENTRY_FIELD_SET.add("errormsg");
        EXCLUDE_ENTRY_FIELD_SET.add("submiterror");
    }
}

