/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService;
import kd.sdk.swc.hpdi.common.events.bizdatabill.AfterAddFieldContainerEvent;
import kd.swc.hpdi.business.helper.BizDataBillEntryExtService;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCCompareTypeConstants;
import kd.swc.hsbp.common.util.SWCDateQFilterParserUtil;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillEntryGridHelper {
    private static Log log = LogFactory.getLog(BizDataBillEntryGridHelper.class);
    private static final String KEY_ENTITY = "hpdi_bizdatabillent";
    private static final String KEY_VALUE = "value";
    private static final String SELECTED_PROPERTIES = "id, bizdatabillid, bizdate, relationdata, currency.id as currency_id, calfrequency.id as calfrequency_id, effectivedateent, expirydateent, updateexpirydate, updateddesc, remark, dataapprovestatus, approvedesc, bizdatastatus, errormsg, submiterror, bizdatacode, empposorgrel.id as empposorgrel_id , empposorgrel.company.id as company_id, empposorgrel.position.id as position_id, empposorgrel.apositiontype as apositiontype, empposorgrel.job.id as job_id, empposorgrel.postype.id as postype_id, empposorgrel.person.number, empposorgrel.person.number as person_number, empposorgrel.person.id as person_id, empposorgrel.isprimary as isprimary, empposorgrel.startdate as startdate, empposorgrel.enddate as enddate, empposorgrel.adminorg.id as entadminorg_id, entryentity.id, entryentity.bizitem.id as bizitem_id, entryentity.bizitem.number as bizitem_number, entryentity.value as value, entryentity.effectivedate as effectivedate, entryentity.expirydate as expirydate";
    private static final String SELECTED_PROPERTIES_FIX = " empposorgrel.company.id as company_id, empposorgrel.position.id as position_id, empposorgrel.apositiontype as apositiontype, empposorgrel.job.id as job_id, empposorgrel.postype.id as postype_id, empposorgrel.person.number, empposorgrel.person.number as person_number, empposorgrel.person.id as person_id, empposorgrel.isprimary as isprimary, empposorgrel.startdate as startdate, empposorgrel.enddate as enddate, empposorgrel.adminorg.id as entadminorg_id, entryentity.id, entryentity.bizitem.id as bizitem_id, entryentity.bizitem.number as bizitem_number, entryentity.value as value, entryentity.effectivedate as effectivedate, entryentity.expirydate as expirydate";

    public static int getRowCountCore(IFormView view) {
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable((IFormView)view);
        int rowCount = 500;
        Long bizDataBillId = (Long)view.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBillId);
        BizDataBillEntryGridHelper.addCustomEntryQueryParam(view, qFilter);
        String selectProperties = "id";
        if (!isHorizontal) {
            selectProperties = "id, entryentity.id";
        }
        rowCount = ORM.create().count("BizDataBillEntryGridHelper.getRowCountCore", KEY_ENTITY, selectProperties, qFilter.toArray());
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getRowIdCore(IFormView view) {
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable((IFormView)view);
        int rowCount = 500;
        Long bizDataBillId = (Long)view.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBillId);
        BizDataBillEntryGridHelper.addCustomEntryQueryParam(view, qFilter);
        String selectProperties = "id";
        if (!isHorizontal) {
            selectProperties = "id, entryentity.id";
        }
        ArrayList<Long> billEntIds = new ArrayList<Long>(10);
        DataSet dataSet = null;
        try {
            dataSet = ORM.create().queryDataSet("BizDataBillEntryGridHelper.getRowCountCore", KEY_ENTITY, selectProperties, qFilter.toArray());
            for (Row row : dataSet) {
                billEntIds.add(row.getLong("id"));
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
        }
        return billEntIds;
    }

    public static List<DynamicObject> getEntryDataEntitiesCoreFull(IFormView view, int startIndex, int endIndex, QFilter custFilter) {
        List<DynamicObject> ret = BizDataBillEntryGridHelper.getEntryDataEntitiesCore(view, startIndex, endIndex, custFilter);
        log.info("getEntryEntity..afterGetEntryDataEntitiesCore...begin...{}...{}", (Object)startIndex, (Object)endIndex);
        BizDataBillEntryGridHelper.afterGetEntryDataEntitiesCore(ret);
        log.info("getEntryEntity..afterGetEntryDataEntitiesCore...end.....{}...{}", (Object)startIndex, (Object)endIndex);
        return ret;
    }

    public static List<DynamicObject> getEntryDataEntitiesCore(IFormView view, int startIndex, int endIndex) {
        return BizDataBillEntryGridHelper.getEntryDataEntitiesCore(view, startIndex, endIndex, null);
    }

    public static List<DynamicObject> getEntryDataEntitiesCore(IFormView view, int startIndex, int endIndex, QFilter custFilter) {
        int offsetIndex = endIndex - startIndex;
        boolean isHorizontal = BizDataBillEntryHelper.isHorizontalTable((IFormView)view);
        Long billId = (Long)view.getModel().getDataEntity().getPkValue();
        DynamicObjectCollection entryEntities = view.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryType = entryEntities.getDynamicObjectType();
        entryEntities.clear();
        ArrayList ret = Lists.newArrayList();
        List<String> rowKeyList = entryType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        if (isHorizontal) {
            BizDataBillEntryGridHelper.fillHorizontalData(view, ret, billId, entryEntities, rowKeyList, startIndex, offsetIndex, custFilter);
        } else {
            BizDataBillEntryGridHelper.fillVerticalData(view, ret, billId, entryEntities, rowKeyList, startIndex, offsetIndex, custFilter);
        }
        return ret;
    }

    private static String getBillEntSelectProp() {
        String[] allPropsArr;
        StringBuilder allProps = new StringBuilder(SELECTED_PROPERTIES_FIX);
        BizDataBillEntryGridHelper.getBillEntSelfSelectProp(allProps);
        AfterAddFieldContainerEvent event = new AfterAddFieldContainerEvent();
        List<String> selectProps = BizDataBillEntryGridHelper.invokeAfterAddFieldContainer(event);
        HashSet<String> propSet = new HashSet<String>(16);
        if (!SWCListUtils.isEmpty(selectProps)) {
            for (String string : selectProps) {
                propSet.add(string.trim());
            }
        }
        for (String prop : allPropsArr = allProps.toString().split(",")) {
            propSet.add(prop.trim());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String prop : propSet) {
            if (stringBuilder.length() >= 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(prop);
        }
        return stringBuilder.toString();
    }

    private static StringBuilder getBillEntSelfSelectProp(StringBuilder allProps) {
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)KEY_ENTITY).getFields();
        allProps.append(",id");
        for (Map.Entry prop : fieldProps.entrySet()) {
            IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
            if (SWCStringUtils.isEmpty((String)propval.getAlias())) continue;
            allProps.append(',');
            if (propval instanceof BasedataProp) {
                allProps.append((String)prop.getKey()).append(".id as ").append((String)prop.getKey()).append("_id");
                continue;
            }
            allProps.append((String)prop.getKey());
        }
        return allProps;
    }

    private static List<String> invokeAfterAddFieldContainer(AfterAddFieldContainerEvent args) {
        BizDataBillEntryExtService ExtService = new BizDataBillEntryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataBillEntryExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService#afterAddFieldContainer", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterAddFieldContainer(args);
            return null;
        });
        return args.getSelectProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillHorizontalData(IFormView view, List<DynamicObject> ret, Long billId, DynamicObjectCollection entryEntities, List<String> rowKeyList, int startIndex, int offsetIndex, QFilter custFilter) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        List controlList = entryGrid.getItems();
        Map<String, Control> cMap = controlList.stream().collect(Collectors.toMap(Control::getKey, control -> control, (key1, key2) -> key1));
        DynamicObject dataEntity = view.getModel().getDataEntity();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", dataEntity.getPkValue()));
        Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)billId);
        if (custFilter != null) {
            qFilter.and(custFilter);
        }
        BizDataBillEntryGridHelper.addCustomEntryQueryParam(view, qFilter);
        String orderBy = "empposorgrel.person.number";
        try (DataSet dataSet = null;){
            log.info("EntryExport.log...getEntryEntity..fillHorizontalData1...begin...{}...{}", (Object)startIndex, (Object)offsetIndex);
            dataSet = ORM.create().queryDataSet("BizDataBillEntryGridHelper.fillHorizontalData1", KEY_ENTITY, "id,empposorgrel.person.number", qFilter.toArray(), "id", startIndex, offsetIndex);
            log.info("EntryExport.log...getEntryEntity..fillHorizontalData1...end.....{}...{}", (Object)startIndex, (Object)offsetIndex);
            ArrayList<Long> billEntIds = new ArrayList<Long>(offsetIndex);
            for (Row row : dataSet) {
                billEntIds.add(row.getLong("id"));
            }
            log.info("EntryExport.log...getEntryEntity..fillHorizontalData2...begin...{}...{}", (Object)startIndex, (Object)offsetIndex);
            int bizItemCount = dataEntity.getInt("bizitemcount");
            int batchMaxSize = 1800;
            int batchSize = bizItemCount == 0 ? batchMaxSize : batchMaxSize / bizItemCount;
            List splitBillEntIds = Lists.partition(billEntIds, (int)batchSize);
            for (int i = 0; i < splitBillEntIds.size(); ++i) {
                List billEntIdList = (List)splitBillEntIds.get(i);
                log.info("EntryExport.log...getEntryEntity..fillHorizontalData2...begin...{}...{}...{}", (Object)i, (Object)billEntIdList.size());
                BizDataBillEntryGridHelper.fillHorizontalDataItem(ret, entryEntities, rowKeyList, cMap, appCache, changedEntryIds, orderBy, billEntIdList);
                log.info("EntryExport.log...getEntryEntity..fillHorizontalData2...end.....{}...{}...{}", (Object)i, (Object)billEntIdList.size());
            }
        }
        log.info("EntryExport.log...getEntryEntity..fillHorizontalData2.for...end...{}...{}", (Object)startIndex, (Object)offsetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillHorizontalDataItem(List<DynamicObject> ret, DynamicObjectCollection entryEntities, List<String> rowKeyList, Map<String, Control> cMap, ISWCAppCache appCache, Set<Long> changedEntryIds, String orderBy, List<Long> billEntIds) {
        log.info("EntryExport.log...getEntryEntity..fillHorizontalDataItem...begin...{}...{}", (Object)billEntIds.size(), (Object)orderBy);
        try (DataSet dataSet1 = null;){
            QFilter qFilter1 = new QFilter("id", "in", billEntIds);
            dataSet1 = ORM.create().queryDataSet("BizDataBillEntryGridHelper.fillHorizontalData2", KEY_ENTITY, BizDataBillEntryGridHelper.getBillEntSelectProp(), qFilter1.toArray(), orderBy);
            log.info("EntryExport.log...getEntryEntity..fillHorizontalData2...end...{}...{}", (Object)billEntIds.size(), (Object)orderBy);
            LinkedHashMap<Long, List<DynamicObject>> map = BizDataBillEntryGridHelper.convertDataSet(dataSet1);
            log.info("EntryExport.log...getEntryEntity..fillHorizontalDataItem.convertDataSet...end...{}...{}", (Object)billEntIds.size(), (Object)orderBy);
            List<String> dataSetKeyList = Arrays.asList(dataSet1.getRowMeta().getFieldNames());
            for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
                DynamicObject entityRow = entryEntities.addNew();
                boolean isChangedRow = CollectionUtils.isNotEmpty(changedEntryIds) && changedEntryIds.contains(entry.getKey());
                DynamicObject changedDy = isChangedRow ? (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(String.valueOf(entry.getKey()), String.class))) : null;
                Map<String, Object> itemMap = entry.getValue().stream().filter(dyObj -> dyObj.get(KEY_VALUE) != null).collect(Collectors.toMap(dyObj -> dyObj.getString("bizitem_number").toLowerCase(), dyObj -> dyObj.get(KEY_VALUE), (key1, key2) -> key1));
                rowKeyList.forEach(rowKey -> {
                    if (isChangedRow) {
                        entityRow.set(rowKey, changedDy.get(rowKey));
                        return;
                    }
                    if (dataSetKeyList.contains(rowKey)) {
                        entityRow.set(rowKey, ((DynamicObject)((List)entry.getValue()).get(0)).get(rowKey));
                    } else {
                        Object value = itemMap.get(rowKey);
                        if (null != value) {
                            if (cMap.get(rowKey) instanceof DateTimeEdit) {
                                try {
                                    entityRow.set(rowKey, (Object)SWCDateTimeUtils.parseDate((String)((String)value)));
                                }
                                catch (ParseException parseException) {}
                            } else if (cMap.get(rowKey) instanceof DecimalEdit || cMap.get(rowKey) instanceof AmountEdit) {
                                entityRow.set(rowKey, (Object)new BigDecimal((String)value));
                            } else {
                                entityRow.set(rowKey, value);
                            }
                        }
                    }
                });
                entityRow.set("originalbizdatacode", entityRow.get("bizdatacode"));
                ret.add(entityRow);
            }
        }
        log.info("EntryExport.log...getEntryEntity..fillHorizontalDataItem...end.....{}...{}", (Object)billEntIds.size(), (Object)orderBy);
    }

    private static LinkedHashMap<Long, List<DynamicObject>> convertDataSet(DataSet dataSet1) {
        LinkedHashMap<Long, List<DynamicObject>> map = new LinkedHashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection dataSetList = ORM.create().toPlainDynamicObjectCollection(dataSet1);
        for (DynamicObject data : dataSetList) {
            Long id = data.getLong("id");
            List<DynamicObject> dataList = map.get(id);
            if (dataList == null) {
                dataList = new ArrayList<DynamicObject>(10);
                map.put(id, dataList);
            }
            dataList.add(data);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillVerticalData(IFormView view, List<DynamicObject> ret, Long billId, DynamicObjectCollection entryEntities, List<String> rowKeyList, int startIndex, int offsetIndex, QFilter custFilter) {
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)billId);
        if (custFilter != null) {
            qFilter.and(custFilter);
        }
        BizDataBillEntryGridHelper.addCustomEntryQueryParam(view, qFilter);
        DataSet dataSet = null;
        try {
            dataSet = ORM.create().queryDataSet("BizDataBillEntryGridHelper.fillVerticalData", KEY_ENTITY, BizDataBillEntryGridHelper.getBillEntSelectProp(), qFilter.toArray(), "id", startIndex, offsetIndex);
            dataSet = dataSet.orderBy(new String[]{"person_number"});
            List<String> dataSetKeyList = Arrays.asList(dataSet.getRowMeta().getFieldNames());
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", view.getModel().getDataEntity().getPkValue()));
            Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
            int seq = 0;
            for (Row row : dataSet) {
                DynamicObject entityRow = entryEntities.addNew();
                boolean isChangedRow = CollectionUtils.isNotEmpty((Collection)changedEntryIds) && changedEntryIds.contains(row.getLong("id"));
                DynamicObject changedDy = isChangedRow ? (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(String.valueOf(row.getLong("id")), String.class))) : null;
                rowKeyList.forEach(rowKey -> {
                    if (dataSetKeyList.contains(rowKey)) {
                        if (isChangedRow) {
                            entityRow.set(rowKey, changedDy.get(rowKey));
                        } else {
                            entityRow.set(rowKey, row.get(rowKey));
                        }
                    }
                });
                entityRow.set("originalbizdatacode", entityRow.get("bizdatacode"));
                entityRow.set("seq", (Object)seq++);
                ret.add(entityRow);
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
        }
    }

    private static void addCustomEntryQueryParam(IFormView view, QFilter qFilter) {
        String selectPropStr = BizDataBillEntryGridHelper.getBillEntSelectProp();
        HashMap<String, String> selectPropMap = new HashMap<String, String>(16);
        for (String selectProp : selectPropStr.split(",")) {
            String selectPropTrim = selectProp.trim();
            if (selectPropTrim.contains(" as ")) {
                String[] selectPropArr = selectPropTrim.split(" as ");
                selectPropMap.put(selectPropArr[1].trim().replace("_id", ""), selectPropArr[0].trim().replace(".id", ".name"));
                continue;
            }
            selectPropMap.put(selectPropTrim, selectPropTrim);
        }
        EntryQueryParam entryQueryParam = view.getModel().getEntryQueryParam("entryentity");
        List filterItems = entryQueryParam.getFilterItems();
        for (EntryFilterItemInfo filterItemInfo : filterItems) {
            String property = (String)selectPropMap.get(filterItemInfo.getPropName());
            filterItemInfo.setPropName(property);
            String compareType = filterItemInfo.getCompareType();
            if (SWCDateQFilterParserUtil.isDateQFilter((String)compareType)) {
                QFilter dateFilter = SWCDateQFilterParserUtil.buildQFilterByFilterItem((EntryFilterItemInfo)filterItemInfo);
                qFilter.and(dateFilter);
                continue;
            }
            String cp = (String)SWCCompareTypeConstants.getCompareTypeMap().get(compareType);
            Object value = SWCCompareTypeConstants.transferValue((String)filterItemInfo.getCompareType(), (Object)filterItemInfo.getValue());
            if (SWCStringUtils.isEmpty((String)property) || SWCStringUtils.isEmpty((String)cp)) continue;
            qFilter.and(property, cp, value);
        }
    }

    private static void afterGetEntryDataEntitiesCore(List<DynamicObject> ret) {
        if (CollectionUtils.isEmpty(ret)) {
            return;
        }
        HashMap<String, BasedataProp> bdEntityMap = new HashMap<String, BasedataProp>(16);
        HashMap<String, Set<Long>> bdMap = new HashMap<String, Set<Long>>(16);
        DataEntityPropertyCollection properties = ret.get(0).getDataEntityType().getProperties();
        for (Object prop : properties) {
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            bdEntityMap.put(bdProp.getName(), bdProp);
        }
        for (DynamicObject data : ret) {
            for (Map.Entry entry : bdEntityMap.entrySet()) {
                BasedataProp bdProp = (BasedataProp)entry.getValue();
                String refIdPropertyName = bdProp.getRefIdPropName();
                Long id = data.getLong(refIdPropertyName);
                if (id == 0L) continue;
                BizDataBillEntryGridHelper.putSetValueToMap(bdMap, (String)entry.getKey(), id);
            }
        }
        Map<Long, DynamicObject> bdDataMap = BizDataBillEntryGridHelper.queryBaseData(bdEntityMap, bdMap);
        for (DynamicObject data : ret) {
            for (Map.Entry entry : bdEntityMap.entrySet()) {
                BasedataProp bdProp = (BasedataProp)entry.getValue();
                String refIdPropertyName = bdProp.getRefIdPropName();
                Long id = data.getLong(refIdPropertyName);
                DynamicObject bdDy = bdDataMap.get(id);
                if (bdDy == null) continue;
                data.set((String)entry.getKey(), (Object)bdDy);
            }
        }
    }

    private static Map<Long, DynamicObject> queryBaseData(Map<String, BasedataProp> bdEntityMap, Map<String, Set<Long>> bdMap) {
        HashMap<Long, DynamicObject> bdDataMap = new HashMap<Long, DynamicObject>(16);
        for (BasedataProp bd : bdEntityMap.values()) {
            Set<Long> ids = bdMap.get(bd.getName());
            if (ids == null || ids.size() == 0) continue;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(bd.getBaseEntityId());
            QFilter idFilter = new QFilter("id", "in", bdMap.get(bd.getName()));
            QFilter[] allFilter = new QFilter[]{idFilter};
            DynamicObject[] objects = serviceHelper.query(bd.getDisplayProp(), allFilter);
            Map<Long, DynamicObject> dyMap = Arrays.stream(objects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            bdDataMap.putAll(dyMap);
        }
        return bdDataMap;
    }

    private static void putSetValueToMap(Map<String, Set<Long>> bdMap, String key, Long value) {
        Set<Long> valueSet = bdMap.get(key);
        if (valueSet == null) {
            valueSet = new HashSet<Long>(16);
        }
        valueSet.add(value);
        bdMap.put(key, valueSet);
    }
}

