/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.expt.IExportService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImportHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.SAXException;

public class BizDataBillEntryImpFailedSheetHandler
extends SheetHandler {
    private static final IExportService exportService = (IExportService)ServiceFactory.getService(IExportService.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String KEY_COLOR = "color";
    private static final Log log = LogFactory.getLog(BizDataBillEntryImpFailedSheetHandler.class);
    private static final Pattern SpecCharPattern = Pattern.compile("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]");
    private final int ERR_ROW_COUNT = 5000;
    private final int MAX_COL_COUNT = 16383;
    private final Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private final BizDataBillEntryImpConfig conf;
    private final FileService service;
    private final Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private final boolean isNewFormat = true;
    private final Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>();
    private SXSSFWorkbook book;
    private ImportLogger importLogger;
    private ImportContext ctx;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private boolean hasErrorCol;
    private Boolean isExportAllDataErrorLog;
    private boolean isDropdownItemsSheet = false;

    BizDataBillEntryImpFailedSheetHandler(BizDataBillEntryImpConfig conf, FileService service) {
        this.setInterrupt(false);
        this.conf = conf;
        this.service = service;
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(10000);
            }
            sheet = this.book.createSheet(row.getSheetName());
            if (this.sheets.size() == 0) {
                sheet.setColumnWidth(0, 10000);
            }
            this.isDropdownItemsSheet = "dropdown_items_sheet".equals(row.getSheetName());
            this.sheets.put(row.getSheetName(), sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        if (this.sheets.size() > 1) {
            this.handleSheet(sheet, currRowNum);
            return;
        }
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        JSONObject styleObj;
        Object logCache;
        List list;
        SXSSFCell cell;
        Map<String, Object> paramMap;
        int titleRowIndex;
        SXSSFRow curRow = this.getRow(sheet, this.cursorRowNum);
        if (currRowNum < 3) {
            curRow.setHidden(Boolean.valueOf(row.isHideRow()));
        }
        if (currRowNum == (titleRowIndex = ((Integer)(paramMap = this.conf.getParam()).get("headEndHeight")).intValue())) {
            SXSSFRow nameRow = this.getRow(sheet, this.cursorRowNum);
            this.conf.setLastCellNum((short)row.getData().size());
            this.nameRows.put(row.getSheetName(), nameRow);
            cell = nameRow.createCell((int)this.conf.getLastCellNum());
            String string = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"DynamicEntryImportStartEdit_6", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            cell.setCellValue(string);
            cell.setCellStyle(this.setBorderStyle(sheet.getWorkbook()));
        } else if (currRowNum > titleRowIndex && CollectionUtils.isNotEmpty((Collection)(list = (List)(logCache = this.conf.getHandler().getLogCache()).get(currRowNum - titleRowIndex - 1)))) {
            cell = this.getRow(sheet, this.cursorRowNum).createCell((int)this.conf.getLastCellNum());
            styleObj = new JSONObject();
            styleObj.put(KEY_COLOR, (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(StringUtils.join((Object[])list.toArray(), (String)";"));
        }
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            CellStyle style;
            if (this.hasErrorCol && (Integer)entry.getKey() == 0 || (Integer)entry.getKey() >= 16383) continue;
            styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            int cellIndex = this.countIndex((Integer)entry.getKey());
            cell = this.getRow(sheet, this.cursorRowNum).createCell(cellIndex);
            if (currRowNum == titleRowIndex) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (((String)entry.getValue()).startsWith("*")) {
                    styleObj.put(KEY_COLOR, (Object)IndexedColors.RED.getIndex());
                }
                Map colProperty = (Map)this.getColHolder().getColProperty().get(cellIndex);
                double colWidth = 0.0;
                if (colProperty != null && NumberUtils.isParsable((String)String.valueOf(colProperty.get("colWidth")))) {
                    colWidth = Double.parseDouble(String.valueOf(colProperty.get("colWidth")));
                }
                sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth((String)((String)entry.getValue()), (int)0, (double)colWidth));
            }
            if ((style = this.getCellStyle(styleObj)) != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
        ++this.cursorRowNum;
        int dataRowNum = this.cursorRowNum - titleRowIndex - 1;
        if (dataRowNum % 1000 == 0 || dataRowNum == this.conf.getResolveRows()) {
            this.conf.setDealRowsErrFile(dataRowNum);
            BizDataBillEntryImportHelper.setProgressToCache(this.conf);
        }
    }

    private CellStyle setBorderStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private void handleSheet(SXSSFSheet sheet, int currRowNum) {
        this.hasErrorCol = true;
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            JSONObject styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            CellStyle style = this.getCellStyle(styleObj);
            if (style != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)entry.getValue());
        }
    }

    private int countIndex(int index) {
        return index;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort(KEY_COLOR);
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int rowNum) {
        SXSSFRow row = sheet.getRow(rowNum);
        if (row == null) {
            row = sheet.createRow(rowNum);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        Set sheetNames = this.getSheetNames();
        sheetNames.remove(this.getSheetName());
        if (sheetNames.isEmpty()) {
            File temp = null;
            OutputStream fos = null;
            FileInputStream fis = null;
            try {
                Map<String, Object> paramMap = this.conf.getParam();
                String urlImport = String.valueOf(paramMap.get("url"));
                temp = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
                fos = new FileOutputStream(temp);
                int indexDropdownItemsSheet = this.book.getSheetIndex("dropdown_items_sheet");
                if (indexDropdownItemsSheet >= 0) {
                    this.book.setSheetHidden(indexDropdownItemsSheet, true);
                }
                this.book.write(fos);
                this.book.dispose();
                String tplStr = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"BizDataBillEntryImpTask_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                String failStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_", (String)"BizDataBillEntryImpTask_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                String fileBaseName = FilenameUtils.getBaseName((String)urlImport);
                fileBaseName = fileBaseName.replace(tplStr, "");
                fileBaseName = fileBaseName.replace(failStr, "");
                String fileName = failStr + fileBaseName + ".xlsx";
                RequestContext rc = RequestContext.getOrCreate();
                String path = FileNameUtils.getExportFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"hpdi", (String)("import" + UUID.randomUUID().toString()), (String)fileName);
                fis = new FileInputStream(temp);
                String uploadFileUrl = this.service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)path, (InputStream)fis, (FileSource)FileSource.EXCEL_IMPORT));
                this.conf.setErrorLogFileUrl(uploadFileUrl);
                this.conf.getParam().put("errorLogFileUrl", uploadFileUrl);
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
            finally {
                try {
                    this.book.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
                if (temp != null && temp.delete()) {
                    temp = null;
                }
                this.sheets.clear();
                this.book = null;
                this.importLogger = null;
            }
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        int rowNum = 3;
        if (!comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = this.book.getSheet(sheetName);
                SXSSFRow row = this.nameRows.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing drawing = sheet.createDrawingPatriarch();
                CommentsTable commentsTable = entry.getValue();
                Iterator cellAddresses = commentsTable.getCellAddresses();
                while (cellAddresses.hasNext()) {
                    XSSFComment comment;
                    CellAddress addr = (CellAddress)cellAddresses.next();
                    SXSSFCell cell = row.getCell(this.countIndex(addr.getColumn()));
                    if (cell == null || (comment = commentsTable.findCellComment(addr)).getRow() != rowNum) continue;
                    Comment temp = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)this.countIndex(comment.getColumn())), rowNum, (short)this.countIndex(comment.getColumn()) + 2, 5));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
            comments.clear();
        }
    }
}

