/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class BizDataBillEntryImpProgressPlugin
extends AbstractBasePlugIn
implements ProgresssListener {
    private static final String KEY_TOTAL_LABEL = "totallabel";
    private static final String WAIT = "wait";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String FAIL_DETAIL_HYPER = "faildetailhyper";
    private static final String KEY_PANEL_FINISH = "panelfinish";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";
    private static final String KEY_PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String KEY_PANEL_HANDLING = "panelhandling";
    private static final String KEY_TIMELABEL = "timelabel";
    private static final String KEY_TASKID = "taskId";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progress.addProgressListener((ProgresssListener)this);
        Label label = (Label)this.getControl(FAIL_DETAIL_HYPER);
        label.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FAIL_DETAIL_HYPER, KEY_PANEL_FINISH, BTN_CANCEL});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        BizDataBillEntryImpConfig BizDataBillEntryImpConfig2 = this.getCalTaskProgressInfoDTO();
        this.setFormInfo(BizDataBillEntryImpConfig2, null);
    }

    public void afterBindData(EventObject evt) {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            return;
        }
        this.startTask();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SWCStringUtils.equals((String)progressKey, (String)KEY_PROGRESSBARAP)) {
            BizDataBillEntryImpConfig BizDataBillEntryImpConfig2 = this.getCalTaskProgressInfoDTO();
            this.setFormInfo(BizDataBillEntryImpConfig2, progressEvent);
        }
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        switch (itemKey = itemControl.getKey()) {
            case "faildetailhyper": {
                this.downloadErrorLogFile();
                break;
            }
        }
    }

    private void downloadErrorLogFile() {
        BizDataBillEntryImpConfig cfg = this.getCalTaskProgressInfoDTO();
        if (cfg == null || StringUtils.isBlank((String)cfg.getErrorLogFileUrl())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728", (String)"ImportingPlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        this.getView().download(UrlService.getAttachmentFullUrl((String)cfg.getErrorLogFileUrl()));
        this.getView().sendFormAction(this.getView());
    }

    public void beforeClosed(BeforeClosedEvent event) {
        IFormView mainView;
        IFormView parentView = this.getView().getParentView();
        String parentFormId = parentView.getEntityId();
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TASKID);
        if ("hpdi_bizbillimportstart".equals(parentFormId)) {
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
        if ((mainView = this.getView().getMainView()) != null) {
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(mainView, taskId);
        }
        BizDataBillEntryImpConfig cfg = this.getCalTaskProgressInfoDTO();
        if (taskId != null && cfg != null && !cfg.isDealEnd()) {
            HRBackgroundTaskHelper.getInstance().showBaskgroundTask(taskId);
        }
    }

    private void startTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBARAP);
        progressBar.start();
    }

    private BizDataBillEntryImpConfig getCalTaskProgressInfoDTO() {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TASKID);
        ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
        String cfgJson = (String)appCache.get(MessageFormat.format("TaskProgress_{0}", taskId), String.class);
        BizDataBillEntryImpConfig cfg = null;
        if (cfgJson != null) {
            cfg = (BizDataBillEntryImpConfig)SerializationUtils.deSerializeFromBase64((String)cfgJson);
        }
        return cfg;
    }

    private void stopProgress(int fail, ProgressEvent progressEvent) {
        this.setStopProgressFormInfo(fail);
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
    }

    private void setStopProgressFormInfo(int fail) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_PANEL_HANDLING});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, KEY_PANEL_FINISH});
        if (fail > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FAIL_DETAIL_HYPER});
        }
    }

    private void setFormInfo(BizDataBillEntryImpConfig cfg, ProgressEvent progressEvent) {
        int total = 0;
        int resolveRows = 0;
        int waitDealRows = 0;
        int success = 0;
        int fail = 0;
        int deal = 0;
        Date startTime = new Date();
        Date endTime = new Date();
        int percentage = 0;
        if (cfg != null) {
            total = cfg.getTotalRows();
            if (total < (resolveRows = cfg.getResolveRows())) {
                total = resolveRows;
            }
            waitDealRows = cfg.getWaitDealRows();
            fail = cfg.getFailRows();
            deal = cfg.getDealRows();
            success = deal - fail;
            startTime = cfg.getStartTime();
            endTime = cfg.getEndTime();
            percentage = cfg.getProgress();
        }
        Label totalLabel = (Label)this.getControl(KEY_TOTAL_LABEL);
        totalLabel.setText(String.valueOf(total));
        Label resolveTotalLabel = (Label)this.getControl("resolvetotallabel");
        resolveTotalLabel.setText(String.valueOf(resolveRows));
        Label labelWait = (Label)this.getView().getControl(WAIT);
        labelWait.setText(String.valueOf(waitDealRows));
        Label labelSuccess = (Label)this.getView().getControl(SUCCESS);
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl(FAIL);
        labelFail.setText(String.valueOf(fail));
        Label labelTime = (Label)this.getView().getControl(KEY_TIMELABEL);
        startTime = startTime == null ? new Date() : startTime;
        endTime = endTime == null ? new Date() : endTime;
        String consumeTime = SWCDateTimeUtils.getConsumeTime((Date)startTime, (Date)endTime);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u8017\u65f6{0}", (String)"LoadingCalculationPlugin_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), consumeTime);
        labelTime.setText(msg);
        Label labelPercentage = (Label)this.getView().getControl(PROGRESS_NUM_LABEL);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("isTaskEnd"))) {
            labelPercentage.setText("100");
            return;
        }
        labelPercentage.setText(String.valueOf(percentage));
        if (percentage >= 100 && progressEvent != null && cfg != null && cfg.isDealEnd()) {
            this.stopProgress(fail, progressEvent);
        }
        if (progressEvent != null) {
            progressEvent.setProgress(percentage);
        }
    }
}

