/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;

public class BizDataBillEntryImpResolveTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(BizDataBillEntryImpResolveTask.class);
    private final String SWC_HSBP_FORMPLUGIN = "swc-hsbp-formplugin";
    private RequestContext ctx;
    private BizDataBillEntryImpConfig conf;

    public BizDataBillEntryImpResolveTask(RequestContext ctx, BizDataBillEntryImpConfig conf) {
        this.ctx = ctx;
        this.conf = conf;
    }

    @Override
    public Object call() throws Exception {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            this.resolve();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        String url = String.valueOf(this.conf.getParam().get("url"));
        final int headEndHeight = (Integer)this.conf.getParam().get("headEndHeight");
        final int fixHeadHeight = (Integer)this.conf.getParam().get("fixHeadHeight");
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in2 = null;
        try {
            this.conf.setResolveBegin(true);
            in2 = service.getInputStream(url);
            new ExcelReader().read(in2, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() < fixHeadHeight - 1) {
                        return;
                    }
                    if (row.getRowNum() <= headEndHeight) {
                        BizDataBillEntryImpResolveTask.this.conf.getDataHead().add(row.getData());
                    } else {
                        Map data;
                        BizDataBillEntryImpResolveTask.this.conf.setResolveRows(BizDataBillEntryImpResolveTask.this.conf.getResolveRows() + 1);
                        if (BizDataBillEntryImpResolveTask.this.conf.getTotalRows() < BizDataBillEntryImpResolveTask.this.conf.getResolveRows()) {
                            BizDataBillEntryImpResolveTask.this.conf.setTotalRows(BizDataBillEntryImpResolveTask.this.conf.getResolveRows());
                        }
                        if ((data = row.getData()) != null) {
                            data.put(-99, String.valueOf(row.getRowNum() - (headEndHeight + 1)));
                        }
                        BizDataBillEntryImpResolveTask.this.conf.getDataQueues().add(data);
                    }
                    if (BizDataBillEntryImpResolveTask.this.conf.getDataQueues().size() >= 9000) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e);
                        }
                    }
                }

                public void setRowCount(int rowCount) {
                    super.setRowCount(rowCount);
                    BizDataBillEntryImpResolveTask.this.conf.setTotalRows(rowCount - (headEndHeight + 1));
                }
            });
            this.conf.setResolveEnd(true);
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", (String)"DynamicEntryImportStartEdit_14", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            log.error((Throwable)e);
        }
        finally {
            try {
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }
}

