/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.hr.hbp.business.bgtask.CommonBizTask;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpFailedSheetHandler;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpResolveTask;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImportHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BizDataBillEntryImpTask
extends CommonBizTask {
    private static Log log = LogFactory.getLog(BizDataBillEntryImpTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        BizDataBillEntryImpConfig conf = new BizDataBillEntryImpConfig(map);
        conf.setStartTime(new Date());
        conf.setTaskId(this.taskId);
        this.resolve(conf);
        this.importData(conf);
    }

    private void importData(BizDataBillEntryImpConfig conf) {
        try {
            int timeout = 0;
            LinkedBlockingQueue<Map<Integer, String>> dataQueue = conf.getDataQueues();
            while (!(conf.isResolveEnd() && dataQueue.isEmpty() || timeout > 5)) {
                ArrayList<Map<Integer, String>> rowdatas = new ArrayList<Map<Integer, String>>(10);
                Map<Integer, String> rowdata = dataQueue.poll(1L, TimeUnit.SECONDS);
                if (null == rowdata || rowdata.isEmpty()) {
                    log.info("...read...null");
                    ++timeout;
                    this.sleep(5);
                    continue;
                }
                timeout = 0;
                rowdatas.add(rowdata);
                dataQueue.drainTo(rowdatas, 1000);
                conf.setWaitDealRows(dataQueue.size());
                BizDataBillEntryImportHelper.dataImport(conf, rowdatas);
                this.setProgress(conf, false);
            }
            this.writeLog(conf);
            conf.setDealEnd(true);
            this.setProgress(conf, true);
        }
        catch (InterruptedException e) {
            log.error("BizDataBillEntryImpTask.importData error...", (Throwable)e);
        }
    }

    private void setProgress(BizDataBillEntryImpConfig conf, boolean isEnd) {
        int progress = conf.getProgress();
        HRBackgroundTaskHelper.getInstance().feedbackProgress(conf.getTaskId(), progress, "", conf.getParam());
        if (isEnd) {
            conf.setEndTime(new Date());
            HRBackgroundTaskHelper.getInstance().feedbackStatus(conf.getTaskId(), "COMPLETED", "", conf.getParam());
        }
        BizDataBillEntryImportHelper.setProgressToCache(conf);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        this.feedbackProgress(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(BizDataBillEntryImpConfig conf) {
        Map logCache = conf.getHandler().getLogCache();
        if (logCache.isEmpty()) {
            return;
        }
        Map<String, Object> paramMap = conf.getParam();
        InputStream in = null;
        try {
            FileService service = FileServiceFactory.getAttachmentFileService();
            String url = String.valueOf(paramMap.get("url"));
            in = FileImportExtensionFactory.getFileImportExtension().decode(url, service.getInputStream(url));
            new ExcelReader().read(in, (SheetHandler)new BizDataBillEntryImpFailedSheetHandler(conf, service));
        }
        catch (Exception e) {
            log.error("BizDataBillEntryImpTask.writeLog error\uff1a ", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    private XSSFCellStyle setBorderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private CellStyle getWarnTextStyle(XSSFWorkbook workbook) {
        XSSFFont font = workbook.createFont();
        font.setColor((short)10);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
    }

    private void resolve(BizDataBillEntryImpConfig conf) {
        BizDataBillEntryImpResolveTask resolveTask = new BizDataBillEntryImpResolveTask(RequestContext.get(), conf);
        SWCThreadPoolFactory.getCommonImportThreadpool().submit((Callable)resolveTask);
    }
}

