/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.formplugin.web.org.structproject.imp.DefaultStructProjectProcessor;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataBillEntryImportArgs;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryImportExtService;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryGridHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpTplDownLoadTask;
import kd.swc.hsbp.business.export.ListExporter;
import kd.swc.hsbp.business.export.ListTemplateExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.ReflectUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.BeforeWriteTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataBillEntryImpTplDownLoadHelper {
    private static final Log log = LogFactory.getLog(BizDataBillEntryImpTplDownLoadHelper.class);
    private static final String SWC_HSBP_FORMPLUGIN = "swc-hsbp-formplugin";
    private static final String KEY_TASK_PROGRESS = "ImpTplDownload_Task_{0}";
    private static final Integer FIXHEADHEIGHT = 3;
    private static final int IMPORT_MAX_ROWS = 500000;
    private IFormView bizDataBillView;
    private IFormView importStartView;
    private String entryKey;
    private List<IDataPort> dataPortService;
    private ImportConfig importConfig;
    private List<Long> batchDataIds = new ArrayList<Long>(10);
    private Set<String> personNumbers = new HashSet<String>(16);
    private String dataType;
    private SXSSFRow headKeyRow;

    private BizDataBillEntryImpTplDownLoadHelper() {
    }

    public BizDataBillEntryImpTplDownLoadHelper(IFormView bizDataBillView, String entryKey, IFormView importStartView, String dataType) {
        this.bizDataBillView = bizDataBillView;
        this.importStartView = importStartView;
        this.entryKey = entryKey;
        this.dataType = dataType;
        this.dataPortService = this.getDataPortService();
        this.importConfig = this.invokeGetImportConfig();
    }

    public void downloadTemplateAll() {
        this.setImpTplDownloadBegin();
        this.openImpTplDownloadPage();
        BizDataBillEntryImpTplDownLoadTask downLodadTask = new BizDataBillEntryImpTplDownLoadTask(RequestContext.get(), this);
        SWCThreadPoolFactory.getCommonExportThreadpool().submit((Callable)downLodadTask);
    }

    public void openImpTplDownloadPage() {
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setFormId("hpdi_bizbillimptpldownloading");
        importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importShowParameter.setCustomParam("taskId", (Object)this.bizDataBillView.getPageId());
        importShowParameter.setCustomParam("dataType", (Object)this.dataType);
        if (this.importStartView != null) {
            this.importStartView.showForm(importShowParameter);
        } else {
            this.bizDataBillView.showForm(importShowParameter);
        }
    }

    private List<IDataPort> getDataPortService() {
        FormViewPluginProxy service = (FormViewPluginProxy)this.bizDataBillView.getService(FormViewPluginProxy.class);
        ArrayList dataPortPlugins = Lists.newArrayListWithExpectedSize((int)service.getPlugIns().size());
        for (IFormPlugin plugIn : service.getPlugIns()) {
            if (!(plugIn instanceof IDataPort)) continue;
            dataPortPlugins.add((IDataPort)plugIn);
        }
        if (dataPortPlugins.size() <= 0) {
            this.bizDataBillView.showMessage(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u81f3\u5c11\u4e00\u4e2a\u5bfc\u5165\u670d\u52a1\u63d2\u4ef6\u3002", (String)"DynamicEntryImportStartEdit_7", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]));
        }
        return dataPortPlugins;
    }

    private void invokeBeforeDownLoadTemplate(SXSSFWorkbook wb) {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this, wb);
        for (IDataPort plugin : this.dataPortService) {
            plugin.beforeDownLoadTemplate(event);
        }
    }

    private void invokeAfterDownLoadTemplate() {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this);
        for (IDataPort plugin : this.dataPortService) {
            plugin.afterDownLoadTemplate(event);
        }
    }

    private ImportConfig invokeGetImportConfig() {
        OnGetImportConfigEvent event = new OnGetImportConfigEvent((Object)this);
        ImportConfig config = new ImportConfig();
        event.setImportConfig(config);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.onGetImportConfig(event);
        }
        ImportConfig importConfig = event.getImportConfig();
        this.setEntryHeadHeight(importConfig);
        return importConfig;
    }

    private void setEntryHeadHeight(ImportConfig importConfig) {
        if (importConfig.getHeadHeight() > 0) {
            return;
        }
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.bizDataBillView, (String)this.entryKey);
        int height = SWCExportEntryHelper.calcSheetHeadHeight((List)wrapper.getContainers());
        importConfig.setHeadHeight(height);
    }

    public void downloadTemplate() {
        this.startExport(this.bizDataBillView);
        this.invokeAfterDownLoadTemplate();
    }

    private void startExport(IFormView entryView) {
        FormShowParameter showParameter = this.bizDataBillView.getFormShowParameter();
        EntryColumnWrapper wrapper = this.invokeLoadCustomDataSource();
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)entryView.getModel().getEntryEntity(this.entryKey).getDynamicObjectType().getProperties(), (boolean)true);
        this.addIgnoreSet(ignoreSet);
        this.addNotFillInFields(ignoreSet);
        String currencyFillType = (String)showParameter.getCustomParam("currencyFillType");
        if ("2".equals(currencyFillType)) {
            ignoreSet.add("currency");
            ignoreSet.add("currency_name");
        }
        List containersOrg = wrapper.getContainers();
        ArrayList<EntryColumnContainer> containers = new ArrayList<EntryColumnContainer>(10);
        this.addEntryColumnContainer(containersOrg, containers);
        SWCExportEntryHelper.removeIgnoreColumn(containers, (Set)ignoreSet);
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        EntityType entityType = (EntityType)entryView.getModel().getDataEntityType().getAllEntities().get(this.entryKey);
        this.beforeListTemplateExporter(entityType);
        ListTemplateExporter exporter = new ListTemplateExporter(containers, entityType, this.importConfig);
        this.headKeyRow = exporter.getWb().getSheetAt(0).getRow(2);
        int index = SWCExportEntryHelper.calcSheetHeadHeight(containers) + FIXHEADHEIGHT;
        if (this.importConfig.getImportType() == ImportConfig.ImportType.Complete) {
            List<Long> allDataIds = this.getAllDataIds(entryView);
            BizDataBillEntryImpConfig confCache = new BizDataBillEntryImpConfig(null);
            confCache.setTotalRows(1 + allDataIds.size() * 100 / 90);
            confCache.setResolveRows(confCache.getTotalRows());
            confCache.setStartTime(new Date());
            ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
            String taskId = this.bizDataBillView.getPageId();
            List batchDataIdsSplit = Lists.partition(allDataIds, (int)999);
            int dealSize = 0;
            boolean isBreak = false;
            Iterator iterator = batchDataIdsSplit.iterator();
            while (iterator.hasNext()) {
                List batchDataIds;
                this.batchDataIds = batchDataIds = (List)iterator.next();
                dealSize += batchDataIds.size();
                DynamicObjectCollection rows = this.invokeBeforeWriteTemplate();
                if (rows != null && rows.size() >= 1) {
                    if (this.importConfig.getRowCount() + rows.size() > 500000) {
                        isBreak = true;
                        DynamicObjectCollection rows2 = new DynamicObjectCollection();
                        for (int i = 0; i < 500000 - this.importConfig.getRowCount(); ++i) {
                            rows2.add(rows.get(i));
                        }
                        rows = rows2;
                        confCache.setMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5b8c\u6210\uff08\u4ec5\u4e0b\u8f7d\u524d50\u4e07\uff09", (String)"BizDataBillEntryImpTplDownloadingPlugin_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    }
                    this.importConfig.setRowCount(this.importConfig.getRowCount() + rows.size());
                    index = this.exportEntryTemplate(entryView, rows, (ListExporter)exporter, captions, index, this.entryKey);
                }
                confCache.setDealRows(dealSize);
                confCache.setResolveRows(this.importConfig.getRowCount());
                confCache.setWaitDealRows(confCache.getTotalRows() - confCache.getDealRows());
                appCache.put(MessageFormat.format(KEY_TASK_PROGRESS, taskId), (Object)SerializationUtils.serializeToBase64((Object)confCache));
                if (!isBreak) continue;
                break;
            }
        }
        this.afterListTemplateExporter(entryView, exporter);
        this.setImpTplDownloadPercent(95, null);
        this.invokeBeforeDownLoadTemplate(exporter.getWb());
        String url = exporter.flush(entryView.getModel().getDataEntityType(), this.importConfig.getTemplateFileName());
        this.setImpTplDownloadPercent(100, url);
    }

    private void afterListTemplateExporter(IFormView entryView, ListTemplateExporter exporter) {
        LinkedHashMap<String, String[]> constraintMap = new LinkedHashMap<String, String[]>(16);
        Long bizitemgroupId = entryView.getModel().getDataEntity().getLong("bizitemgroup.id");
        ArrayList<Long> bizItemGrpIdList = new ArrayList<Long>(1);
        bizItemGrpIdList.add(bizitemgroupId);
        DynamicObject[] itemGroupList = HPDIServiceUtils.getBizItemGroupById(bizItemGrpIdList);
        if (itemGroupList != null && itemGroupList.length >= 1) {
            ArrayList<Long> bizItemIds = new ArrayList<Long>(10);
            for (DynamicObject item : itemGroupList[0].getDynamicObjectCollection("entryentity")) {
                if (!"C".equals(item.getString("bizitem.status")) || !"1".equals(item.getString("bizitem.enable"))) continue;
                bizItemIds.add(item.getLong("bizitem.id"));
            }
            Set<String> itemNames = this.getBizItemNamesHasPerm(bizItemIds);
            constraintMap.put("bizitem", itemNames.toArray(new String[0]));
        }
        exporter.addConstraintInfo(constraintMap);
    }

    private void addIgnoreSet(Set<String> ignoreSet) {
        String billType = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("billType");
        if ("1".equals(billType)) {
            boolean isCycle;
            ignoreSet.add("relationdata");
            ignoreSet.add("updateexpirydate");
            ignoreSet.add("updateddesc");
            ignoreSet.add("dataapprovestatus");
            ignoreSet.add("approvedesc");
            ignoreSet.add("bizdatastatus");
            ignoreSet.add("errormsg");
            ignoreSet.add("submiterror");
            ignoreSet.add("bizdatacode");
            ignoreSet.add("originalbizdatacode");
            ignoreSet.add("bizitem");
            String matchRule = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("matchrule");
            if ("1".equals(matchRule)) {
                ignoreSet.add("bizdatadim");
                ignoreSet.add("bizdatadim_name");
            }
            if (!(isCycle = ((Boolean)this.bizDataBillView.getFormShowParameter().getCustomParam("isCycle")).booleanValue())) {
                ignoreSet.add("expirydate");
            }
        } else if ("2".equals(billType)) {
            ignoreSet.add("value");
            ignoreSet.add("relationdata");
            ignoreSet.add("currency");
            ignoreSet.add("calfrequency");
            ignoreSet.add("effectivedate");
            ignoreSet.add("expirydate");
            ignoreSet.add("remark");
            ignoreSet.add("dataapprovestatus");
            ignoreSet.add("approvedesc");
            ignoreSet.add("bizdatastatus");
            ignoreSet.add("errormsg");
            ignoreSet.add("submiterror");
            ignoreSet.add("bizdatacode");
            ignoreSet.add("bizitem");
            ignoreSet.add("bizdatadim");
            ignoreSet.add("bizdatadim_name");
        }
        ignoreSet.add("sumcol");
        ignoreSet.add("enttranssalarystatus");
    }

    private List<Long> getAllDataIds(IFormView entryView) {
        if ("1".equals(this.getDataType())) {
            return this.queryEmpposorgrel(entryView);
        }
        return this.getAllBizDataEntIds(entryView);
    }

    private List<Long> getAllBizDataEntIds(IFormView entryView) {
        return BizDataBillEntryGridHelper.getRowIdCore(entryView);
    }

    private List<Long> getAllAdminOrgIds(IFormView entryView) {
        DynamicObject billDy = entryView.getModel().getDataEntity();
        Long adminOrgId = billDy.getLong("adminorg.id");
        boolean includeChild = this.importStartView.getModel().getDataEntity().getBoolean("includechild");
        List<Long> adminOrgIds = new ArrayList<Long>(1);
        adminOrgIds.add(adminOrgId);
        if (includeChild && ((adminOrgIds = this.getSubAdminOrgs(adminOrgId)) == null || adminOrgIds.isEmpty())) {
            return new ArrayList<Long>();
        }
        return adminOrgIds;
    }

    private List<Long> queryEmpposorgrel(IFormView entryView) {
        QFilter commFilter = this.getCommFilter(entryView);
        DynamicObject importStartDy = this.getImportStartView().getModel().getDataEntity();
        String dataType = importStartDy.getString("datatype");
        if ("mainempdata".equals(dataType)) {
            commFilter.and("isprimary", "=", (Object)"1");
        }
        BizDataBillEntryImportArgs args = new BizDataBillEntryImportArgs();
        args.setBizDataBill(this.getBizDataBillView().getModel().getDataEntity());
        BizDataBillEntryImportExtService extService = new BizDataBillEntryImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataBillEntryImportExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin#downTemplate", null);
        args.setEmpFilter(commFilter);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addFilterBeforeGetEmp(args);
            return null;
        });
        commFilter = args.getEmpFilter();
        String selectFields = "id";
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter[] qfilters = new QFilter[]{commFilter};
        String orderBy = "person.number, isprimary desc, enddate desc, startdate desc, number desc";
        DynamicObject[] dys = serviceHelper.query(selectFields, qfilters, orderBy);
        List<Long> dyIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return dyIds;
    }

    private QFilter getCommFilter(IFormView entryView) {
        DynamicObject billDy = this.getBizDataBillView().getModel().getDataEntity();
        QFilter adminOrgPremFilter = this.getAdminOrgPremFilter(entryView);
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"empposorgrel", (String)"47150e89000000ac");
        QFilter qjEndFilter = this.getQJEndFilter(billDy);
        QFilter qjStartFilter = this.getQJStartFilter(billDy);
        QFilter commFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        commFilter.and("datastatus", "=", (Object)"1");
        commFilter.and(QFilter.isNotNull((String)"person.number"));
        if (adminOrgPremFilter != null) {
            commFilter.and(adminOrgPremFilter);
        }
        if (!isSuperUser && empposFilter != null) {
            commFilter.and(empposFilter);
        }
        if (qjEndFilter != null) {
            commFilter.and(qjEndFilter);
        }
        if (qjStartFilter != null) {
            commFilter.and(qjStartFilter);
        }
        return commFilter;
    }

    private QFilter getQJStartFilter(DynamicObject billDy) {
        QFilter qjStartFilter = null;
        Date qjStartdate = billDy.getDate("calperiod.startdate");
        if (qjStartdate != null) {
            qjStartdate = SWCDateTimeUtils.getDayDate((Date)qjStartdate);
            qjStartFilter = new QFilter("enddate", ">=", (Object)qjStartdate);
        }
        return qjStartFilter;
    }

    private QFilter getQJEndFilter(DynamicObject billDy) {
        QFilter qjEndFilter = null;
        Date qjEnddate = billDy.getDate("calperiod.enddate");
        if (qjEnddate != null) {
            qjEnddate = SWCDateTimeUtils.getDayDate((Date)qjEnddate);
            qjEnddate = SWCDateTimeUtils.addDay((Date)qjEnddate, (long)1L);
            qjEndFilter = new QFilter("startdate", "<", (Object)qjEnddate);
        }
        return qjEndFilter;
    }

    private QFilter getAdminOrgPremFilter(IFormView entryView) {
        String adminOrgKey;
        boolean includeHis = BizDataBillEntryHelper.checkEntryPermByAdminorgvid();
        String string = adminOrgKey = includeHis ? "adminorgvid" : "adminorg";
        if (SWCPermissionServiceHelper.isSuperUser()) {
            return this.getSuperUserAdminOrgFilter(entryView, includeHis, adminOrgKey);
        }
        String permEntity = "hpdi_bizdatabillent";
        String permItemId = "47156aff000000ac";
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0NXW1VOPH+QV", (String)permEntity, (String)permItemId, (String)"empposorgrel.".concat(adminOrgKey));
        if (null == adminOrgIds) {
            return this.getSuperUserAdminOrgFilter(entryView, includeHis, adminOrgKey);
        }
        Set<Long> allAdminOrgIds = this.getAllAdminOrgIds(entryView, adminOrgIds, includeHis);
        QFilter adminOrgPremFilter = new QFilter(adminOrgKey, "in", allAdminOrgIds);
        return adminOrgPremFilter;
    }

    private QFilter getSuperUserAdminOrgFilter(IFormView entryView, boolean includeHis, String adminOrgKey) {
        boolean includeChild = this.importStartView.getModel().getDataEntity().getBoolean("includechild");
        DynamicObject billDy = entryView.getModel().getDataEntity();
        Long adminOrgId = billDy.getLong("adminorg.id");
        if (!includeChild) {
            QFilter adminOrgFilter = new QFilter(adminOrgKey, "=", (Object)adminOrgId);
            return adminOrgFilter;
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (rootOrgId == adminOrgId) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("haos_adminorghr");
        DynamicObject adminOrg = helper.queryOne("id, structnumber", (Object)adminOrgId);
        QFilter structFilter = new QFilter("structlongnumber", "like", (Object)("%" + adminOrg.getString("structnumber") + "%"));
        structFilter.and("datastatus", "in", (Object)new String[]{"0", "1", "2"});
        structFilter.and("structproject", "=", (Object)new DefaultStructProjectProcessor().getDefaultFirstStructProjectId());
        if (!includeHis) {
            structFilter.and("iscurrentversion", "=", (Object)"1");
        }
        SWCDataServiceHelper structHelper = new SWCDataServiceHelper(OrgTreeDynEnum.ORG_TEAM_STRUCT.getDynEntity());
        DynamicObject[] adminOrgArr = structHelper.query("orgteamhisid", new QFilter[]{structFilter});
        List adminOrgIds = Arrays.stream(adminOrgArr).map(dy -> dy.getLong("orgteamhisid")).collect(Collectors.toList());
        QFilter adminOrgFilter = new QFilter(adminOrgKey, "in", adminOrgIds);
        return adminOrgFilter;
    }

    private Set<Long> getAllAdminOrgIds(IFormView entryView, Set<Long> permAdminOrgIds, boolean includeHis) {
        HashSet<Long> allAdminOrgIdSet = new HashSet<Long>(16);
        DynamicObject billDy = entryView.getModel().getDataEntity();
        Long adminOrgId = billDy.getLong("adminorg.id");
        if (null == permAdminOrgIds) {
            permAdminOrgIds = new HashSet<Long>(16);
        }
        permAdminOrgIds.add(adminOrgId);
        allAdminOrgIdSet.add(adminOrgId);
        boolean includeChild = this.importStartView.getModel().getDataEntity().getBoolean("includechild");
        if (includeChild) {
            SWCDataServiceHelper orgHelper = new SWCDataServiceHelper("haos_adminorghr");
            DynamicObject adminOrg = orgHelper.queryOne("id, structnumber", (Object)adminOrgId);
            SWCDataServiceHelper helper = new SWCDataServiceHelper(OrgTreeDynEnum.ORG_TEAM_STRUCT.getDynEntity());
            QFilter filter = new QFilter("orgteamhisid", "in", permAdminOrgIds);
            filter.and("datastatus", "in", (Object)new String[]{"0", "1", "2"});
            filter.and("structproject", "=", (Object)new DefaultStructProjectProcessor().getDefaultFirstStructProjectId());
            if (!includeHis) {
                filter.and("iscurrentversion", "=", (Object)"1");
            }
            filter.and("structlongnumber", "like", (Object)("%" + adminOrg.getString("structnumber") + "%"));
            DynamicObject[] adminOrgArr = helper.query("orgteamhisid, structnumber, structlongnumber", new QFilter[]{filter});
            allAdminOrgIdSet.addAll(Arrays.stream(adminOrgArr).map(dy -> dy.getLong("orgteamhisid")).collect(Collectors.toList()));
        }
        return allAdminOrgIdSet;
    }

    private List<Long> getSubAdminOrgs(Long adminOrgId) {
        List adminOrgIds = null;
        if (adminOrgId == null) {
            return adminOrgIds;
        }
        List batchGetAllSubOrgList = AdminOrgHelper.getAllSubAdminOrg((Long)adminOrgId);
        if (batchGetAllSubOrgList != null) {
            adminOrgIds = batchGetAllSubOrgList.stream().map(batchGetAllSubOrgMap -> Long.valueOf(String.valueOf(batchGetAllSubOrgMap.get("orgId")))).collect(Collectors.toList());
        }
        return adminOrgIds;
    }

    private String setImpTplDownloadBegin() {
        BizDataBillEntryImpConfig confCache = new BizDataBillEntryImpConfig(null);
        confCache.setTotalRows(1000000);
        confCache.setResolveRows(0);
        confCache.setWaitDealRows(1000000);
        confCache.setDealRows(0);
        confCache.setFailRows(0);
        confCache.setStartTime(new Date());
        confCache.setDealEnd(false);
        ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
        String taskId = this.bizDataBillView.getPageId();
        appCache.put(MessageFormat.format(KEY_TASK_PROGRESS, taskId), (Object)SerializationUtils.serializeToBase64((Object)confCache));
        return taskId;
    }

    private void setImpTplDownloadPercent(int percent, String url) {
        ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
        String taskId = this.bizDataBillView.getPageId();
        String cfgJson = (String)appCache.get(MessageFormat.format(KEY_TASK_PROGRESS, taskId), String.class);
        if (cfgJson != null) {
            BizDataBillEntryImpConfig cfg = (BizDataBillEntryImpConfig)SerializationUtils.deSerializeFromBase64((String)cfgJson);
            cfg.setDealRows(cfg.getTotalRows() * percent / 100);
            if (percent >= 100) {
                cfg.setDealEnd(true);
                cfg.setErrorLogFileUrl(url);
                cfg.setEndTime(new Date());
            }
            appCache.put(MessageFormat.format(KEY_TASK_PROGRESS, taskId), (Object)SerializationUtils.serializeToBase64((Object)cfg));
        }
    }

    private EntryColumnWrapper invokeLoadCustomDataSource() {
        LoadCustomEntryMetasEvent event = new LoadCustomEntryMetasEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.loadCustomEntryMetas(event);
        }
        return event.getEntryColumnWrapper();
    }

    private DynamicObjectCollection invokeBeforeWriteTemplate() {
        BeforeWriteTemplateEvent event = new BeforeWriteTemplateEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.beforeWriteTemplate(event);
        }
        return event.getDynamicObjectCollection();
    }

    private void addNotFillInFields(Set<String> ignoreSet) {
        String notFillInFieldStr = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("notFillInFieldSet");
        if (notFillInFieldStr == null) {
            return;
        }
        Set notFillInFields = (Set)SerializationUtils.deSerializeFromBase64((String)notFillInFieldStr);
        if (CollectionUtils.isNotEmpty((Collection)notFillInFields)) {
            ignoreSet.addAll(notFillInFields);
            Set<String> bdPropKeySet = this.getEntryBasedataPropKeys();
            for (String notFillInField : notFillInFields) {
                if (!bdPropKeySet.contains(notFillInField)) continue;
                ignoreSet.add(notFillInField + "_name");
            }
        }
    }

    private Set<String> getEntryBasedataPropKeys() {
        String entryEntityPropMapStr = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("entryEntityPropMap");
        Map entryEntityPropMap = (Map)SerializationUtils.deSerializeFromBase64((String)entryEntityPropMapStr);
        HashSet<String> excludeBDPropKeySet = new HashSet<String>(16);
        excludeBDPropKeySet.add("person");
        HashSet<String> bdPropKeySet = new HashSet<String>(16);
        for (Map propMap : entryEntityPropMap.values()) {
            String type = String.valueOf(propMap.get("type"));
            if (!"BasedataProp".equals(type) || excludeBDPropKeySet.contains(propMap.get("pkey"))) continue;
            bdPropKeySet.add(String.valueOf(propMap.get("pkey")));
        }
        return bdPropKeySet;
    }

    private Set<String> getBizItemNamesHasPerm(List<Long> bizItemIds) {
        DynamicObject[] bizItemArr;
        HashSet<String> bizItemNames = new HashSet<String>(16);
        QFilter filter = new QFilter("id", "in", bizItemIds);
        Object value = this.getBizDataBillView().getFormShowParameter().getCustomParam("orgId");
        Long orgId = null == value ? null : Long.valueOf(Long.parseLong(value.toString()));
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
        SWCDataServiceHelper bizItemHepler = new SWCDataServiceHelper("hsbs_bizitem");
        for (DynamicObject bizItem : bizItemArr = bizItemHepler.query("id, name", new QFilter[]{filter, useOrgFilter}, "name")) {
            bizItemNames.add(bizItem.getString("name"));
        }
        return bizItemNames;
    }

    private void addEntryColumnContainer(List<EntryColumnContainer> containersOrg, List<EntryColumnContainer> containers) {
        Set<String> bdPropKeySet = this.getEntryBasedataPropKeys();
        String number = ResManager.loadKDString((String)".\u7f16\u7801", (String)"BizDataBillEntryImportStartEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)".\u540d\u79f0", (String)"BizDataBillEntryImportStartEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        for (EntryColumnContainer container : containersOrg) {
            String oldName = container.getHeader().getLocaleValue();
            containers.add(container);
            container.setTextAlign("left");
            if (!bdPropKeySet.contains(container.getKey())) continue;
            container.setHeader(new LocaleString(oldName + number));
            EntryColumnContainer numberContainer = new EntryColumnContainer();
            numberContainer.setKey(container.getKey() + "_name");
            numberContainer.setHeader(new LocaleString(oldName + name));
            if ("bizitem".equals(container.getKey())) {
                numberContainer.setHeader(new LocaleString(oldName));
            }
            numberContainer.setType(container.getType());
            numberContainer.setVisible(container.isVisible());
            numberContainer.setTextAlign(container.getTextAlign());
            containers.add(numberContainer);
        }
    }

    private void beforeListTemplateExporter(EntityType entityType) {
        String matchRule;
        String billType = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("billType");
        if ("2".equals(billType)) {
            ReflectUtils.setFieldValue((String)"mustInput", (Object)entityType.getProperty("updateexpirydate"), (Object)Boolean.TRUE);
        }
        if ("2".equals(matchRule = (String)this.bizDataBillView.getFormShowParameter().getCustomParam("matchrule"))) {
            ReflectUtils.setFieldValue((String)"mustInput", (Object)entityType.getProperty("bizdatadim"), (Object)Boolean.TRUE);
        }
    }

    private int exportEntryTemplate(IFormView entryView, DynamicObjectCollection rows, ListExporter exporter, Map<String, KeyValue> captions, int excelRowIndex, String entryKey) {
        IDataModel model = entryView.getModel();
        EntityType entityType = (EntityType)entryView.getModel().getDataEntityType().getAllEntities().get(entryKey);
        ArrayList<Object> rowdata = new ArrayList<Object>(captions.size());
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            for (String filedName : captions.keySet()) {
                DateFormat dateFormat;
                Object value;
                String disProp = "number";
                if (filedName.endsWith("_name")) {
                    disProp = "name";
                    filedName = filedName.replace("_name", "");
                }
                if ("person".equals(filedName)) {
                    disProp = "name";
                }
                IDataEntityProperty prop = model.getProperty(filedName);
                Object val = null;
                if (prop instanceof BooleanProp) {
                    val = Boolean.TRUE.equals(prop.getValue((Object)row)) ? ResManager.loadKDString((String)"\u662f", (String)"DynamicEntryImportStartEdit_4", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicEntryImportStartEdit_5", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]);
                } else if (prop instanceof MulBasedataProp) {
                    value = (DynamicObjectCollection)prop.getValue((Object)row);
                    BasedataProp refBaseProp = (BasedataProp)((MulBasedataProp)prop).getRefBaseProp();
                    ArrayList<String> valStrs = new ArrayList<String>(value.size());
                    for (int j = 0; j < value.size(); ++j) {
                        DynamicObject baseDataObj = ((DynamicObject)value.get(j)).getDynamicObject((IDataEntityProperty)refBaseProp);
                        String displayValue = refBaseProp.getDisplayValue((Object)baseDataObj);
                        valStrs.add(j, displayValue);
                    }
                    val = String.join((CharSequence)";", valStrs);
                } else if (prop instanceof DecimalProp) {
                    val = prop.getValue((Object)row);
                    if (null != val) {
                        NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                        val = number.toString();
                    }
                } else if (prop instanceof BasedataProp) {
                    DynamicObject dy = (DynamicObject)prop.getValue((Object)row);
                    if (dy != null) {
                        val = dy.get(disProp);
                    }
                } else if (prop instanceof DateProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateProp)prop).getDateFormat();
                        String mask = ((DateProp)prop).getMask();
                        if (mask != null) {
                            dateFormat = new SimpleDateFormat(mask);
                        }
                        dateFormat.setTimeZone(((DateProp)prop).getTimeZone(null).getTimeZone());
                        val = dateFormat.format((Date)value);
                    }
                } else if (prop instanceof DateTimeProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateTimeProp)prop).getDateFormat();
                        dateFormat.setTimeZone(((DateTimeProp)prop).getTimeZone(null).getTimeZone());
                        val = dateFormat.format((Date)value);
                    }
                } else if (prop instanceof ComboProp) {
                    val = prop.getValue((Object)row);
                    List valueMapItems = ((ComboProp)entityType.getProperty(filedName)).getComboItems();
                    for (ValueMapItem item : valueMapItems) {
                        if (!item.getValue().equals(val)) continue;
                        val = item.getName().getLocaleValue();
                        break;
                    }
                } else if (prop != null) {
                    val = prop.getValue((Object)row);
                }
                rowdata.add(val);
            }
            exporter.writeLine(rowdata, excelRowIndex++);
            rowdata.clear();
        }
        return excelRowIndex;
    }

    public IFormView getBizDataBillView() {
        return this.bizDataBillView;
    }

    public void setBizDataBillView(IFormView bizDataBillView) {
        this.bizDataBillView = bizDataBillView;
    }

    public IFormView getImportStartView() {
        return this.importStartView;
    }

    public void setImportStartView(IFormView importStartView) {
        this.importStartView = importStartView;
    }

    public List<Long> getBatchDataIds() {
        return this.batchDataIds;
    }

    public void setBatchDataIds(List<Long> batchDataIds) {
        this.batchDataIds = batchDataIds;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public SXSSFRow getHeadKeyRow() {
        return this.headKeyRow;
    }

    public void setHeadKeyRow(SXSSFRow headKeyRow) {
        this.headKeyRow = headKeyRow;
    }

    public Set<String> getPersonNumbers() {
        return this.personNumbers;
    }

    public void setPersonNumbers(Set<String> personNumbers) {
        this.personNumbers = personNumbers;
    }
}

