/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpTplDownLoadHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class BizDataBillEntryImpTplDownLoadTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(BizDataBillEntryImpTplDownLoadTask.class);
    private RequestContext ctx;
    private BizDataBillEntryImpTplDownLoadHelper tplDownLoadHelper;
    private static final String KEY_TASK_PROGRESS = "ImpTplDownload_Task_{0}";

    public BizDataBillEntryImpTplDownLoadTask(RequestContext ctx, BizDataBillEntryImpTplDownLoadHelper tplDownLoadHelper) {
        this.ctx = ctx;
        this.tplDownLoadHelper = tplDownLoadHelper;
    }

    @Override
    public Object call() throws Exception {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            this.downloadTemplate();
        }
        catch (Exception e) {
            this.setImpTplDownloadStop();
            log.error("BizDataBillEntryImpTplDownLoadTask..call..error...", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
        return null;
    }

    private void downloadTemplate() {
        this.tplDownLoadHelper.downloadTemplate();
    }

    private void setImpTplDownloadStop() {
        ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
        String taskId = this.tplDownLoadHelper.getBizDataBillView().getPageId();
        String cfgJson = (String)appCache.get(MessageFormat.format(KEY_TASK_PROGRESS, taskId), String.class);
        if (cfgJson != null) {
            BizDataBillEntryImpConfig cfg = (BizDataBillEntryImpConfig)SerializationUtils.deSerializeFromBase64((String)cfgJson);
            cfg.setMessage("error");
            cfg.setEndTime(new Date());
            appCache.put(MessageFormat.format(KEY_TASK_PROGRESS, taskId), (Object)SerializationUtils.serializeToBase64((Object)cfg));
        }
    }
}

