/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataBillEntryImportArgs;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryImportExtService;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpConfig;
import kd.swc.hsbp.business.imports.DynamicEntryImportConvertHelper;
import kd.swc.hsbp.business.imports.ImportEntRowEntity;
import kd.swc.hsbp.business.imports.converter.DecimalConverter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BizDataBillEntryImportHelper {
    public static final String KEY_START_DATE = "startdate";
    public static final String KEY_SYS_END_DATE = "enddate";
    private static final Log LOGGER = LogFactory.getLog(BizDataBillEntryImportHelper.class);
    private static final String SUFFIX_NAME = "_name";
    private static final int BATCH_SIZE = 1000;
    private static final String KEY_HANDLER = "handler";
    private static final String KEY_TOTALROWNUM = "totalRowNum";
    private static final String KEY_MODEL = "model";
    private static final String KEY_COLIDMAP = "colIdMap";
    private static final String KEY_COLKEYINDEXMAP = "colKeyIndexMap";
    private static final String KEY_BIZDATABILLID = "bizDataBillId";
    private static final String KEY_BIZDATAENTEXCELLIST = "bizDataEntList";
    private static final String KEY_IMPCONFIG = "BizDataBillEntryImpConfig";
    private static final String KEY_BIZITEMGROUPITEMS = "bizItemGroupItems";
    private static final String KEY_OBJRULEMATCHEMPINFO = "objRuleMatchEmpInfo";
    private static final String KEY_MATCHDATETYPE = "matchDateType";
    private static final String KEY_MATCHMODE = "matchMode";
    private static final String KEY_CURRENCYFILLTYPE = "currencyFillType";
    private static final String KEY_SYSFILLCURRENCYID = "sysFillCurrencyId";

    public static FormShowParameter showProgressForm(IFormView view, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hpdi_bizbillimporting");
        showParameter.setCustomParams(customParams);
        view.showForm(showParameter);
        return showParameter;
    }

    public static void dataImport(BizDataBillEntryImpConfig conf, List<Map<Integer, String>> dataRow) {
        Long bizDataBillId;
        Map<Integer, String> errorMap;
        Map<Integer, String> colIdMap = conf.getDataHead().get(0);
        if (colIdMap.values().contains("bizitem_name")) {
            colIdMap.put(colIdMap.size(), "bizitem");
        }
        HashMap<String, Integer> colKeyIndexMap = new HashMap<String, Integer>();
        colIdMap.forEach((key, value) -> colKeyIndexMap.put((String)value, (Integer)key));
        if (colIdMap.values().contains("bizitem_name")) {
            conf.getDataHead().get(1).put((Integer)colKeyIndexMap.get("bizitem"), conf.getDataHead().get(1).get(colKeyIndexMap.get("bizitem_name")));
        }
        if (MapUtils.isNotEmpty(errorMap = BizDataBillEntryImportHelper.invokeAfterReadData(colKeyIndexMap, dataRow, bizDataBillId = (Long)conf.getParam().get(KEY_BIZDATABILLID)))) {
            List failDataRow = dataRow.stream().filter(row -> errorMap.containsKey(Integer.parseInt((String)row.get(-99)))).collect(Collectors.toList());
            dataRow.removeAll(failDataRow);
            conf.setDealRows(conf.getDealRows() + failDataRow.size());
            ProgressHandler handler = conf.getHandler();
            errorMap.entrySet().forEach(entry -> handler.putRowError((Integer)entry.getKey(), (String)entry.getValue()));
            if (CollectionUtils.isEmpty(dataRow)) {
                conf.setFailRows(handler.getLogCache().size());
                return;
            }
        }
        List<ImportEntRowEntity> dataRows = BizDataBillEntryImportHelper.transformDataRow(conf, dataRow);
        DynamicObject bizItemGroup = BizDataBillEntryImportHelper.queryBizItemGroup(conf.getParam().get("bizItemGroupId"));
        Map<String, DynamicObject> bizItemGroupItems = BizDataBillEntryImportHelper.getBizItemGroupItems(bizItemGroup);
        Map<String, Object> matchEmpMap = BizDataBillEntryImportHelper.getObjRuleMatchMode(bizItemGroup);
        List subList = Lists.partition(dataRows, (int)1000);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put(KEY_COLIDMAP, colIdMap);
        param.put(KEY_COLKEYINDEXMAP, colKeyIndexMap);
        param.put(KEY_IMPCONFIG, conf);
        param.put(KEY_BIZITEMGROUPITEMS, bizItemGroupItems);
        param.put(KEY_OBJRULEMATCHEMPINFO, matchEmpMap);
        param.put(KEY_CURRENCYFILLTYPE, bizItemGroup.getString("currencyfilltype"));
        param.put(KEY_SYSFILLCURRENCYID, bizItemGroup.getDynamicObject("sysfillcurrency"));
        for (int i = 0; i < subList.size(); ++i) {
            List bizDataEntList = (List)subList.get(i);
            param.put(KEY_BIZDATAENTEXCELLIST, bizDataEntList);
            BizDataBillEntryImportHelper.dataImportOneBatch(param);
        }
    }

    private static List<ImportEntRowEntity> transformDataRow(BizDataBillEntryImpConfig conf, List<Map<Integer, String>> dataRow) {
        ArrayList<ImportEntRowEntity> dataRows = new ArrayList<ImportEntRowEntity>(10);
        Map<Integer, String> colIdMap = conf.getDataHead().get(0);
        Map<Integer, String> colNameMap = conf.getDataHead().get(1);
        HashMap colKeyIndexMap = new HashMap();
        colIdMap.forEach((key, value) -> colKeyIndexMap.put(value, key));
        for (int i = 0; i < dataRow.size(); ++i) {
            Map<Integer, String> data = dataRow.get(i);
            ImportEntRowEntity entity = new ImportEntRowEntity(Integer.parseInt(data.get(-99)), data);
            entity.setColIdMap(colIdMap);
            entity.setColNameMap(colNameMap);
            entity.setColKeyIndexMap(colKeyIndexMap);
            dataRows.add(entity);
        }
        return dataRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dataImportOneBatch(Map<String, Object> param) {
        BizDataBillEntryImpConfig conf = (BizDataBillEntryImpConfig)param.get(KEY_IMPCONFIG);
        ProgressHandler handler = conf.getHandler();
        Map<String, Object> paramMap = conf.getParam();
        Long bizDataBillId = (Long)paramMap.get(KEY_BIZDATABILLID);
        List bizDataEntList = (List)param.get(KEY_BIZDATAENTEXCELLIST);
        try (TXHandle txHandle = TX.requiresNew();){
            long currTime = System.currentTimeMillis();
            LOGGER.info("BizDataBillEntryImportHelper.dataImportOneBatch...1...{}", (Object)currTime);
            List<ImportEntRowEntity> bizDataEntDyList = BizDataBillEntryImportHelper.convertToEntDyList(param);
            BizDataBillEntryImportHelper.executeOp("save_validate", bizDataEntDyList, handler);
            LOGGER.info("BizDataBillEntryImportHelper.dataImportOneBatch...3...{}", (Object)currTime);
            bizDataEntDyList = BizDataBillEntryImportHelper.filterRightRows(bizDataEntDyList, handler);
            BizDataBillEntryImportHelper.executeOp("save", bizDataEntDyList, handler);
            LOGGER.info("BizDataBillEntryImportHelper.dataImportOneBatch...5...{}", (Object)currTime);
            BizDataBillEntryImportHelper.afterSave(bizDataBillId);
            LOGGER.info("BizDataBillEntryImportHelper.dataImportOneBatch...6...{}", (Object)currTime);
            int failed = handler.getLogCache().size();
            conf.setFailRows(failed);
            conf.setDealRows(conf.getDealRows() + bizDataEntList.size());
            txHandle.commit();
        }
    }

    private static void afterSave(Long bizDataBillId) {
        BizDataHelper.refreshBillDataCount((Long)bizDataBillId);
    }

    public static void executeOp(String opName, List<ImportEntRowEntity> bizDataEntDyList, ProgressHandler handler) {
        if (bizDataEntDyList == null || bizDataEntDyList.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> waitDys = new ArrayList<DynamicObject>(10);
        HashMap<Long, ImportEntRowEntity> bizDataEntMap = new HashMap<Long, ImportEntRowEntity>(16);
        BizDataBillEntryImportHelper.setBizDataEntDyId(bizDataEntDyList, waitDys, bizDataEntMap);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("OPERATE_SRC", "import");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation(opName, waitDys.toArray(new DynamicObject[0]), operateOption);
        BizDataBillEntryImportHelper.dealOperationResult(opName, bizDataEntMap, operationResult, handler);
    }

    private static void setBizDataEntDyId(List<ImportEntRowEntity> bizDataEntDyList, List<DynamicObject> waitDys, Map<Long, ImportEntRowEntity> bizDataEntMap) {
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("hpdi_bizdatabillent", bizDataEntDyList.size());
        for (int i = 0; i < bizDataEntDyList.size(); ++i) {
            ImportEntRowEntity rowEntity = bizDataEntDyList.get(i);
            DynamicObject dy = rowEntity.getDyObj();
            if (dy.getLong("id") == 0L) {
                dy.set("id", (Object)ids[i]);
            }
            waitDys.add(dy);
            bizDataEntMap.put(dy.getLong("id"), rowEntity);
        }
    }

    private static void dealOperationResult(String opName, Map<Long, ImportEntRowEntity> bizDataEntMap, OperationResult operationResult, ProgressHandler handler) {
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                ImportEntRowEntity importRow = bizDataEntMap.get(Long.parseLong(String.valueOf(operateInfo.getPkValue())));
                handler.putRowError(Integer.valueOf(importRow.getRowIndex()), operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && StringUtils.isNotEmpty((CharSequence)msg)) {
                for (ImportEntRowEntity rowEntity : bizDataEntMap.values()) {
                    handler.putRowError(Integer.valueOf(rowEntity.getRowIndex()), operationResult.getMessage());
                }
            }
        }
    }

    private static List<ImportEntRowEntity> convertToEntDyList(Map<String, Object> param) {
        BizDataBillEntryImpConfig conf = (BizDataBillEntryImpConfig)param.get(KEY_IMPCONFIG);
        ProgressHandler handler = conf.getHandler();
        Map<String, Object> paramMap = conf.getParam();
        Long bizDataBillId = (Long)paramMap.get(KEY_BIZDATABILLID);
        String modelType = (String)paramMap.get("modelType");
        List<ImportEntRowEntity> bizDataEntList = (List<ImportEntRowEntity>)param.get(KEY_BIZDATAENTEXCELLIST);
        Map colIdMap = (Map)param.get(KEY_COLIDMAP);
        Map colKeyIndexMap = (Map)param.get(KEY_COLKEYINDEXMAP);
        Map bizItemGroupItems = (Map)param.get(KEY_BIZITEMGROUPITEMS);
        Map matchConfMap = (Map)param.get(KEY_OBJRULEMATCHEMPINFO);
        String entryEntityPropMapStr = String.valueOf(paramMap.get("entryEntityPropMap"));
        Map entryEntityPropMap = (Map)SerializationUtils.deSerializeFromBase64((String)entryEntityPropMapStr);
        BizDataBillEntryImportHelper.preConvertToEntDyList(bizDataEntList, colKeyIndexMap);
        HashMap permMap = Maps.newHashMap();
        HashMap bdQueryPropMap = Maps.newHashMap();
        HashSet<String> queryAllKeySet = new HashSet<String>();
        queryAllKeySet.add("entadminorg");
        queryAllKeySet.add("entadminorg_name");
        queryAllKeySet.add("job");
        queryAllKeySet.add("job_name");
        queryAllKeySet.add("postype");
        queryAllKeySet.add("postype_name");
        queryAllKeySet.add("position");
        queryAllKeySet.add("position_name");
        Map baseDataMap = DynamicEntryImportConvertHelper.loadBaseDataWithPermission((List)bizDataEntList, (Map)colIdMap, (Map)entryEntityPropMap, (Map)bdQueryPropMap, (Map)permMap, queryAllKeySet);
        bizDataEntList = BizDataBillEntryImportHelper.filterRightRows(bizDataEntList, handler);
        BizDataBillEntryImportHelper.convertToModelValue(bizDataEntList, colKeyIndexMap, baseDataMap, entryEntityPropMap, handler);
        bizDataEntList = BizDataBillEntryImportHelper.filterRightRows(bizDataEntList, handler);
        BizDataBillEntryImportHelper.matchPersonEmpposorgrel(bizDataEntList, handler, matchConfMap);
        bizDataEntList = BizDataBillEntryImportHelper.filterRightRows(bizDataEntList, handler);
        BizDataBillEntryImportHelper.validateBeforeExcelToEntDy(bizDataEntList, modelType, bizItemGroupItems, handler);
        bizDataEntList = BizDataBillEntryImportHelper.filterRightRows(bizDataEntList, handler);
        BizDataBillEntryImportHelper.convertExcelImportMapToEntDy(bizDataEntList, bizDataBillId, modelType, param);
        return bizDataEntList;
    }

    public static Map<String, Map<String, Object>> convertToModelValue(List<ImportEntRowEntity> bizDataEntList, Map<String, Integer> colIdMap, Map<String, Map<String, List<DynamicObject>>> baseDataMap, Map<String, Map<String, Object>> entryEntityPropMap, ProgressHandler handler) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(bizDataEntList)) {
            return map;
        }
        String msgNotUnique = ResManager.loadKDString((String)"{0}\u201c{1}\u201d\u5339\u914d\u5230\u591a\u6761\u6570\u636e\u3002", (String)"BizDataBillEntryImportHelper_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String msgNotMatch = ResManager.loadKDString((String)"{0}\u201c{1}\u201d\u672a\u5339\u914d\u5230\u6570\u636e\u3002", (String)"BizDataBillEntryImportHelper_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String numberFlag = ResManager.loadKDString((String)".\u7f16\u7801", (String)"BizDataBillEntryImportHelper_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String nameFlag = ResManager.loadKDString((String)".\u540d\u79f0", (String)"BizDataBillEntryImportHelper_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String dateFormatMsg = ResManager.loadKDString((String)"{0}\u201c{1}\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a2023/12/31 \u6216\u8005 2023-12-31\u3002", (String)"BizDataBillEntryImportHelper_5", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String personNumber = ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BizDataBillEntryImportHelper_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        Map colNameMap = bizDataEntList.get(0).getColNameMap();
        for (ImportEntRowEntity cellrowEntity : bizDataEntList) {
            Map cellrow = cellrowEntity.getData();
            Map rowData = cellrowEntity.getDataMap();
            for (Map.Entry<String, Integer> keyIndexEntry : colIdMap.entrySet()) {
                List<DynamicObject> datas;
                String propName = keyIndexEntry.getKey();
                Map<String, Object> property = entryEntityPropMap.get(propName);
                if (property == null) continue;
                String type = String.valueOf(property.get("type"));
                Integer colIndex = keyIndexEntry.getValue();
                String cellValue = (String)cellrow.get(colIndex);
                DynamicObject cellObject = cellValue;
                String colName = ((String)colNameMap.get(colIndex)).replace("*", "").replace(numberFlag, "").replace(nameFlag, "");
                if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
                    if ("DecimalProp".equals(type)) {
                        DecimalConverter converter = new DecimalConverter(String.valueOf(property.get("dataScope")), ((Integer)property.get("precision")).intValue(), ((Integer)property.get("scale")).intValue());
                        cellObject = converter.convert((Object)cellValue);
                    }
                    if ("ComboProp".equals(type)) {
                        ValueMapItem valueMapItem = DynamicEntryImportConvertHelper.getComboItemByLocaleValue((String)cellValue, (List)((List)property.get("comboItems")));
                        if (valueMapItem != null) {
                            cellObject = valueMapItem.getValue();
                        } else {
                            cellObject = null;
                            handler.putRowError(Integer.valueOf(cellrowEntity.getRowIndex()), MessageFormat.format(msgNotMatch, colNameMap.get(colIndex), cellValue));
                        }
                    }
                    if ("BasedataProp".equals(type)) {
                        DynamicObject datas2 = baseDataMap.get(propName).get(cellValue);
                        if ("person".equals(propName)) {
                            colName = personNumber;
                        }
                        if (!CollectionUtils.isEmpty(datas2)) {
                            if (datas2.size() == 1) {
                                cellObject = datas2.get(0);
                            } else if (!"person".equals(propName)) {
                                handler.putRowError(Integer.valueOf(cellrowEntity.getRowIndex()), MessageFormat.format(msgNotUnique, colName, cellValue));
                            } else {
                                cellObject = datas2;
                            }
                        } else {
                            handler.putRowError(Integer.valueOf(cellrowEntity.getRowIndex()), MessageFormat.format(msgNotMatch, colName, cellValue));
                        }
                    }
                    if ("DateProp".equals(type)) {
                        try {
                            cellObject = SWCDateTimeUtils.parseDate((String)cellValue, (String)(cellValue.length() == 6 || cellValue.length() == 7 ? "yyyy-MM" : "yyyy-MM-dd"));
                        }
                        catch (ParseException var3) {
                            LOGGER.error("BizDataBillEntryImportHelper.convertToModelValue.parseDateValue error...1...", (Throwable)var3);
                            try {
                                cellObject = SWCDateTimeUtils.parseDate((String)cellValue, (String)(cellValue.length() == 6 || cellValue.length() == 7 ? "yyyy/MM" : "yyyy/MM/dd"));
                            }
                            catch (ParseException var4) {
                                LOGGER.error("BizDataBillEntryImportHelper.convertToModelValue.parseDateValue error...2...", (Throwable)var4);
                                handler.putRowError(Integer.valueOf(cellrowEntity.getRowIndex()), MessageFormat.format(dateFormatMsg, colName, cellValue));
                                cellObject = null;
                            }
                        }
                        if (cellObject != null) {
                            Calendar ca = Calendar.getInstance();
                            ca.setTime((Date)cellObject);
                            if (ca.get(1) > 2999) {
                                cellObject = null;
                                LOGGER.error("BizDataBillEntryImportHelper.convertToModelValue.parseDateValue error...2...{}", (Object)cellValue);
                                handler.putRowError(Integer.valueOf(cellrowEntity.getRowIndex()), MessageFormat.format(dateFormatMsg, colName, cellValue));
                            }
                        }
                    }
                    rowData.putIfAbsent(propName, cellObject);
                    continue;
                }
                if (!"BasedataProp".equals(type) || propName.endsWith(SUFFIX_NAME)) continue;
                Integer nameColIndex = colIdMap.get(propName + SUFFIX_NAME);
                String nameCellValue = (String)cellrow.get(nameColIndex);
                Map<String, List<DynamicObject>> namebdMap = baseDataMap.get(propName + SUFFIX_NAME);
                if (namebdMap == null || CollectionUtils.isEmpty(datas = namebdMap.get(nameCellValue)) || datas.size() != 1) continue;
                cellObject = datas.get(0);
                rowData.putIfAbsent(propName, cellObject);
            }
        }
        return map;
    }

    private static void validateBeforeExcelToEntDy(List<ImportEntRowEntity> bizDataEntList, String modelType, Map<String, DynamicObject> bizItemGroupItems, ProgressHandler handler) {
        ImportEntRowEntity data;
        int i;
        if (CollectionUtils.isEmpty(bizDataEntList)) {
            return;
        }
        Map colIdMap = bizDataEntList.get(0).getColIdMap();
        Map colNameMap = bizDataEntList.get(0).getColNameMap();
        String mustFlag = "*";
        int split = 44;
        String numberFlag = ResManager.loadKDString((String)".\u7f16\u7801", (String)"BizDataBillEntryImportHelper_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        for (i = 0; i < bizDataEntList.size(); ++i) {
            data = bizDataEntList.get(i);
            ArrayList<String> propNameList = new ArrayList<String>(10);
            for (Map.Entry entry : colNameMap.entrySet()) {
                if (!((String)entry.getValue()).startsWith(mustFlag)) continue;
                String propName = ((String)entry.getValue()).replace(mustFlag, "").replace(numberFlag, "");
                Object value = data.getDataMap().get(colIdMap.get(entry.getKey()));
                if (value != null || propNameList.contains(propName)) continue;
                propNameList.add(propName);
            }
            if (propNameList.size() == 0) continue;
            handler.putRowError(Integer.valueOf(data.getRowIndex()), HPDIResMgrBusiness.getMsgOfMustInput((String)String.join((CharSequence)",", propNameList.toArray(new String[0]))));
        }
        if ("2".equals(modelType)) {
            for (i = 0; i < bizDataEntList.size(); ++i) {
                data = bizDataEntList.get(i);
                boolean isHasOneValue = false;
                for (Map.Entry<Object, Object> entry : bizItemGroupItems.entrySet()) {
                    Object value = data.getDataMap().get(entry.getKey());
                    if (value == null) continue;
                    isHasOneValue = true;
                    break;
                }
                if (isHasOneValue) continue;
                handler.putRowError(Integer.valueOf(data.getRowIndex()), HPDIResMgrBusiness.getMsgOfItemNeedHasOneValue());
            }
        }
    }

    private static List<ImportEntRowEntity> filterRightRows(List<ImportEntRowEntity> bizDataEntList, ProgressHandler handler) {
        return bizDataEntList.stream().filter(o1 -> !handler.getLogCache().containsKey(o1.getRowIndex())).collect(Collectors.toList());
    }

    private static void preConvertToEntDyList(List<ImportEntRowEntity> bizDataEntList, Map<String, Integer> colKeyIndexMap) {
        List bizDataCodes = HPDIServiceUtils.getBizDataCodes((String)"Manual", (int)bizDataEntList.size());
        for (int i = 0; i < bizDataEntList.size(); ++i) {
            Integer bizdatacodeIndex;
            ImportEntRowEntity bizDataEntity = bizDataEntList.get(i);
            Map bizDataEnt = bizDataEntity.getData();
            if (colKeyIndexMap.containsKey("person")) {
                int personNumberIndex = colKeyIndexMap.get("person_number");
                int personIndex = colKeyIndexMap.get("person");
                String personNumberVal = (String)bizDataEnt.get(personNumberIndex);
                bizDataEnt.put(personIndex, personNumberVal);
            }
            if ((bizdatacodeIndex = colKeyIndexMap.get("bizdatacode")) != null) {
                bizDataEnt.put(bizdatacodeIndex, bizDataCodes.get(i));
            }
            for (Map.Entry<String, Integer> col : colKeyIndexMap.entrySet()) {
                String nameValue;
                Integer nameIndex;
                String value = (String)bizDataEnt.get(col.getValue());
                if (SWCStringUtils.isEmpty((String)value) || (nameIndex = colKeyIndexMap.get(col.getKey() + SUFFIX_NAME)) == null || !SWCStringUtils.isNotEmpty((String)(nameValue = (String)bizDataEnt.get(nameIndex)))) continue;
                bizDataEnt.put(nameIndex, null);
            }
        }
    }

    private static void matchPersonEmpposorgrel(List<ImportEntRowEntity> bizDataEntList, ProgressHandler handler, Map<String, Object> matchConfMap) {
        Map<String, List<DynamicObject>> personExperiencesMap = BizDataBillEntryImportHelper.getExperiences(bizDataEntList);
        BizDataBillEntryImportHelper.getMatchedPersonExperiences(bizDataEntList, handler, personExperiencesMap, matchConfMap);
    }

    public static void getMatchedPersonExperiences(List<ImportEntRowEntity> bizDataEntList, ProgressHandler handler, Map<String, List<DynamicObject>> personExperiencesMap, Map<String, Object> matchConfMap) {
        String adminOrgKey = BizDataBillEntryHelper.checkEntryPermByAdminorgvid() ? "adminorgvid" : "adminorg";
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47150e89000000ac", (String)"empposorgrel.".concat(adminOrgKey));
        for (ImportEntRowEntity entry : bizDataEntList) {
            Map bizDataBillEntry = entry.getDataMap();
            String personNumber = BizDataBillEntryImportHelper.getBaseDataNumber(bizDataBillEntry, "person");
            String string = personNumber = !SWCStringUtils.isEmpty((String)personNumber) ? personNumber : MapUtils.getString((Map)bizDataBillEntry, (Object)"person_number");
            if (SWCStringUtils.isEmpty((String)personNumber)) {
                handler.putRowError(Integer.valueOf(entry.getRowIndex()), HPDIResMgrBusiness.getMsgOfNotFoundPersonInfo());
                continue;
            }
            String orgNumber = BizDataBillEntryImportHelper.getBaseDataNumber(bizDataBillEntry, "entadminorg");
            String jobNumber = BizDataBillEntryImportHelper.getBaseDataNumber(bizDataBillEntry, "job");
            String isPrimary = bizDataBillEntry.get("isprimary") == null ? null : String.valueOf(bizDataBillEntry.get("isprimary"));
            String posTypeNumber = BizDataBillEntryImportHelper.getBaseDataNumber(bizDataBillEntry, "postype");
            Date startDate = (Date)bizDataBillEntry.get(KEY_START_DATE);
            Date endDate = (Date)bizDataBillEntry.get(KEY_SYS_END_DATE);
            Date bizDate = (Date)bizDataBillEntry.get("bizdate");
            if ("1".equals(MapUtils.getString(matchConfMap, (Object)KEY_MATCHDATETYPE))) {
                bizDate = (Date)bizDataBillEntry.get("effectivedate");
            }
            String positionNumber = BizDataBillEntryImportHelper.getBaseDataNumber(bizDataBillEntry, "position");
            String positionType = bizDataBillEntry.get("positionType") == null ? null : String.valueOf(bizDataBillEntry.get("positionType"));
            List<Object> personExperienceList = new ArrayList(10);
            List<DynamicObject> personExperiencesFromDB = personExperiencesMap.get(personNumber);
            if (personExperiencesFromDB != null) {
                for (DynamicObject personExperience : personExperiencesFromDB) {
                    Date experienceStartDate = personExperience.getDate(KEY_START_DATE);
                    Date experienceEndDate = personExperience.getDate(KEY_SYS_END_DATE);
                    boolean isEqualOrgNumber = SWCStringUtils.isEmpty((String)orgNumber) || SWCStringUtils.equals((String)personExperience.getString("adminorg.number"), (String)orgNumber);
                    boolean isEqualJobNumber = SWCStringUtils.isEmpty((String)jobNumber) || SWCStringUtils.equals((String)personExperience.getString("job.number"), (String)jobNumber);
                    boolean isEqualIsPrimary = SWCStringUtils.isEmpty((String)isPrimary) || SWCStringUtils.equals((String)personExperience.getString("isprimary"), (String)isPrimary);
                    boolean isEqualPosTypeNumber = SWCStringUtils.isEmpty((String)posTypeNumber) || SWCStringUtils.equals((String)personExperience.getString("postype.number"), (String)posTypeNumber);
                    boolean isEqualStartDate = startDate == null || SWCDateTimeUtils.dayEqualsWithoutTime((Date)experienceStartDate, (Date)startDate);
                    boolean isEqualEndDate = endDate == null || SWCDateTimeUtils.dayEqualsWithoutTime((Date)experienceEndDate, (Date)endDate);
                    boolean isEqualPositionNumber = SWCStringUtils.isEmpty((String)positionNumber) || SWCStringUtils.equals((String)personExperience.getString("position.number"), (String)positionNumber);
                    boolean isEqualPositionType = SWCStringUtils.isEmpty((String)positionType) || SWCStringUtils.equals((String)personExperience.getString("apositiontype"), (String)positionType);
                    Date startDateOfExperience = personExperience.getDate(KEY_START_DATE);
                    Date endDateOfExperience = personExperience.getDate(KEY_SYS_END_DATE);
                    Date startDateTmp = startDateOfExperience == null ? SWCDateTimeUtils.addYear((Date)new Date(), (int)100) : SWCDateTimeUtils.getDayDate((Date)startDateOfExperience);
                    Date endDateTmp = endDateOfExperience == null ? SWCDateTimeUtils.addYear((Date)new Date(), (int)100) : SWCDateTimeUtils.getDayDate((Date)endDateOfExperience);
                    boolean isMatchBizDate = true;
                    if (!SWCObjectUtils.isEmpty((Object)bizDate) && (startDateTmp.after(bizDate) || endDateTmp.before(bizDate))) {
                        isMatchBizDate = false;
                    }
                    if (!isEqualOrgNumber || !isEqualJobNumber || !isEqualIsPrimary || !isEqualPosTypeNumber || !isEqualStartDate || !isEqualEndDate || !isEqualPositionNumber || !isEqualPositionType || !isMatchBizDate) continue;
                    personExperienceList.add(personExperience);
                }
            }
            if (personExperienceList.size() == 0) {
                handler.putRowError(Integer.valueOf(entry.getRowIndex()), HPDIResMgrBusiness.getMsgOfNotFoundPersonInfo());
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)adminOrgIds)) {
                personExperienceList = personExperienceList.stream().filter(dy -> adminOrgIds.contains(dy.getLong(adminOrgKey.concat(".id")))).collect(Collectors.toList());
            }
            if (personExperienceList.size() == 0) {
                handler.putRowError(Integer.valueOf(entry.getRowIndex()), HPDIResMgrBusiness.getMsgOfNotFoundPersonInfo());
                continue;
            }
            if (personExperienceList.size() == 1) {
                bizDataBillEntry.put("empposorgrel", personExperienceList.get(0));
                continue;
            }
            if ("1".equals(MapUtils.getString(matchConfMap, (Object)KEY_MATCHMODE))) {
                BizDataBillEntryImportHelper.sortRelDys(personExperienceList);
                bizDataBillEntry.put("empposorgrel", personExperienceList.get(0));
                continue;
            }
            handler.putRowError(Integer.valueOf(entry.getRowIndex()), HPDIResMgrBusiness.getMsgOfFoundMultiplePersonInfo());
        }
    }

    private static void sortRelDys(List<DynamicObject> relDys) {
        Collections.sort(relDys, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                String isprimary1 = o1.getString("isprimary");
                String isprimary2 = o2.getString("isprimary");
                Date enddate1 = o1.getDate(BizDataBillEntryImportHelper.KEY_SYS_END_DATE);
                Date enddate2 = o2.getDate(BizDataBillEntryImportHelper.KEY_SYS_END_DATE);
                Date startdate1 = o1.getDate(BizDataBillEntryImportHelper.KEY_START_DATE);
                Date startdate2 = o2.getDate(BizDataBillEntryImportHelper.KEY_START_DATE);
                String number1 = o1.getString("number");
                String number2 = o2.getString("number");
                if (isprimary1.compareTo(isprimary2) > 0) {
                    return -1;
                }
                if (isprimary1.compareTo(isprimary2) < 0) {
                    return 1;
                }
                if (enddate1.getTime() > enddate2.getTime()) {
                    return -1;
                }
                if (enddate1.getTime() < enddate2.getTime()) {
                    return 1;
                }
                if (startdate1.getTime() > startdate2.getTime()) {
                    return -1;
                }
                if (startdate1.getTime() < startdate2.getTime()) {
                    return 1;
                }
                if (number1.compareTo(number2) > 0) {
                    return -1;
                }
                if (number1.compareTo(number2) < 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private static String getBaseDataNumber(Map<String, Object> bizDataBillEntry, String propName) {
        Object objVal = bizDataBillEntry.get(propName);
        if (objVal instanceof DynamicObject) {
            return ((DynamicObject)objVal).getString("number");
        }
        if (objVal instanceof List) {
            return ((DynamicObject)((List)objVal).get(0)).getString("number");
        }
        return null;
    }

    private static Map<String, List<DynamicObject>> getExperiences(List<ImportEntRowEntity> bizDataEntList) {
        Object[] personExperiencesFromDB;
        try {
            String selectFields = "id,number,employee,startdate,enddate,adminorg,job,isprimary,postype,position,apositiontype,person,adminorgvid";
            QFilter qFilter = BizDataBillEntryImportHelper.getQFilter(bizDataEntList);
            personExperiencesFromDB = HPDIServiceUtils.listFieldsFilterInfo((String)selectFields, (QFilter)qFilter, (String)"hrpi_empposorgrel");
        }
        catch (KDBizException exception) {
            LOGGER.error(MessageFormat.format("PersonExistsFilter-getExperiences listFieldsFilterInfo exception:{0}", new Object[]{exception}));
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
        if (SWCArrayUtils.isEmpty((Object[])personExperiencesFromDB)) {
            return new HashMap<String, List<DynamicObject>>(1);
        }
        Map<String, List<DynamicObject>> personExperiencesMap = Arrays.stream(personExperiencesFromDB).collect(Collectors.groupingBy(personExperience -> personExperience.getString("employee.empnumber")));
        return personExperiencesMap;
    }

    public static QFilter getQFilter(List<ImportEntRowEntity> bizDataEntList) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        int size = bizDataEntList.size();
        HashSet<String> personNumbers = new HashSet<String>(size);
        for (ImportEntRowEntity rowData : bizDataEntList) {
            String personNumber;
            if (rowData.getDataMap().containsKey("person")) {
                Object person = rowData.getDataMap().get("person");
                if (person instanceof DynamicObject) {
                    personNumber = ((DynamicObject)person).getString("number");
                    personNumbers.add(personNumber);
                    continue;
                }
                if (!(person instanceof List)) continue;
                personNumber = ((DynamicObject)((List)person).get(0)).getString("number");
                personNumbers.add(personNumber);
                continue;
            }
            personNumber = (String)rowData.getDataMap().get("person_number");
            personNumbers.add(personNumber);
        }
        if (CollectionUtils.isEmpty(personNumbers)) {
            qFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        } else {
            qFilter.and("employee.empnumber", "in", personNumbers);
        }
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"empposorgrel", (String)"47150e89000000ac");
        if (!isSuperUser && empposFilter != null) {
            qFilter.and(empposFilter);
        }
        return qFilter;
    }

    private static List<DynamicObject> convertExcelImportMapToEntDy(List<ImportEntRowEntity> bizDataEntList, Long bizDataBillId, String modelType, Map<String, Object> param) {
        List bizDataCodes = HPDIServiceUtils.getBizDataCodes((String)"Manual", (int)bizDataEntList.size());
        ArrayList<DynamicObject> bizDataEntDyList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < bizDataEntList.size(); ++i) {
            ImportEntRowEntity dataOne = bizDataEntList.get(i);
            DynamicObject entDy = BizDataBillEntryImportHelper.convertExcelImportMapToEntDyOne(dataOne, bizDataBillId, modelType, param);
            if (StringUtils.isEmpty((CharSequence)entDy.getString("bizdatacode"))) {
                entDy.set("bizdatacode", bizDataCodes.get(i));
            }
            dataOne.setDyObj(entDy);
            bizDataEntDyList.add(entDy);
        }
        return bizDataEntDyList;
    }

    public static DynamicObject convertExcelImportMapToEntDyOne(ImportEntRowEntity data, Long bizDataBillId, String modelType, Map<String, Object> param) {
        Map<String, String> fieldRlsMap = BizDataBillEntryImportHelper.getFieldRelationMap();
        DynamicObject entry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyDynamicObject();
        for (Map.Entry<String, String> fieldRls : fieldRlsMap.entrySet()) {
            String vkey = fieldRls.getKey();
            Object value = data.getDataMap().get(vkey);
            entry.set(fieldRls.getValue(), value);
        }
        entry.set("bizdatabillid", (Object)bizDataBillId);
        BizDataBillEntryImportHelper.dealDetail(entry, data, modelType, param);
        return entry;
    }

    public static void dealDetail(DynamicObject entry, ImportEntRowEntity data, String modelType, Map<String, Object> param) {
        Map bizItemGroupItems = (Map)param.get(KEY_BIZITEMGROUPITEMS);
        String currencyFillType = MapUtils.getString(param, (Object)KEY_CURRENCYFILLTYPE);
        DynamicObject sysFillCurrency = (DynamicObject)param.get(KEY_SYSFILLCURRENCYID);
        boolean fillAmountItem = false;
        Map<String, String> detailFieldRlsMap = BizDataBillEntryImportHelper.getDetailFieldRelationMap();
        DynamicObjectCollection bizDataDetails = entry.getDynamicObjectCollection("entryentity");
        DynamicObject bizItemDetail = null;
        if ("2".equals(modelType)) {
            detailFieldRlsMap.remove("bizitem");
            detailFieldRlsMap.remove("value");
            for (Map.Entry bizItem : bizItemGroupItems.entrySet()) {
                Object value = data.getDataMap().get(bizItem.getKey());
                if (value == null) continue;
                bizItemDetail = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject(entry, "entryentity");
                bizItemDetail.set("bizitem", bizItem.getValue());
                bizItemDetail.set("value", value);
                if (value instanceof Date) {
                    bizItemDetail.set("value", (Object)SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd"));
                }
                for (Map.Entry<String, String> fieldRls : detailFieldRlsMap.entrySet()) {
                    bizItemDetail.set(fieldRls.getValue(), data.getDataMap().get(fieldRls.getKey()));
                }
                bizDataDetails.add((Object)bizItemDetail);
                if (1020L != bizItemDetail.getLong("bizitem.datatype.id")) continue;
                fillAmountItem = true;
            }
        } else {
            bizItemDetail = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.generateEmptyEntryDynamicObject(entry, "entryentity");
            for (Map.Entry<String, String> fieldRls : detailFieldRlsMap.entrySet()) {
                bizItemDetail.set(fieldRls.getValue(), data.getDataMap().get(fieldRls.getKey()));
                if (1020L != bizItemDetail.getLong("bizitem.datatype.id")) continue;
                fillAmountItem = true;
            }
            bizDataDetails.add((Object)bizItemDetail);
        }
        if (fillAmountItem && "2".equals(currencyFillType)) {
            entry.set("currency", (Object)sysFillCurrency);
        }
    }

    private static Map<String, String> getDetailFieldRelationMap() {
        HashMap<String, String> detailFieldRlsMap = new HashMap<String, String>(16);
        detailFieldRlsMap.put("bizitem", "bizitem");
        detailFieldRlsMap.put("value", "value");
        detailFieldRlsMap.put("effectivedate", "effectivedate");
        detailFieldRlsMap.put("expirydate", "expirydate");
        return detailFieldRlsMap;
    }

    private static Map<String, String> getFieldRelationMap() {
        HashMap<String, String> fieldRlsMap = new HashMap<String, String>(16);
        fieldRlsMap.put("effectivedate", "effectivedateent");
        fieldRlsMap.put("expirydate", "expirydateent");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdatabillent");
        List fields = SWCHisBaseDataHelper.getFields((MainEntityType)mainEntityType);
        for (String field : fields) {
            if (fieldRlsMap.values().contains(field)) continue;
            fieldRlsMap.put(field, field);
        }
        return fieldRlsMap;
    }

    public static Map<String, Map<String, Object>> getEntryEntityProp(IDataModel dataModel) {
        HashMap<String, Map<String, Object>> entryEntityPropMap = new HashMap<String, Map<String, Object>>(16);
        DataEntityPropertyCollection props = ((EntryProp)dataModel.getProperty("entryentity")).getItemType().getProperties();
        for (IDataEntityProperty property : props) {
            String pkey = property.getName();
            HashMap<String, Object> propMap = (HashMap<String, Object>)entryEntityPropMap.get(pkey);
            if (propMap == null) {
                propMap = new HashMap<String, Object>(16);
                propMap.put("pkey", pkey);
                entryEntityPropMap.put(pkey, propMap);
            }
            if (property instanceof BasedataProp) {
                BasedataProp bd = (BasedataProp)property;
                propMap.put("type", "BasedataProp");
                propMap.put("baseEntityId", bd.getBaseEntityId());
                propMap.put("displayProp", "number");
                HashMap<String, String> bdNameMap = new HashMap<String, String>(16);
                bdNameMap.put("type", "BasedataProp");
                bdNameMap.put("baseEntityId", bd.getBaseEntityId());
                bdNameMap.put("displayProp", "name");
                String namekey = pkey + SUFFIX_NAME;
                entryEntityPropMap.put(namekey, bdNameMap);
            }
            if (property instanceof DecimalProp) {
                DecimalProp decimalProp = (DecimalProp)property;
                propMap.put("type", "DecimalProp");
                propMap.put("dataScope", decimalProp.getDataScope());
                propMap.put("precision", decimalProp.getPrecision());
                propMap.put("scale", decimalProp.getScale());
            }
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                propMap.put("type", "ComboProp");
                propMap.put("comboItems", comboProp.getComboItems());
            }
            if (!(property instanceof DateProp)) continue;
            DateProp dateProp = (DateProp)property;
            propMap.put("type", "DateProp");
            propMap.put("dateFormat", dateProp.getDateFormat());
        }
        return entryEntityPropMap;
    }

    private static Map<String, DynamicObject> getBizItemGroupItems(DynamicObject bizItemGroup) {
        DynamicObjectCollection bizItems = bizItemGroup.getDynamicObjectCollection("entryentity");
        Set<Long> itemIds = bizItems.stream().map(bizItem -> bizItem.getLong("bizitem.id")).collect(Collectors.toSet());
        DynamicObject[] bizItemDys = HPDIDataServiceHelper.HSBS_BIZITEM_HELPER.query((Object[])itemIds.toArray(new Long[0]));
        Map<String, DynamicObject> bizItemGroupItems = Arrays.asList(bizItemDys).stream().collect(Collectors.toMap(dy -> dy.getString("number").toLowerCase(), dy -> dy, (k1, k2) -> k2));
        return bizItemGroupItems;
    }

    private static Map<String, Object> getObjRuleMatchMode(DynamicObject bizItemGroup) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bizDataObjRule = bizItemGroup.getDynamicObject("bizdataobjrule");
        if (SWCObjectUtils.isEmpty((Object)bizDataObjRule)) {
            bizDataObjRule = BizDataHelper.queryDefaultBizDataObjRule();
        }
        result.put(KEY_MATCHDATETYPE, bizDataObjRule.getString("matchdatetype"));
        result.put(KEY_MATCHMODE, bizDataObjRule.getString("matchmode"));
        return result;
    }

    private static DynamicObject queryBizItemGroup(Object bizItemGroupId) {
        SWCDataServiceHelper bigHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER;
        DynamicObject bizItemGroup = bigHelper.queryOne(bizItemGroupId);
        return bizItemGroup;
    }

    private static Map<Integer, String> invokeAfterReadData(Map<String, Integer> colKeyIndexMap, List<Map<Integer, String>> dataRow, Long bizDataBillId) {
        DynamicObject bizDataBill = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne((Object)bizDataBillId);
        BizDataBillEntryImportArgs args = new BizDataBillEntryImportArgs();
        args.setColKeyIndexMap(colKeyIndexMap);
        args.setDataRow(dataRow);
        args.setBizDataBill(bizDataBill);
        BizDataBillEntryImportExtService extService = new BizDataBillEntryImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataBillEntryImportExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin#afterReadData", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterReadData(args);
            return null;
        });
        return args.getErrorMap();
    }

    public static void setProgressToCache(BizDataBillEntryImpConfig conf) {
        BizDataBillEntryImpConfig confCache = new BizDataBillEntryImpConfig(conf.getParam());
        confCache.setTaskId(conf.getTaskId());
        confCache.setTotalRows(conf.getTotalRows());
        confCache.setResolveRows(conf.getResolveRows());
        confCache.setWaitDealRows(conf.getWaitDealRows());
        confCache.setDealRows(conf.getDealRows());
        confCache.setFailRows(conf.getFailRows());
        confCache.setStartTime(conf.getStartTime());
        confCache.setEndTime(conf.getEndTime());
        confCache.setErrorLogFileUrl(conf.getErrorLogFileUrl());
        confCache.setDealEnd(conf.isDealEnd());
        confCache.setDealRowsErrFile(conf.getDealRowsErrFile());
        ISWCAppCache appCache = SWCAppCache.get((String)"hpdi");
        appCache.put(MessageFormat.format("TaskProgress_{0}", conf.getTaskId()), (Object)SerializationUtils.serializeToBase64((Object)confCache));
    }
}

