/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpTplDownLoadHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImportHelper;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.formplugin.imports.DynamicEntryImportStartEdit;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class BizDataBillEntryImportStartEdit
extends AbstractFormPlugin
implements UploadListener {
    private static final String FILEPATH = "filepath";
    private static final String FILEPANEL = "filepanel";
    private static final Integer FIXHEADHEIGHT = 3;
    private static final String SWC_HSBP_FORMPLUGIN = "swc-hsbp-formplugin";
    private static Log log = LogFactory.getLog(DynamicEntryImportStartEdit.class);
    private final String IMPORT_START_ERROR = ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"DynamicEntryImportStartEdit_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
    private List<IDataPort> dataPortService;
    private ImportConfig importConfig;
    private static final String KEY_TASK_PROGRESS = "ImpTplDownload_Task_{0}";
    private static final int IMPORT_MAX_ROWS = 500000;
    public List<Long> batchAdminOrgIds = new ArrayList<Long>(1);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        this.dataPortService = this.getDataPortService();
        this.importConfig = this.invokeGetImportConfig();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if ("datatype".equals(fieldKey)) {
            DynamicObject importStartDy = this.getView().getModel().getDataEntity();
            String dataType = importStartDy.getString(fieldKey);
            if ("nodata".equals(dataType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexincludechild"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexincludechild"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportProcessCallBack")) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        title.setText(this.getEntryView().getModel().getDataEntityType().getDisplayName().toString());
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexincludechild"});
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            final IFormView view = this.getView();
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            final ArrayList dataHead = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final ArrayList dataRow = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final BooleanWrapperHolder hasRowDataWhenIsPartial = new BooleanWrapperHolder(Boolean.FALSE);
            final int endHeight = this.getEntryHeadEndHeight();
            try (InputStream in = service.getInputStream(url);){
                new ExcelReader().read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getRowNum() < FIXHEADHEIGHT - 1) {
                            return;
                        }
                        if (row.getRowNum() <= endHeight) {
                            dataHead.add(row.getData());
                        } else if (BizDataBillEntryImportStartEdit.this.importConfig.getImportType() == ImportConfig.ImportType.Partial) {
                            if (!row.isEmpty()) {
                                hasRowDataWhenIsPartial.value = Boolean.TRUE;
                                this.setInterrupt(true);
                            }
                        } else {
                            dataRow.add(row.getData());
                        }
                    }

                    public void setRowCount(int rowCount) {
                        if (rowCount + BizDataBillEntryImportStartEdit.this.getEntryHeadEndHeight() > BizDataBillEntryImportStartEdit.this.importConfig.getMaxRowCount()) {
                            String formatString = MessageFormat.format("{0}{1}\uff0c{2}", ResManager.loadKDString((String)"\u6700\u5927\u884c\u9650\u5236", (String)"DynamicEntryImportStartEdit_0", (String)BizDataBillEntryImportStartEdit.SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]), BizDataBillEntryImportStartEdit.this.importConfig.getMaxRowCount(), ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"DynamicEntryImportStartEdit_1", (String)BizDataBillEntryImportStartEdit.SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]));
                            view.showMessage(formatString);
                        }
                    }
                });
            }
            catch (KDBizException e) {
                ErrorCode code = e.getErrorCode();
                if (code == null || !"ValidFile".equalsIgnoreCase(code.getCode())) {
                    view.showErrorNotification(e.getMessage());
                    return;
                }
            }
            catch (Throwable e) {
                log.error(e);
                view.showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR(), e instanceof KDBizException ? e.getMessage() : this.IMPORT_START_ERROR, MessageTypes.Default);
                String billNo = (String)this.getView().getFormShowParameter().getCustomParam("bizDataBillNo");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)billNo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", "DynamicEntryImportStartEdit_14", SWC_HSBP_FORMPLUGIN), (String[])new String[0]);
                return;
            }
            if (this.importConfig.getImportType() == ImportConfig.ImportType.Partial && !hasRowDataWhenIsPartial.value.booleanValue()) {
                view.showMessage(ImportConstants.PARSED_INVALID_DATA(), ImportConstants.LOGGING_DATA(), MessageTypes.Default);
                String billNo = (String)this.getView().getFormShowParameter().getCustomParam("bizDataBillNo");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)billNo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "DynamicEntryImportStartEdit_13", SWC_HSBP_FORMPLUGIN), (String[])new String[0]);
                return;
            }
            if (dataHead.size() == 0) {
                view.showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR());
                return;
            }
            ValidateResults validateResult = this.invokeOnValidateTemplate(dataHead, dataRow);
            if (validateResult.isSuccess()) {
                view.setVisible(Boolean.TRUE, new String[]{FILEPANEL});
                view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
                IDataModel model = this.getModel();
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue(FILEPATH, (Object)url);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String entryKey = (String)showParameter.getCustomParam("entrykey");
                BizDataBillEntryImpTplDownLoadHelper tplDownLoadHelper = new BizDataBillEntryImpTplDownLoadHelper(this.getEntryView(), entryKey, this.getView(), "1");
                tplDownLoadHelper.downloadTemplateAll();
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue(FILEPATH, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void importData() {
        String url = this.getModel().getDataEntity().getString(FILEPATH);
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DynamicEntryImportStartEdit_8", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]));
            LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5f00\u59cb\u4e0a\u4f20", (String)"DynamicEntryImportStartEdit_10", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u3002", (String)"DynamicEntryImportStartEdit_11", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]));
            String billNo = (String)this.getView().getFormShowParameter().getCustomParam("bizDataBillNo");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)billNo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u3002", "DynamicEntryImportStartEdit_11", SWC_HSBP_FORMPLUGIN), (String[])new String[0]);
            return;
        }
        this.createBaskgroundTask(url);
    }

    private void createBaskgroundTask(String url) {
        String tplHeadStr = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"BizDataBillEntryImportStartEdit_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String name = FilenameUtils.getBaseName((String)url).replace(tplHeadStr, "");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("url", url);
        int headEndHeight = this.getEntryHeadEndHeight();
        params.put("headEndHeight", headEndHeight);
        params.put("fixHeadHeight", FIXHEADHEIGHT);
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        params.put("bizDataBillId", customParam.get("bizDataBillId"));
        params.put("bizItemGroupId", customParam.get("bizItemGroupId"));
        params.put("modelType", customParam.get("modelType"));
        params.put("entryEntityPropMap", customParam.get("entryEntityPropMap"));
        String pageId = this.getView().getParentView().getPageId();
        IFormView mainView = this.getView().getParentView().getMainView();
        String rootPageId = pageId;
        if (mainView != null) {
            rootPageId = mainView.getPageId();
        }
        String taskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hpdi_bizdatabillimport", name, false, rootPageId, pageId, params);
        customParam.put("taskId", taskId);
        BizDataBillEntryImportHelper.showProgressForm(this.getView(), customParam);
    }

    private int getEntryHeadEndHeight() {
        return this.importConfig.getHeadHeight() + FIXHEADHEIGHT - 1;
    }

    private List<IDataPort> getDataPortService() {
        FormViewPluginProxy service = (FormViewPluginProxy)this.getEntryView().getService(FormViewPluginProxy.class);
        ArrayList dataPortPlugins = Lists.newArrayListWithExpectedSize((int)service.getPlugIns().size());
        for (IFormPlugin plugIn : service.getPlugIns()) {
            if (!(plugIn instanceof IDataPort)) continue;
            dataPortPlugins.add((IDataPort)plugIn);
        }
        if (dataPortPlugins.size() <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u81f3\u5c11\u4e00\u4e2a\u5bfc\u5165\u670d\u52a1\u63d2\u4ef6\u3002", (String)"DynamicEntryImportStartEdit_7", (String)SWC_HSBP_FORMPLUGIN, (Object[])new Object[0]));
        }
        return dataPortPlugins;
    }

    private IFormView getEntryView() {
        String entryViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("entryview");
        return this.getView().getView(entryViewPageId);
    }

    private ImportConfig invokeGetImportConfig() {
        OnGetImportConfigEvent event = new OnGetImportConfigEvent((Object)this);
        ImportConfig config = new ImportConfig();
        event.setImportConfig(config);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.onGetImportConfig(event);
        }
        ImportConfig importConfig = event.getImportConfig();
        this.setEntryHeadHeight(importConfig);
        return importConfig;
    }

    private void setEntryHeadHeight(ImportConfig importConfig) {
        if (importConfig.getHeadHeight() > 0) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getEntryView(), (String)entryKey);
        int height = SWCExportEntryHelper.calcSheetHeadHeight((List)wrapper.getContainers());
        importConfig.setHeadHeight(height);
    }

    private ValidateResults invokeOnValidateTemplate(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        Map<Integer, String> map = dataHead.get(dataHead.size() - 1);
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (!value.contains("*")) continue;
            String trim = value.replaceFirst("\\*", "").trim();
            entry.setValue(trim);
        }
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.onValidateTemplate(event);
        }
        return event.getValidateResults();
    }
}

