/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.util.Pair;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataBillEntryImportArgs;
import kd.sdk.swc.hpdi.common.events.bizdatabill.AfterAddFieldContainerEvent;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin;
import kd.swc.hpdi.business.helper.BizDataBillEntryExtService;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryImportExtService;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.constants.BizDataBillConstants;
import kd.swc.hpdi.formplugin.web.HPDIResMgrFormPlugin;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryGrid;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryGridHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImpTplDownLoadHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataBillEntryImportHelper;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.FieldParamContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCGridUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.BeforeWriteTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class BizDataBillEntryPlugin
extends AbstractBillPlugIn
implements BizDataBillConstants,
IDataPort,
BeforeF7SelectListener,
EntryGridBindDataListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(BizDataBillEntryPlugin.class);
    private static char[] FILE_NAME_ILELGAL_CHARACTER = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
    private static char REPLACE_CHARACTER = (char)45;

    public void initialize() {
        this.rewriteEntryGrid();
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            return;
        }
        Long bizItemGroupId = this.getBizItemGroupId(this.getView().getFormShowParameter());
        List<Long> mulBizItemIds = this.getMulBizItemIds(this.getView().getFormShowParameter());
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(this.getView(), bizItemGroupId, mulBizItemIds, this.getView().getFormShowParameter().getCustomParams());
        EntryParamContainerBaseHelper.registProp(entryApBuildParam, (EntityType)((EntityType)newMainType.getAllEntities().get("entryentity")));
        args.setNewEntityType(newMainType);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        Long bizItemGroupId = this.getBizItemGroupId(args.getSource());
        List<Long> mulBizItemIds = this.getMulBizItemIds(args.getSource());
        Map<String, Object> params = this.getBizItemsAndBizDataRuleFields(args.getSource());
        params.put("bizItemGroupId", bizItemGroupId);
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(this.getView(), bizItemGroupId, mulBizItemIds, params);
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(0);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        args.getItems().add(mapEntry);
    }

    public void loadCustomEntryMetas(LoadCustomEntryMetasEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        evt.setEntryColumnWrapper(wrapper);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        if (!BizDataBillEntryHelper.isHorizontalTable((IFormView)this.getView())) {
            BasedataEdit bizItem = (BasedataEdit)this.getControl("bizitem");
            bizItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calfrequency = (BasedataEdit)this.getControl("calfrequency");
        calfrequency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizDataDim = (BasedataEdit)this.getControl("bizdatadim");
        bizDataDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        Control oldGrid = this.getView().getControl("entryentity");
        EntryGrid entryGrid = this.rewriteEntryGridControl(oldGrid);
        this.setEntryGridControlIndex(entryGrid, this.getView());
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List fields = entryGrid.getItems().stream().map(r1 -> r1.getKey()).collect(Collectors.toList());
        if (fields.contains("person_number")) {
            entryGrid.setColumnProperty("person_number", "isFixed", (Object)Boolean.TRUE);
        }
        if (fields.contains("person")) {
            entryGrid.setColumnProperty("person", "isFixed", (Object)Boolean.TRUE);
        }
        BizDataBillEntryHelper.setFieldsNotQuickAddNew((IFormView)this.getView());
        BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "submit": 
            case "submitandeffect": 
            case "save": {
                formOperate.getOption().setVariableValue("deleteentryids", this.getView().getPageCache().get("deleteentryids"));
                IPageCache pageCache = BizDataBillEntryHelper.getBizDataBillPageCache((IFormView)this.getView());
                String bizItemsStr = pageCache.get("bizItems");
                if (!SWCStringUtils.isNotEmpty((String)bizItemsStr)) break;
                ArrayList bizItems = new ArrayList(10);
                bizItems.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)bizItemsStr));
                Set bizItemKeys = bizItems.stream().map(item -> item.getString("bizitem.number").toLowerCase()).collect(Collectors.toSet());
                formOperate.getOption().setVariableValue("bizItemKeys", SerializationUtils.toJsonString(bizItemKeys));
                break;
            }
            case "donothing_deleteentry": {
                if ("hpdi_bizdatabillnewentry".equals(this.getView().getFormShowParameter().getFormId())) break;
                BizDataBillEntryGrid entryGrid = (BizDataBillEntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"BizDataBillEntryPlugin_51", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String showMsg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillEntryPlugin_50", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(MessageFormat.format(showMsg, selectRows.length), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteentry_confirm"));
                break;
            }
            case "donothing_import": {
                this.beforeImportData(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "deleteentry_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                StringBuilder selectRowIdsb = this.getEntrySelectRowIds();
                this.getView().getPageCache().put("deleteentryids", selectRowIdsb.toString());
                this.getView().invokeOperation("refresh");
                this.getView().invokeOperation("save");
                this.getView().invokeOperation("modify");
                break;
            }
        }
    }

    private void beforeImportData(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billType = this.getModel().getDataEntity().getString("billtype");
        if ("2".equals(billType)) {
            if (SWCStringUtils.isEmpty((String)dataEntity.getString("billno")) || SWCStringUtils.isEmpty((String)dataEntity.getString("billname")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("adminorg")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("bizitemgroup"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5355\u636e\u7f16\u53f7\u201d\u3001\u201c\u5355\u636e\u540d\u79f0\u201d\u3001\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3001\u201c\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u201d\u3001\u201c\u85aa\u8d44\u671f\u95f4\u201d\u3002", (String)"BizDataImportEdit_5", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (SWCStringUtils.isEmpty((String)dataEntity.getString("billno")) || SWCStringUtils.isEmpty((String)dataEntity.getString("billname")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("adminorg")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("bizitemgroup")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("calperiod"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5355\u636e\u7f16\u53f7\u201d\u3001\u201c\u5355\u636e\u540d\u79f0\u201d\u3001\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3001\u201c\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u201d\u3001\u201c\u85aa\u8d44\u671f\u95f4\u201d\u3002", (String)"BizDataImportEdit_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billNo = dataEntity.getString("billno");
        DynamicObject obj = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("entryentity.empposorgrel,entryentity.bizitem,population,itemnum,entrynum", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        OperateOption operateOption = OperateOption.create();
        if (SWCObjectUtils.isEmpty((Object)obj)) {
            BizDataHelper.setRuleVersionCaseSaveBizItemGroup((IFormView)this.getView());
            operateOption.setVariableValue("is_self_save", "true");
            this.getView().invokeOperation("save", operateOption);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4fdd\u5b58", (String)"BizDataImportEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        } else {
            operateOption.setVariableValue("is_self_save", "true");
            OperationResult operationResult = this.getView().invokeOperation("save", operateOption);
            if (!operationResult.isSuccess()) {
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = args.getOperateKey()) {
            case "submit": 
            case "submitandeffect": 
            case "save": {
                OperationResult opResult = args.getOperationResult();
                if (opResult == null || !opResult.isSuccess()) break;
                this.getView().getPageCache().remove("deleteentryids");
                break;
            }
            case "donothing_import": {
                this.openImportWindow(this.getView(), (IFormPlugin)this, null);
                break;
            }
            case "donothing_exportbytpl": {
                this.addFormShowParameterForExportByTpl();
                break;
            }
            case "refresh": {
                IPageCache pageCache = this.getPageCache();
                pageCache.remove("pageindex");
                pageCache.remove("pagerows");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "bizitem": {
                this.addBizitemFilter(arg);
                ((ListShowParameter)arg.getFormShowParameter()).setMultiSelect(false);
                if ("hpdi_bizdatabillnewentry".equals(this.getView().getFormShowParameter().getFormId())) {
                    Long orgId = this.getModel().getDataEntity().getLong("org.id");
                    QFilter userOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (Long)orgId);
                    arg.addCustomQFilter(userOrgFilter);
                }
                arg.getFormShowParameter().setCustomParam("filterLeftTree", (Object)"1");
                break;
            }
            case "calfrequency": 
            case "currency": {
                ((ListShowParameter)arg.getFormShowParameter()).setMultiSelect(false);
                break;
            }
            case "bizdatadim": {
                this.beforeShowBizDataDim(arg);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (!(evt.getSource() instanceof SubEntryGrid)) {
            return;
        }
        SubEntryGrid subEntryGrid = (SubEntryGrid)evt.getSource();
    }

    public void entryGridBindData(EntryGridBindDataEvent evt) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hpdi_bizdatabillnewentry".equals(formId)) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        String pageIndex = String.valueOf(evt.getData().get("pageindex"));
        String pageRows = String.valueOf(evt.getData().get("pagerows"));
        pageCache.put("pagerows", pageRows);
        pageCache.put("pageindex", pageIndex);
        BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
        int startRowIndex = (Integer.parseInt(pageIndex) - 1) * Integer.parseInt(pageRows);
        this.setUserDefinedColor(startRowIndex);
        this.getView().addClientCallBack("calSummary");
    }

    public void beforeWriteTemplate(BeforeWriteTemplateEvent evt) {
        BizDataBillEntryImpTplDownLoadHelper downLoadHelper = (BizDataBillEntryImpTplDownLoadHelper)evt.getSource();
        String dataType = downLoadHelper.getDataType();
        if ("1".equals(dataType)) {
            this.beforeWriteTemplateForPerson(evt, downLoadHelper);
        } else {
            this.beforeWriteTemplateForBizDataEnt(evt, downLoadHelper);
        }
    }

    private void beforeWriteTemplateForBizDataEnt(BeforeWriteTemplateEvent evt, BizDataBillEntryImpTplDownLoadHelper downLoadHelper) {
        QFilter custFilter = new QFilter("id", "in", downLoadHelper.getBatchDataIds());
        List<DynamicObject> dys = BizDataBillEntryGridHelper.getEntryDataEntitiesCoreFull(this.getView(), 0, 10000, custFilter);
        DynamicObjectCollection dysAll = new DynamicObjectCollection();
        dysAll.addAll(dys);
        evt.setDynamicObjectCollection(dysAll);
    }

    private void beforeWriteTemplateForPerson(BeforeWriteTemplateEvent evt, BizDataBillEntryImpTplDownLoadHelper downLoadHelper) {
        DynamicObject importStartDy = downLoadHelper.getImportStartView().getModel().getDataEntity();
        String dataType = importStartDy.getString("datatype");
        if ("nodata".equals(dataType)) {
            evt.setDynamicObjectCollection(new DynamicObjectCollection());
            return;
        }
        List<Long> adminOrgIds = downLoadHelper.getBatchDataIds();
        List adminOrgIdsSplit = Lists.partition(adminOrgIds, (int)100);
        BizDataBillEntryImportArgs args = new BizDataBillEntryImportArgs();
        args.setBizDataBill(downLoadHelper.getBizDataBillView().getModel().getDataEntity());
        BizDataBillEntryImportExtService extService = new BizDataBillEntryImportExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IBizDataBillEntryImportExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataBillEntryImportExtPlugin#downTemplate", null);
        DynamicObjectCollection dysAll = new DynamicObjectCollection();
        for (List adminOrgIdsTmp : adminOrgIdsSplit) {
            QFilter custFilter = new QFilter("id", "in", (Object)adminOrgIdsTmp);
            DynamicObject[] relDys = this.queryEmpposorgrel(custFilter);
            DynamicObjectCollection dys = this.transferToEntryDys(Arrays.asList(relDys), downLoadHelper);
            args.setEmpCol(dys);
            hrPluginProxy.callReplaceIfPresent(proxy -> {
                proxy.setFieldDefaultValue(args);
                return null;
            });
            dysAll.addAll((Collection)dys);
        }
        evt.setDynamicObjectCollection(dysAll);
    }

    private DynamicObject[] queryEmpposorgrel(QFilter custFilter) {
        logger.info("queryEmpposorgrel...begin...");
        String selectFields = "id,number,person,company,position,apositiontype,job,postype,isprimary,startdate,enddate,adminorg";
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hrpi_empposorgrel");
        QFilter[] qfilters = new QFilter[]{custFilter};
        String orderBy = "person.number, isprimary desc, enddate desc, startdate desc, number desc";
        DynamicObject[] dys = serviceHelper.query(selectFields, qfilters, orderBy);
        logger.info("queryEmpposorgrel...end...dys.length={}", (Object)dys.length);
        CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
        return dys;
    }

    private DynamicObjectCollection transferToEntryDys(List<DynamicObject> relDys, BizDataBillEntryImpTplDownLoadHelper downLoadHelper) {
        SWCDataServiceHelper orgHelper = new SWCDataServiceHelper("hpdi_bizdatabill");
        DynamicObjectCollection dys = new DynamicObjectCollection();
        DynamicObject dy = this.getModel().getDataEntity();
        List props = SWCHisBaseDataHelper.getEntityPropeties((MainEntityType)((MainEntityType)dy.getDataEntityType()), (String)"entryentity");
        Set<String> personNumbers = downLoadHelper.getPersonNumbers();
        for (DynamicObject relDy : relDys) {
            DynamicObject entry = orgHelper.generateEmptyEntryDynamicObject(dy, "entryentity");
            if (!personNumbers.add(relDy.getString("person.number"))) continue;
            for (IDataEntityProperty prop : props) {
                String propKey = prop.getName();
                String valueKey = prop.getName();
                if ("entadminorg".equals(valueKey)) {
                    valueKey = "adminorg";
                }
                entry.set(propKey, relDy.containsProperty(valueKey) ? relDy.get(valueKey) : null);
            }
            entry.set("person_number", (Object)relDy.getString("person.number"));
            entry.set("empposorgrel", (Object)relDy);
            dys.add((Object)entry);
        }
        return dys;
    }

    private void sortRelDys(List<DynamicObject> relDys) {
        Collections.sort(relDys, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                String personNumber1 = o1.getString("person.number");
                String personNumber2 = o2.getString("person.number");
                String isprimary1 = o1.getString("isprimary");
                String isprimary2 = o2.getString("isprimary");
                Date enddate1 = o1.getDate("enddate");
                Date enddate2 = o2.getDate("enddate");
                Date startdate1 = o1.getDate("startdate");
                Date startdate2 = o2.getDate("startdate");
                String number1 = o1.getString("number");
                String number2 = o2.getString("number");
                if (personNumber1 == null || personNumber2 == null || isprimary1 == null || isprimary2 == null || enddate1 == null || enddate2 == null || startdate1 == null || startdate2 == null || number1 == null || number2 == null) {
                    return 0;
                }
                if (personNumber1.compareTo(personNumber2) > 0) {
                    return 1;
                }
                if (personNumber1.compareTo(personNumber2) < 0) {
                    return -1;
                }
                if (isprimary1.compareTo(isprimary2) > 0) {
                    return -1;
                }
                if (isprimary1.compareTo(isprimary2) < 0) {
                    return 1;
                }
                if (enddate1.getTime() > enddate2.getTime()) {
                    return -1;
                }
                if (enddate1.getTime() < enddate2.getTime()) {
                    return 1;
                }
                if (startdate1.getTime() > startdate2.getTime()) {
                    return -1;
                }
                if (startdate1.getTime() < startdate2.getTime()) {
                    return 1;
                }
                if (number1.compareTo(number2) > 0) {
                    return -1;
                }
                if (number1.compareTo(number2) < 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private QFilter getCommFilter() {
        DynamicObject billDy = this.getModel().getDataEntity();
        QFilter adminOrgPremFilter = this.getAdminOrgPremFilter();
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"empposorgrel", (String)"47150e89000000ac");
        QFilter qjEndFilter = this.getQJEndFilter(billDy);
        QFilter qjStartFilter = this.getQJStartFilter(billDy);
        QFilter commFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        commFilter.and("datastatus", "=", (Object)"1");
        commFilter.and(QFilter.isNotNull((String)"person.number"));
        if (adminOrgPremFilter != null) {
            commFilter.and(adminOrgPremFilter);
        }
        if (!isSuperUser && empposFilter != null) {
            commFilter.and(empposFilter);
        }
        if (qjEndFilter != null) {
            commFilter.and(qjEndFilter);
        }
        if (qjStartFilter != null) {
            commFilter.and(qjStartFilter);
        }
        return commFilter;
    }

    private QFilter getQJStartFilter(DynamicObject billDy) {
        QFilter qjStartFilter = null;
        Date qjStartdate = billDy.getDate("calperiod.startdate");
        if (qjStartdate != null) {
            qjStartdate = SWCDateTimeUtils.getDayDate((Date)qjStartdate);
            qjStartFilter = new QFilter("enddate", ">=", (Object)qjStartdate);
        }
        return qjStartFilter;
    }

    private QFilter getQJEndFilter(DynamicObject billDy) {
        QFilter qjEndFilter = null;
        Date qjEnddate = billDy.getDate("calperiod.enddate");
        if (qjEnddate != null) {
            qjEnddate = SWCDateTimeUtils.getDayDate((Date)qjEnddate);
            qjEnddate = SWCDateTimeUtils.addDay((Date)qjEnddate, (long)1L);
            qjEndFilter = new QFilter("startdate", "<", (Object)qjEnddate);
        }
        return qjEndFilter;
    }

    private QFilter getAdminOrgPremFilter() {
        QFilter adminOrgPremFilter = null;
        String permEntity = "hpdi_bizdatabillent";
        String permItemId = "47150e89000000ac";
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"0NXW1VOPH+QV", (String)permEntity, (String)permItemId, (String)"empposorgrel.adminorg");
        if (adminOrgIds != null) {
            adminOrgPremFilter = new QFilter("adminorg", "in", (Object)adminOrgIds);
        }
        return adminOrgPremFilter;
    }

    private List<Long> getSubAdminOrgs(Long adminOrgId) {
        List adminOrgIds = null;
        if (adminOrgId == null) {
            return adminOrgIds;
        }
        List batchGetAllSubOrgList = AdminOrgHelper.getAllSubAdminOrg((Long)adminOrgId);
        if (batchGetAllSubOrgList != null) {
            adminOrgIds = batchGetAllSubOrgList.stream().map(batchGetAllSubOrgMap -> Long.valueOf(String.valueOf(batchGetAllSubOrgMap.get("orgId")))).collect(Collectors.toList());
        }
        return adminOrgIds;
    }

    private QFilter getSubAdminOrgFilter(DynamicObject billDy) {
        QFilter subAdminOrgFilter = null;
        Long adminOrgId = billDy.getLong("adminorg.id");
        if (adminOrgId == null) {
            return subAdminOrgFilter;
        }
        List batchGetAllSubOrgList = AdminOrgHelper.getAllSubAdminOrg((Long)adminOrgId);
        if (batchGetAllSubOrgList != null) {
            List orgFinalIds = batchGetAllSubOrgList.stream().map(batchGetAllSubOrgMap -> Long.valueOf(String.valueOf(batchGetAllSubOrgMap.get("orgId")))).collect(Collectors.toList());
            subAdminOrgFilter = new QFilter("adminorg", "in", orgFinalIds);
        }
        return subAdminOrgFilter;
    }

    public void onValidateTemplate(DataImportEvent evt) {
        List dataHead = evt.getDataHead();
        ValidateResults validateResults = new ValidateResults(ErrorLevel.Error);
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        if (!this.validateDataHead(dataHead)) {
            validateResults.failed();
            source.getView().showErrorNotification(ImportConstants.IMPORT_TEMPLATE_ERROR());
            evt.setValidateResults(validateResults);
            return;
        }
        evt.setValidateResults(validateResults);
    }

    private boolean validateDataHead(List<Map<Integer, String>> dataHead) {
        if (dataHead == null) {
            return false;
        }
        Map<Integer, String> colIdMap = dataHead.get(0);
        ArrayList<String> colSet = new ArrayList<String>(colIdMap.values());
        DynamicObject dy = this.getModel().getDataEntity();
        Long bizItemGroupId = dy.getLong("bizitemgroup.id");
        SWCDataServiceHelper bigHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER;
        DynamicObject bizItemGroup = bigHelper.queryOne((Object)bizItemGroupId);
        DynamicObjectCollection bizItems = bizItemGroup.getDynamicObjectCollection("entryentity");
        List bizItemNumberSet = bizItems.stream().map(bizItem -> bizItem.getString("bizitem.number").toLowerCase()).collect(Collectors.toList());
        String showType = bizItemGroup.getString("modeltype");
        String billType = dy.getString("billtype");
        if ("2".equals(showType)) {
            if ("1".equals(billType)) {
                ArrayList<String> mustHasColumn = new ArrayList<String>(10);
                mustHasColumn.add("person_number");
                mustHasColumn.add("effectivedate");
                logger.info("BizDataBillEntryPlugin.validateDataHead...colSet={}", (Object)((Object)colSet).toString());
                logger.info("BizDataBillEntryPlugin.validateDataHead...mustHasColumn={}", (Object)((Object)mustHasColumn).toString());
                logger.info("BizDataBillEntryPlugin.validateDataHead...bizItemNumberSet={}", (Object)bizItemNumberSet.toString());
                for (String column : mustHasColumn) {
                    if (colSet.contains(column)) continue;
                    return false;
                }
                for (String bizItemNumber : bizItemNumberSet) {
                    if (!colSet.contains(bizItemNumber)) continue;
                    return true;
                }
                return false;
            }
        } else if ("1".equals(billType)) {
            ArrayList<String> mustHasColumn = new ArrayList<String>(10);
            mustHasColumn.add("person_number");
            mustHasColumn.add("bizitem_name");
            mustHasColumn.add("value");
            mustHasColumn.add("effectivedate");
            for (String column : mustHasColumn) {
                if (colSet.contains(column)) continue;
                return false;
            }
        } else {
            ArrayList<String> mustHasColumn = new ArrayList<String>(10);
            mustHasColumn.add("person_number");
            mustHasColumn.add("person");
            mustHasColumn.add("bizitem_name");
            mustHasColumn.add("updateexpirydate");
            for (String column : mustHasColumn) {
                if (colSet.contains(column)) continue;
                return false;
            }
        }
        return true;
    }

    public void onGetImportConfig(OnGetImportConfigEvent evt) {
        ImportConfig config = evt.getImportConfig();
        if (config == null) {
            config = new ImportConfig();
        }
        config.setImportType(ImportConfig.ImportType.Complete);
        config.setMaxRowCount(1000000);
        String billTypeDesc = "";
        String str = ResManager.loadKDString((String)"\u65b0\u589e\u4e1a\u52a1\u6570\u636e_{0}_{1}", (String)"BizDataBillEntryPlugin_52", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        DynamicObject billDy = this.getModel().getDataEntity();
        String billType = billDy.getString("billtype");
        if ("2".equals(billType)) {
            billTypeDesc = ResManager.loadKDString((String)"_\u66f4\u65b0\u5931\u6548\u65e5\u671f", (String)"BizDataBillEntryPlugin_45", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
            str = ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u5931\u6548\u65e5\u671f_{0}_{1}", (String)"BizDataBillEntryPlugin_53", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        }
        String templateFirstName = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63d0\u62a5-\u5bfc\u5165\u6a21\u677f", (String)"BizDataBillEntryPlugin_58", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        config.setTemplateCaption(templateFirstName.concat(billTypeDesc));
        String modelName = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63d0\u62a5", (String)"BizDataBillEntryPlugin_43", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        config.setModelName(modelName);
        String bizDataGroupName = this.getModel().getDataEntity().getString("bizitemgroup.name");
        bizDataGroupName = this.replaceFileNameIllegalCharacter(bizDataGroupName);
        LocalDate now = LocalDate.now();
        String dateStr = String.format(Locale.ROOT, "%02d", now.getMonthValue()).concat(String.format(Locale.ROOT, "%02d", now.getDayOfMonth()));
        str = MessageFormat.format(str, bizDataGroupName, dateStr);
        config.setTemplateFileName(str);
        String templateWarningInfo = ResManager.loadKDString((String)"\uff08\u7f16\u7801\u548c\u540d\u79f0\u7ec4\u5408\u5b57\u6bb5\uff0c\u82e5\u586b\u5199\u4e86\u7f16\u7801\u5c06\u6839\u636e\u7f16\u7801\u5339\u914d\u6570\u636e\uff0c\u82e5\u4ec5\u586b\u5199\u540d\u79f0\uff0c\u5219\u6839\u636e\u540d\u79f0\u5339\u914d\u6570\u636e\u3002\uff09", (String)"BizDataBillEntryPlugin_46", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        config.setTemplateWarningInfo(config.getTemplateWarningInfo() + templateWarningInfo);
        config.setFieldAnnotation(this.getFieldAnnotation());
        AfterAddFieldContainerEvent event = new AfterAddFieldContainerEvent();
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("bizDataBillId", this.getModel().getDataEntity().getLong("id"));
        customParams.put("bizItemGroupId", this.getModel().getDataEntity().getLong("bizitemgroup.id"));
        event.setCustomParams(customParams);
        event.setTemplateWarningInfo(config.getTemplateWarningInfo());
        event.setFieldAnnotation(config.getFieldAnnotation());
        this.invokeAfterAddFieldContainer(event);
        config.setTemplateWarningInfo(event.getTemplateWarningInfo());
        config.setFieldAnnotation(event.getFieldAnnotation());
        String notMustInputFieldsStr = this.getPageCache().get("tplNotMustInput");
        config.setNotMustInputFields((Set)SerializationUtils.fromJsonString((String)notMustInputFieldsStr, Set.class));
        evt.setImportConfig(config);
    }

    public Map<String, String> getFieldAnnotation() {
        HashMap map = Maps.newHashMap();
        String currencyMustInputMsg = ResManager.loadKDString((String)"\u91d1\u989d\u7c7b\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u5e01\u79cd\u7f16\u7801\u548c\u540d\u79f0\u5fc5\u586b\u4e00\u9879", (String)"BizDataBillEntryPlugin_57", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        map.put("currency", currencyMustInputMsg);
        String dateFormatMsg = ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\uff1a\u201c2023/12/31\u201d \u6216 \u201c2023-12-31\u201d\u3002", (String)"BizDataBillEntryPlugin_49", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        map.put("bizdate", dateFormatMsg);
        map.put("effectivedate", dateFormatMsg);
        map.put("expirydate", dateFormatMsg);
        return map;
    }

    public void beforeDownLoadTemplate(DownLoadTemplateEvent evt) {
        BizDataBillEntryImpTplDownLoadHelper downLoadHelper = (BizDataBillEntryImpTplDownLoadHelper)evt.getSource();
        AfterAddFieldContainerEvent event = new AfterAddFieldContainerEvent();
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("bizDataBillId", this.getModel().getDataEntity().getLong("id"));
        customParams.put("bizItemGroupId", this.getModel().getDataEntity().getLong("bizitemgroup.id"));
        event.setCustomParams(customParams);
        this.invokeAfterAddFieldContainer(event);
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("entryentity");
        String entryName = entityType.getDisplayName().getLocaleValue();
        SXSSFSheet sheet = evt.getWb().getSheet(entryName);
        if (sheet == null) {
            logger.info("beforeDownLoadTemplate...sheet is null,entryName={}", (Object)entryName);
            return;
        }
        SXSSFRow row = downLoadHelper.getHeadKeyRow();
        if (row == null) {
            logger.info("beforeDownLoadTemplate.....row is null");
            return;
        }
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            String cellVal = cell.getStringCellValue();
            if (!event.getHideFields().contains(cellVal)) continue;
            sheet.setColumnHidden(cell.getColumnIndex(), true);
        }
    }

    public void dataImport(DataImportEvent evt) {
    }

    public void afterImport(DataImportEvent dataImportEvent) {
        this.getView().invokeOperation("refresh");
    }

    private List<EntryParamContainer> createEntryBuildParamForTabular(IFormView view, Long bizItemGroupId, List<Long> mulBizItemIds, Map<String, Object> params) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        SWCDataServiceHelper bigHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER;
        DynamicObject bizItemGroup = bigHelper.queryOne((Object)bizItemGroupId);
        String showType = bizItemGroup.getString("modeltype");
        ArrayList<DynamicObject> bizItems = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection bizDataRuleFields = new DynamicObjectCollection();
        this.initBizItemsAndBizDataRuleFields(view, params, bizItemGroup, mulBizItemIds, bizItems, bizDataRuleFields);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hpdi_bizdatabill", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        ArrayList<String> empFields = new ArrayList<String>(bizDataRuleFields.size());
        this.addBizRuleContainer(allContainer, entityMetadata, bizDataRuleFields, empFields);
        this.addBizItemContainer(allContainer, entityMetadata, bizItems, showType);
        this.addFixedFieldContainer(allContainer, entityMetadata);
        this.afterAddFieldContainer(allContainer, entityMetadata, params);
        if (null != view) {
            String ruleFieldsStr = SerializationUtils.serializeToBase64((Object)bizDataRuleFields);
            String itemsStr = SerializationUtils.serializeToBase64(bizItems);
            view.getPageCache().put("entryBizDataObjRule", ruleFieldsStr);
            view.getPageCache().put("bizItems", itemsStr);
            view.getFormShowParameter().setCustomParam("entryBizDataObjRule", (Object)ruleFieldsStr);
            view.getFormShowParameter().setCustomParam("bizItems", (Object)itemsStr);
            view.getPageCache().put(String.format(Locale.ROOT, "bizItemGroupEmpposorgrelFields_%s", bizItemGroupId), SerializationUtils.serializeToBase64(empFields));
        }
        return allContainer;
    }

    private List<Map<String, Object>> getStdFieldContainer(List<EntryParamContainer> allContainer) {
        ArrayList<Map<String, Object>> stdFieldParamMaps = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> fieldParamMap = null;
        for (EntryParamContainer paramContainer : allContainer) {
            FieldParamContainer tempContainer = (FieldParamContainer)paramContainer;
            fieldParamMap = new HashMap<String, Object>(16);
            fieldParamMap.put("key", tempContainer.getKey());
            fieldParamMap.put("name", tempContainer.getName());
            fieldParamMap.put("lock", tempContainer.getLock());
            fieldParamMap.put("visible", tempContainer.getVisible());
            fieldParamMap.put("width", tempContainer.getWidth());
            fieldParamMap.put("textAlign", tempContainer.getTextAlign());
            fieldParamMap.put("mustInput", tempContainer.isMustInput());
            stdFieldParamMaps.add(fieldParamMap);
        }
        return stdFieldParamMaps;
    }

    private void afterAddFieldContainer(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata, Map<String, Object> customParams) {
        Object bizDataBillPageId;
        logger.info("afterAddFieldContainer...customParams.bizDataBillId={}.bizItemGroupId={}", customParams.get("bizDataBillId"), customParams.get("bizItemGroupId"));
        List stdFieldParamMaps = this.getStdFieldContainer(allContainer);
        IPageCache pageCache = null;
        if (null != this.getView()) {
            pageCache = BizDataBillEntryHelper.getBizDataBillPageCache((IFormView)this.getView());
        }
        if (null == pageCache && null != customParams && null != (bizDataBillPageId = customParams.get("bizDataBillPageId"))) {
            pageCache = new PageCache(String.valueOf(bizDataBillPageId));
        }
        String fieldParamMapStr = null;
        String stdFieldParamMapStr = null;
        List<Map<String, Object>> fieldParamMaps = null;
        AfterAddFieldContainerEvent event = null;
        if (null != pageCache) {
            fieldParamMapStr = pageCache.get("ext_fieldParamMaps");
            stdFieldParamMapStr = pageCache.get("ext_stdFieldParamMaps");
        }
        if (fieldParamMapStr != null && stdFieldParamMapStr != null) {
            fieldParamMaps = (List<Map<String, Object>>)SerializationUtils.deSerializeFromBase64((String)fieldParamMapStr);
            stdFieldParamMaps = (List)SerializationUtils.deSerializeFromBase64((String)stdFieldParamMapStr);
        } else {
            event = new AfterAddFieldContainerEvent();
            event.setCustomParams(customParams);
            event.setStdFieldParamMaps(stdFieldParamMaps);
            fieldParamMaps = this.invokeAfterAddFieldContainer(event);
            if (null != pageCache && customParams != null && customParams.containsKey("bizItemGroupId")) {
                pageCache.put("ext_fieldParamMaps", SerializationUtils.serializeToBase64((Object)event.getFieldParamMaps()));
                pageCache.put("ext_stdFieldParamMaps", SerializationUtils.serializeToBase64((Object)event.getStdFieldParamMaps()));
            }
        }
        this.setStdFieldParam(allContainer, stdFieldParamMaps);
        logger.info("afterAddFieldContainer...fieldParamMaps={}", (Object)fieldParamMaps.toString());
        if (SWCListUtils.isEmpty(fieldParamMaps)) {
            return;
        }
        for (Map<String, Object> itemMap : fieldParamMaps) {
            String dataType = String.valueOf(itemMap.get("datatype"));
            FieldParamContainer itemContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)dataType, (EntityMetadata)entityMetadata, itemMap);
            String addAfterKey = String.valueOf(itemMap.get("addAfterKey"));
            Integer fieldIndex = this.findFieldIndexByKey(allContainer, addAfterKey);
            if (fieldIndex == null) {
                allContainer.add((EntryParamContainer)itemContainer);
                continue;
            }
            allContainer.add(fieldIndex + 1, (EntryParamContainer)itemContainer);
        }
    }

    private void setStdFieldParam(List<EntryParamContainer> allContainer, List<Map<String, Object>> stdFieldParamMaps) {
        HashMap<String, Map<String, Object>> stdFieldParamMap = new HashMap<String, Map<String, Object>>(16);
        Map<String, EntryParamContainer> allContainerMap = allContainer.stream().collect(Collectors.toMap(EntryParamContainer::getKey, con -> con, (v1, v2) -> v1));
        Map<String, Object> tempParam = null;
        for (int i = 0; i < stdFieldParamMaps.size(); ++i) {
            tempParam = stdFieldParamMaps.get(i);
            String pkey = String.valueOf(tempParam.get("key"));
            stdFieldParamMap.put(pkey, tempParam);
            EntryParamContainer paramContainer = allContainerMap.get(pkey);
            if (paramContainer == null) continue;
            allContainer.remove(paramContainer);
            allContainer.add(i, paramContainer);
        }
        HashSet<String> notMustInputFields = new HashSet<String>(16);
        for (EntryParamContainer container : allContainer) {
            Map extParam = (Map)stdFieldParamMap.get(container.getKey());
            if (extParam == null) continue;
            FieldParamContainer tempContainer = (FieldParamContainer)container;
            tempContainer.setName((String)extParam.get("name"));
            tempContainer.setLock((String)extParam.get("lock"));
            tempContainer.setVisible((String)extParam.get("visible"));
            tempContainer.setWidth((String)extParam.get("width"));
            tempContainer.setTextAlign((String)extParam.get("textAlign"));
            tempContainer.setMustInput(((Boolean)extParam.get("mustInput")).booleanValue());
            tempContainer.setMask((String)extParam.get("mask"));
            Boolean tplNotMustInput = (Boolean)extParam.get("tplNotMustInput");
            if (tplNotMustInput == null || !tplNotMustInput.booleanValue()) continue;
            notMustInputFields.add((String)extParam.get("key"));
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put("tplNotMustInput", SerializationUtils.toJsonString(notMustInputFields));
        }
    }

    private Integer findFieldIndexByKey(List<EntryParamContainer> allContainer, String addAfterKey) {
        for (int i = 0; i < allContainer.size(); ++i) {
            if (!allContainer.get(i).getKey().equals(addAfterKey)) continue;
            return i;
        }
        return null;
    }

    private List<Map<String, Object>> invokeAfterAddFieldContainer(AfterAddFieldContainerEvent args) {
        BizDataBillEntryExtService ExtService = new BizDataBillEntryExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataBillEntryExtService.class, (String)"kd.sdk.swc.hpdi.business.extpoint.bizdatabill.IBizDataBillEntryExtService#afterAddFieldContainer", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterAddFieldContainer(args);
            return null;
        });
        return args.getFieldParamMaps();
    }

    private void addBizRuleContainer(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata, DynamicObjectCollection bizDataRuleFields, List<String> empFields) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("key", "empposorgrel");
        map.put("name", HPDIResMgrFormPlugin.getNameOfEmpposorgrel());
        map.put("lock", "submit,audit");
        map.put("mustInput", Boolean.FALSE);
        map.put("baseEntityId", "hrpi_empposorgrel");
        FieldParamContainer empContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, map);
        empContainer.setHidden(true);
        allContainer.add((EntryParamContainer)empContainer);
        if (null == bizDataRuleFields || bizDataRuleFields.size() == 0) {
            return;
        }
        boolean bizDateMustInput = false;
        for (DynamicObject field : bizDataRuleFields) {
            FieldParamContainer container;
            String key = field.getString("bizobjruleconf.number");
            if ("bizdate".equals(key)) {
                bizDateMustInput = "0".equals(field.getString("fillmode"));
                continue;
            }
            String newKey = key;
            if (newKey.contains(".")) {
                newKey = BizDataBillEntryHelper.getNewKey((String)newKey);
            }
            HashMap<String, Object> empMap = new HashMap<String, Object>(16);
            empMap.put("key", newKey);
            empMap.put("name", field.getString("bizobjruleconf.name"));
            empMap.put("lock", "new,edit,view,submit,audit");
            empMap.put("mustInput", "0".equals(field.getString("fillmode")));
            empMap.put("width", "160");
            switch (newKey) {
                case "startdate": 
                case "enddate": {
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1050_S", (EntityMetadata)entityMetadata, empMap);
                    empFields.add(key);
                    break;
                }
                case "apositiontype": {
                    Pair relationPair1 = new Pair((Object)"0", (Object)HPDIResMgrFormPlugin.getPairNameOfPosition0());
                    Pair relationPair2 = new Pair((Object)"1", (Object)HPDIResMgrFormPlugin.getPairNameOfPosition1());
                    Pair relationPair3 = new Pair((Object)"2", (Object)HPDIResMgrFormPlugin.getPairNameOfPosition2());
                    empMap.put("pairs", new Pair[]{relationPair1, relationPair2, relationPair3});
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, empMap);
                    empFields.add(key);
                    break;
                }
                case "isprimary": {
                    Pair primaryPair1 = new Pair((Object)"0", (Object)HPDIResMgrFormPlugin.getPairNameOfIsPrimary1());
                    Pair primaryPair2 = new Pair((Object)"1", (Object)HPDIResMgrFormPlugin.getPairNameOfIsPrimary0());
                    empMap.put("pairs", new Pair[]{primaryPair1, primaryPair2});
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, empMap);
                    empFields.add(key);
                    break;
                }
                case "person_name": {
                    empMap.put("key", "person");
                    empMap.put("baseEntityId", "hrpi_person");
                    empMap.put("viewDetail", Boolean.FALSE);
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    break;
                }
                case "adminorg_number": {
                    empMap.put("key", "entadminorg");
                    empMap.put("baseEntityId", "haos_adminorghr");
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    break;
                }
                case "job_number": {
                    empMap.put("key", "job");
                    empMap.put("baseEntityId", "hbjm_jobhr");
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    empFields.add("job");
                    break;
                }
                case "company_number": {
                    empMap.put("key", "company");
                    empMap.put("baseEntityId", "haos_adminorghr");
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    empFields.add("company");
                    break;
                }
                case "postype_number": {
                    empMap.put("key", "postype");
                    empMap.put("baseEntityId", "hbss_postype");
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    empFields.add("postype");
                    break;
                }
                case "position_number": {
                    empMap.put("key", "position");
                    empMap.put("baseEntityId", "hbpm_positionhr");
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, empMap);
                    empFields.add("position");
                    break;
                }
                default: {
                    container = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, empMap);
                    empFields.add(key);
                }
            }
            allContainer.add((EntryParamContainer)container);
        }
        HashMap<String, Object> bizDateMap = new HashMap<String, Object>(16);
        bizDateMap.put("key", "bizdate");
        bizDateMap.put("name", HPDIResMgrFormPlugin.getNameOfBizDate());
        bizDateMap.put("lock", "view,submit,audit");
        bizDateMap.put("width", "140");
        bizDateMap.put("mustInput", bizDateMustInput);
        FieldParamContainer bizDateContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1050_S", (EntityMetadata)entityMetadata, bizDateMap);
        allContainer.add((EntryParamContainer)bizDateContainer);
        HashMap<String, Object> bizDataDimMap = new HashMap<String, Object>(16);
        bizDataDimMap.put("key", "bizdatadim");
        bizDataDimMap.put("name", HPDIResMgrFormPlugin.getNameOfBizDataDim());
        bizDataDimMap.put("lock", "submit,audit");
        bizDataDimMap.put("mustInput", Boolean.FALSE);
        bizDataDimMap.put("viewDetail", Boolean.FALSE);
        bizDataDimMap.put("baseEntityId", "hsbs_bizdatadim");
        FieldParamContainer bizDataDimContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, bizDataDimMap);
        allContainer.add((EntryParamContainer)bizDataDimContainer);
    }

    private void addBizItemContainer(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata, List<DynamicObject> bizItems, String showType) {
        if (CollectionUtils.isEmpty(bizItems)) {
            return;
        }
        if ("2".equals(showType)) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            for (DynamicObject item : bizItems) {
                String dataType;
                itemMap.put("key", item.getString("bizitem.number").toLowerCase());
                itemMap.put("name", item.getString("bizitem.name"));
                itemMap.put("lock", "submit,audit");
                itemMap.put("mustInput", Boolean.FALSE);
                itemMap.put("scaleLimit", item.getInt("bizitem.scalelimit"));
                itemMap.put("width", "150");
                Date erliestDate = BizDataHelper.getMaxDate((Date)item.getDate("bizitem.earliestdate"), (Date)item.getDate("submitstartdate"));
                Date lastDate = BizDataHelper.getMinDate((Date)item.getDate("bizitem.lastdate"), (Date)item.getDate("submitenddate"));
                if (null != erliestDate) {
                    itemMap.put("minDate", SWCDateTimeUtils.format((Date)erliestDate));
                }
                if (null != lastDate) {
                    itemMap.put("maxDate", SWCDateTimeUtils.format((Date)lastDate));
                }
                if ("1010_S".equals(dataType = item.getString("bizitem.datatype.number")) || "1020_S".equals(dataType)) {
                    dataType = "1030_S";
                }
                FieldParamContainer itemContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)dataType, (EntityMetadata)entityMetadata, itemMap);
                allContainer.add((EntryParamContainer)itemContainer);
            }
        } else {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            itemMap.put("key", "bizitem");
            itemMap.put("name", HPDIResMgrFormPlugin.getNameOfBizItem());
            itemMap.put("lock", "submit,audit");
            itemMap.put("mustInput", Boolean.TRUE);
            itemMap.put("baseEntityId", "hsbs_bizitem");
            FieldParamContainer itemContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, itemMap);
            allContainer.add((EntryParamContainer)itemContainer);
            HashMap<String, Object> vMap = new HashMap<String, Object>(16);
            vMap.put("key", "value");
            vMap.put("name", HPDIResMgrFormPlugin.getNameOfValue());
            vMap.put("lock", "submit,audit");
            vMap.put("mustInput", Boolean.TRUE);
            vMap.put("width", "150");
            FieldParamContainer valueContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, vMap);
            allContainer.add((EntryParamContainer)valueContainer);
        }
    }

    private void addFixedFieldContainer(List<EntryParamContainer> allContainer, EntityMetadata entityMetadata) {
        Pair relationPair1 = new Pair((Object)"A", (Object)HPDIResMgrFormPlugin.getPairNameOfRelationData0());
        Pair relationPair2 = new Pair((Object)"B", (Object)"");
        Pair relationPair3 = new Pair((Object)"C", (Object)HPDIResMgrFormPlugin.getPairNameOfRelationData1());
        HashMap<String, Object> rdMap = new HashMap<String, Object>(16);
        rdMap.put("key", "relationdata");
        rdMap.put("name", HPDIResMgrFormPlugin.getNameOfRelationData());
        rdMap.put("lock", "new,edit,view,submit,audit");
        rdMap.put("mustInput", Boolean.FALSE);
        rdMap.put("pairs", new Pair[]{relationPair1, relationPair2, relationPair3});
        FieldParamContainer relationDataContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, rdMap);
        relationDataContainer.setHyperlink(true);
        allContainer.add((EntryParamContainer)relationDataContainer);
        HashMap<String, Object> curMap = new HashMap<String, Object>(16);
        curMap.put("key", "currency");
        curMap.put("name", HPDIResMgrFormPlugin.getNameOfCurrency());
        curMap.put("lock", "submit,audit");
        curMap.put("mustInput", Boolean.FALSE);
        curMap.put("width", "120");
        curMap.put("baseEntityId", "bd_currency");
        FieldParamContainer currencyContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, curMap);
        allContainer.add((EntryParamContainer)currencyContainer);
        HashMap<String, Object> calMap = new HashMap<String, Object>(16);
        calMap.put("key", "calfrequency");
        calMap.put("name", HPDIResMgrFormPlugin.getNameOfCalFrequency());
        calMap.put("lock", "submit,audit");
        calMap.put("mustInput", Boolean.FALSE);
        calMap.put("width", "120");
        calMap.put("baseEntityId", "hsbs_calfrequency");
        FieldParamContainer freqContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, calMap);
        allContainer.add((EntryParamContainer)freqContainer);
        HashMap<String, Object> efMap = new HashMap<String, Object>(16);
        efMap.put("key", "effectivedate");
        efMap.put("name", HPDIResMgrFormPlugin.getNameOfEffectiveDate());
        efMap.put("lock", "submit,audit");
        efMap.put("mustInput", Boolean.TRUE);
        efMap.put("width", "140");
        FieldParamContainer startContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1050_S", (EntityMetadata)entityMetadata, efMap);
        allContainer.add((EntryParamContainer)startContainer);
        HashMap<String, Object> exMap = new HashMap<String, Object>(16);
        exMap.put("key", "expirydate");
        exMap.put("name", HPDIResMgrFormPlugin.getNameOfExpireDate());
        exMap.put("lock", "submit,audit");
        exMap.put("mustInput", Boolean.FALSE);
        exMap.put("width", "140");
        FieldParamContainer endContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1050_S", (EntityMetadata)entityMetadata, exMap);
        allContainer.add((EntryParamContainer)endContainer);
        HashMap<String, Object> ueMap = new HashMap<String, Object>(16);
        ueMap.put("key", "updateexpirydate");
        ueMap.put("name", HPDIResMgrFormPlugin.getNameOfUpdateExpireDate());
        ueMap.put("lock", "submit,audit");
        ueMap.put("mustInput", Boolean.FALSE);
        ueMap.put("width", "140");
        FieldParamContainer updateExpiryDateContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1050_S", (EntityMetadata)entityMetadata, ueMap);
        allContainer.add((EntryParamContainer)updateExpiryDateContainer);
        HashMap<String, Object> udMap = new HashMap<String, Object>(16);
        udMap.put("key", "updateddesc");
        udMap.put("name", HPDIResMgrFormPlugin.getNameOfUpdateDesc());
        udMap.put("lock", "submit,audit");
        udMap.put("mustInput", Boolean.FALSE);
        FieldParamContainer updatedDescContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, udMap);
        allContainer.add((EntryParamContainer)updatedDescContainer);
        HashMap<String, Object> rMap = new HashMap<String, Object>(16);
        rMap.put("key", "remark");
        rMap.put("name", HPDIResMgrFormPlugin.getNameOfRemark());
        rMap.put("lock", "submit,audit");
        rMap.put("mustInput", Boolean.FALSE);
        FieldParamContainer remarkContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, rMap);
        allContainer.add((EntryParamContainer)remarkContainer);
        Pair dasPair1 = new Pair((Object)"1", (Object)HPDIResMgrFormPlugin.getPairNameOfDataApproveStatus0());
        Pair dasPair2 = new Pair((Object)"2", (Object)"");
        HashMap<String, Object> dasMap = new HashMap<String, Object>(16);
        dasMap.put("key", "dataapprovestatus");
        dasMap.put("name", HPDIResMgrFormPlugin.getNameOfDataApproveStatus());
        dasMap.put("lock", "new,edit,view,submit,audit");
        dasMap.put("mustInput", Boolean.FALSE);
        dasMap.put("pairs", new Pair[]{dasPair1, dasPair2});
        FieldParamContainer dataApproveStatusContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, dasMap);
        allContainer.add((EntryParamContainer)dataApproveStatusContainer);
        HashMap<String, Object> adMap = new HashMap<String, Object>(16);
        adMap.put("key", "approvedesc");
        adMap.put("name", HPDIResMgrFormPlugin.getNameOfApproveDesc());
        adMap.put("lock", "new,edit,view,submit,audit");
        adMap.put("mustInput", Boolean.FALSE);
        FieldParamContainer approveDescContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, adMap);
        allContainer.add((EntryParamContainer)approveDescContainer);
        Pair bdsPair1 = new Pair((Object)"1", (Object)HPDIResMgrFormPlugin.getPairNameOfBizDataStatus0());
        Pair bdsPair2 = new Pair((Object)"2", (Object)HPDIResMgrFormPlugin.getPairNameOfBizDataStatus1());
        HashMap<String, Object> bdsMap = new HashMap<String, Object>(16);
        bdsMap.put("key", "bizdatastatus");
        bdsMap.put("name", HPDIResMgrFormPlugin.getNameOfBizDataStatus());
        bdsMap.put("lock", "submit,audit");
        bdsMap.put("mustInput", Boolean.FALSE);
        bdsMap.put("pairs", new Pair[]{bdsPair1, bdsPair2});
        FieldParamContainer bizDataStatusContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, bdsMap);
        allContainer.add((EntryParamContainer)bizDataStatusContainer);
        Pair btsPair1 = new Pair((Object)BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode(), (Object)BizDataStatusEnum.TO_BE_PUSH_SALARY.getDesc());
        Pair btsPair2 = new Pair((Object)BizDataStatusEnum.PUSHING_SALARY.getCode(), (Object)BizDataStatusEnum.PUSHING_SALARY.getDesc());
        Pair btsPair3 = new Pair((Object)BizDataStatusEnum.PUSHED_SALARY.getCode(), (Object)BizDataStatusEnum.PUSHED_SALARY.getDesc());
        Pair btsPair4 = new Pair((Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode(), (Object)BizDataStatusEnum.PUSHED_SALARY_FAIL.getDesc());
        Pair btsPair5 = new Pair((Object)BizDataStatusEnum.DISABLED.getCode(), (Object)BizDataStatusEnum.DISABLED.getDesc());
        Pair btsPair6 = new Pair((Object)BizDataStatusEnum.SALARY_REJECT.getCode(), (Object)BizDataStatusEnum.SALARY_REJECT.getDesc());
        Pair btsPair7 = new Pair((Object)BizDataStatusEnum.WITHDRAWN.getCode(), (Object)BizDataStatusEnum.WITHDRAWN.getDesc());
        Pair btsPair8 = new Pair((Object)BizDataStatusEnum.HSAS_DISABLED.getCode(), (Object)BizDataStatusEnum.HSAS_DISABLED.getDesc());
        HashMap<String, Object> btsMap = new HashMap<String, Object>(16);
        btsMap.put("key", "enttranssalarystatus");
        btsMap.put("name", HPDIResMgrFormPlugin.getNameOfTransSalaryStatus());
        btsMap.put("lock", "new,edit,view,submit,audit");
        btsMap.put("mustInput", Boolean.FALSE);
        btsMap.put("pairs", new Pair[]{btsPair1, btsPair2, btsPair3, btsPair4, btsPair5, btsPair6, btsPair7, btsPair8});
        FieldParamContainer transSalaryStatusContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, btsMap);
        allContainer.add((EntryParamContainer)transSalaryStatusContainer);
        HashMap<String, Object> eMap = new HashMap<String, Object>(16);
        eMap.put("key", "errormsg");
        eMap.put("name", HPDIResMgrFormPlugin.getNameOfErrorMsg());
        eMap.put("lock", "submit,audit");
        eMap.put("mustInput", Boolean.FALSE);
        FieldParamContainer errorMsgContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, eMap);
        allContainer.add((EntryParamContainer)errorMsgContainer);
        Pair sePair1 = new Pair((Object)"1", (Object)HPDIResMgrFormPlugin.getPairNameOfSubmitError0());
        Pair sePair2 = new Pair((Object)"2", (Object)HPDIResMgrFormPlugin.getPairNameOfSubmitError1());
        Pair sePair3 = new Pair((Object)"3", (Object)HPDIResMgrFormPlugin.getPairNameOfSubmitError2());
        Pair sePair6 = new Pair((Object)"6", (Object)HPDIResMgrFormPlugin.getPairNameOfSubmitError5());
        Pair sePair7 = new Pair((Object)"7", (Object)HPDIResMgrFormPlugin.getPairNameOfSubmitError6());
        HashMap<String, Object> seMap = new HashMap<String, Object>(16);
        seMap.put("key", "submiterror");
        seMap.put("name", HPDIResMgrFormPlugin.getNameOfSubmitError());
        seMap.put("lock", "submit,audit");
        seMap.put("mustInput", Boolean.FALSE);
        seMap.put("pairs", new Pair[]{sePair1, sePair2, sePair3, sePair7, sePair6});
        FieldParamContainer submitErrorContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"COMBO", (EntityMetadata)entityMetadata, seMap);
        allContainer.add((EntryParamContainer)submitErrorContainer);
        HashMap<String, Object> bMap = new HashMap<String, Object>(16);
        bMap.put("key", "bizdatacode");
        bMap.put("name", HPDIResMgrFormPlugin.getNameOfBizDataCode());
        bMap.put("lock", "new,edit,view,submit,audit");
        bMap.put("mustInput", Boolean.FALSE);
        bMap.put("width", "350");
        FieldParamContainer bizDataNumContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, bMap);
        allContainer.add((EntryParamContainer)bizDataNumContainer);
        HashMap<String, Object> obMap = new HashMap<String, Object>(16);
        obMap.put("key", "originalbizdatacode");
        obMap.put("name", HPDIResMgrFormPlugin.getNameOfOriginalBizDataCode());
        obMap.put("lock", "new,edit,view,submit,audit");
        obMap.put("mustInput", Boolean.FALSE);
        FieldParamContainer originalBizDataCodeContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1030_S", (EntityMetadata)entityMetadata, obMap);
        allContainer.add((EntryParamContainer)originalBizDataCodeContainer);
        HashMap<String, Object> sfMap = new HashMap<String, Object>(16);
        sfMap.put("key", "salaryfile");
        sfMap.put("name", HPDIResMgrFormPlugin.getNameOfSalaryFile());
        sfMap.put("lock", "submit,audit");
        sfMap.put("mustInput", Boolean.FALSE);
        sfMap.put("baseEntityId", "hsas_salaryfile");
        FieldParamContainer salaryFileContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, sfMap);
        salaryFileContainer.setHidden(true);
        allContainer.add((EntryParamContainer)salaryFileContainer);
        HashMap<String, Object> pgMap = new HashMap<String, Object>(16);
        pgMap.put("key", "payrollgrp");
        pgMap.put("name", HPDIResMgrFormPlugin.getNameOfPayrollGrp());
        pgMap.put("lock", "submit,audit");
        pgMap.put("mustInput", Boolean.FALSE);
        pgMap.put("baseEntityId", "hsas_payrollgrp");
        FieldParamContainer payrollContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"BASEDATA", (EntityMetadata)entityMetadata, pgMap);
        payrollContainer.setHidden(true);
        allContainer.add((EntryParamContainer)payrollContainer);
        HashMap<String, Object> sumMap = new HashMap<String, Object>(16);
        sumMap.put("key", "sumcol");
        sumMap.put("name", "sumcol");
        sumMap.put("lock", "new,edit,view,submit,audit");
        sumMap.put("mustInput", Boolean.FALSE);
        sumMap.put("scaleLimit", 0);
        FieldParamContainer noneContainer = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.createContainer((String)"1010_S", (EntityMetadata)entityMetadata, sumMap);
        allContainer.add((EntryParamContainer)noneContainer);
    }

    private void rewriteEntryGrid() {
        Long bizItemGroupId = this.getBizItemGroupId(this.getView().getFormShowParameter());
        this.rewriteEntryGridControl(bizItemGroupId);
        this.createDynamicEntryColumn(bizItemGroupId);
    }

    private void createDynamicEntryColumn(Long bizItemGroupId) {
        Control rootControl = this.getView().getRootControl();
        EntryGrid oldGrid = (EntryGrid)kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.findControl(Collections.singletonList(rootControl), (String)"entryentity");
        List<Long> mulBizItemIds = this.getMulBizItemIds(this.getView().getFormShowParameter());
        List<EntryParamContainer> entryApBuildParam = this.createEntryBuildParamForTabular(this.getView(), bizItemGroupId, mulBizItemIds, this.getView().getFormShowParameter().getCustomParams());
        EntryAp entryAp2 = EntryParamContainerBaseHelper.createControlAp(entryApBuildParam);
        oldGrid.getItems().clear();
        oldGrid.getItems().addAll(((Container)entryAp2.buildRuntimeControl()).getItems());
        kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.setControlView((List)oldGrid.getItems(), (IFormView)this.getView());
        oldGrid.endInit();
    }

    private void rewriteEntryGridControl(Long bizItemGroupId) {
        Container container = (Container)this.getControl("flexpanelap6");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hpdi_bizdatabillent", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List<Long> mulBizItemIds = this.getMulBizItemIds(this.getView().getFormShowParameter());
        List<EntryParamContainer> createEntryBuildParam = this.createEntryBuildParamForTabular(this.getView(), bizItemGroupId, mulBizItemIds, this.getView().getFormShowParameter().getCustomParams());
        EntryAp entryAp = EntryParamContainerBaseHelper.createControlAp(createEntryBuildParam);
        entryAp.setShowSeq(true);
        entryAp.setOrderAndFilter(0);
        BizDataBillEntryGrid grid = new BizDataBillEntryGrid();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        if ("hpdi_bizdatabillnewentry".equals(this.getView().getFormShowParameter().getFormId())) {
            grid.setSplitPage(false);
        } else {
            grid.setSplitPage(true);
        }
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.setControlView((List)grid.getItems(), (IFormView)this.getView());
        grid.setView(this.getView());
        grid.endInit();
        grid.endInit();
        int index = kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.findControlIndex((List)container.getItems(), (String)"entryentity");
        if (index >= 0) {
            container.getItems().add(index, grid);
        }
        this.getView().createControlIndex(Collections.singletonList(grid));
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        grid.initGridConfig(map);
    }

    private EntryGrid rewriteEntryGridControl(Control oldGrid) {
        BizDataBillEntryGrid entryGrid = new BizDataBillEntryGrid();
        entryGrid.setView(this.getView());
        entryGrid.setKey("entryentity");
        entryGrid.setEntryKey("entryentity");
        if ("hpdi_bizdatabillnewentry".equals(this.getView().getFormShowParameter().getFormId())) {
            entryGrid.setSplitPage(false);
        } else {
            entryGrid.setSplitPage(true);
        }
        if (oldGrid == null) {
            this.findControl("entryentity");
        }
        if (oldGrid instanceof EntryGrid) {
            entryGrid.setPageRow(((EntryGrid)oldGrid).getPageRow());
            entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
        }
        return entryGrid;
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return kd.swc.hpdi.business.helper.BizDataBillEntryGridHelper.findControl((List)root.getItems(), (String)key);
    }

    private void setEntryGridControlIndex(EntryGrid entryGrid, IFormView formView) {
        Container advconchildpanelap = (Container)this.findControl("flexpanelap6");
        if (advconchildpanelap == null) {
            return;
        }
        List items = advconchildpanelap.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Control item = (Control)items.get(i);
            if (!"entryentity".equals(item.getKey())) continue;
            advconchildpanelap.getItems().set(i, entryGrid);
        }
        formView.createControlIndex(advconchildpanelap.getItems());
    }

    private StringBuilder getEntrySelectRowIds() {
        BizDataBillEntryGrid entryGrid = (BizDataBillEntryGrid)this.getControl("entryentity");
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        int[] selectRows = entryGrid.getSelectRows();
        StringBuilder selectRowIdsb = new StringBuilder();
        if (selectRows != null && selectRows.length != 0) {
            for (int index : selectRows) {
                Long id;
                if (selectRowIdsb.length() != 0) {
                    selectRowIdsb.append(',');
                }
                if ((id = Long.valueOf(dataEntitys[index].getLong("id"))) == 0L) continue;
                selectRowIdsb.append(id);
            }
        }
        return selectRowIdsb;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportStartCloseCallBack")) {
            this.getView().invokeOperation("refresh");
            BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
        }
    }

    private void openImportWindow(IFormView formView, IFormPlugin source, String caption) {
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setFormId("hpdi_bizbillimportstart");
        importShowParameter.setCloseCallBack(new CloseCallBack(source, "ImportStartCloseCallBack"));
        importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)caption)) {
            importShowParameter.setCaption(caption);
        }
        importShowParameter.setCustomParam("entryview", (Object)formView.getPageId());
        importShowParameter.setCustomParam("entityid", (Object)formView.getEntityId());
        importShowParameter.setCustomParam("entrykey", (Object)"entryentity");
        this.addFormShowParameterForImport(importShowParameter);
        formView.showForm(importShowParameter);
    }

    private void addFormShowParameterForImport(FormShowParameter importShowParameter) {
        Map<String, Object> paramMap = this.getFormShowParameterMapForImport();
        importShowParameter.getCustomParams().putAll(paramMap);
        IFormView billView = this.getView();
        FormShowParameter formShowParameter = billView.getFormShowParameter();
        formShowParameter.getCustomParams().putAll(paramMap);
        billView.cacheFormShowParameter();
    }

    private void addFormShowParameterForExportByTpl() {
        Map<String, Object> paramMap = this.getFormShowParameterMapForImport();
        IFormView billView = this.getView();
        FormShowParameter formShowParameter = billView.getFormShowParameter();
        formShowParameter.getCustomParams().putAll(paramMap);
        billView.cacheFormShowParameter();
    }

    private Map<String, Object> getFormShowParameterMapForImport() {
        List itemList;
        List resultList;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        IFormView billView = this.getView();
        DynamicObject billDy = billView.getModel().getDataEntity();
        Long bizDataBillId = billDy.getLong("id");
        Long bizItemGroupId = billDy.getLong("bizitemgroup.id");
        String modelType = billDy.getString("bizitemgroup.modeltype");
        paramMap.put("bizDataBillId", bizDataBillId);
        paramMap.put("bizDataBillNo", billDy.getString("billno"));
        paramMap.put("bizItemGroupId", bizItemGroupId);
        paramMap.put("modelType", modelType);
        paramMap.put("billType", billDy.getString("billtype"));
        Map<String, Map<String, Object>> entryEntityPropMap = BizDataBillEntryImportHelper.getEntryEntityProp(billView.getModel());
        paramMap.put("entryEntityPropMap", SerializationUtils.serializeToBase64(entryEntityPropMap));
        Set<String> notFillInFields = this.getObjRuleNotFillInFields(billDy.getLong("bizitemgroup.bizdataobjrule.id"));
        paramMap.put("notFillInFieldSet", SerializationUtils.serializeToBase64(notFillInFields));
        paramMap.put("currencyFillType", billDy.getString("bizitemgroup.currencyfilltype"));
        DynamicObject bizDataRuleObj = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup((DynamicObject)billDy.getDynamicObject("bizitemgroup"));
        paramMap.put("matchrule", bizDataRuleObj.getString("matchrule"));
        paramMap.put("orgId", billView.getModel().getDataEntity().getLong("org.id"));
        Map bizItemGroupMap = BizDataHelper.getBizItemGroupMapById((DynamicObject)billDy.getDynamicObject("bizitemgroup"));
        if (bizItemGroupMap != null && MapUtils.getBoolean((Map)bizItemGroupMap, (Object)"success").booleanValue() && CollectionUtils.isNotEmpty((Collection)(resultList = (List)bizItemGroupMap.get("result"))) && CollectionUtils.isNotEmpty((Collection)(itemList = (List)((Map)resultList.get(0)).get("bizitem")))) {
            paramMap.put("isCycle", MapUtils.getBoolean((Map)((Map)itemList.get(0)), (Object)"cycle"));
        }
        return paramMap;
    }

    private void addDeleteEntryIdsToCache(FormOperate formOperate) {
        String deleteentryidsVar = formOperate.getOption().getVariableValue("deleteentryids", null);
        String deleteentryidsCache = this.getView().getPageCache().get("deleteentryids");
        deleteentryidsCache = deleteentryidsCache == null ? deleteentryidsVar : deleteentryidsCache + "," + deleteentryidsVar;
        this.getView().getPageCache().put("deleteentryids", deleteentryidsCache);
    }

    private void addBizitemFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter qFilter;
        List resultList;
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        DynamicObject bizItemGroup = (DynamicObject)this.getModel().getValue("bizitemgroup");
        DynamicObjectCollection bizItemColl = bizItemGroup.getDynamicObjectCollection("entryentity");
        ArrayList filterItemList = new ArrayList(10);
        bizItemColl.forEach(bizItem -> filterItemList.add(bizItem.getLong("bizitem.id")));
        Map bizItemGroupMap = BizDataHelper.getBizItemGroupMapById((DynamicObject)bizItemGroup);
        HashMap bizDataMaxInputTimeMap = new HashMap();
        ArrayList<Long> cycleBizItemIds = new ArrayList<Long>(10);
        if (bizItemGroupMap != null && MapUtils.getBoolean((Map)bizItemGroupMap, (Object)"success").booleanValue() && (resultList = (List)bizItemGroupMap.get("result")) != null) {
            for (Map bizItemMap : resultList) {
                List itemList = (List)bizItemMap.get("bizitem");
                itemList.forEach(item -> {
                    Long bizItemId = MapUtils.getLong((Map)item, (Object)"bizitemid");
                    bizDataMaxInputTimeMap.put(bizItemId, MapUtils.getInteger((Map)item, (Object)"maxinputtime"));
                    if (MapUtils.getBoolean((Map)item, (Object)"cycle").booleanValue()) {
                        cycleBizItemIds.add(bizItemId);
                    }
                });
            }
        }
        if (bizDataMaxInputTimeMap.isEmpty()) {
            qFilter = new QFilter("id", "=", null);
        } else {
            int rowIndex = beforeF7SelectEvent.getRow();
            int startRowIndex = BizDataBillEntryHelper.getCurrentPageStartRowIndex((IFormView)this.getView());
            int dataIndex = rowIndex - startRowIndex;
            DynamicObject entry = (DynamicObject)entryEntities.get(dataIndex);
            DynamicObject calPeriod = (DynamicObject)this.getModel().getValue("calperiod");
            Long empPosOrgRelId = entry.getDynamicObject("empposorgrel").getLong("id");
            Map itemAndBizDataMap = BizDataHelper.getSubmittedDataMap(filterItemList, (DynamicObject)calPeriod, (Long)empPosOrgRelId);
            Long currentDataEntityId = this.getModel().getDataEntity().getLong("id");
            BizDataHelper.getUnSubmittedDataMap(filterItemList, (DynamicObject)calPeriod, (Long)empPosOrgRelId, (Map)itemAndBizDataMap, (Long)currentDataEntityId, (IFormView)this.getView());
            HashBasedTable currentDataEntityItemTable = HashBasedTable.create();
            boolean isAddEntryShowForm = "hpdi_bizdatabillnewentry".equals(this.getView().getFormShowParameter().getFormId());
            if (isAddEntryShowForm) {
                currentDataEntityItemTable = BizDataHelper.getCurrentDataEntityItemMap((DynamicObjectCollection)entryEntities);
            }
            if (CollectionUtils.isNotEmpty(cycleBizItemIds)) {
                this.getBillBizDataCycle((Table<Long, Long, List<DynamicObject>>)currentDataEntityItemTable, currentDataEntityId, empPosOrgRelId, cycleBizItemIds, isAddEntryShowForm);
            }
            List needRemoveItemIdList = BizDataHelper.getNeedRemoveItemIdList((DynamicObjectCollection)bizItemColl, bizDataMaxInputTimeMap, (Map)itemAndBizDataMap, (Table)currentDataEntityItemTable, (Long)empPosOrgRelId);
            filterItemList.removeAll(needRemoveItemIdList);
            qFilter = new QFilter("id", "in", filterItemList);
        }
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    private Long getBizItemGroupIdByBillId(Long bizDataBillId) {
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        DynamicObject dynamicObject = helper.queryOriginalOne("bizitemgroup.id", (Object)bizDataBillId);
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5\u3002", (String)"BizDataBillEntryPlugin_59", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        }
        return dynamicObject.getLong("bizitemgroup.id");
    }

    private Long getBizItemGroupId(Object param) {
        Long bizItemGroupId = null;
        if (param instanceof BillShowParameter) {
            BillShowParameter billShowParameter = (BillShowParameter)param;
            Object pkIdObj = billShowParameter.getPkId();
            if (pkIdObj != null) {
                Long bizDataBillId = Long.parseLong(String.valueOf(pkIdObj));
                bizItemGroupId = this.getBizItemGroupIdByBillId(bizDataBillId);
            } else {
                bizItemGroupId = (Long)billShowParameter.getCustomParam("bizItemGroupId");
                if (bizItemGroupId == null) {
                    bizItemGroupId = (Long)billShowParameter.getCustomParam("bizitemgroup");
                }
            }
        } else if (param instanceof FormShowParameter) {
            FormShowParameter formShowParameter = (FormShowParameter)param;
            bizItemGroupId = (Long)formShowParameter.getCustomParam("bizItemGroupId");
        }
        if (this.getView() != null) {
            this.getView().getFormShowParameter().setCustomParam("bizItemGroupId", (Object)bizItemGroupId);
        }
        return bizItemGroupId;
    }

    private void getBillBizDataCycle(Table<Long, Long, List<DynamicObject>> dataEntityItemTable, Long bizDataBillId, Long empPosOrgRelId, List<Long> cycleBizItemIds, boolean isAddEntryShowForm) {
        DynamicObjectCollection dys;
        String deleteEntryIdsStr;
        QFilter qFilter = new QFilter("bizdatabillid", "=", (Object)bizDataBillId);
        qFilter.and("empposorgrel", "=", (Object)empPosOrgRelId);
        qFilter.and("entryentity.bizitem", "in", cycleBizItemIds);
        if (!isAddEntryShowForm && null != (deleteEntryIdsStr = this.getView().getPageCache().get("deleteentryids"))) {
            String[] deleteEntryIdStrArray = deleteEntryIdsStr.split(",");
            ArrayList<Long> deleteEntryIds = new ArrayList<Long>(deleteEntryIdStrArray.length);
            for (String entryId : deleteEntryIdStrArray) {
                deleteEntryIds.add(Long.valueOf(entryId));
            }
            qFilter.and("id", "not in", deleteEntryIds);
        }
        if (CollectionUtils.isEmpty((Collection)(dys = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.queryOriginalCollection("id, bizdatabillid, bizdatacode, empposorgrel, entryentity.bizitem.id", qFilter.toArray())))) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hpdi_bizdatabill_entry_changed_%s", bizDataBillId));
        Set changedEntryIds = (Set)appCache.get("changed_entry_id_collection", HashSet.class);
        ArrayList<DynamicObject> bizItemList = null;
        for (DynamicObject dy : dys) {
            Long bizItemId = dy.getLong("entryentity.bizitem.id");
            DynamicObject obj = dy;
            if (!isAddEntryShowForm) {
                boolean isChangedRow;
                boolean bl = isChangedRow = CollectionUtils.isNotEmpty((Collection)changedEntryIds) && changedEntryIds.contains(dy.getLong("id"));
                if (isChangedRow) {
                    obj = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(String.valueOf(dy.getLong("id")), String.class)));
                    bizItemId = obj.getLong("bizitem.id");
                }
            }
            if (null == bizItemId || 0L == bizItemId) continue;
            bizItemList = (ArrayList<DynamicObject>)dataEntityItemTable.get((Object)empPosOrgRelId, (Object)bizItemId);
            if (bizItemList == null) {
                bizItemList = new ArrayList<DynamicObject>();
            }
            bizItemList.add(obj);
            dataEntityItemTable.put((Object)empPosOrgRelId, (Object)bizItemId, bizItemList);
        }
    }

    private void deleteUpdateEntryToCache(FormOperate formOperate) {
        String deleteentryidsVar = formOperate.getOption().getVariableValue("deleteentryids", null);
        if (null == deleteentryidsVar) {
            return;
        }
        String[] deleteEntryIdsVar = deleteentryidsVar.split(",");
        ArrayList<Long> deleteEntryIds = new ArrayList<Long>(deleteEntryIdsVar.length);
        for (String idVar : deleteEntryIdsVar) {
            deleteEntryIds.add(Long.valueOf(idVar));
        }
        BizDataBillEntryHelper.removeEntryDataCache((boolean)false, (Long)this.getModel().getDataEntity().getLong("id"), deleteEntryIds);
    }

    private void setUserDefinedColor(int rowIndex) {
        DynamicObjectCollection bizDataBillEntry = this.getModel().getEntryEntity("entryentity");
        IClientViewProxy clientService = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (DynamicObject bizDataDy : bizDataBillEntry) {
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)"dataapprovestatus", (String)"#FD6C6A");
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)"errormsg", (String)"#FD6C6A");
            SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)"submiterror", (String)"#FD6C6A");
            String bizDataStatus = bizDataDy.getString("bizdatastatus");
            if ("2".equals(bizDataStatus)) {
                SWCGridUtils.setGridStyle((IClientViewProxy)clientService, (String)"entryentity", (int)rowIndex, (String)"bizdatastatus", (String)"#FD6C6A");
            }
            ++rowIndex;
        }
    }

    private void clearDeletedEntryEntities() {
        String deleteentryidsCache = this.getView().getPageCache().get("deleteentryids");
        if (!SWCStringUtils.isEmpty((String)deleteentryidsCache)) {
            String[] deleteIdArr = deleteentryidsCache.split(",");
            Set deleteIds = Arrays.stream(deleteIdArr).map(item -> Long.valueOf(item)).collect(Collectors.toSet());
            DynamicObjectCollection dyCol = this.getModel().getEntryEntity("entryentity");
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
            int index = 0;
            for (DynamicObject dy : dyCol) {
                if (deleteIds.contains(dy.getLong("id"))) {
                    rowIndexs.add(index);
                }
                ++index;
            }
            if (CollectionUtils.isNotEmpty(rowIndexs)) {
                this.getModel().deleteEntryRows("entryentity", rowIndexs.stream().mapToInt(Integer::valueOf).toArray());
            }
        }
    }

    private Set<String> getObjRuleNotFillInFields(Long bizDataObjRuleId) {
        HashSet<String> notFillInFields = new HashSet<String>(16);
        SWCDataServiceHelper bdroHelper = HPDIDataServiceHelper.HSBS_BIZDATAOBJRULE_HELPER;
        DynamicObject bizDataRuleObj = null == bizDataObjRuleId || 0L == bizDataObjRuleId ? BizDataHelper.queryDefaultBizDataObjRule() : bdroHelper.queryOne((Object)bizDataObjRuleId);
        DynamicObjectCollection bizDataRuleFields = bizDataRuleObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject field : bizDataRuleFields) {
            if (!"2".equals(field.getString("fillmode"))) continue;
            String fieldKey = field.getString("bizobjruleconf.dbname");
            if ("adminorg".equals(fieldKey)) {
                fieldKey = "entadminorg";
            }
            if (fieldKey.contains(".")) {
                fieldKey = BizDataBillEntryHelper.getNewKey((String)fieldKey);
            }
            notFillInFields.add(fieldKey);
        }
        return notFillInFields;
    }

    private List<Long> getMulBizItemIds(Object param) {
        List<Long> mulBizItemIds = new ArrayList<Long>(10);
        if (param instanceof BillShowParameter) {
            BillShowParameter billShowParameter = (BillShowParameter)param;
            Object pkIdObj = billShowParameter.getPkId();
            if (pkIdObj != null) {
                Long bizDataBillId = Long.parseLong(String.valueOf(pkIdObj));
                mulBizItemIds = this.getMulBizItemByBillId(bizDataBillId);
            } else if (billShowParameter.getCustomParams().containsKey("mulBizItemIds")) {
                mulBizItemIds = (List)billShowParameter.getCustomParam("mulBizItemIds");
            }
        } else if (param instanceof FormShowParameter) {
            FormShowParameter formShowParameter = (FormShowParameter)param;
            mulBizItemIds = (List)formShowParameter.getCustomParam("mulBizItemIds");
        }
        return mulBizItemIds;
    }

    private List<Long> getMulBizItemByBillId(Long bizDataBillId) {
        List<Long> mulBizItemIds = new ArrayList<Long>(10);
        QFilter filter = new QFilter("id", "=", (Object)bizDataBillId);
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        DynamicObject bizDataBill = helper.queryOne("mulbizitem", new QFilter[]{filter});
        MulBasedataDynamicObjectCollection bizItemColl = (MulBasedataDynamicObjectCollection)bizDataBill.get("mulbizitem");
        if (CollectionUtils.isNotEmpty((Collection)bizItemColl)) {
            mulBizItemIds = bizItemColl.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        return mulBizItemIds;
    }

    private String replaceFileNameIllegalCharacter(String fileName) {
        for (char ch : FILE_NAME_ILELGAL_CHARACTER) {
            if (!fileName.contains(String.valueOf(ch))) continue;
            fileName = fileName.replace(ch, REPLACE_CHARACTER);
        }
        return fileName;
    }

    private Map<String, Object> getBizItemsAndBizDataRuleFields(Object param) {
        Map<String, Object> params = new HashMap<String, Object>(16);
        if (param instanceof FormShowParameter) {
            FormShowParameter formShowParameter = (FormShowParameter)param;
            params = formShowParameter.getCustomParams();
            if ("hpdi_bizdatabill".equals(formShowParameter.getFormId())) {
                params.put("bizDataBillPageId", formShowParameter.getPageId());
            }
            if ("hpdi_bizdatabill".equals(formShowParameter.getParentFormId())) {
                params.put("bizDataBillPageId", formShowParameter.getParentPageId());
            }
        }
        return params;
    }

    private void initBizItemsAndBizDataRuleFields(IFormView view, Map<String, Object> params, DynamicObject bizItemGroup, List<Long> mulBizItemIds, List<DynamicObject> bizItems, DynamicObjectCollection bizDataRuleFields) {
        if (null != view) {
            IPageCache pageCache = BizDataBillEntryHelper.getBizDataBillPageCache((IFormView)view);
            String bizItemsStr = pageCache.get("bizItems");
            String bizDataRuleFieldsStr = pageCache.get("entryBizDataObjRule");
            if (SWCStringUtils.isNotEmpty((String)bizItemsStr) && SWCStringUtils.isNotEmpty((String)bizDataRuleFieldsStr)) {
                bizItems.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)bizItemsStr));
                bizDataRuleFields.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)bizDataRuleFieldsStr));
                return;
            }
        }
        if (MapUtils.isNotEmpty(params)) {
            Object bizItemsObj = params.get("bizItems");
            Object bizDataRuleFiledObj = params.get("entryBizDataObjRule");
            if (null != bizItemsObj && null != bizDataRuleFiledObj) {
                bizItems.addAll((List)SerializationUtils.deSerializeFromBase64((String)String.valueOf(bizItemsObj)));
                bizDataRuleFields.addAll((Collection)((DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)String.valueOf(bizDataRuleFiledObj))));
                return;
            }
        }
        DynamicObject bizDataRuleObj = BizDataBillEntryHelper.getBizDataObjRuleByItemGroup((DynamicObject)bizItemGroup);
        bizDataRuleFields.addAll((Collection)bizDataRuleObj.getDynamicObjectCollection("entryentity"));
        DynamicObjectCollection bizItemColl = bizItemGroup.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty(mulBizItemIds)) {
            bizItems.addAll(bizItemColl.stream().filter(item -> mulBizItemIds.contains(item.getLong("bizitem.id"))).sorted((item1, item2) -> {
                int index1 = mulBizItemIds.indexOf(item1.getLong("bizitem.id"));
                int index2 = mulBizItemIds.indexOf(item2.getLong("bizitem.id"));
                return index1 - index2;
            }).collect(Collectors.toList()));
        } else {
            bizItems.addAll((Collection<DynamicObject>)bizItemColl);
        }
    }

    private void beforeShowBizDataDim(BeforeF7SelectEvent arg) {
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        QFilter filter = new QFilter("org.id", "=", (Object)orgId);
        arg.addCustomQFilter(filter);
        Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabillent", (String)"47150e89000000ac");
        if (null != bizDataDimIds) {
            QFilter bizDataDimFilter = new QFilter("id", "in", (Object)bizDataDimIds);
            arg.addCustomQFilter(bizDataDimFilter);
        }
        String showColumnKeys = "fseq,number,name,description";
        ListShowParameter listShowParameter = (ListShowParameter)arg.getFormShowParameter();
        listShowParameter.setCustomParam("showColumnKeys", (Object)showColumnKeys);
        listShowParameter.setMultiSelect(false);
    }
}

