/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.BizDataTransSalaryStatusHelper;
import kd.swc.hpdi.business.util.HPDIServiceUtils;
import kd.swc.hpdi.formplugin.web.HPDIResMgrFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(BizDataBillList.class);
    private static final String PAGE_CACHE_KEY = "countDownMap";

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        SWCPageCache hpdiPageCache = new SWCPageCache(this.getView());
        hpdiPageCache.remove(PAGE_CACHE_KEY);
        List<Map<String, Object>> params = this.getParamsOfQueryPayNodeTimes(dataEvent);
        if (SWCListUtils.isEmpty(params)) {
            return;
        }
        Map result = HPDIServiceUtils.queryPayNodeTimes(params);
        boolean isSuccess = (Boolean)result.get("success");
        if (!isSuccess) {
            logger.error(MessageFormat.format("BizDataBillList-PayNodeHelper.queryPayNodeTimeBatch() exception:{0}", result.get("message")));
        } else {
            Object dataObj = result.get("data");
            if (dataObj == null) {
                return;
            }
            HashMap<String, String> idAndCountDownMap = new HashMap<String, String>(16);
            JSONArray data = (JSONArray)result.get("data");
            for (int j = 0; j < data.size(); ++j) {
                String returnedId = (String)data.getJSONObject(j).get((Object)"id");
                Date endTime = (Date)data.getJSONObject(j).get((Object)"endtime");
                Date startTime = (Date)data.getJSONObject(j).get((Object)"starttime");
                logger.info(MessageFormat.format("BizDataBillList-result:startTime is {0}, endTime is {1}", startTime, endTime));
                Date nowDate = new Date();
                String countDownByTime = BizDataHelper.getCountDownByTime((Date)endTime, (Date)nowDate);
                if (SWCStringUtils.isEmpty((String)countDownByTime)) continue;
                idAndCountDownMap.put(returnedId, countDownByTime);
            }
            hpdiPageCache.put(PAGE_CACHE_KEY, idAndCountDownMap);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        String fieldKey = ((ColumnDesc)packageDataEvent.getSource()).getFieldKey();
        DynamicObject rowData = packageDataEvent.getRowData();
        String billType = rowData.getString("billtype");
        if ("countdown".equals(fieldKey) && SWCStringUtils.equals((String)billType, (String)"1")) {
            long id = rowData.getLong("id");
            SWCPageCache hpdiPageCache = new SWCPageCache(this.getView());
            Map idAndCountDownMap = (Map)hpdiPageCache.get(PAGE_CACHE_KEY, Map.class);
            if (idAndCountDownMap == null || idAndCountDownMap.isEmpty()) {
                return;
            }
            String countDownByTime = (String)idAndCountDownMap.get(String.valueOf(id));
            if (SWCStringUtils.isEmpty((String)countDownByTime)) {
                return;
            }
            packageDataEvent.setFormatValue((Object)countDownByTime);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        super.beforeShowBill(event);
        BillShowParameter billShowParameter = event.getParameter();
        if (!billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "abandon": {
                BizDataHelper.abandonBeforeDo((IFormView)this.getView());
                break;
            }
            case "refreshstatus": {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.isEmpty()) break;
                List bizDataBillIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                BizDataTransSalaryStatusHelper.refreshBizDataBillTransStatus(bizDataBillIds);
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(HPDIResMgrFormPlugin.getMsgOfRefreshTransStatusSuccess());
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "doabandon": {
                BizDataHelper.afterDoAbandon((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "submitandeffect": {
                this.afterSubmitAndEffect(args);
                break;
            }
            case "donothing_updateexpirydate": {
                this.openBizDataBillChoice(2);
                break;
            }
            case "olddata": {
                BizDataBillEntryHelper.bizDataBillDetailUpdateForOldData();
                break;
            }
            case "donothing_newbill": {
                this.openBizDataBillChoice(1);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "abandon_confirm": {
                BizDataHelper.abandonCheckClose((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        args.getFilterContainerInitEvent().getFastFilterColumns();
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("condition");
        if (customParam != null && customParam.size() > 0) {
            Object statusTrackFlag = customParam.get("isStatusTrackFlag");
            List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            if (commonFilterColumnList != null) {
                boolean fromBizDataBillCard = false;
                CommonFilterColumn orgFilterColumn = null;
                for (FilterColumn listFilter : commonFilterColumnList) {
                    List datarange;
                    CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                    String fieldName = commFilter.getFieldName();
                    if (statusTrackFlag != null && SWCStringUtils.isNotEmpty((String)((String)statusTrackFlag)) && SWCStringUtils.equals((String)((String)statusTrackFlag), (String)"isStatusTrackFlag")) {
                        if (fieldName.equals("auditdate") && customParam.get("auditdate") != null) {
                            datarange = (List)customParam.get(fieldName);
                            commFilter.setDefaultValues(new Object[]{datarange.get(0), datarange.get(1)});
                        }
                    } else if (fieldName.equals("createtime") && customParam.get("createtime") != null) {
                        datarange = (List)customParam.get(fieldName);
                        commFilter.setDefaultValues(new Object[]{datarange.get(0), datarange.get(1)});
                    }
                    if (fieldName.equals("billstatus") && customParam.get("billstatus") != null) {
                        commFilter.setDefaultValues((List)JSON.parseArray((String)String.valueOf(customParam.get(fieldName))));
                        fromBizDataBillCard = true;
                    }
                    if (fieldName.equals("bizitemgroup.name") && customParam.get("bizitemgroup") != null) {
                        commFilter.setDefaultValues(new Object[]{String.valueOf(customParam.get("bizitemgroup"))});
                    }
                    if (fieldName.equals("datastatus") && customParam.get("datastatus") != null) {
                        datarange = (List)customParam.get(fieldName);
                        commFilter.setDefaultValues(new Object[]{datarange.get(0), datarange.get(1)});
                        fromBizDataBillCard = true;
                    }
                    if (!fieldName.equals("org.name")) continue;
                    orgFilterColumn = commFilter;
                }
                if (fromBizDataBillCard && null != orgFilterColumn) {
                    orgFilterColumn.setDefaultValues(new Object[]{""});
                }
            }
        }
    }

    public void setFilter(SetFilterEvent filterEvent) {
        List qFilters;
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            filterEvent.getQFilters().addAll(authorizedDataRuleQFilter);
        }
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("appid")) && (qFilters = filterEvent.getQFilters()) != null) {
            String sourceSSCMenu = (String)this.getView().getFormShowParameter().getCustomParam("sourceSSCMenu");
            if (HRStringUtils.equals((String)Boolean.toString(Boolean.TRUE), (String)sourceSSCMenu)) {
                qFilters.add(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"hpdi_bizdatabillchoicetplopen")) {
            this.openBizDataBill(event);
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "bizitemgroup.name": {
                List filters = args.getQFilters();
                QFilter orgFilter = BizDataHelper.getOrgFilterBizOrgPerm();
                filters.add(orgFilter);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "bizitemgroup.name": {
                List filters = args.getQfilters();
                QFilter orgFilter = BizDataHelper.getOrgFilterBizOrgPerm();
                filters.add(orgFilter);
                break;
            }
        }
    }

    private List<Map<String, Object>> getParamsOfQueryPayNodeTimes(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        int pageDataSize = pageData.size();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(pageDataSize);
        for (int i = 0; i < pageDataSize; ++i) {
            long calPeriodTypeId;
            DynamicObject calPeriod;
            String billType;
            DynamicObject rowData = (DynamicObject)pageData.get(i);
            try {
                billType = rowData.getString("billtype");
            }
            catch (Exception exception) {
                return null;
            }
            if (!SWCStringUtils.equals((String)billType, (String)"1")) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(7);
            DynamicObject bizItemGroup = rowData.getDynamicObject("bizitemgroup");
            if (SWCObjectUtils.isEmpty((Object)bizItemGroup) || SWCObjectUtils.isEmpty((Object)(calPeriod = rowData.getDynamicObject("calperiod"))) || (calPeriodTypeId = bizItemGroup.getLong("calperiodtype.id")) == 0L) continue;
            long bizItemGroupId = bizItemGroup.getLong("id");
            String periodNumber = calPeriod.getString("number");
            long id = rowData.getLong("id");
            paramMap.put("calperiodtype", calPeriodTypeId);
            paramMap.put("bizitemgroupid", bizItemGroupId);
            paramMap.put("periodnumber", periodNumber);
            paramMap.put("id", id);
            paramMap.put("orgId", bizItemGroup.getLong("createorg.id"));
            params.add(paramMap);
        }
        return params;
    }

    private void afterSubmitAndEffect(AfterDoOperationEventArgs args) {
        List allErrorList = args.getOperationResult().getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorList)) {
            this.getView().invokeOperation("refresh");
            return;
        }
        String message = args.getOperationResult().getMessage();
        if (SWCStringUtils.isNotEmpty((String)message)) {
            logger.info(MessageFormat.format("BizDataBillList-afterSubmitAndEffect args.getOperationResult().getMessage() is:{0}", message));
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        operationResult.setShowMessage(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizDataBillList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void openBizDataBill(ClosedCallBackEvent event) {
        BillShowParameter show = new BillShowParameter();
        Map returnData = (Map)event.getReturnData();
        if (null == returnData) {
            return;
        }
        show.setFormId("hpdi_bizdatabill");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("billtype", returnData.get("billtype"));
        show.setCustomParam("bizItemGroupId", returnData.get("bizItemGroupId"));
        show.setCustomParam("orgId", returnData.get("orgId"));
        List mulBizItemIds = (List)returnData.get("mulBizItemIds");
        if (!CollectionUtils.isEmpty((Collection)mulBizItemIds)) {
            show.setCustomParam("mulBizItemIds", (Object)mulBizItemIds);
        }
        this.getView().showForm((FormShowParameter)show);
    }

    private void openBizDataBillChoice(int type) {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hpdi_bizdatabillchoicetpl");
        show.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63d0\u62a5", (String)"BizDataBillList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)show);
        show.getOpenStyle().setShowType(ShowType.Modal);
        if (type == 1) {
            show.setCustomParam("billtype", (Object)"1");
        } else if (type == 2) {
            show.setCustomParam("billtype", (Object)"2");
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "hpdi_bizdatabillchoicetplopen");
        show.setCloseCallBack(callBack);
        this.getView().showForm(show);
    }
}

