/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillListPlugin
extends AbstractListPlugin
implements TabSelectListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("all");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Tab tab = (Tab)this.getControl("all");
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tab");
        if (SWCStringUtils.isNotEmpty((String)tabKey)) {
            tab.selectTab(tabKey);
            tab.activeTab(tabKey);
        } else {
            this.loadAllBizDataList();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "allpage": {
                this.loadAllBizDataList();
                break;
            }
            case "notcirclepage": {
                this.loadNoCircleBizDataList();
                break;
            }
            case "circlepage": {
                this.loadCircleBizDataList();
                break;
            }
        }
    }

    private void loadCircleBizDataList() {
        QFilter qFilter = new QFilter("bizitem.cycle", "=", (Object)Boolean.TRUE);
        this.loadBizDataListByFilter(qFilter, "circlepage", "hpdi_circlebizdata");
    }

    private void loadNoCircleBizDataList() {
        QFilter qFilter = new QFilter("bizitem.cycle", "=", (Object)Boolean.FALSE);
        this.loadBizDataListByFilter(qFilter, "notcirclepage", "hpdi_notcirclebizdata");
    }

    private void loadAllBizDataList() {
        this.loadBizDataListByFilter(null, "allpage", "hpdi_allbizdata");
    }

    private void loadBizDataListByFilter(QFilter qFilter, String targetKey, String pageId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageId);
        listShowParameter.getOpenStyle().setTargetKey(targetKey);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (qFilter != null) {
            listFilterParameter.getQFilters().add(qFilter);
        }
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("appid"))) {
            listShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        }
        listShowParameter.setListFilterParameter(listFilterParameter);
        HashMap<String, String> customParam = (HashMap<String, String>)this.getView().getFormShowParameter().getCustomParam("condition");
        String bizDataStatus = (String)this.getView().getFormShowParameter().getCustomParam("bizdatastatus");
        if (customParam != null) {
            if (SWCStringUtils.isNotEmpty((String)bizDataStatus)) {
                customParam.put("bizdatastatus", bizDataStatus);
            }
            listShowParameter.setCustomParam("condition", (Object)customParam);
            listShowParameter.setFilterSchemeId("0");
        } else if (SWCStringUtils.isNotEmpty((String)bizDataStatus)) {
            customParam = new HashMap<String, String>(16);
            customParam.put("bizdatastatus", bizDataStatus);
            listShowParameter.setCustomParam("condition", customParam);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }
}

