/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataBillEntryCheckingHelper;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataBillHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.constants.BizDataConstants;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataBillNewEntryPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
PagerClickListener {
    public static final Log logger = LogFactory.getLog(BizDataBillNewEntryPlugin.class);

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName;
        switch (fieldName = args.getProperty().getName()) {
            case "updateexpirydate": {
                ChangeData changeEntryEntity = args.getChangeSet()[0];
                DynamicObject dataEntity = changeEntryEntity.getDataEntity();
                DynamicObject bizItemGroup = (DynamicObject)this.getModel().getValue("bizitemgroup");
                Map responses = BizDataBillEntryCheckingHelper.checkUpdateExpiryDate((DynamicObject)bizItemGroup, (List)Lists.newArrayList((Object[])new DynamicObject[]{dataEntity}), (String)"1");
                if (responses.isEmpty()) {
                    return;
                }
                String bizDataCode = dataEntity.getString("bizdatacode");
                Map responseMap = (Map)responses.get(bizDataCode);
                if (MapUtils.isEmpty((Map)responseMap)) {
                    return;
                }
                Object response = responseMap.get("key_result_error_msg");
                if (SWCObjectUtils.isEmpty(response) || !SWCStringUtils.isNotEmpty((String)((String)response))) break;
                this.getView().showErrorNotification((String)response);
                break;
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addPagerClickListener((PagerClickListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        super.entryGridBindData(event);
        this.setEnable();
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.setEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        block6 : switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_newentry": {
                String billType;
                boolean isSuccess = BizDataBillHelper.checkAndSaveBaseData((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
                if (!isSuccess) break;
                switch (billType = this.getModel().getDataEntity().getString("billtype")) {
                    case "1": {
                        this.showPersonF7();
                        break block6;
                    }
                    case "2": {
                        this.showBizDataF7();
                        break block6;
                    }
                }
                break;
            }
            case "donothing_clearallentry": {
                Object pkValue = this.getModel().getDataEntity().getPkValue();
                QFilter qFilter = new QFilter("bizdatabillid", "=", pkValue);
                boolean isExistsEntry = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.isExists(new QFilter[]{qFilter});
                if (isExistsEntry) {
                    String showMsg = ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u5df2\u6dfb\u52a0\u7684\u6240\u6709\u4e1a\u52a1\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataBillNewEntryPlugin_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_clearallentry"));
                    break;
                }
                String showMsg = ResManager.loadKDString((String)"\u65e0\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u9700\u6e05\u7a7a\u3002", (String)"BizDataBillNewEntryPlugin_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(showMsg, MessageBoxOptions.OK);
                break;
            }
            case "checkandsavebill": {
                BizDataBillHelper.checkAndSaveBaseData((IFormView)this.getView(), (BeforeDoOperationEventArgs)args);
                break;
            }
            case "donothing_addentry": {
                this.handlerForDoNothingAddEntry(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("donothing_import".equals(key)) {
            this.getPageCache().put("bizdatabill_operationstatus", "edit");
        }
        switch (key) {
            case "viewrelationdata": 
            case "refreshrelationdata": 
            case "donothing_newentry": 
            case "donothing_import": 
            case "donothing_export": 
            case "donothing_deleteentry": 
            case "donothing_clearallentry": 
            case "refreshcountdown": 
            case "refresh": 
            case "donothing_exportbytpl": 
            case "donothing_addentry": {
                OperationStatus operationStatus;
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                OperationResult opResult = args.getOperationResult();
                if (!"refresh".equals(key) && (opResult == null || !opResult.isSuccess())) break;
                String modelBillNo = (String)this.getView().getFormShowParameter().getCustomParam("modelbillno");
                String viewStatus = this.getPageCache().get("bizdatabill_operationstatus");
                if (SWCStringUtils.isEmpty((String)modelBillNo) || !SWCStringUtils.equals((String)billStatus, (String)"D")) break;
                this.getView().setStatus(OperationStatus.EDIT);
                if (SWCStringUtils.equals((String)viewStatus, (String)"VIEW")) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                if ((operationStatus = this.getView().getFormShowParameter().getStatus()) != OperationStatus.EDIT) break;
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getView().setStatus(OperationStatus.EDIT);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "donothing_clearallentry": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                BizDataBillEntryHelper.deleteEntryData((IFormView)this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String acctionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (acctionId) {
            case "newentry": {
                Object[] primaryKeyValues;
                if (null == returnData || !Objects.nonNull(primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues())) break;
                this.openBizDataBillNewEntry(primaryKeyValues, null);
                break;
            }
            case "hpdi_bizdatabillnewentry_open": {
                this.getView().invokeOperation("refresh");
                this.getView().invokeOperation("modify");
                BizDataHelper.refreshEntryEntity((IDataModel)this.getModel());
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                BizDataBillEntryHelper.setMustInputForUpdateExpiryDate((IFormView)this.getView());
                BizDataBillEntryHelper.setFieldsTextAlign((IFormView)this.getView());
                break;
            }
        }
    }

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    private void showPersonF7() {
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructPersonF7();
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showBizDataF7() {
        ListShowParameter listShowParameter = BizDataBillEntryHelper.constructBizDataF7((IFormView)this.getView());
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newentry"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void openBizDataBillNewEntry(Object[] primaryKeyValues, List<Map<Object, Object>> depempMappingList) {
        FormShowParameter show = new FormShowParameter();
        show.setFormId("hpdi_bizdatabillnewentry");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)show);
        show.getOpenStyle().setShowType(ShowType.Modal);
        show.setCustomParam("primaryKeyValues", (Object)primaryKeyValues);
        show.setCustomParam("id", this.getModel().getValue("id"));
        show.setCustomParam("billno", this.getModel().getValue("billno"));
        show.setCustomParam("billtype", this.getModel().getValue("billtype"));
        show.setCustomParam("billstatus", this.getModel().getValue("billstatus"));
        show.setCustomParam("approvenode", this.getView().getFormShowParameter().getCustomParam("approvenode"));
        show.setCustomParam("bizdatabillid", this.getModel().getDataEntity().getPkValue());
        show.setCustomParam("bizItemGroupId", (Object)this.getModel().getDataEntity().getLong("bizitemgroup.id"));
        show.setCustomParam("calperiodId", (Object)this.getModel().getDataEntity().getLong("calperiod.id"));
        show.setCustomParam("org", (Object)this.getModel().getDataEntity().getLong("org.id"));
        MulBasedataDynamicObjectCollection mulBizItems = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity().get("mulbizitem");
        if (!CollectionUtils.isEmpty((Collection)mulBizItems)) {
            List mulBizItemIds = mulBizItems.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
            show.setCustomParam("mulBizItemIds", mulBizItemIds);
        }
        show.setCustomParam("bizItems", (Object)this.getView().getPageCache().get("bizItems"));
        show.setCustomParam("entryBizDataObjRule", (Object)this.getView().getPageCache().get("entryBizDataObjRule"));
        show.setCustomParam("depempMappingList", depempMappingList);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "hpdi_bizdatabillnewentry_open");
        show.setCloseCallBack(callBack);
        this.getView().showForm(show);
    }

    private void setEnable() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String billType = (String)this.getModel().getValue("billtype");
        if (status == OperationStatus.EDIT && SWCStringUtils.equals((String)billType, (String)"2")) {
            this.getView().setEnable(Boolean.FALSE, -1, BizDataConstants.DEFAULT_DISABLE_BIZDATABILL_ENTRY_FIELDS);
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"updateexpirydate", "updateddesc"});
        }
    }

    private void handlerForDoNothingAddEntry(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String depempMappingListStr = option.getVariableValue("depempMappingList", null);
        if (SWCStringUtils.isEmpty((String)depempMappingListStr)) {
            return;
        }
        List depempMappingList = SerializationUtils.fromJsonStringToList((String)depempMappingListStr, Map.class);
        if (CollectionUtils.isEmpty((Collection)depempMappingList)) {
            return;
        }
        List depempIds = depempMappingList.stream().map(item -> MapUtils.getLong((Map)item, (Object)"depempId")).collect(Collectors.toList());
        this.openBizDataBillNewEntry(depempIds.toArray(), depempMappingList);
    }
}

