/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hpdi.business.helper.BizDataBillEntryHelper;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillRelationEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String VIEW_RELATION_DATA = "viewrelationdata";
    private static final String REFRESH_RELATION_DATA = "refreshrelationdata";
    private static final String IS_QUERY_ALL = "is_query_all";
    private static final String HPDI_BIZ_DATA_REATION_LIST = "hpdi_bizdatareationlist";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String key = formOperate.getOperateKey();
        String billNo = (String)this.getView().getModel().getValue("billno");
        DynamicObjectCollection entryEntitys = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        switch (key) {
            case "viewrelationdata": {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int[] rowIndexArr = proxy.getEntryState("entryentity").getSelectedRows();
                FormShowParameter bill = new FormShowParameter();
                bill.setStatus(OperationStatus.VIEW);
                bill.setFormId(HPDI_BIZ_DATA_REATION_LIST);
                SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)bill);
                bill.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> conditionMap = new HashMap<String, Object>(16);
                conditionMap.put("billno", billNo);
                bill.setCustomParam("condition", conditionMap);
                if (rowIndexArr != null && rowIndexArr.length == 0) {
                    conditionMap.put(IS_QUERY_ALL, "true");
                } else if (rowIndexArr != null && rowIndexArr.length > 0) {
                    ArrayList<String> codeList = new ArrayList<String>(10);
                    int[] nArray = rowIndexArr;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer rowIndex = nArray[i];
                        codeList.add(((DynamicObject)entryEntitys.get(rowIndex.intValue())).getString("bizdatacode"));
                    }
                    conditionMap.put("bizDataCodeList", codeList);
                }
                this.getView().showForm(bill);
                break;
            }
            case "refreshrelationdata": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REFRESH_RELATION_DATA, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u83b7\u53d6\u5168\u91cf\u4e1a\u52a1\u6570\u636e\u7684\u6700\u65b0\u5173\u8054\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"BizDataBillRelationEdit_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        switch (event.getCallBackId()) {
            case "refreshrelationdata": {
                if (event.getResult().getValue() != MessageBoxResult.Yes.getValue()) break;
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                int status = this.getView().getFormShowParameter().getStatus().getValue();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("is_self_save", "true");
                OperationResult operationResult = this.getView().invokeOperation("save", operateOption);
                if (SWCStringUtils.isNotEmpty((String)operationResult.getMessage())) {
                    return;
                }
                if (OperationStatus.EDIT.getValue() == status) {
                    this.getView().invokeOperation("modify");
                }
                this.getView().updateView("entryentity");
                BizDataHelper.refreshRelationData((DynamicObject)this.getModel().getDataEntity());
                this.getView().updateView("entryentity");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizDataBillRelationEdit_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                BizDataBillEntryHelper.setEntryFieldMustInput((IFormView)this.getView());
                BizDataBillEntryHelper.setEntryFieldEnable((IFormView)this.getView());
                BizDataBillEntryHelper.setMustInputForUpdateExpiryDate((IFormView)this.getView());
                if (!"B".equals(billStatus)) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "modify", "bar_submit", "submitandeffect", "doabandon"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"unsubmit", "viewflow"});
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object source = hyperLinkClickEvent.getSource();
        if (source instanceof EntryGrid && "relationdata".equals(hyperLinkClickEvent.getFieldName())) {
            int index = hyperLinkClickEvent.getRowIndex();
            DynamicObject[] dynamicObjects = ((EntryGrid)source).getEntryData().getDataEntitys();
            if (dynamicObjects.length > 0) {
                DynamicObject bizData = dynamicObjects[index];
                String billNo = (String)this.getView().getModel().getValue("billno");
                FormShowParameter bill = new FormShowParameter();
                bill.setStatus(OperationStatus.VIEW);
                bill.setFormId(HPDI_BIZ_DATA_REATION_LIST);
                SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)bill);
                bill.getOpenStyle().setShowType(ShowType.Modal);
                HashMap<String, Object> conditionMap = new HashMap<String, Object>(16);
                conditionMap.put("billno", billNo);
                ArrayList<String> codeList = new ArrayList<String>();
                codeList.add(bizData.getString("bizdatacode"));
                conditionMap.put("bizDataCodeList", codeList);
                bill.setCustomParam("condition", conditionMap);
                this.getView().showForm(bill);
            }
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }
}

