/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;

public class BizDataConfirmListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlag((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void afterCreateNewData(EventObject evt) {
        List idList = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        if (!CollectionUtils.isEmpty((Collection)idList)) {
            HashMap<Long, List<DynamicObject>> relationMap = new HashMap<Long, List<DynamicObject>>(16);
            ArrayList haveRelatedIds = new ArrayList(10);
            HashSet selectedIdSet = new HashSet(idList.size());
            selectedIdSet.addAll(idList);
            List partitionList = Lists.partition((List)idList, (int)1000);
            for (List subList : partitionList) {
                DynamicObject[] relationObjs;
                Map result = BizDataHelper.batchFindRelationIds((List)subList);
                List<Object> relationIds = new ArrayList(result.keySet());
                if (CollectionUtils.isEmpty(relationIds)) continue;
                haveRelatedIds.addAll(result.values());
                relationIds = relationIds.stream().filter(obj -> !selectedIdSet.contains(obj)).collect(Collectors.toList());
                for (DynamicObject relationObj : relationObjs = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("expirydate,effectivedate,value,description,currency,bizdatacode", new QFilter[]{new QFilter("id", "in", relationIds)})) {
                    Long originId = (Long)result.get(relationObj.getLong("id"));
                    ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)relationMap.get(originId);
                    if (null == list) {
                        list = new ArrayList<DynamicObject>(10);
                        relationMap.put(originId, list);
                    }
                    list.add(relationObj);
                }
            }
            DynamicObject[] selectObjs = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("expirydate,effectivedate,value,description,currency,bizdatacode,empposorgrel,bizitem", new QFilter[]{new QFilter("id", "in", haveRelatedIds)});
            this.initEntryEntityTable(selectObjs, relationMap);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView(), (boolean)true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "dosave": {
                this.getView().returnDataToParent((Object)"hpdi_bizdatacalsalary");
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private void initEntryEntityTable(DynamicObject[] selectObjs, Map<Long, List<DynamicObject>> relationMap) {
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (int index = 0; index < selectObjs.length; ++index) {
            List<DynamicObject> relationObjs = relationMap.get(selectObjs[index].getLong("id"));
            if (relationObjs == null || relationObjs.size() <= 0) continue;
            for (int indexJ = 0; indexJ < relationObjs.size(); ++indexJ) {
                vs.set("empposorgrel", (Object)selectObjs[index].getLong("empposorgrel.id"), indexRow);
                vs.set("bizitem", (Object)selectObjs[index].getLong("bizitem.id"), indexRow);
                vs.set("bizdatacode", (Object)selectObjs[index].getString("bizdatacode"), indexRow);
                vs.set("effectivedate", (Object)selectObjs[index].getDate("effectivedate"), indexRow);
                vs.set("expirydate", (Object)selectObjs[index].getDate("expirydate"), indexRow);
                vs.set("currency", (Object)selectObjs[index].getLong("currency.id"), indexRow);
                vs.set("value", (Object)selectObjs[index].getString("value"), indexRow);
                vs.set("description", (Object)selectObjs[index].getString("description"), indexRow);
                vs.set("relationeffectivedate", (Object)relationObjs.get(indexJ).getDate("effectivedate"), indexRow);
                vs.set("relationexpirydate", (Object)relationObjs.get(indexJ).getDate("expirydate"), indexRow);
                vs.set("relationcurrency", (Object)relationObjs.get(indexJ).getLong("currency.id"), indexRow);
                vs.set("relationvalue", (Object)relationObjs.get(indexJ).getString("value"), indexRow);
                vs.set("relationdescription", (Object)relationObjs.get(indexJ).getString("description"), indexRow);
                vs.set("relationbizdatacode", (Object)relationObjs.get(indexJ).getString("bizdatacode"), indexRow);
                ++indexRow;
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }
}

