/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataErrorList
extends AbstractListPlugin {
    private Map<Object, Integer> mapMatchFailMap;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                Object[] pkIds = rows.stream().map(DataEntityBase::getPkValue).toArray();
                BizDataErrorList.this.mapMatchFailMap = Arrays.stream(HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.query(pkIds)).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getInt("matchmorefilenum") + dy.getInt("notmatchfilenum")));
                return rows;
            }
        });
    }

    public void setFilter(SetFilterEvent evt) {
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdataerrorlog", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            evt.getQFilters().addAll(authorizedDataRuleQFilter);
        }
        QFilter orgFilter = BizDataHelper.assembleOrgFilterByBizOrgPerm();
        evt.getQFilters().add(orgFilter);
    }

    public void packageData(PackageDataEvent evt) {
        String fieldKey = ((ColumnDesc)evt.getSource()).getFieldKey();
        if (this.mapMatchFailMap != null && "matchfailnum".equals(fieldKey)) {
            Integer matchFailNum = this.mapMatchFailMap.get(evt.getRowData().getPkValue());
            evt.setFormatValue((Object)(matchFailNum == 0 ? null : matchFailNum));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        block5: {
            super.filterContainerInit(args);
            List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            if (commonFilterColumnList == null) break block5;
            Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("condition");
            if (customParam != null && customParam.size() > 0) {
                for (FilterColumn listFilter : commonFilterColumnList) {
                    CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                    String fieldName = commFilter.getFieldName();
                    if ("operatetime".equals(fieldName)) {
                        commFilter.setDefaultValues(new Object[]{customParam.get("startdate"), customParam.get("enddate")});
                    }
                    if (!fieldName.equals("bizitemgroup.name") || customParam.get("bizitemgroup") == null) continue;
                    commFilter.setDefaultValues(new Object[]{String.valueOf(customParam.get("bizitemgroup"))});
                }
            } else {
                for (FilterColumn listFilter : commonFilterColumnList) {
                    CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                    String fieldName = commFilter.getFieldName();
                    if (!"operatetime".equals(fieldName)) continue;
                    Date startDate = SWCDateTimeUtils.truncateDate((Date)SWCDateTimeUtils.addDay((Date)new Date(), (long)-30L));
                    Date endDate = new Date();
                    commFilter.setDefaultValues(new Object[]{SWCDateTimeUtils.format((Date)startDate, null, null, null), SWCDateTimeUtils.format((Date)endDate, null, null, null)});
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (SWCStringUtils.equals((String)"billno", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long id = (Long)listView.getFocusRowPkId();
            DynamicObject errorObj = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER.queryOne("billno", (Object)id);
            DynamicObject bizDataBill = null;
            if (!SWCObjectUtils.isEmpty((Object)errorObj) && !SWCStringUtils.isEmpty((String)errorObj.getString("billno"))) {
                bizDataBill = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("id, org.id", new QFilter[]{new QFilter("billno", "=", (Object)errorObj.getString("billno"))});
            }
            if (SWCObjectUtils.isEmpty(bizDataBill)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728", (String)"BizDataList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            if (bizDataBill != null) {
                if (!BizDataHelper.hasOrgPermission((Long)bizDataBill.getLong("org.id"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u8be2\u201d\u201c\u4e1a\u52a1\u6570\u636e\u63d0\u62a5\u201d\u7684\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizDataList_10", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    return;
                }
                BaseShowParameter parameter = new BaseShowParameter();
                parameter.setFormId("hpdi_bizdatabill");
                parameter.setPkId((Object)bizDataBill.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "bizitemgroup.name": {
                List filters = args.getQFilters();
                QFilter orgFilter = SWCPermissionServiceHelper.getOrgFilterByOrgPerm((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac", (String)"hsbs_bizitemgroup");
                filters.add(orgFilter);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "bizitemgroup.name": {
                List filters = args.getQfilters();
                QFilter orgFilter = SWCPermissionServiceHelper.getOrgFilterByOrgPerm((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac", (String)"hsbs_bizitemgroup");
                filters.add(orgFilter);
                break;
            }
        }
    }
}

