/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataF7List
extends AbstractListPlugin
implements ListRowClickListener {
    private static final String LIST_NAME_NUMBER_CACHE = "listnamenumberkey";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("isCloseBizDataBillShowF7");
        if (customParam != null && SWCStringUtils.equals((String)"1", (String)((String)customParam))) {
            this.reloadSelectedRowsNameNumber(evt.getListSelectedRowCollection());
        }
    }

    private void reloadSelectedRowsNameNumber(ListSelectedRowCollection selectedRows) {
        Set needLoadNameNumberPkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        SWCPageCache pageCache = new SWCPageCache(this.getPageCache());
        HashMap<String, Map> listNameNumberCache = (HashMap<String, Map>)pageCache.get(LIST_NAME_NUMBER_CACHE, Map.class);
        if (listNameNumberCache == null) {
            listNameNumberCache = new HashMap<String, Map>(selectedRows.size());
        } else {
            for (ListSelectedRow selectedRow : selectedRows) {
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                if (SWCStringUtils.isEmpty((String)selectedRow.getName()) && SWCStringUtils.isEmpty((String)selectedRow.getNumber())) {
                    Map nameNumberMap = (Map)listNameNumberCache.get(String.valueOf(primaryKeyValue));
                    if (nameNumberMap == null) continue;
                    selectedRow.setNumber((String)nameNumberMap.get("number"));
                    selectedRow.setName((String)nameNumberMap.get("name"));
                    needLoadNameNumberPkSet.remove(primaryKeyValue);
                    continue;
                }
                needLoadNameNumberPkSet.remove(primaryKeyValue);
            }
        }
        if (needLoadNameNumberPkSet.isEmpty()) {
            return;
        }
        String numberKey = (String)this.getView().getFormShowParameter().getCustomParam("numberKey");
        String nameKey = (String)this.getView().getFormShowParameter().getCustomParam("nameKey");
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter queryQFilter = new QFilter("id", "in", needLoadNameNumberPkSet);
        DynamicObject[] selectedRowsNameNumberArray = bizDataHelper.query("id,empposorgrel.person.number,empposorgrel.person.name", new QFilter[]{queryQFilter});
        Map<Object, Map> listNameNumberMap = Arrays.stream(selectedRowsNameNumberArray).collect(Collectors.toMap(selectedRowsNameNumber -> selectedRowsNameNumber.get("id"), selectedRowsNameNumber -> {
            HashMap<String, String> nameNumberMap = new HashMap<String, String>(3);
            nameNumberMap.put("number", selectedRowsNameNumber.getString(numberKey));
            nameNumberMap.put("name", selectedRowsNameNumber.getString(nameKey));
            return nameNumberMap;
        }, (key, value) -> key));
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            Map nameNumberMap = listNameNumberMap.get(primaryKeyValue);
            if (!MapUtils.isNotEmpty((Map)nameNumberMap)) continue;
            selectedRow.setNumber((String)nameNumberMap.get("number"));
            selectedRow.setName((String)nameNumberMap.get("name"));
            listNameNumberCache.put(String.valueOf(primaryKeyValue), nameNumberMap);
        }
        pageCache.put(LIST_NAME_NUMBER_CACHE, listNameNumberCache);
    }
}

