/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ListVisible;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.swc.hpdi.common.events.bizdata.BizDataHyperLinkClickArgs;
import kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataListExtPlugin;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataListDataProvider;
import kd.swc.hpdi.formplugin.web.bizdata.BizDataListExtPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.ArrayUtils;

public class BizDataList
extends AbstractListPlugin {
    private static final String HPDI_TRANSALARY_CONFIRM = "hpdi_transalaryconfirm";
    private static final String AFTER_CONFIRM_CALLBACK = "after_confirm_callback";
    private static final String DATA_LIMIT_SHOW_PROCESS = "1000";
    private static final Log LOGGER = LogFactory.getLog(BizDataList.class);
    private Map<String, Boolean> relationMap = new HashMap<String, Boolean>(16);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        args.getListColumn("empposorgrel.person.number").setFixed(true);
        args.getListColumn("empposorgrel.person.name").setFixed(true);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        if ("hpdi_notcirclebizdata".equals(billFormId)) {
            args.getListColumn("expirydate").setVisible(ListVisible.NOT.getVisible());
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "bizitemgroup.name": {
                QFilter filter = new QFilter("modeltype", "=", (Object)"1");
                filters.add(filter);
                QFilter orgFilter = BizDataHelper.getOrgFilterBizOrgPerm();
                filters.add(orgFilter);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "bizitemgroup.id": 
            case "bizitemgroup.name": {
                QFilter filter = new QFilter("modeltype", "=", (Object)"1");
                filters.add(filter);
                QFilter orgFilter = BizDataHelper.getOrgFilterBizOrgPerm();
                filters.add(orgFilter);
                break;
            }
            case "bizdatadim.name": {
                String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)billFormId, (String)"47150e89000000ac");
                if (null == bizDataDimIds) break;
                QFilter dimFilter = new QFilter("id", "in", (Object)bizDataDimIds);
                filters.add(dimFilter);
                break;
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isCloseBizDataBillShowF7 = (String)formShowParameter.getCustomParam("isCloseBizDataBillShowF7");
        LOGGER.info(MessageFormat.format("BizDataList-beforeCreateListDataProvider isCloseBizDataBillShowF7={0}", isCloseBizDataBillShowF7));
        if (SWCStringUtils.equals((String)isCloseBizDataBillShowF7, (String)"1")) {
            args.setListDataProvider((IListDataProvider)new BizDataListDataProvider());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getParentView(), (boolean)true);
        OperateOption option = formOperate.getOption();
        option.setVariableValue("batchop_batchsize", String.valueOf(500));
        switch (key = formOperate.getOperateKey()) {
            case "abandon": {
                this.beforeDoAbandon(args);
                break;
            }
            case "calsalary": {
                this.beforeCalSalary(args);
                break;
            }
            case "dealdesc": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("hpdi_bizdataoperatetip");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)parameter);
                this.getView().showForm(parameter);
                break;
            }
            case "circlerollback": {
                this.doCircleRollback(args);
                break;
            }
            case "nocirclerollback": {
                this.doNoCircleRollback(args);
                break;
            }
            case "donothing_viewoprecord": {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                List<Long> selectBizDataIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                this.showBizDataOpRecord(selectBizDataIds);
                break;
            }
            case "listrow_viewoprecord": {
                Long currentSelectBizDataId = (Long)((IListView)this.getView()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
                ArrayList<Long> currentSelectBizDataIds = new ArrayList<Long>(1);
                currentSelectBizDataIds.add(currentSelectBizDataId);
                this.showBizDataOpRecord(currentSelectBizDataIds);
                break;
            }
        }
    }

    private void beforeDoAbandon(BeforeDoOperationEventArgs args) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        Object[] bizDataIds = selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        DynamicObject[] bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(bizDataIds);
        boolean allTransCal = Arrays.stream(bizData).allMatch(dy -> BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode().equals(dy.getString("bizdatastatus")) || BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode().equals(dy.getString("bizdatastatus")) || BizDataStatusEnum.WITHDRAWN.getCode().equals(dy.getString("bizdatastatus")));
        if (!allTransCal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u5f85\u63a8\u9001\u7b97\u85aa\u201d\u3001\u201c\u63a8\u9001\u7b97\u85aa\u5931\u8d25\u201d\u3001\u201c\u5df2\u64a4\u56de\u201d\u7684\u6570\u636e\u8fdb\u884c\u5e9f\u5f03\u5904\u7406\u3002", (String)"BizDataList_13", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        BizDataHelper.abandonBeforeDo((IFormView)this.getView());
    }

    private void doCircleRollback(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM_CALLBACK, new RefObject())) {
            return;
        }
        if (formOperate.getOption().tryGetVariableValue("batchop_completed", new RefObject())) {
            return;
        }
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        if (selectRows.size() > 5000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u64cd\u4f5c\u6700\u591a\u53ef\u5904\u74065000\u6761\u6570\u636e\u3002", (String)"BizDataList_12", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] bizDataIds = selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        String allCols = SWCHisBaseDataHelper.getSelectProperties((String)"hpdi_bizdata");
        DynamicObject[] bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(allCols, new QFilter[]{new QFilter("id", "in", (Object)bizDataIds)});
        boolean allTransCal = Arrays.stream(bizData).allMatch(dy -> "3".equals(dy.getString("bizdatastatus")));
        if (!allTransCal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u56de\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63a8\u9001\u7b97\u85aa\u201d\u7684\u6570\u636e\u3002", (String)"BizDataList_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("circlerollback", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u56de\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u7528\u4e8e\u85aa\u8d44\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataList_11", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBack);
    }

    private void doNoCircleRollback(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM_CALLBACK, new RefObject())) {
            return;
        }
        if (formOperate.getOption().tryGetVariableValue("batchop_completed", new RefObject())) {
            return;
        }
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        Object[] bizDataIds = selectRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        DynamicObject[] bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query(bizDataIds);
        boolean allTransCal = Arrays.stream(bizData).allMatch(dy -> "3".equals(dy.getString("bizdatastatus")));
        if (!allTransCal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u56de\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63a8\u9001\u7b97\u85aa\u201d\u7684\u6570\u636e\u3002", (String)"BizDataList_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("nocirclerollback", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u56de\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u7528\u4e8e\u85aa\u8d44\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataList_11", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBack);
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        DynamicObjectCollection dyCol = evt.getPageData();
        if (CollectionUtils.isEmpty((Collection)dyCol)) {
            return;
        }
        if (!((DynamicObject)dyCol.get(0)).getDataEntityType().getProperties().containsKey((Object)"billtype")) {
            return;
        }
        Set bizDataCodes = dyCol.stream().filter(dy -> "1".equals(dy.getString("billtype"))).map(dy -> dy.getString("bizdatacode")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("currentbizdatacode", "in", bizDataCodes);
        Object[] records = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])records)) {
            Map<String, List<DynamicObject>> map = Arrays.stream(records).collect(Collectors.groupingBy(dy -> dy.getString("currentbizdatacode")));
            for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                this.relationMap.put(entry.getKey(), !CollectionUtils.isEmpty((Collection)entry.getValue()));
            }
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        String fieldKey = ((ColumnDesc)evt.getSource()).getFieldKey();
        DynamicObject rowData = evt.getRowData();
        if ("relationrecord".equals(fieldKey) && this.relationMap.getOrDefault(rowData.getString("bizdatacode"), Boolean.FALSE).booleanValue()) {
            evt.setFormatValue((Object)"A");
        }
    }

    private void beforeCalSalary(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM_CALLBACK, new RefObject())) {
            return;
        }
        if (formOperate.getOption().tryGetVariableValue("batchop_completed", new RefObject())) {
            return;
        }
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u201d\u3002", (String)"BizDataList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<Long> selectedRowIds = new ArrayList<Long>(10);
        for (ListSelectedRow selectedRow : selectedRows) {
            selectedRowIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        SWCDataServiceHelper bizDataHelper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter bizDataFilter = new QFilter("id", "in", selectedRowIds);
        DynamicObject[] bizDataArr = bizDataHelper.query("id, bizdatastatus, bizitem.cycle", new QFilter[]{bizDataFilter});
        boolean containCycle = false;
        for (DynamicObject bizDataDy : bizDataArr) {
            String bizDataStatus = bizDataDy.getString("bizdatastatus");
            String isCycle = bizDataDy.getString("bizitem.cycle");
            if (!("1".equals(bizDataStatus) || "4".equals(bizDataStatus) || "7".equals(bizDataStatus))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u5f85\u63a8\u9001\u7b97\u85aa\u201d\u3001\u201c\u63a8\u9001\u7b97\u85aa\u5931\u8d25\u201d\u3001\u201c\u5df2\u64a4\u56de\u201d\u7684\u6570\u636e\u8fdb\u884c\u63a8\u9001\u7b97\u85aa\u5904\u7406\u3002", (String)"BizDataList_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"1".equals(isCycle)) continue;
            containCycle = true;
        }
        boolean isShowData = false;
        if (containCycle) {
            HashSet<Long> selectedRowIdSet = new HashSet<Long>(16);
            selectedRowIdSet.addAll(selectedRowIds);
            List partitionList = Lists.partition(selectedRowIds, (int)1000);
            for (List subList : partitionList) {
                Map result = BizDataHelper.batchFindRelationIds((List)subList);
                Set relationList = result.keySet();
                for (Long relationId : relationList) {
                    if (selectedRowIdSet.contains(relationId)) continue;
                    isShowData = true;
                    break;
                }
                if (!isShowData) continue;
                selectedRowIdSet.clear();
                break;
            }
        }
        if (isShowData) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(HPDI_TRANSALARY_CONFIRM);
            SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)parameter);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HPDI_TRANSALARY_CONFIRM));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("ids", selectedRowIds);
            this.getView().showForm(parameter);
            args.setCancel(true);
        } else if (containCycle) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("hpdi_bizdatacalsalary", (IFormPlugin)this);
            this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\u8fdb\u884c\u63a8\u9001\u7b97\u85aa\u5904\u7406\u3002\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\u975e\u9996\u6b21\u63d0\u62a5\uff0c\u8bf7\u6ce8\u610f\u5904\u7406\u8bf4\u660e\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataList_9", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), selectedRowIds.size()), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        switch (key = args.getOperateKey()) {
            case "doabandon": {
                BizDataHelper.afterDoAbandon((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "calsalary": {
                this.getView().showSuccessNotification(args.getOperationResult().getMessage());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "circlerollback": 
            case "nocirclerollback": {
                OperationResult operateResult = args.getOperationResult();
                if (operateResult.isSuccess()) {
                    this.getView().showSuccessNotification(HPDIResMgrBusiness.getMsgOfRollbackSuccess());
                } else {
                    operateResult.setMessage(null);
                    List errorInfos = operateResult.getAllErrorInfo();
                    if (!CollectionUtils.isEmpty((Collection)errorInfos)) {
                        Iterator it = errorInfos.iterator();
                        while (it.hasNext()) {
                            OperateErrorInfo errorInfo = (OperateErrorInfo)it.next();
                            if ("rollback_fail".equals(errorInfo.getErrorCode())) continue;
                            it.remove();
                        }
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (key) {
            case "abandon_confirm": {
                BizDataHelper.abandonCheckClose((IFormView)this.getView(), (MessageBoxClosedEvent)messageBoxClosedEvent);
                break;
            }
            case "hpdi_bizdatacalsalary": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption bizDataCalSalaryOp = OperateOption.create();
                bizDataCalSalaryOp.setVariableValue(AFTER_CONFIRM_CALLBACK, "yes");
                this.getView().invokeOperation("calsalary", bizDataCalSalaryOp);
                break;
            }
            case "circlerollback": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption circleRollbackOp = OperateOption.create();
                circleRollbackOp.setVariableValue(AFTER_CONFIRM_CALLBACK, "yes");
                circleRollbackOp.setVariableValue("billFormId", ((IListView)this.getView()).getBillFormId());
                this.getView().invokeOperation("circlerollback", circleRollbackOp);
                break;
            }
            case "nocirclerollback": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption noCircleRollbackOp = OperateOption.create();
                noCircleRollbackOp.setVariableValue(AFTER_CONFIRM_CALLBACK, "yes");
                noCircleRollbackOp.setVariableValue("billFormId", ((IListView)this.getView()).getBillFormId());
                this.getView().invokeOperation("nocirclerollback", noCircleRollbackOp);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        IFormView parentView = this.getView().getParentView();
        String isCloseBizDataBillShowF7 = (String)this.getView().getFormShowParameter().getCustomParam("isCloseBizDataBillShowF7");
        if (parentView != null && !SWCStringUtils.equals((String)isCloseBizDataBillShowF7, (String)"1")) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hpdi_bizdatacalsalary": 
            case "hpdi_transalaryconfirm": {
                if (!"hpdi_bizdatacalsalary".equals(event.getReturnData())) break;
                OperateOption bizDataCalSalaryOp = OperateOption.create();
                bizDataCalSalaryOp.setVariableValue(AFTER_CONFIRM_CALLBACK, "yes");
                bizDataCalSalaryOp.setVariableValue("batchop_batchsize", DATA_LIMIT_SHOW_PROCESS);
                this.getView().invokeOperation("calsalary", bizDataCalSalaryOp);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent evt) {
        this.buildQuickSearch(evt.getQFilters());
        String[] split = this.getView().getFormShowParameter().getIdentifyFormId().split("-");
        List authorizedDataRuleQFilter = split.length > 1 ? SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)split[1], (String)"47150e89000000ac") : SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdata", (String)"47150e89000000ac");
        if (authorizedDataRuleQFilter != null) {
            evt.getQFilters().addAll(authorizedDataRuleQFilter);
        }
        QFilter verticalQfilter = new QFilter("bizdatarecord", "=", (Object)0);
        evt.getQFilters().add(verticalQfilter);
        QFilter orgFilter = BizDataHelper.assembleOrgFilterByBizOrgPerm();
        evt.getQFilters().add(orgFilter);
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("appid"))) {
            String sourceSSCMenu = (String)this.getView().getFormShowParameter().getCustomParam("sourceSSCMenu");
            if (HRStringUtils.equals((String)Boolean.toString(Boolean.TRUE), (String)sourceSSCMenu)) {
                evt.getQFilters().add(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
            }
        }
    }

    private List<QFilter> buildQuickSearch(List<QFilter> qFilters) {
        if (qFilters == null || qFilters.size() == 0) {
            return qFilters;
        }
        for (int x = 0; x < qFilters.size(); ++x) {
            String filterstring = qFilters.get(x).toString();
            if (!filterstring.contains("empposorgrel.person.number") && !filterstring.contains("empposorgrel.person.name")) continue;
            qFilters.add(new QFilter("empposorgrel.iscurrentversion", "=", (Object)"1"));
            qFilters.add(new QFilter("empposorgrel.person.iscurrentversion", "=", (Object)"1"));
        }
        return qFilters;
    }

    private void invokeBillListHyperLinkClick(BizDataHyperLinkClickArgs args) {
        BizDataListExtPlugin ExtService = new BizDataListExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)ExtService, IBizDataListExtPlugin.class, (String)"kd.sdk.swc.hpdi.formplugin.extpoint.bizdata.IBizDataListExtPlugin#billListHyperLinkClick", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.billListHyperLinkClick(args);
            return null;
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BizDataHyperLinkClickArgs event = new BizDataHyperLinkClickArgs();
        event.setView(this.getView());
        event.setArgs(args);
        this.invokeBillListHyperLinkClick(event);
        if (args.isCancel()) {
            return;
        }
        if (SWCStringUtils.equals((String)"applyno", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long id = (Long)listView.getFocusRowPkId();
            DynamicObject bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne("applyno", (Object)id);
            if (SWCObjectUtils.isEmpty((Object)bizData)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728", (String)"BizDataList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bizDataBill = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("id, org.id", new QFilter[]{new QFilter("billno", "=", (Object)bizData.getString("applyno"))});
            if (SWCObjectUtils.isEmpty((Object)bizDataBill)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728", (String)"BizDataList_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!BizDataHelper.hasOrgPermission((Long)bizDataBill.getLong("org.id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u8be2\u201d\u201c\u4e1a\u52a1\u6570\u636e\u63d0\u62a5\u201d\u7684\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizDataList_10", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("hpdi_bizdatabill");
            parameter.setPkId((Object)bizDataBill.getLong("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (SWCStringUtils.equals((String)"relationrecord", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long pkVal = (Long)listView.getFocusRowPkId();
            DynamicObject bizData = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.queryOne((Object)pkVal);
            FormShowParameter bill = new FormShowParameter();
            bill.setStatus(OperationStatus.VIEW);
            bill.setFormId("hpdi_bizdatarecordlist");
            SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)bill);
            bill.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> conditionMap = new HashMap<String, String>(1);
            conditionMap.put("bizdatacode", bizData.getString("bizdatacode"));
            bill.setCustomParam("condition", conditionMap);
            this.getView().showForm(bill);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumnList;
        super.filterContainerInit(args);
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("condition");
        if (customParam != null && customParam.size() > 0 && (commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns()) != null) {
            for (FilterColumn listFilter : commonFilterColumnList) {
                List datarange;
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if (fieldName.equals("submitdate") && (datarange = (List)customParam.get(fieldName)) != null) {
                    commFilter.setDefaultValues(new Object[]{datarange.get(0), datarange.get(1)});
                }
                if (fieldName.equals("bizdatastatus") && customParam.containsKey("bizdatastatus")) {
                    commFilter.setDefaultValues(new Object[]{String.valueOf(customParam.get(fieldName))});
                }
                if (!fieldName.equals("bizitemgroup.name") || customParam.get("bizitemgroup") == null) continue;
                commFilter.setDefaultValues(new Object[]{String.valueOf(customParam.get("bizitemgroup"))});
            }
        }
    }

    private void showBizDataOpRecord(List<Long> bizDataIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("hpdi_bizdataoperatelog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String billFormId = ((IListView)this.getView()).getBillFormId();
        listShowParameter.setCustomParam("parentBillFormId", (Object)billFormId);
        if (!CollectionUtils.isEmpty(bizDataIds)) {
            QFilter filter = new QFilter("id", "in", bizDataIds);
            DynamicObject[] bizDatas = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode", new QFilter[]{filter});
            List bizDataCodes = Arrays.stream(bizDatas).map(dy -> dy.getString("bizdatacode")).collect(Collectors.toList());
            listShowParameter.setCustomParam("bizDataCodes", bizDataCodes);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

