/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import org.apache.commons.lang.ArrayUtils;

public class BizDataRecordListPlugin
extends AbstractListPlugin {
    private static final String KEY_CONDITION = "condition";

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlag((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void afterCreateNewData(EventObject evt) {
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam(KEY_CONDITION);
        String bizDataCode = (String)customParam.get("bizdatacode");
        QFilter qFilter = new QFilter("currentbizdatacode", "=", (Object)bizDataCode);
        Object[] records = HPDIDataServiceHelper.HPDI_BIZDATAOPERATEHIS_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])records)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < records.length; ++i) {
            vs.set("bizdataoperatehis", records[i].getPkValue(), i);
            vs.set("empposorgrel", records[i].getDynamicObject("empposorgrel").getPkValue(), i);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView(), (boolean)true);
    }
}

