/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataRelationListPlugin
extends AbstractListPlugin {
    private static final String IS_QUERY_ALL = "is_query_all";
    private static final String[] EXCLUDE_BIZ_DATA_STATUS_ARR = new String[]{"5", "6"};

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlag((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void afterCreateNewData(EventObject evt) {
        DynamicObject[] bizDataRelations;
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("condition");
        String isQueryAll = (String)customParam.get(IS_QUERY_ALL);
        String billNo = (String)customParam.get("billno");
        this.showColsByBizDataRule(billNo);
        List bizDataCodeList = (List)customParam.get("bizDataCodeList");
        if (!StringUtils.isEmpty((Object)billNo) && !CollectionUtils.isEmpty((Collection)bizDataCodeList) && StringUtils.isEmpty((Object)isQueryAll)) {
            bizDataRelations = HPDIDataServiceHelper.HPDI_BIZDATARELATION_HELPER.query("relationbizdatacode,bizdatacode,isconfilct,dataobtaintime", new QFilter[]{new QFilter("bizdatacode", "in", (Object)bizDataCodeList)});
            this.initEntryEntityTableByBizDataRelations(bizDataRelations, billNo);
        } else if (!StringUtils.isEmpty((Object)isQueryAll) && !StringUtils.isEmpty((Object)billNo)) {
            bizDataRelations = HPDIDataServiceHelper.HPDI_BIZDATARELATION_HELPER.query("relationbizdatacode,bizdatacode,isconfilct,dataobtaintime", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
            this.initEntryEntityTableByBizDataRelations(bizDataRelations, billNo);
        }
        Label tip = (Label)this.getControl("labelap");
        tip.setText(ResManager.loadKDString((String)"\u5f53\u524d\u901a\u8fc7\u76f8\u540c\u7684\u201c\u4eba\u5458\u4efb\u804c\u201d\u6216\u201c\u4eba\u5458&\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u201d\u4ee5\u53ca\u76f8\u540c\u7684\u4e1a\u52a1\u9879\u76ee\uff0c\u83b7\u53d6\u5173\u8054\u6570\u636e\u67e5\u770b\u3002\u6700\u7ec8\u5c06\u4ee5\u63a8\u9001\u7b97\u85aa\u65f6\u5339\u914d\u540c\u4e00\u85aa\u8d44\u6863\u6848\u7684\u6570\u636e\u8fdb\u884c\u5173\u8054\u66f4\u65b0\u3002", (String)"BizDataRelationListPlugin_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
    }

    public void showColsByBizDataRule(String billNo) {
        DynamicObject bizDataRuleDy;
        String[] ruleVersionArr;
        String bizDataRuleVersion;
        this.getView().setVisible(Boolean.FALSE, "personnumber,personname,adminorgname,jobname,isprimary,postypename,startdate,enddate,companyname,positionname,dataapprovestatus,approvedesc,bizdatastatus,errormsg,submiterror,datacode,apositiontype,enttranssalarystatus".split(","));
        DynamicObject billObj = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("bizdataruleversion", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        Long ruleId = 0L;
        Long versionId = 0L;
        if (!SWCObjectUtils.isEmpty((Object)billObj) && !StringUtils.isEmpty((Object)(bizDataRuleVersion = billObj.getString("bizdataruleversion"))) && (ruleVersionArr = bizDataRuleVersion.split("-")) != null && ruleVersionArr.length > 1) {
            ruleId = Long.valueOf(ruleVersionArr[0]);
            versionId = Long.valueOf(ruleVersionArr[1]);
        }
        if ((bizDataRuleDy = BizDataHelper.getBizDataRuleByVersion((Long)ruleId, (Long)versionId)) != null) {
            DynamicObjectCollection bizDataRuleConfEntry = bizDataRuleDy.getDynamicObjectCollection("entryentity");
            StringJoiner visibleFiledStringJoiner = new StringJoiner(",");
            for (DynamicObject bizDataRuleConfDy : bizDataRuleConfEntry) {
                String bizDataRuleNumber = bizDataRuleConfDy.getString("bizobjruleconf.number");
                String showFiled = (String)BizDataHelper.getRuleConfMap().get(bizDataRuleNumber);
                if (kd.bos.util.StringUtils.isBlank((String)showFiled)) continue;
                visibleFiledStringJoiner.add(showFiled);
            }
            String visibleFiledStr = visibleFiledStringJoiner.toString();
            String[] visibleFiledArr = visibleFiledStr.split(",");
            this.getView().setVisible(Boolean.TRUE, visibleFiledArr);
        }
    }

    public void initEntryEntityTableByBizDataRelations(DynamicObject[] bizDataRelations, String billNo) {
        Map<String, String> relationCodeMap = this.getRelationCodeMap(bizDataRelations);
        DynamicObject bizDataBill = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("id", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (SWCObjectUtils.isEmpty((Object)bizDataBill)) {
            return;
        }
        QFilter qFilter = new QFilter("bizdatabillid", "=", bizDataBill.getPkValue());
        QFilter qFilterBizCode = new QFilter("bizdatacode", "in", relationCodeMap.keySet());
        DynamicObject[] bizDataBillEnts = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER.query("bizdatacode, currency, remark, entryentity.value, entryentity.effectivedate, entryentity.expirydate", new QFilter[]{qFilter, qFilterBizCode});
        DynamicObject[] relationBizDataDetails = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("bizdatacode,empposorgrel,bizdate,payrollgrp,salaryfile,bizitem,value,currency,description,effectivedate,expirydate", new QFilter[]{new QFilter("bizdatacode", "in", relationCodeMap.values())});
        this.initEntryEntityTable(relationBizDataDetails, bizDataBillEnts, bizDataRelations);
    }

    public Map<String, Date> initDataObtainTimeMap(DynamicObject[] bizDataRelations) {
        HashMap<String, Date> result = new HashMap<String, Date>(16);
        for (DynamicObject bizDataRelation : bizDataRelations) {
            result.put(bizDataRelation.getString("bizdatacode"), bizDataRelation.getDate("dataobtaintime"));
        }
        return result;
    }

    public Map<String, String> initIsConfictMap(DynamicObject[] bizDataRelations) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (DynamicObject bizDataRelation : bizDataRelations) {
            result.put(bizDataRelation.getString("bizdatacode"), bizDataRelation.getString("isconfilct"));
        }
        return result;
    }

    public Map<String, DynamicObject> initRelationMap(DynamicObject[] relationBizDataDetails, DynamicObjectCollection bizDataDetails, Map<String, String> relationCodeMap) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        block0: for (DynamicObject relationBizDataDetail : relationBizDataDetails) {
            for (DynamicObject bizDataDetail : bizDataDetails) {
                String relationCode = relationBizDataDetail.getString("bizdatacode");
                if (!relationBizDataDetail.getString("bizdatacode").equals(relationCodeMap.get(bizDataDetail.getString("bizdatacode")))) continue;
                result.put(relationCode, bizDataDetail);
                continue block0;
            }
        }
        return result;
    }

    public void initEntryEntityTable(DynamicObject[] relationBizDataDetails, DynamicObject[] bizDataBillEnts, DynamicObject[] bizDataRelations) {
        IDataModel dataModel = this.getModel();
        if (!(dataModel instanceof AbstractFormDataModel)) {
            return;
        }
        Map<String, DynamicObject> bizDataMap = Arrays.stream(bizDataBillEnts).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy, (dy1, dy2) -> dy1));
        Map<String, DynamicObject> relBizMap = Arrays.stream(relationBizDataDetails).collect(Collectors.toMap(dy -> dy.getString("bizdatacode"), dy -> dy, (dy1, dy2) -> dy1));
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int indexRow = 0;
        for (int index = 0; index < bizDataRelations.length; ++index) {
            DynamicObject relObj = bizDataRelations[index];
            DynamicObject bizDataObj = bizDataMap.get(relObj.getString("bizdatacode"));
            DynamicObject relBizData = relBizMap.get(relObj.getString("relationbizdatacode"));
            if (SWCObjectUtils.isEmpty((Object)bizDataObj) || SWCObjectUtils.isEmpty((Object)relBizData)) continue;
            vs.set("empposorgrel", (Object)relBizData.getLong("empposorgrel.id"), indexRow);
            vs.set("bizdate", (Object)relBizData.getDate("bizdate"), indexRow);
            vs.set("payrollgrp", (Object)relBizData.getLong("payrollgrp.id"), indexRow);
            vs.set("salaryfile", (Object)relBizData.getLong("salaryfile.id"), indexRow);
            vs.set("bizitem", (Object)relBizData.getLong("bizitem.id"), indexRow);
            DynamicObjectCollection dtlCollection = bizDataObj.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)dtlCollection)) {
                DynamicObject bizDataObjDtl = (DynamicObject)dtlCollection.get(0);
                vs.set("effectivedate", (Object)bizDataObjDtl.getDate("effectivedate"), indexRow);
                vs.set("expirydate", (Object)bizDataObjDtl.getDate("expirydate"), indexRow);
                vs.set("value", (Object)bizDataObjDtl.getString("value"), indexRow);
                Date effectiveDate = bizDataObjDtl.getDate("effectivedate");
                if (effectiveDate != null) {
                    vs.set("afterupdatedate", (Object)SWCDateTimeUtils.addDay((Date)effectiveDate, (long)-1L), indexRow);
                }
            }
            vs.set("currency", (Object)bizDataObj.getLong("currency.id"), indexRow);
            vs.set("description", (Object)bizDataObj.getString("remark"), indexRow);
            vs.set("bizdatacode", (Object)bizDataObj.getString("bizdatacode"), indexRow);
            vs.set("relationeffectivedate", (Object)relBizData.getDate("effectivedate"), indexRow);
            vs.set("relationexpirydate", (Object)relBizData.getDate("expirydate"), indexRow);
            vs.set("relationcurrency", (Object)relBizData.getLong("currency.id"), indexRow);
            vs.set("relationvalue", (Object)relBizData.getString("value"), indexRow);
            vs.set("relationdescription", (Object)relBizData.getString("description"), indexRow);
            vs.set("relationbizdatacode", (Object)relBizData.getString("bizdatacode"), indexRow);
            vs.set("isconfilct", (Object)relObj.getString("isconfilct"), indexRow);
            vs.set("dataobtaintime", (Object)relObj.getDate("dataobtaintime"), indexRow);
            ++indexRow;
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public Map<String, String> getRelationCodeMap(DynamicObject[] bizDataRelations) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (int index = 0; index < bizDataRelations.length; ++index) {
            String relationCode = bizDataRelations[index].getString("relationbizdatacode");
            String code = bizDataRelations[index].getString("bizdatacode");
            result.put(code, relationCode);
        }
        return result;
    }

    public String[] getRelationBizDatas(DynamicObject[] bizDataRelations) {
        String[] result = new String[bizDataRelations.length];
        for (int index = 0; index < bizDataRelations.length; ++index) {
            result[index] = bizDataRelations[index].getString("relationbizdatacode");
        }
        return result;
    }
}

