/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public class SideWorkflowPlugin
extends SWCCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(SideWorkflowPlugin.class);
    private static final String RIGHTMAIN_PANEL = "rightmainpanel";
    private static final String SPLIT_PANEL_AP = "splitcontainerap";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setWorkflowVisible();
    }

    private void setWorkflowVisible() {
        String billNo = (String)this.getView().getModel().getValue("billno");
        if (!SWCStringUtils.isEmpty((String)billNo)) {
            DynamicObject obj = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("id, billstatus, datastatus", new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
            SplitContainer container = (SplitContainer)this.getView().getControl(SPLIT_PANEL_AP);
            if (SWCObjectUtils.isEmpty((Object)obj)) {
                logger.info("hpdi_SideWorkflowPlugin_setWorkflowVisible queryBizDataBillInfo is empty");
                container.hidePanel(SplitDirection.right, true);
                container.setCollapse(true);
            } else {
                String parentFormId;
                String bizKey = (String)this.getView().getFormShowParameter().getCustomParam("businessKey");
                logger.info("hpdi_SideWorkflowPlugin_setWorkflowVisible billNo is:{}, businessKey is:{}", (Object)billNo, (Object)bizKey);
                try {
                    parentFormId = this.getView().getFormShowParameter().getParentFormId();
                }
                catch (Exception exception) {
                    parentFormId = null;
                }
                logger.info("hpdi_SideWorkflowPlugin_setWorkflowVisible billNo is:{}, parentFormId is:{}", (Object)billNo, (Object)parentFormId);
                if (!SWCStringUtils.equals((String)parentFormId, (String)"hpdi_apphome")) {
                    container.hidePanel(SplitDirection.right, true);
                    container.setCollapse(true);
                } else {
                    Long processInstanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)String.valueOf(obj.getLong("id")));
                    logger.info("hpdi_SideWorkflowPlugin_setWorkflowVisible billNo is:{}, getProcessInstanceIdByBusinessKey is: {}", (Object)billNo, processInstanceId == null ? "null" : processInstanceId);
                    if (processInstanceId == null || processInstanceId == 0L) {
                        container.hidePanel(SplitDirection.right, true);
                        container.setCollapse(true);
                    } else {
                        container.hidePanel(SplitDirection.right, false);
                        container.setCollapse(false);
                    }
                }
            }
        }
        this.refreshWFRecord();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "refresh": 
            case "submit": 
            case "unsubmit": {
                this.setWorkflowVisible();
                break;
            }
            case "save": {
                this.getView().setVisible(Boolean.TRUE, new String[]{RIGHTMAIN_PANEL});
                break;
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{RIGHTMAIN_PANEL});
    }

    private void refreshWFRecord() {
        String id = this.getId();
        ApprovalRecord approvalRecord = (ApprovalRecord)this.getControl("approvalrecordap");
        if (null != approvalRecord) {
            String businessKey = SWCStringUtils.isEmpty((String)id) ? "0" : id;
            HashMap shareParams = new HashMap(16);
            approvalRecord.setParameters(shareParams);
            approvalRecord.setBusinessKey(businessKey);
        }
    }

    private String getId() {
        BillShowParameter param = (BillShowParameter)this.getView().getFormShowParameter();
        Object id = param.getPkId();
        if (null == id) {
            return "";
        }
        return param.getPkId().toString();
    }
}

