/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata.bizdataoperatelog;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections.CollectionUtils;

public class BizDataOperateLogList
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        String parentBillFormId = (String)this.getView().getFormShowParameter().getCustomParam("parentBillFormId");
        if ("hpdi_bizdatarecord".equals(parentBillFormId)) {
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn column = (IListColumn)iterator.next();
                if (!"bizitem.name".equals(column.getListFieldKey())) continue;
                iterator.remove();
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List bizDataCodes = (List)this.getView().getFormShowParameter().getCustomParam("bizDataCodes");
        if (CollectionUtils.isNotEmpty((Collection)bizDataCodes)) {
            List filterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumns) {
                if (!"modifytime".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("");
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List bizDataCodes = (List)showParameter.getCustomParam("bizDataCodes");
        if (CollectionUtils.isNotEmpty((Collection)bizDataCodes)) {
            evt.addCustomQFilter(new QFilter("bizdatacode", "in", (Object)bizDataCodes));
        }
        evt.addCustomQFilter(this.getParentFormFilter());
    }

    private QFilter getParentFormFilter() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parentBillFormId = (String)showParameter.getCustomParam("parentBillFormId");
        if (null == parentBillFormId) {
            return null;
        }
        QFilter filter = null;
        switch (parentBillFormId) {
            case "hpdi_allbizdata": {
                filter = new QFilter("modeltype", "=", (Object)"1");
                break;
            }
            case "hpdi_circlebizdata": {
                filter = new QFilter("modeltype", "=", (Object)"1");
                filter.and("bizitem.cycle", "=", (Object)"1");
                break;
            }
            case "hpdi_notcirclebizdata": {
                filter = new QFilter("modeltype", "=", (Object)"1");
                filter.and("bizitem.cycle", "=", (Object)"0");
                break;
            }
            case "hpdi_bizdatarecord": {
                Long bizItemGroupId = (Long)showParameter.getCustomParam("bizItemGroupId");
                filter = new QFilter("bizitemgroup", "=", (Object)bizItemGroupId);
                filter.and("modeltype", "=", (Object)"2");
                break;
            }
        }
        return filter;
    }
}

