/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata.transversetable;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ListVisible;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hpdi.business.bizdata.export.BizDataExportDataHelper;
import kd.swc.hpdi.business.bizdata.herizonlist.BizDataHorizonListExportService;
import kd.swc.hpdi.business.bizdata.herizonlist.BizDataHorizonRecordHelper;
import kd.swc.hpdi.business.bizdata.herizonlist.BizDataHorizonRecordService;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.common.vo.BizDataRecordExportProgressInfo;
import kd.swc.hpdi.formplugin.web.bizdata.transversetable.BizDataEntityTypeBillList;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataRecordBasePlugin
extends SWCDataBaseList {
    public final Log log = LogFactory.getLog(BizDataRecordBasePlugin.class);
    private static final String CLOSE_LABEL = "donothing_close";
    private static final String BIZITEMGROUP = "bizitemgroup";
    private Map<Long, DynamicObject> cacheBizItemMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, String> cacheDataTypeMap;
    private static final int TEXT_DEFAULT_LENGTH = 1000;
    private static final int NUM_DEFAULT_LENGTH = 10;
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private BizDataEntityTypeBillList billList;
    private static final String EXPORT = "donothing_export";
    public static final Integer PAGE_SIZE = 100;
    private static final String MODULE_NAME = "swc-hpdi-formplugin";
    public static final int ROW_ACCESS_WINDOWS_SIZE = PAGE_SIZE;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final int START = 0;
    public static final String CACHE_CALTABLE_EXPORT_KEY = "SWC_CALTABLE_%s";
    public static final int MAX_EXPORT_AWAIT_MINUTES = 30;
    public static final String KEY_USAGESTATUS = "usagestatus";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)CLOSE_LABEL)) {
            this.pageCloseEvent();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && EXPORT.equals(opKey)) {
            this.doExport();
        }
    }

    public void setFilter(SetFilterEvent event) {
        this.cacheColumnFilter(event);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            event.getQFilters().add(new QFilter("1", "!=", (Object)1));
            return;
        }
        if (this.parentViewIsRollBack()) {
            List<Long> bizDataRecordIds = this.getBizDataRecordIds();
            if (CollectionUtils.isNotEmpty(bizDataRecordIds)) {
                event.getQFilters().add(new QFilter("id", "in", bizDataRecordIds));
            }
            return;
        }
        DynamicObject bizItemGroupObj = (DynamicObject)parentView.getModel().getValue(BIZITEMGROUP);
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupObj)) {
            event.getQFilters().add(new QFilter("1", "!=", (Object)1));
        } else {
            ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
            Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
            event.getQFilters().add(new QFilter(BIZITEMGROUP, "=", (Object)bizItemGroupId));
        }
        this.cacheColumnFilter(event);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        List<IListColumn> newColumns = this.buildBizDataCloumns(columns);
        args.setListColumns(newColumns);
        args.getListColumn("expirydate").setVisible(ListVisible.NOT.getVisible());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BizDataRecordLoadDataImpl());
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        super.getEntityType(args);
        args.setNewEntityType(this.getEntityType());
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            args.setControl((Control)customControl);
        }
    }

    protected BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new BizDataEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hpdi_bizdatarecord");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (SWCStringUtils.equals((String)"applyno", (String)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            Long id = (Long)listView.getFocusRowPkId();
            DynamicObject bizData = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.queryOne("applyno", (Object)id);
            if (SWCObjectUtils.isEmpty((Object)bizData)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u4e0d\u5b58\u5728", (String)"BizDataRecordBasePlugin_0", (String)MODULE_NAME, (Object[])new Object[0]));
                return;
            }
            DynamicObject bizDataBill = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER.queryOne("id, org.id", new QFilter[]{new QFilter("billno", "=", (Object)bizData.getString("applyno"))});
            if (!BizDataHelper.hasOrgPermission((Long)bizDataBill.getLong("org.id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u8be2\u201d\u201c\u4e1a\u52a1\u6570\u636e\u63d0\u62a5\u201d\u7684\u6570\u636e\u6743\u9650\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizDataList_10", (String)MODULE_NAME, (Object[])new Object[0]));
                return;
            }
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId("hpdi_bizdatabill");
            parameter.setPkId((Object)bizDataBill.getLong("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hpdi_bizdatarecord");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        MainEntityType returnEntityType = this.addMainEntityType(mainEntityType);
        if (returnEntityType == null) {
            return mainType;
        }
        return returnEntityType;
    }

    private MainEntityType addMainEntityType(MainEntityType mainEntityType) {
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            return null;
        }
        BizDataHorizonRecordHelper bizDataHorizonRecordHelper = new BizDataHorizonRecordHelper();
        DynamicObject bizItemGroupDetailObj = this.cacheBizItemMap.get(bizItemGroupId);
        if (bizItemGroupDetailObj == null) {
            bizItemGroupDetailObj = bizDataHorizonRecordHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
            this.cacheBizItemMap.put(bizItemGroupId, bizItemGroupDetailObj);
        }
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return null;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return null;
        }
        Map<Long, String> dataTypeMap = this.getCacheDataTypeMap();
        for (DynamicObject bizItemEntryObj : bizItemColl) {
            DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
            DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeMap.get(dataTypeId);
            this.addBizItemProp(bizItemObj, dataType, (DynamicObjectType)mainEntityType);
        }
        if (this.parentViewIsRollBack()) {
            LocaleString usageStatusName = new LocaleString(ResManager.loadKDString((String)"\u7b97\u85aa\u4f7f\u7528\u72b6\u6001", (String)"BizDataRecordBasePlugin_5", (String)MODULE_NAME, (Object[])new Object[0]));
            TextProp property = new TextProp();
            property.setName(KEY_USAGESTATUS);
            property.setDisplayName(usageStatusName);
            mainEntityType.addProperty((DynamicProperty)property);
        }
        return mainEntityType;
    }

    private void addBizItemProp(DynamicObject bizItemObj, String dataType, DynamicObjectType mainEntityType) {
        String bizItemNumber = bizItemObj.getString("number");
        String bizItemName = bizItemObj.getString("name");
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            TextProp property = new TextProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setMaxLenth(bizItemObj.getInt("datalength") == 0 ? 1000 : bizItemObj.getInt("datalength"));
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.NUM.getCode().equals(dataType)) {
            DecimalProp property = new DecimalProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setPrecision(23);
            String scalelimit = bizItemObj.getString("scalelimit");
            if (SWCStringUtils.isEmpty((String)scalelimit)) {
                property.setScale(10);
            } else {
                property.setScale(Integer.parseInt(scalelimit));
            }
            property.setZeroShow(true);
            property.setEnableNull(true);
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            DateProp property = new DateProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            TextProp property = new TextProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setMaxLenth(50);
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    private List<IListColumn> buildBizDataCloumns(List<IListColumn> columns) {
        int index;
        ArrayList<IListColumn> newColumns = new ArrayList<IListColumn>(10);
        for (index = 0; index <= 20; ++index) {
            newColumns.add(columns.get(index));
        }
        BizDataHorizonRecordHelper bizDataHorizonRecordHelper = new BizDataHorizonRecordHelper();
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            return columns;
        }
        DynamicObject bizItemGroupDetailObj = this.cacheBizItemMap.get(bizItemGroupId);
        if (bizItemGroupDetailObj == null) {
            bizItemGroupDetailObj = bizDataHorizonRecordHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
            this.cacheBizItemMap.put(bizItemGroupId, bizItemGroupDetailObj);
        }
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return columns;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return columns;
        }
        Map<Long, String> dataTypeMap = this.getCacheDataTypeMap();
        for (DynamicObject bizItemObj : bizItemColl) {
            DynamicObject bizItemInfo = bizItemObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemInfo)) continue;
            String bizItemNumber = bizItemInfo.getString("number");
            String bizItemName = bizItemInfo.getString("name");
            DynamicObject dataTypeObj = bizItemInfo.getDynamicObject("datatype");
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeMap.get(dataTypeId);
            this.addBizItemColumns(bizItemNumber, bizItemName, dataType, newColumns);
        }
        boolean isRollBack = this.parentViewIsRollBack();
        LocaleString usageStatusName = new LocaleString(ResManager.loadKDString((String)"\u7b97\u85aa\u4f7f\u7528\u72b6\u6001", (String)"BizDataRecordBasePlugin_5", (String)MODULE_NAME, (Object[])new Object[0]));
        while (index < columns.size()) {
            if (isRollBack && "calsalarydate".equals(columns.get(index).getListFieldKey())) {
                ListColumn column = new ListColumn();
                column.setCaption(usageStatusName);
                column.setKey(KEY_USAGESTATUS);
                column.setListFieldKey(KEY_USAGESTATUS);
                newColumns.add((IListColumn)column);
            }
            newColumns.add(columns.get(index));
            ++index;
        }
        return newColumns;
    }

    private void addBizItemColumns(String number, String name, String dataType, List<IListColumn> columns) {
        if (SWCShowType.NUM.getCode().equals(dataType)) {
            DecimalListColumn decimalCol = new DecimalListColumn();
            decimalCol.setCaption(new LocaleString(name));
            decimalCol.setKey(number.toLowerCase());
            decimalCol.setListFieldKey(number.toLowerCase());
            decimalCol.setZeroShow(true);
            columns.add((IListColumn)decimalCol);
        } else {
            ListColumn column = new ListColumn();
            column.setCaption(new LocaleString(name));
            column.setKey(number.toLowerCase());
            column.setListFieldKey(number.toLowerCase());
            columns.add((IListColumn)column);
        }
    }

    private Map<Long, String> getCacheDataTypeMap() {
        if (this.cacheDataTypeMap != null && this.cacheDataTypeMap.size() > 0) {
            return this.cacheDataTypeMap;
        }
        BizDataHorizonRecordHelper bizDataHorizonRecordHelper = new BizDataHorizonRecordHelper();
        DynamicObject[] dataTypeArray = bizDataHorizonRecordHelper.getDataType();
        if (dataTypeArray == null || dataTypeArray.length == 0) {
            return new HashMap<Long, String>(16);
        }
        HashMap<Long, String> dataTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject dataTypeObj : dataTypeArray) {
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeObj.getString("storagetype");
            dataTypeMap.put(dataTypeId, dataType);
        }
        this.cacheDataTypeMap = dataTypeMap;
        return this.cacheDataTypeMap;
    }

    private void pageCloseEvent() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getView().close();
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }

    private void doExport() {
        BillList billListAp = new BillList();
        billListAp.setKey(KEY_BILL_LIST_AP);
        billListAp.setEntityId("hpdi_bizdatarecord");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        for (int index = 0; index < size; ++index) {
            selectRows[index] = (Long)selectedRows.get(index).getPrimaryKeyValue();
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"BizDataRecordBasePlugin_45", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = this.getQueryFilters(selectRows, bizItemGroupId);
        BizDataHorizonRecordHelper bizDataRecordListHelper = new BizDataHorizonRecordHelper();
        DynamicObject bizItemGroupDetailObj = bizDataRecordListHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        BizDataHorizonListExportService bizDataRecordListExportService = new BizDataHorizonListExportService();
        Map headerMap = bizDataRecordListExportService.getExportHeaders(bizItemColl, this.parentViewIsRollBack());
        this.startExport(filters, headerMap, bizItemGroupId);
    }

    private void startExport(QFilter[] filters, Map<String, String> headerMap, Long bizItemGroupId) {
        String downLoadTaskId = this.getExportTaskID();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hpdi_bizdatarecord", filters);
        if (totalElements == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"BizDataRecordBasePlugin_45", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u4e1a\u52a1\u6570\u636e\uff08\u6a2a\u8868\uff09_{0}", (String)"BizDataRecordBasePlugin_7", (String)MODULE_NAME, (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        BizDataRecordExportProgressInfo progressInfo = new BizDataRecordExportProgressInfo();
        boolean isRollBackPage = this.parentViewIsRollBack();
        Map<String, String> usMap = this.getUsageStatus();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("isRollBackPage", isRollBackPage);
        param.put("usageStatusMap", usMap);
        ThreadPools.executeOnce((String)"HPDI_BIZDATARECORD_EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.log.info("hpdi bizDataRecord starting export data: {}", (Object)stopWatch.toString());
            try (SXSSFWorkbook wb = new SXSSFWorkbook(ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                BizDataHorizonListExportService bizDataRecordListExportService = new BizDataHorizonListExportService();
                bizDataRecordListExportService.write2ExportHead(sheet, headerMap);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getCommonExportThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List data = bizDataRecordListExportService.getExportData(filters, bizItemGroupId, currentPage, PAGE_SIZE.intValue(), param);
                            lock.lock();
                            bizDataRecordListExportService.write2ExportContent(sheet, Integer.valueOf(currentPage * PAGE_SIZE + 1), data, headerMap);
                        }
                        catch (Exception e) {
                            this.log.error("CalTableExportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(this.getView());
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            if (totalElements < 100) {
                                complete = totalElements;
                            } else {
                                complete = ((long)totalPages - countDownLatch.getCount()) * (long)PAGE_SIZE.intValue();
                                if (complete > (long)totalElements) {
                                    complete = totalElements;
                                }
                            }
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            this.addTaskInfoToCache(progressInfo, totalElements, progress, (int)complete, downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(30L, TimeUnit.MINUTES)) {
                    this.flushAll(headerMap, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements);
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        });
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, BizDataRecordExportProgressInfo progressInfo, int totalElements) throws IOException {
        List headList = BizDataExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            Map columnMap = (Map)headList.get(i);
            String key = (String)columnMap.get("key");
            if (SWCStringUtils.equals((String)key, (String)"fseq")) {
                sheet.setColumnWidth(i, columnWidth);
                continue;
            }
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = BizDataExportDataHelper.writeFile((SXSSFWorkbook)sheet.getWorkbook(), (String)fileName);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        this.addTaskInfoToCache(progressInfo, totalElements, progress, totalElements, downLoadTaskId);
        stopWatch.stop();
        this.log.info("ending export data: %s,countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u8bb0\u5f55", (String)"BizDataRecordBasePlugin_3", (String)MODULE_NAME, (Object[])new Object[0]));
        para.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\uff08\u6a2a\u8868\uff09\u5bfc\u51fa\u8fdb\u5ea6", (String)"BizDataRecordBasePlugin_6", (String)MODULE_NAME, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private String getExportTaskID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private QFilter[] getQueryFilters(long[] selectRows, Long bizItemGroupId) {
        SWCPageCache pageCache;
        List columnFilterList;
        if (this.parentViewIsRollBack()) {
            List<Long> bizDataRecordIds;
            QFilter qFilter = null != selectRows && selectRows.length > 0 ? new QFilter("id", "in", (Object)selectRows) : (CollectionUtils.isNotEmpty(bizDataRecordIds = this.getBizDataRecordIds()) ? new QFilter("id", "in", bizDataRecordIds) : new QFilter("1", "!=", (Object)1));
            return qFilter.toArray();
        }
        QFilter filter = new QFilter(BIZITEMGROUP, "=", (Object)bizItemGroupId);
        if (selectRows != null && selectRows.length > 0) {
            filter.and("id", "in", (Object)selectRows);
        }
        if ((columnFilterList = (List)(pageCache = new SWCPageCache(this.getView())).get("columnFilterList", List.class)) != null && columnFilterList.size() > 0) {
            for (String columnFilterStr : columnFilterList) {
                QFilter columnFilter = QFilter.fromSerializedString((String)columnFilterStr);
                filter.and(columnFilter);
            }
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    private void addTaskInfoToCache(BizDataRecordExportProgressInfo progressInfo, int totalElements, Double progress, int complete, String downLoadTaskId) {
        progressInfo.setProgress(progress);
        progressInfo.setTotal(totalElements);
        progressInfo.setComplete(complete);
        progressInfo.setStatus(0);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, CACHE_CALTABLE_EXPORT_KEY, downLoadTaskId));
        String progressInfoKey = MessageFormat.format("progressInfo_{0}", downLoadTaskId);
        appCache.put(progressInfoKey, (Object)progressInfo);
    }

    private boolean parentViewIsRollBack() {
        boolean isRollBack = false;
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        String rollBackPage = (String)appCache.get(this.getView().getPageId() + "_rollbackpage", String.class);
        if ("1".equals(rollBackPage)) {
            isRollBack = true;
        }
        return isRollBack;
    }

    private Map<String, String> getUsageStatus() {
        Map usMap = (Map)this.getView().getFormShowParameter().getCustomParam("usageStatus");
        return usMap;
    }

    private List<Long> getBizDataRecordIds() {
        List bizDataRecordIds = null;
        IFormView parentView = this.getView().getParentView();
        Map customParam = (Map)parentView.getFormShowParameter().getCustomParam("condition");
        String bizDataRecordIdStr = (String)customParam.get("bizDataRecordIds");
        if (!SWCStringUtils.isEmpty((String)bizDataRecordIdStr)) {
            bizDataRecordIds = JSON.parseArray((String)bizDataRecordIdStr, Long.class);
        }
        return bizDataRecordIds;
    }

    private void cacheColumnFilter(SetFilterEvent event) {
        List filterList = event.getMergeQFilters();
        filterList.add(this.getBizDataDimFilter());
        if ("hstc".equals(this.getView().getFormShowParameter().getCustomParam("appid"))) {
            String sourceSSCMenu = (String)this.getView().getFormShowParameter().getCustomParam("sourceSSCMenu");
            if (HRStringUtils.equals((String)Boolean.toString(Boolean.TRUE), (String)sourceSSCMenu)) {
                filterList.add(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
            }
        }
        if (filterList != null && filterList.size() > 0) {
            ArrayList<String> columnFilterList = new ArrayList<String>(filterList.size());
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            for (QFilter qFilter : filterList) {
                if (qFilter == null) continue;
                String comulnFilterStr = qFilter.toSerializedString();
                columnFilterList.add(comulnFilterStr);
            }
            pageCache.put("columnFilterList", columnFilterList);
        }
    }

    private QFilter getBizDataDimFilter() {
        QFilter dimFilter = null;
        Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatarecord", (String)"47150e89000000ac");
        this.log.info("*****************BizDataRecordBasePlugin.getBizDataDimFilter bizDataDimIds is :{}", (Object)bizDataDimIds);
        if (null != bizDataDimIds) {
            dimFilter = new QFilter("id", "in", (Object)bizDataDimIds);
        }
        return dimFilter;
    }

    public class BizDataRecordLoadDataImpl
    extends ListDataProvider {
        boolean isSelectAllRows = false;

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection bizDataRecordDatas = super.getData(start, limit);
            if (bizDataRecordDatas == null || bizDataRecordDatas.size() == 0 || this.isSelectAllRows) {
                return bizDataRecordDatas;
            }
            BizDataRecordBasePlugin.this.addMainEntityType((MainEntityType)bizDataRecordDatas.getDynamicObjectType());
            BizDataHorizonRecordService service = new BizDataHorizonRecordService();
            Map dataTypeMap = BizDataRecordBasePlugin.this.getCacheDataTypeMap();
            service.getBizDataRecordDatas(bizDataRecordDatas, dataTypeMap);
            if (BizDataRecordBasePlugin.this.parentViewIsRollBack()) {
                Map usMap = BizDataRecordBasePlugin.this.getUsageStatus();
                service.setBizDataRecordUsageStatus(bizDataRecordDatas, usMap);
            }
            return bizDataRecordDatas;
        }

        protected boolean isOnlyPK4SelectedAllRows() {
            this.isSelectAllRows = true;
            return true;
        }
    }
}

