/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.bizdata.transversetable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.HPDIResMgrBusiness;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataRecordList
extends AbstractListPlugin {
    private static final String AFTER_CONFIRM_CALLBACK = "after_confirm_callback";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"abandon"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "abandon": {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.size() == 0) break;
                Object[] bizDataRecordIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                DynamicObject[] bizDataRecordArr = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.query(bizDataRecordIds);
                boolean allTransCal = Arrays.stream(bizDataRecordArr).allMatch(dy -> BizDataStatusEnum.TO_BE_PUSH_SALARY.getCode().equals(dy.getString("bizdatastatus")) || BizDataStatusEnum.PUSHED_SALARY_FAIL.getCode().equals(dy.getString("bizdatastatus")) || BizDataStatusEnum.WITHDRAWN.getCode().equals(dy.getString("bizdatastatus")));
                if (!allTransCal) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u5f85\u63a8\u9001\u7b97\u85aa\u201d\u3001\u201c\u63a8\u9001\u7b97\u85aa\u5931\u8d25\u201d\u3001\u201c\u5df2\u64a4\u56de\u201d\u7684\u6570\u636e\u8fdb\u884c\u5e9f\u5f03\u5904\u7406\u3002", (String)"BizDataList_13", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    break;
                }
                BizDataHelper.abandonBeforeDo((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calsalary": {
                this.beforeTransSalary(args);
                break;
            }
            case "nocirclerollback": {
                this.doNoCircleRollback(args);
                break;
            }
            case "donothing_viewoprecord": {
                DynamicObject bizItemGroup = this.getView().getParentView().getModel().getDataEntity().getDynamicObject("bizitemgroup");
                if (SWCObjectUtils.isEmpty((Object)bizItemGroup)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u201d\u3002", (String)"BizDataRecordList_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                List<Long> selectRowIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                this.showBizDataOpRecord(selectRowIds);
                break;
            }
            case "listrow_viewoprecord": {
                Long currentSelectBizDataId = (Long)((IListView)this.getView()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
                ArrayList<Long> currentSelectBizDataIds = new ArrayList<Long>(1);
                currentSelectBizDataIds.add(currentSelectBizDataId);
                this.showBizDataOpRecord(currentSelectBizDataIds);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "doabandon": {
                BizDataHelper.afterDoAbandon((IFormView)this.getView(), (AfterDoOperationEventArgs)args);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "calsalary": {
                this.getView().showSuccessNotification(args.getOperationResult().getMessage());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "nocirclerollback": {
                OperationResult operateResult = args.getOperationResult();
                if (operateResult.isSuccess()) {
                    this.getView().showSuccessNotification(HPDIResMgrBusiness.getMsgOfRollbackSuccess());
                } else {
                    operateResult.setMessage(null);
                    List errorInfos = operateResult.getAllErrorInfo();
                    if (!CollectionUtils.isEmpty((Collection)errorInfos)) {
                        Iterator it = errorInfos.iterator();
                        while (it.hasNext()) {
                            OperateErrorInfo errorInfo = (OperateErrorInfo)it.next();
                            if ("rollback_fail".equals(errorInfo.getErrorCode())) continue;
                            it.remove();
                        }
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String key = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (key) {
            case "abandon_confirm": {
                BizDataHelper.abandonCheckClose((IFormView)this.getView(), (MessageBoxClosedEvent)event);
                break;
            }
            case "nocirclerollback": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                OperateOption noCircleRollbackOp = OperateOption.create();
                noCircleRollbackOp.setVariableValue(AFTER_CONFIRM_CALLBACK, "yes");
                noCircleRollbackOp.setVariableValue("billFormId", ((IListView)this.getView()).getBillFormId());
                this.getView().invokeOperation("nocirclerollback", noCircleRollbackOp);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("condition");
        if (customParam != null && customParam.size() > 0) {
            List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            if (SWCListUtils.isEmpty((List)commonFilterColumnList)) {
                return;
            }
            for (FilterColumn listFilter : commonFilterColumnList) {
                List dataRange;
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if (fieldName.equals("submitdate") && (dataRange = (List)customParam.get(fieldName)) != null) {
                    commFilter.setDefaultValues(new Object[]{dataRange.get(0), dataRange.get(1)});
                }
                if (!fieldName.equals("bizdatastatus") || !customParam.containsKey("bizdatastatus")) continue;
                commFilter.setDefaultValues(new Object[]{String.valueOf(customParam.get(fieldName))});
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "bizdatadim.name": {
                Set bizDataDimIds = SWCPermissionServiceHelper.getBizDataDimSetByPermItem((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatarecord", (String)"47150e89000000ac");
                if (null == bizDataDimIds) break;
                QFilter dimFilter = new QFilter("id", "in", (Object)bizDataDimIds);
                filters.add(dimFilter);
                break;
            }
        }
    }

    private void beforeTransSalary(BeforeDoOperationEventArgs args) {
        DynamicObject[] bizDataRecordArr;
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u6570\u636e\u201d\u3002", (String)"BizDataList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<Long> selectedRowIds = new ArrayList<Long>(10);
        for (ListSelectedRow selectedRow : selectedRows) {
            selectedRowIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        SWCDataServiceHelper bizDataRecordHleper = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER;
        QFilter qFilter = new QFilter("id", "in", selectedRowIds);
        for (DynamicObject bizDataRecord : bizDataRecordArr = bizDataRecordHleper.query("id, bizdatastatus", new QFilter[]{qFilter})) {
            String bizDataStatus = bizDataRecord.getString("bizdatastatus");
            if ("1".equals(bizDataStatus) || "4".equals(bizDataStatus) || "7".equals(bizDataStatus)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u5f85\u63a8\u9001\u7b97\u85aa\u201d\u3001\u201c\u63a8\u9001\u7b97\u85aa\u5931\u8d25\u201d\u3001\u201c\u5df2\u64a4\u56de\u201d\u7684\u6570\u636e\u8fdb\u884c\u63a8\u9001\u7b97\u85aa\u5904\u7406\u3002", (String)"BizDataRecordList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void doNoCircleRollback(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (formOperate.getOption().tryGetVariableValue(AFTER_CONFIRM_CALLBACK, new RefObject())) {
            return;
        }
        if (formOperate.getOption().tryGetVariableValue("batchop_completed", new RefObject())) {
            return;
        }
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        List bizDataRecordIds = selectRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("bizdatarecord", "in", bizDataRecordIds);
        DynamicObject[] bizDataArray = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER.query("id, bizdatastatus", qFilter.toArray());
        boolean allTransCal = Arrays.stream(bizDataArray).allMatch(dy -> "3".equals(dy.getString("bizdatastatus")));
        if (!allTransCal) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u56de\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63a8\u9001\u7b97\u85aa\u201d\u7684\u6570\u636e\u3002", (String)"BizDataList_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("nocirclerollback", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u56de\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u7528\u4e8e\u85aa\u8d44\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizDataList_11", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBack);
    }

    private void showBizDataOpRecord(List<Long> bizDataRecordIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("hpdi_bizdataoperatelog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String billFormId = ((IListView)this.getView()).getBillFormId();
        listShowParameter.setCustomParam("parentBillFormId", (Object)billFormId);
        listShowParameter.setCustomParam("bizItemGroupId", (Object)this.getView().getParentView().getModel().getDataEntity().getLong("bizitemgroup.id"));
        if (!CollectionUtils.isEmpty(bizDataRecordIds)) {
            QFilter filter = new QFilter("id", "in", bizDataRecordIds);
            DynamicObject[] bizDatas = HPDIDataServiceHelper.HPDI_BIZDATARECORD_HELPER.query("bizdatacode", new QFilter[]{filter});
            List bizDataCodes = Arrays.stream(bizDatas).map(dy -> dy.getString("bizdatacode")).collect(Collectors.toList());
            listShowParameter.setCustomParam("bizDataCodes", bizDataCodes);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

