/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hpdi.business.bizdata.enums.BizDataStatusEnum;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.formplugin.web.homepage.BizDataErrorComparePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataBillCardPlugin
extends AbstractBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(BizDataBillCardPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            Date startDate = (Date)this.getView().getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)this.getView().getParentView().getModel().getValue("datarange_enddate");
            if (SWCObjectUtils.isEmpty((Object)startDate) || SWCObjectUtils.isEmpty((Object)endDate)) {
                return;
            }
            DynamicObject bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup");
            long bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
            try {
                startDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00"));
                endDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59"));
            }
            catch (ParseException parseException) {
                LOGGER.info(parseException.getMessage());
            }
            this.showManualSubmissionBill(startDate, endDate, bizDataModule);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
            String operateKey = formOperate.getOperateKey();
            Date startDate = (Date)this.getView().getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)this.getView().getParentView().getModel().getValue("datarange_enddate");
            DynamicObject bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup");
            long bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            ArrayList<String> datarange = new ArrayList<String>();
            datarange.add(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00");
            datarange.add(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59");
            customParam.put("createtime", datarange);
            if (bizDataModule != 0L) {
                customParam.put("bizitemgroup", bizDataModule);
            }
            if ("donothing_temporarystoragecount".equals(operateKey)) {
                customParam.put("billstatus", new String[]{"A"});
                this.OpenListPage(customParam);
            } else if ("donothing_underapprovalcount".equals(operateKey)) {
                customParam.put("billstatus", new String[]{"D", "B"});
                this.OpenListPage(customParam);
            } else if ("donothing_waitsubmit".equals(operateKey)) {
                customParam.put("billstatus", new String[]{"G"});
                this.OpenListPage(customParam);
            } else if ("donothing_approvalfailedcount".equals(operateKey)) {
                customParam.put("billstatus", new String[]{"E"});
                this.OpenListPage(customParam);
            } else if ("donothing_dataexceptioncount".equals(operateKey)) {
                ArrayList<String> dataStatus = new ArrayList<String>();
                dataStatus.add(BizDataStatusEnum.ALL_FAILED_PRESENT.getCode());
                dataStatus.add(BizDataStatusEnum.PART_PRESENT.getCode());
                customParam.put("datastatus", dataStatus);
                this.OpenListPage(customParam);
            }
        }
    }

    private void showManualSubmissionBill(Date startDate, Date endDate, long bizItemGroup) {
        DynamicObject[] bizDataBills;
        HasPermOrgResult permOrgResult;
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATABILL_HELPER;
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        QFilter filter = new QFilter("createtime", ">", (Object)startDate);
        filter.and(new QFilter("createtime", "<", (Object)endDate));
        if (bizItemGroup != 0L) {
            filter.and(new QFilter("bizitemgroup", "=", (Object)bizItemGroup));
        }
        if (permissionFilter != null && permissionFilter.size() > 0) {
            permissionFilter.stream().forEach(perFilter -> filter.and(perFilter));
        }
        if (!(permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            List allOrgList = permOrgResult.getHasPermOrgs();
            if (allOrgList == null) {
                filter.and(new QFilter("1", "!=", (Object)1));
            } else {
                filter.and(new QFilter("org", "in", (Object)allOrgList));
            }
        }
        ArrayList<Long> bizDataBillIdsOfHold = new ArrayList<Long>(10);
        ArrayList<Long> bizDataBillIdsOfApproving = new ArrayList<Long>(10);
        ArrayList<Long> bizDataBillIdsOfStopApprove = new ArrayList<Long>(10);
        ArrayList<Long> bizDataBillIdsOfToSubmit = new ArrayList<Long>(10);
        ArrayList<Long> bizDataBillIdsOfException = new ArrayList<Long>(10);
        long entryCountOfHold = 0L;
        long entryCountOfApproving = 0L;
        long entryCountOfStopApprove = 0L;
        long entryCountOfToSubmit = 0L;
        long entryCountPosOrgRel = 0L;
        for (DynamicObject bizDataBill : bizDataBills = helper.query("id,personcount,billstatus,datastatus,bizdatacount", new QFilter[]{filter})) {
            String billStatus;
            long billDataId = bizDataBill.getLong("id");
            long bizDataCount = bizDataBill.getLong("bizdatacount");
            switch (billStatus = bizDataBill.getString("billstatus")) {
                case "A": {
                    bizDataBillIdsOfHold.add(billDataId);
                    entryCountOfHold += bizDataCount;
                    break;
                }
                case "D": 
                case "B": {
                    bizDataBillIdsOfApproving.add(billDataId);
                    entryCountOfApproving += bizDataCount;
                    break;
                }
                case "E": {
                    bizDataBillIdsOfStopApprove.add(billDataId);
                    entryCountOfStopApprove += bizDataCount;
                    break;
                }
                case "G": {
                    bizDataBillIdsOfToSubmit.add(billDataId);
                    entryCountOfToSubmit += bizDataCount;
                    break;
                }
            }
            String dataStatus = bizDataBill.getString("datastatus");
            if (!SWCStringUtils.equals((String)dataStatus, (String)BizDataStatusEnum.PART_PRESENT.getCode()) && !SWCStringUtils.equals((String)dataStatus, (String)BizDataStatusEnum.ALL_FAILED_PRESENT.getCode())) continue;
            bizDataBillIdsOfException.add(billDataId);
            entryCountPosOrgRel += bizDataCount;
        }
        SWCDataServiceHelper entryHelper = HPDIDataServiceHelper.HPDI_BIZDATABILLENT_HELPER;
        int personCountOfHold = entryHelper.count("hpdi_bizdatabillent", "empposorgrel", this.getQFilter("bizdatabillid", bizDataBillIdsOfHold), (Distinctable)WithDistinctable.get());
        int personCountOfApproving = entryHelper.count("hpdi_bizdatabillent", "empposorgrel", this.getQFilter("bizdatabillid", bizDataBillIdsOfApproving), (Distinctable)WithDistinctable.get());
        int personCountOfStopApprove = entryHelper.count("hpdi_bizdatabillent", "empposorgrel", this.getQFilter("bizdatabillid", bizDataBillIdsOfStopApprove), (Distinctable)WithDistinctable.get());
        int personCountOfToSubmit = entryHelper.count("hpdi_bizdatabillent", "empposorgrel", this.getQFilter("bizdatabillid", bizDataBillIdsOfToSubmit), (Distinctable)WithDistinctable.get());
        int personCountPosOrgRel = entryHelper.count("hpdi_bizdatabillent", "empposorgrel", this.getQFilter("bizdatabillid", bizDataBillIdsOfException), (Distinctable)WithDistinctable.get());
        this.setLabelText("temporarystoragecount", bizDataBillIdsOfHold.size(), personCountOfHold, entryCountOfHold);
        this.setLabelText("underapprovalcount", bizDataBillIdsOfApproving.size(), personCountOfApproving, entryCountOfApproving);
        this.setLabelText("approvalfailedcount", bizDataBillIdsOfStopApprove.size(), personCountOfStopApprove, entryCountOfStopApprove);
        this.setLabelText("waitsubmit", bizDataBillIdsOfToSubmit.size(), personCountOfToSubmit, entryCountOfToSubmit);
        this.setLabelText("dataexceptioncount", bizDataBillIdsOfException.size(), personCountPosOrgRel, entryCountPosOrgRel);
        if (bizDataBillIdsOfStopApprove.size() == 0) {
            this.setForeground("approvalfailedcount");
        }
        if (bizDataBillIdsOfException.size() == 0) {
            this.setForeground("dataexceptioncount");
        }
    }

    private void setLabelText(String labelName, long totalCount, long personCount, long entryCount) {
        Label label = (Label)this.getView().getControl(labelName);
        label.setText(this.transferValue(totalCount));
        label = (Label)this.getView().getControl(labelName + "1");
        label.setText(this.transferValue(personCount));
        label = (Label)this.getView().getControl(labelName + "2");
        label.setText(this.transferValue(entryCount));
    }

    private void OpenListPage(Map<String, Object> customParam) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hpdi_bizdatabill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("condition", customParam);
        showParameter.setFilterSchemeId("0");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String transferValue(long value) {
        String result = "";
        result = value >= 1000000L ? value / 1000000L + "m+" : (value >= 100000L && value < 1000000L ? value / 1000L + "k+" : value + "");
        return result;
    }

    private void setForeground(String label) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("fc", "#666666");
        this.getView().updateControlMetadata(label, ctrl);
    }

    private QFilter[] getQFilter(String selectFields, List<Long> bizDataBillIds) {
        return new QFilter[]{new QFilter(selectFields, "in", bizDataBillIds)};
    }
}

