/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.formplugin.web.homepage.BizDataBillCardPlugin;
import kd.swc.hpdi.formplugin.web.homepage.BizDataErrorComparePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataCardPlugin
extends AbstractBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(BizDataBillCardPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            Date startDate = (Date)this.getView().getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)this.getView().getParentView().getModel().getValue("datarange_enddate");
            DynamicObject bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup");
            long bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
            try {
                startDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00"));
                endDate = SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59"));
                this.showBizData(startDate, endDate, bizDataModule);
            }
            catch (Exception parseException) {
                LOGGER.info(parseException.getMessage());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
            String operateKey = formOperate.getOperateKey();
            Date startDate = (Date)this.getView().getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)this.getView().getParentView().getModel().getValue("datarange_enddate");
            DynamicObject bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup");
            long bizItemGroup = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            ArrayList<String> datarange = new ArrayList<String>();
            datarange.add(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00");
            datarange.add(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59");
            customParam.put("submitdate", datarange);
            if (bizItemGroup != 0L) {
                customParam.put("bizitemgroup", bizItemGroup);
            }
            if ("donothing_totalcount".equals(operateKey)) {
                this.OpenListPage(customParam);
            } else if ("donothing_waittransfercount".equals(operateKey)) {
                customParam.put("bizdatastatus", "1");
                this.OpenListPage(customParam);
            } else if ("donothing_transfercount".equals(operateKey)) {
                customParam.put("bizdatastatus", "2");
                this.OpenListPage(customParam);
            } else if ("donothing_failtransfercount".equals(operateKey)) {
                customParam.put("bizdatastatus", "4");
                this.OpenListPage(customParam);
            } else if ("donothing_convertedsalary".equals(operateKey)) {
                customParam.put("bizdatastatus", "3");
                this.OpenListPage(customParam);
            }
        }
    }

    private void showBizData(Date startDate, Date endDate, long bizItemGroup) {
        List permissionFilter;
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATA_HELPER;
        QFilter filter = new QFilter("submitdate", ">", (Object)startDate);
        filter.and(new QFilter("submitdate", "<", (Object)endDate));
        if (bizItemGroup != 0L) {
            filter.and(new QFilter("bizitemgroup", "=", (Object)bizItemGroup));
        }
        if ((permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_allbizdata", (String)"47150e89000000ac")) != null && permissionFilter.size() > 0) {
            permissionFilter.stream().forEach(perFilter -> {
                filter.and(perFilter);
                LOGGER.info(perFilter.getProperty());
                LOGGER.info(perFilter.getValue().toString());
            });
        }
        DynamicObject[] bizDatas = helper.query("id,empposorgrel,bizdatastatus", new QFilter[]{filter});
        long count = bizDatas.length;
        Set empSet = Arrays.stream(bizDatas).map(bizData -> bizData.getLong("empposorgrel.employee.id")).collect(Collectors.toSet());
        long waitTransferCount = 0L;
        long transferCount = 0L;
        long failTransferCount = 0L;
        long convertedSalaryCount = 0L;
        for (DynamicObject bizData2 : bizDatas) {
            if (bizData2.getInt("bizdatastatus") == 1) {
                ++waitTransferCount;
                continue;
            }
            if (bizData2.getInt("bizdatastatus") == 2) {
                ++transferCount;
                continue;
            }
            if (bizData2.getInt("bizdatastatus") == 4) {
                ++failTransferCount;
                continue;
            }
            if (bizData2.getInt("bizdatastatus") != 3) continue;
            ++convertedSalaryCount;
        }
        Label label = (Label)this.getView().getControl("totalpeple");
        label.setText(String.valueOf(empSet.size()));
        label = (Label)this.getView().getControl("totalcount");
        label.setText(this.transferValue(count));
        label = (Label)this.getView().getControl("waittransfercount");
        label.setText(this.transferValue(waitTransferCount));
        label = (Label)this.getView().getControl("transfercount");
        label.setText(this.transferValue(transferCount));
        label = (Label)this.getView().getControl("failtransfercount");
        label.setText(this.transferValue(failTransferCount));
        label = (Label)this.getView().getControl("convertedsalary");
        label.setText(this.transferValue(convertedSalaryCount));
        if (failTransferCount == 0L) {
            this.setForeground("failtransfercount");
            this.setForeground("failtransferunit");
        }
    }

    private void OpenListPage(Map<String, Object> customParam) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hpdi_bizdatalist");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("condition", customParam);
        this.getView().showForm(formShowParameter);
    }

    private String transferValue(long value) {
        String result = "";
        result = value >= 1000000L ? value / 1000000L + "m+" : (value >= 100000L && value < 1000000L ? value / 1000L + "k+" : value + "");
        return result;
    }

    private void setForeground(String label) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("fc", "#666666");
        this.getView().updateControlMetadata(label, ctrl);
    }
}

