/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hpdi.formplugin.web.homepage.BizDataErrorComparePlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataErroItemGroupTopPlugin
extends AbstractBillPlugIn {
    private static final String KEY_DATA_RANGE_START_DATE = "datarange_startdate";
    private static final String KEY_DATA_RANGE_END_DATE = "datarange_enddate";
    private static final String KEY_DATE_RANGE_FIELD = "daterangefield";
    private static final String KEY_COUNTS = "counts";
    private static final String KEY_DATA_PANEL = "datapanel";
    private static final String KEY_NO_DATA_PANEL = "nodatapanel";
    private static final Log LOGGER = LogFactory.getLog(BizDataErroItemGroupTopPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)eventArgs);
        super.preOpenForm(eventArgs);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            this.intItemGroupData();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATA_PANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_NO_DATA_PANEL});
        }
    }

    private void intItemGroupData() {
        DynamicObject bizDataModuleDy;
        long bizDataModule;
        Date endDate;
        Date startDate = (Date)this.getView().getParentView().getModel().getValue(KEY_DATA_RANGE_START_DATE);
        List<Map<String, Long>> errorItemGroupList = this.getErrorItemGroupData(BizDataErrorComparePlugin.getCustomParam(startDate, endDate = (Date)this.getView().getParentView().getModel().getValue(KEY_DATA_RANGE_END_DATE), bizDataModule = SWCObjectUtils.isEmpty((Object)(bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup"))) ? 0L : bizDataModuleDy.getLong("id")));
        List<Map<String, String>> errorItemGroupNameList = this.getErrorItemGroupNameList(errorItemGroupList);
        if (errorItemGroupNameList == null || errorItemGroupNameList.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DATA_PANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_NO_DATA_PANEL});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_NO_DATA_PANEL});
        for (int index = 0; index < 7; ++index) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel" + index});
            if (errorItemGroupList.size() <= index) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{"panel" + index});
            Label nameLabel = (Label)this.getView().getControl("itemgroupname" + index);
            nameLabel.setText(errorItemGroupNameList.get(index).get("name"));
            Label countLabel = (Label)this.getView().getControl("itemgroupnumber" + index);
            countLabel.setText(errorItemGroupNameList.get(index).get(KEY_COUNTS));
        }
    }

    private List<Map<String, String>> getErrorItemGroupNameList(List<Map<String, Long>> errorItemGroupList) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (!CollectionUtils.isEmpty(errorItemGroupList)) {
            ArrayList<Long> idList = new ArrayList<Long>();
            errorItemGroupList.stream().forEach(obj -> idList.add((Long)obj.get("id")));
            DynamicObject[] itemGroupList = null;
            try {
                itemGroupList = this.getBizItemGroups(idList);
            }
            catch (Exception exception) {
                LOGGER.error(MessageFormat.format("BizDataErroItemGroupTopPlugin-getErrorItemGroupNameList getBizItemGroupById Exception:", exception));
            }
            if (itemGroupList != null && itemGroupList.length > 0) {
                for (Map<String, Long> map : errorItemGroupList) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    tmpMap.put(KEY_COUNTS, map.get(KEY_COUNTS).toString());
                    tmpMap.put("name", "");
                    for (DynamicObject itemGroup : itemGroupList) {
                        if (map.get("id").longValue() != itemGroup.getLong("id")) continue;
                        tmpMap.put("name", itemGroup.getLocaleString("name").getLocaleValue());
                        break;
                    }
                    result.add(tmpMap);
                }
            }
        }
        return result;
    }

    public List<Map<String, Long>> getErrorItemGroupData(Map<String, Object> customParam) {
        List permissionFilter;
        ArrayList<Map<String, Long>> result = new ArrayList<Map<String, Long>>();
        String startDataStr = (String)customParam.get("startdate");
        String endDataStr = (String)customParam.get("enddate");
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            startDate = SWCDateTimeUtils.parseDate((String)startDataStr);
            endDate = SWCDateTimeUtils.parseDate((String)endDataStr);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        Long bizItemGroupId = (Long)customParam.get("bizitemgroup");
        QFilter filter = new QFilter("operatetime", ">", (Object)startDate);
        filter.and(new QFilter("operatetime", "<", (Object)endDate));
        if (bizItemGroupId != null && bizItemGroupId != 0L) {
            filter.and(new QFilter("bizitemgroup", "=", (Object)bizItemGroupId));
        }
        if ((permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdataerrorlog", (String)"47150e89000000ac")) != null && permissionFilter.size() > 0) {
            permissionFilter.stream().forEach(perFilter -> filter.and(perFilter));
        }
        filter.and(BizDataHelper.assembleOrgFilterByBizOrgPerm());
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER;
        DynamicObject[] datas = helper.query("bizitemgroup", new QFilter[]{filter});
        if (datas != null && datas.length > 0) {
            Map<Long, List<DynamicObject>> groupBizData = Arrays.stream(datas).collect(Collectors.groupingBy(dy -> dy.getLong("bizitemgroup.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : groupBizData.entrySet()) {
                Long code = entry.getKey();
                List<DynamicObject> dys = entry.getValue();
                HashMap<String, Long> tmpMap = new HashMap<String, Long>();
                tmpMap.put("id", code);
                tmpMap.put(KEY_COUNTS, Long.valueOf(dys.size()));
                result.add(tmpMap);
            }
            if (!CollectionUtils.isEmpty(result)) {
                Collections.sort(result, (o1, o2) -> -((Long)o1.get(KEY_COUNTS)).compareTo((Long)o2.get(KEY_COUNTS)));
            }
        }
        return result;
    }

    private DynamicObject[] getBizItemGroups(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        QFilter filter = new QFilter("id", "in", ids);
        return helper.query("id,name,entryentity.bizitem", new QFilter[]{filter});
    }
}

