/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.swc.hpdi.formplugin.web.homepage.BizDataErrorComparePlugin;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataErrorChartPlugin
extends AbstractBillPlugIn {
    private static final String HPDI_BIZ_DATA_ERROR_LOG = "hpdi_bizdataerrorlog";
    private static final String KEY_SHOW_DETAIL = "showdetail";
    private static final String KEY_DATA_RANGE_START_DATE = "datarange_startdate";
    private static final String KEY_DATA_RANGE_END_DATE = "datarange_enddate";
    private static int MAX_BIT = 0;

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void createNewData(BizDataEventArgs args) {
        super.createNewData(args);
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            this.initPointLineChart();
        }
    }

    private void initPointLineChart() {
        PieChart chartType = (PieChart)this.getView().getControl("piechartap");
        if (null == chartType) {
            return;
        }
        Map<String, BigDecimal> errorGroupData = BizDataErrorComparePlugin.getNowErrorData(this.getView());
        String totalNum = errorGroupData.get("totalnum").toString();
        if ("0".equals(totalNum)) {
            return;
        }
        this.getErrorGroupDataBit(errorGroupData);
        String totalValue = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"BizDataErrorChartPlugin_0", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        chartType.setShowTooltip(true);
        chartType.setName(new LocaleString(totalValue));
        PieSeries series = chartType.createPieSeries(ResManager.loadKDString((String)"\u624b\u5de5\u63d0\u62a5\u5f02\u5e38", (String)"BizDataErrorChartPlugin_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
        String overInputTimeStr = MessageFormat.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u8f93\u5165\u6b21\u6570\u2001\u2001\u2001\u2001|\u2001{0}\u2001\u2001{1}\u6b21", (String)"BizDataErrorChartPlugin_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), BizDataErrorChartPlugin.percentage(errorGroupData.get("overinputnum"), errorGroupData.get("totalnum")), this.transferData(errorGroupData.get("overinputnum").toString()));
        String notInTimeStr = MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u5728\u65f6\u95f4\u7a97\u53e3\u5185\u2001\u2001\u2001|\u2001{0}\u2001\u2001{1}\u6b21", (String)"BizDataErrorChartPlugin_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), BizDataErrorChartPlugin.percentage(errorGroupData.get("notintimewindownum"), errorGroupData.get("totalnum")), this.transferData(errorGroupData.get("notintimewindownum").toString()));
        String notPassAuditStr = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u5ba1\u6279\u4e0d\u901a\u8fc7\u2001\u2001\u2001|\u2001{0}\u2001\u2001{1}\u6b21", (String)"BizDataErrorChartPlugin_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), BizDataErrorChartPlugin.percentage(errorGroupData.get("notpassauditnum"), errorGroupData.get("totalnum")), this.transferData(errorGroupData.get("notpassauditnum").toString()));
        BigDecimal notMatch = errorGroupData.get("notmatchfilenum");
        BigDecimal matchMoreOne = errorGroupData.get("matchmorefilenum");
        BigDecimal allMatchFail = notMatch.add(matchMoreOne);
        String allMatchFailStr = MessageFormat.format(ResManager.loadKDString((String)"\u5339\u914d\u85aa\u8d44\u6863\u6848\u5931\u8d25\u2001\u2001|\u2001{0}\u2001\u2001{1}\u6b21", (String)"BizDataErrorChartPlugin_8", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), BizDataErrorChartPlugin.percentage(allMatchFail, errorGroupData.get("totalnum")), this.transferData(allMatchFail.toString()));
        String otherStr = MessageFormat.format(ResManager.loadKDString((String)"\u5176\u4ed6\u2001\u2001\u2001\u2001\u2001\u2001\u2001\u2001|\u2001{0}\u2001\u2001{1}\u6b21", (String)"BizDataErrorChartPlugin_7", (String)"swc-hpdi-formplugin", (Object[])new Object[0]), BizDataErrorChartPlugin.percentage(errorGroupData.get("othernum"), errorGroupData.get("totalnum")), this.transferData(errorGroupData.get("othernum").toString()));
        if (0 != BigDecimal.ZERO.compareTo(errorGroupData.get("overinputnum"))) {
            series.addData(new ItemValue(overInputTimeStr, (Number)errorGroupData.get("overinputnum"), "#5e83fd"));
        }
        if (0 != BigDecimal.ZERO.compareTo(errorGroupData.get("notintimewindownum"))) {
            series.addData(new ItemValue(notInTimeStr, (Number)errorGroupData.get("notintimewindownum"), "#FFC53D"));
        }
        if (0 != BigDecimal.ZERO.compareTo(errorGroupData.get("notpassauditnum"))) {
            series.addData(new ItemValue(notPassAuditStr, (Number)errorGroupData.get("notpassauditnum"), "#73D13D"));
        }
        if (0 != BigDecimal.ZERO.compareTo(allMatchFail)) {
            series.addData(new ItemValue(allMatchFailStr, (Number)errorGroupData.get("notmatchfilenum"), "#45DAD1"));
        }
        if (0 != BigDecimal.ZERO.compareTo(errorGroupData.get("othernum"))) {
            series.addData(new ItemValue(otherStr, (Number)errorGroupData.get("othernum"), "#40A9FF"));
        }
        series.setRadius("40%", "60%");
        series.setCenter("30%", "50%");
        HashMap propMap = new HashMap();
        HashMap<String, Object> positionMap = new HashMap<String, Object>();
        positionMap.put("position", "inside");
        positionMap.put("show", Boolean.FALSE);
        propMap.put("normal", positionMap);
        series.setPropValue("label", propMap);
        chartType.setShowTooltip(false);
        chartType.setTitlePropValue("top", (Object)"40%");
        chartType.setTitlePropValue("left", (Object)"29%");
        chartType.setTitlePropValue("textAlign", (Object)"center");
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("color", "#666666");
        chartType.setTitlePropValue("textStyle", colorMap);
        chartType.setTitlePropValue("subtext", (Object)errorGroupData.get("totalnum").toString());
        chartType.setShowTitle(true);
        chartType.setLegendPropValue("left", (Object)"45%");
        chartType.setLegendPropValue("top", (Object)"40%");
        chartType.setLegendPropValue("icon", (Object)"circle");
        chartType.setLegendPropValue("orient", (Object)"vertical");
        chartType.setShowLegend(true);
    }

    private String transferData(String countStr) {
        String result = countStr;
        int countLength = countStr.length();
        if (countLength < MAX_BIT) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < MAX_BIT - countLength; ++index) {
                sb.append('\u2002');
            }
            sb.append(countStr);
            result = sb.toString();
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        long bizDataModule;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        Date startDate = (Date)this.getView().getParentView().getModel().getValue(KEY_DATA_RANGE_START_DATE);
        Date endDate = (Date)this.getView().getParentView().getModel().getValue(KEY_DATA_RANGE_END_DATE);
        DynamicObject bizDataModuleDy = (DynamicObject)this.getView().getParentView().getModel().getValue("bizitemgroup");
        long l = bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
        if (KEY_SHOW_DETAIL.equals(operateKey) && BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            this.openListPage(BizDataErrorComparePlugin.getCustomParam(startDate, endDate, bizDataModule));
        }
    }

    private void openListPage(Map<String, Object> customParam) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(HPDI_BIZ_DATA_ERROR_LOG);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("condition", customParam);
        showParameter.setFilterSchemeId("0");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static String percentage(BigDecimal base, BigDecimal pct) {
        StringBuilder result = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (pct.compareTo(BigDecimal.ZERO) > 0) {
            sb.append(base.multiply(new BigDecimal(100)).divide(pct, 4));
        } else {
            sb.append(0);
        }
        if (sb.toString().length() == 1) {
            result.append(" \u2001");
        } else if (sb.toString().length() == 2) {
            result.append("  ");
        }
        result.append((CharSequence)sb);
        result.append('%');
        return result.toString();
    }

    public void getErrorGroupDataBit(Map<String, BigDecimal> errorGroupData) {
        for (Map.Entry<String, BigDecimal> entrySet : errorGroupData.entrySet()) {
            int tmpBit;
            BigDecimal tmpVal = entrySet.getValue();
            if (tmpVal == null || (tmpBit = tmpVal.toString().length()) <= MAX_BIT) continue;
            MAX_BIT = tmpBit;
        }
    }
}

