/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;

public class BizDataErrorComparePlugin
extends AbstractBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(BizDataErrorComparePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        SWCSecurityServiceHelper.checkSwcSecurityFlagForWidgets((PreOpenFormEventArgs)args);
        super.preOpenForm(args);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DateRangeEdit endDateEdit = (DateRangeEdit)this.getView().getControl("daterangefield");
        endDateEdit.setMaxDate(new Date());
        if (BizDataErrorComparePlugin.validateRightDate(this.getView())) {
            Date startDate = (Date)this.getView().getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)this.getView().getParentView().getModel().getValue("datarange_enddate");
            if (startDate != null && endDate != null) {
                Long day = SWCDateTimeUtils.dateDiff((String)"d", (Date)startDate, (Date)endDate);
                Date compareStartDate = SWCDateTimeUtils.addDay((Date)startDate, (long)(-day.longValue() - 1L));
                Date compareEndDate = SWCDateTimeUtils.addDay((Date)compareStartDate, (long)day);
                this.getModel().setValue("datarange_startdate", (Object)compareStartDate);
                this.getModel().setValue("datarange_enddate", (Object)compareEndDate);
                this.initHistogramChart();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if ("datarange_startdate".equals(fieldKey) || "datarange_enddate".equals(fieldKey)) {
            Date compareStartDate = (Date)this.getView().getModel().getValue("datarange_startdate");
            Date compareEndDate = (Date)this.getView().getModel().getValue("datarange_enddate");
            if (compareStartDate != null && compareEndDate != null) {
                this.initHistogramChart();
                this.getView().updateView("histogramchartap");
            }
        }
    }

    private void initHistogramChart() {
        String overInputTimeStr = ResManager.loadKDString((String)"\u8d85\u8fc7\u8f93\u5165\u6b21\u6570", (String)"BizDataErrorComparePlugin_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String notInTimeWindowStr = ResManager.loadKDString((String)"\u4e0d\u5728\u65f6\u95f4\u7a97\u53e3\u5185", (String)"BizDataErrorComparePlugin_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String notPassAuditStr = ResManager.loadKDString((String)"\u6570\u636e\u5ba1\u6279\u4e0d\u901a\u8fc7\u3002", (String)"BizDataErrorComparePlugin_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String allMatchFailFileStr = ResManager.loadKDString((String)"\u201c\u85aa\u8d44\u6863\u6848\u201d\u5339\u914d\u5931\u8d25\u3002", (String)"BizDataErrorComparePlugin_9", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String otherStr = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"BizDataErrorComparePlugin_6", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String compareStr = ResManager.loadKDString((String)"\u5bf9\u6bd4", (String)"BizDataErrorComparePlugin_7", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        String nowStr = ResManager.loadKDString((String)"\u5f53\u524d", (String)"BizDataErrorComparePlugin_8", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
        Map<String, BigDecimal> nowErrorData = BizDataErrorComparePlugin.getNowErrorData(this.getView());
        Map<String, BigDecimal> compareErrorData = BizDataErrorComparePlugin.getCompareErrorData(this.getView());
        Control chartControl = this.getControl("histogramchartap");
        if (null == chartControl) {
            return;
        }
        HistogramChart histogramChart = (HistogramChart)chartControl;
        histogramChart.clearData();
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>();
        prop.put("show", Boolean.FALSE);
        Axis xAxis = histogramChart.createXAxis("", new String[]{overInputTimeStr, notInTimeWindowStr, notPassAuditStr, allMatchFailFileStr, otherStr});
        xAxis.setPropValue("axisLine", prop);
        xAxis.setPropValue("axisTick", prop);
        Axis yAxis = histogramChart.createYAxis("");
        yAxis.setPropValue("axisLine", prop);
        yAxis.setPropValue("axisTick", prop);
        BarSeries barSeries = histogramChart.createSeries(compareStr);
        barSeries.setColor("#40A9FF");
        histogramChart.setName(new LocaleString(compareStr));
        histogramChart.setShowTitle(false);
        histogramChart.setShowTooltip(true);
        histogramChart.setLegendAlign(XAlign.left, YAlign.top);
        histogramChart.setShowLegend(true);
        barSeries.setBarWidth("20");
        barSeries.setData((Number[])new Integer[]{compareErrorData.get("overinputnum").intValue(), compareErrorData.get("notintimewindownum").intValue(), compareErrorData.get("notpassauditnum").intValue(), compareErrorData.get("notmatchfilenum").intValue() + compareErrorData.get("matchmorefilenum").intValue(), compareErrorData.get("othernum").intValue()});
        BarSeries nowBarSeries = histogramChart.createSeries(nowStr);
        nowBarSeries.setColor("#45DAD1");
        histogramChart.setName(new LocaleString(nowStr));
        histogramChart.setShowTitle(false);
        histogramChart.setShowTooltip(true);
        histogramChart.setLegendAlign(XAlign.left, YAlign.top);
        histogramChart.setShowLegend(true);
        nowBarSeries.setBarWidth("20");
        nowBarSeries.setData((Number[])new Integer[]{nowErrorData.get("overinputnum").intValue(), nowErrorData.get("notintimewindownum").intValue(), nowErrorData.get("notpassauditnum").intValue(), nowErrorData.get("notmatchfilenum").intValue() + nowErrorData.get("matchmorefilenum").intValue(), nowErrorData.get("othernum").intValue()});
    }

    public static Map<String, BigDecimal> getNowErrorData(IFormView formView) {
        Date startDate = (Date)formView.getParentView().getModel().getValue("datarange_startdate");
        Date endDate = (Date)formView.getParentView().getModel().getValue("datarange_enddate");
        DynamicObject bizDataModuleDy = (DynamicObject)formView.getParentView().getModel().getValue("bizitemgroup");
        long bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
        return BizDataErrorComparePlugin.getErrorGroupData(BizDataErrorComparePlugin.getCustomParam(startDate, endDate, bizDataModule));
    }

    public static Map<String, BigDecimal> getCompareErrorData(IFormView formView) {
        Date compareStartDate = (Date)formView.getModel().getValue("datarange_startdate");
        Date compareEndDate = (Date)formView.getModel().getValue("datarange_enddate");
        DynamicObject bizDataModuleDy = (DynamicObject)formView.getParentView().getModel().getValue("bizitemgroup");
        long bizDataModule = SWCObjectUtils.isEmpty((Object)bizDataModuleDy) ? 0L : bizDataModuleDy.getLong("id");
        return BizDataErrorComparePlugin.getErrorGroupData(BizDataErrorComparePlugin.getCustomParam(compareStartDate, compareEndDate, bizDataModule));
    }

    public static Map<String, BigDecimal> getErrorGroupData(Map<String, Object> customParam) {
        List permissionFilter;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put("totalnum", BigDecimal.ZERO);
        result.put("notpassauditnum", BigDecimal.ZERO);
        result.put("notmatchfilenum", BigDecimal.ZERO);
        result.put("overinputnum", BigDecimal.ZERO);
        result.put("notintimewindownum", BigDecimal.ZERO);
        result.put("matchmorefilenum", BigDecimal.ZERO);
        result.put("othernum", BigDecimal.ZERO);
        String startDataStr = (String)customParam.get("startdate");
        String endDataStr = (String)customParam.get("enddate");
        Long bizItemGroupId = (Long)customParam.get("bizitemgroup");
        Date startDate = new Date();
        Date endDate = new Date();
        try {
            startDate = SWCDateTimeUtils.parseDate((String)startDataStr);
            endDate = SWCDateTimeUtils.parseDate((String)endDataStr);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        QFilter filter = new QFilter("operatetime", ">", (Object)startDate);
        filter.and(new QFilter("operatetime", "<", (Object)endDate));
        if (bizItemGroupId != null && bizItemGroupId != 0L) {
            filter.and(new QFilter("bizitemgroup", "=", (Object)bizItemGroupId));
        }
        if ((permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdataerrorlog", (String)"47150e89000000ac")) != null && permissionFilter.size() > 0) {
            permissionFilter.stream().forEach(perFilter -> filter.and(perFilter));
        }
        filter.and(BizDataHelper.assembleOrgFilterByBizOrgPerm());
        SWCDataServiceHelper helper = HPDIDataServiceHelper.HPDI_BIZDATAERRORLOG_HELPER;
        DynamicObject[] datas = helper.query("totalnum,notpassauditnum,notmatchfilenum,overinputnum,notintimewindownum,matchmorefilenum,othernum", new QFilter[]{filter});
        if (datas != null && datas.length > 0) {
            Arrays.stream(datas).forEach(data -> {
                result.put("totalnum", new BigDecimal(data.getInt("totalnum")).add(result.getOrDefault("totalnum", BigDecimal.ZERO)));
                result.put("notpassauditnum", new BigDecimal(data.getInt("notpassauditnum")).add(result.getOrDefault("notpassauditnum", BigDecimal.ZERO)));
                result.put("notmatchfilenum", new BigDecimal(data.getInt("notmatchfilenum")).add(result.getOrDefault("notmatchfilenum", BigDecimal.ZERO)));
                result.put("overinputnum", new BigDecimal(data.getInt("overinputnum")).add(result.getOrDefault("overinputnum", BigDecimal.ZERO)));
                result.put("notintimewindownum", new BigDecimal(data.getInt("notintimewindownum")).add(result.getOrDefault("notintimewindownum", BigDecimal.ZERO)));
                result.put("matchmorefilenum", new BigDecimal(data.getInt("matchmorefilenum")).add(result.getOrDefault("matchmorefilenum", BigDecimal.ZERO)));
                result.put("othernum", new BigDecimal(data.getInt("othernum")).add(result.getOrDefault("othernum", BigDecimal.ZERO)));
            });
        }
        return result;
    }

    public static Map<String, Object> getCustomParam(Date startDate, Date endDate, long bizDataModule) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("startdate", SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00");
        result.put("enddate", SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59");
        if (bizDataModule != 0L) {
            result.put("bizitemgroup", bizDataModule);
        }
        return result;
    }

    public static boolean validateRightDate(IFormView formView) {
        boolean result = true;
        try {
            Date startDate = (Date)formView.getParentView().getModel().getValue("datarange_startdate");
            Date endDate = (Date)formView.getParentView().getModel().getValue("datarange_enddate");
            if (startDate == null || endDate == null || endDate.before(startDate)) {
                result = false;
            }
            SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00"));
            SWCDateTimeUtils.parseDate((String)(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59"));
        }
        catch (Exception exception) {
            LOGGER.info(exception.getMessage());
            result = false;
        }
        return result;
    }
}

