/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hpdi.formplugin.web.homepage;

import com.alibaba.fastjson.JSONArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.container.MessageCarouselContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hpdi.business.helper.BizDataHelper;
import kd.swc.hpdi.business.helper.HPDIDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizDataHomePagePlugin
extends GridContainerPlugin
implements ItemClickListener,
BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(BizDataHomePagePlugin.class);
    private static final String KEY_BIZ_ITEM_GROUP_ID = "bizitemgroupid";
    private static final String KEY_BIZ_ITEM_GROUP_NAME = "bizitemgroupname";
    private static final String KEY_START_TIME = "starttime";
    private static final String KEY_END_TIME = "endtime";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Date currentDate = new Date();
        Date startDate = SWCDateTimeUtils.addDay((Date)currentDate, (long)-30L);
        this.getModel().setValue("datarange_startdate", (Object)startDate);
        this.getModel().setValue("datarange_enddate", (Object)currentDate);
        DateRangeEdit endDateEdit = (DateRangeEdit)this.getView().getControl("daterangefield");
        endDateEdit.setMaxDate(new Date());
        MessageCarouselContainer mcc = (MessageCarouselContainer)this.getControl("messagecarouselcontainerap");
        ArrayList data = new ArrayList(10);
        String[] texts = this.getRecentlyBizItemGroupInfo();
        if (texts == null || texts.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"timepanelap"});
        } else {
            logger.info(MessageFormat.format("----------texts[0]:[{0}]----------", texts[0]));
        }
        HashMap<String, String> propsMap = null;
        HashMap<String, HashMap<String, String>> controlsMap = null;
        if (texts != null) {
            for (int i = 0; i < texts.length; ++i) {
                propsMap = new HashMap<String, String>();
                controlsMap = new HashMap<String, HashMap<String, String>>();
                propsMap.put("text", texts[i]);
                controlsMap.put("labelap", propsMap);
                data.add(controlsMap);
            }
        }
        mcc.setData(data);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("startTime", System.currentTimeMillis() + "");
    }

    private String[] getRecentlyBizItemGroupInfo() {
        String[] result = null;
        Long startTime = System.currentTimeMillis();
        DynamicObject[] bizItemGroups = BizDataHomePagePlugin.queryAllBizItemGroup();
        Long endTime = System.currentTimeMillis();
        logger.info(MessageFormat.format("queryAllBizItemGroup", endTime - startTime));
        startTime = System.currentTimeMillis();
        List<Map<String, Object>> params = BizDataHomePagePlugin.queryAllCalPeriod(bizItemGroups);
        endTime = System.currentTimeMillis();
        logger.info(MessageFormat.format("queryAllCalPeriod", endTime - startTime));
        startTime = System.currentTimeMillis();
        Map codResult = BizDataHelper.getCod(params);
        endTime = System.currentTimeMillis();
        logger.info(MessageFormat.format("getCod", endTime - startTime));
        List<Map<String, Object>> totalDataList = BizDataHomePagePlugin.queryAllDataByCod(codResult, params, true);
        if (CollectionUtils.isEmpty(totalDataList)) {
            return result;
        }
        logger.info(MessageFormat.format("----------totalDataList size:[{0}]----------", totalDataList.size()));
        List<Map<String, Object>> filterList = BizDataHomePagePlugin.filterTotalList(totalDataList);
        logger.info(MessageFormat.format("----------filterList size:[{0}]----------", filterList.size()));
        ArrayList<String> textStrList = new ArrayList<String>(10);
        ArrayList<Long> groupIds = new ArrayList<Long>(10);
        HashMap<Long, Long> groupIdPeriodRls = new HashMap<Long, Long>(16);
        for (Map<String, Object> filterMap : filterList) {
            groupIds.add((Long)filterMap.get(KEY_BIZ_ITEM_GROUP_ID));
            groupIdPeriodRls.put((Long)filterMap.get(KEY_BIZ_ITEM_GROUP_ID), (Long)filterMap.get("calperiodtype"));
            StringBuilder sb = new StringBuilder();
            sb.append(filterMap.get(KEY_BIZ_ITEM_GROUP_NAME));
            sb.append("   ");
            if (filterMap.get(KEY_START_TIME) == null) {
                sb.append(HRInteDateTimeUtil.formatDate((String)"hsas_paynodescm", (String)KEY_END_TIME, (Date)((Date)filterMap.get(KEY_END_TIME))));
                String cutoff = ResManager.loadKDString((String)"\u622a\u6b62", (String)"BizDataHomePagePlugin_3", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
                sb.append(cutoff);
            } else {
                sb.append(HRInteDateTimeUtil.formatDate((String)"hsas_paynodescm", (String)KEY_START_TIME, (Date)((Date)filterMap.get(KEY_START_TIME))));
                sb.append('~');
                sb.append(HRInteDateTimeUtil.formatDate((String)"hsas_paynodescm", (String)KEY_END_TIME, (Date)((Date)filterMap.get(KEY_END_TIME))));
            }
            sb.append("   ");
            String remain = ResManager.loadKDString((String)"\u5269\u4f59", (String)"BizDataHomePagePlugin_4", (String)"swc-hpdi-formplugin", (Object[])new Object[0]);
            sb.append(remain);
            sb.append(filterMap.get("countdown"));
            textStrList.add(sb.toString());
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (!CollectionUtils.isEmpty(groupIds)) {
            pageCache.put("groupIds", SerializationUtils.toJsonString(groupIds));
            pageCache.put("groupIdPeriodRls", SerializationUtils.toJsonString(groupIdPeriodRls));
        }
        logger.info(MessageFormat.format("----------textStrList size:[{0}]----------", textStrList.size()));
        logger.info(MessageFormat.format("----------textStrList:[{0}]----------", ((Object)textStrList).toString()));
        return textStrList.toArray(new String[0]);
    }

    public static DynamicObject[] queryAllBizItemGroup() {
        DynamicObject[] result = null;
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
        QFilter bizitemgroupQFilter = null;
        if (!CollectionUtils.isEmpty((Collection)permissionFilter)) {
            for (QFilter filter : permissionFilter) {
                if (!"bizitemgroup".equals(filter.getProperty())) continue;
                bizitemgroupQFilter = new QFilter("id", filter.getCP(), filter.getValue());
                break;
            }
        }
        if (bizitemgroupQFilter != null) {
            statusQFilter.and(bizitemgroupQFilter);
        }
        statusQFilter.and(BizDataHelper.getOrgFilterBizOrgPerm());
        SWCDataServiceHelper swcDataServiceHelper = HPDIDataServiceHelper.HSBS_BIZITEMGROUP_HELPER;
        result = swcDataServiceHelper.query("name,calperiodtype,createorg", new QFilter[]{enableQFilter, statusQFilter});
        return result;
    }

    public static List<Map<String, Object>> queryAllCalPeriod(DynamicObject[] bizItemGroups) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        ArrayList<Long> calPeriodTypeIds = new ArrayList<Long>(10);
        for (DynamicObject bizItemGroup : bizItemGroups) {
            DynamicObject calperiodType = bizItemGroup.getDynamicObject("calperiodtype");
            if (calperiodType == null) continue;
            calPeriodTypeIds.add(calperiodType.getLong("id"));
        }
        SWCDataServiceHelper calperiodTypeHelper = HPDIDataServiceHelper.HSBS_CALPERIODTYPE_HELPER;
        DynamicObject[] calperiodTypeDetails = calperiodTypeHelper.query("entryentity.startdate,entryentity.enddate,entryentity.periodnumber,entryentity.periodname", new QFilter[]{new QFilter("id", "in", calPeriodTypeIds)});
        Map<Object, Object> calperiodTypeDetailMap = new HashMap(16);
        if (calperiodTypeDetails != null && calperiodTypeDetails.length > 0) {
            ArrayList<DynamicObject> calperiodTypeDetailList = new ArrayList<DynamicObject>(Arrays.asList(calperiodTypeDetails));
            calperiodTypeDetailMap = calperiodTypeDetailList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("id")));
        }
        for (DynamicObject bizItemGroup : bizItemGroups) {
            List calperiodTypeList = (List)calperiodTypeDetailMap.get(bizItemGroup.getLong("calperiodtype.id"));
            if (CollectionUtils.isEmpty((Collection)calperiodTypeList)) continue;
            DynamicObject calperiodTypeDetail = (DynamicObject)calperiodTypeList.get(0);
            DynamicObjectCollection entryEntities = calperiodTypeDetail.getDynamicObjectCollection("entryentity");
            entryEntities.forEach(obj -> {
                HashMap<String, Object> parameterMap = new HashMap<String, Object>(16);
                parameterMap.put("periodnumber", obj.get("periodnumber"));
                parameterMap.put("calperiod", obj.get("id"));
                parameterMap.put("calperiodtype", calperiodTypeDetail.get("id"));
                parameterMap.put("calperiodstartdate", obj.get("startdate"));
                parameterMap.put("calperiodenddate", obj.get("enddate"));
                parameterMap.put("orgId", bizItemGroup.getLong("createorg.id"));
                parameterMap.put(KEY_BIZ_ITEM_GROUP_ID, bizItemGroup.getLong("id"));
                parameterMap.put(KEY_BIZ_ITEM_GROUP_NAME, bizItemGroup.getString("name"));
                parameterMap.put("id", bizItemGroup.getLong("id") + "_" + obj.get("periodnumber"));
                result.add(parameterMap);
            });
        }
        return result;
    }

    public static List<Map<String, Object>> queryAllDataByCod(Map<String, Object> codResult, List<Map<String, Object>> params, boolean isCompareToCurrDate) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        if (codResult != null && ((Boolean)codResult.get("success")).booleanValue() && codResult.get("data") != null) {
            JSONArray jsonArray = (JSONArray)codResult.get("data");
            block0: for (int j = 0; j < jsonArray.size(); ++j) {
                Date endTime = (Date)jsonArray.getJSONObject(j).get((Object)KEY_END_TIME);
                Date startTime = (Date)jsonArray.getJSONObject(j).get((Object)KEY_START_TIME);
                String id = (String)jsonArray.getJSONObject(j).get((Object)"id");
                boolean isOk = false;
                if (endTime != null) {
                    if (isCompareToCurrDate && endTime.after(new Date())) {
                        isOk = true;
                    }
                    if (!isCompareToCurrDate) {
                        isOk = true;
                    }
                }
                if (!isOk) continue;
                for (Map<String, Object> param : params) {
                    if (!id.equals(param.get("id"))) continue;
                    HashMap<String, Object> filterMap = new HashMap<String, Object>(16);
                    filterMap.put("calperiod", param.get("calperiod"));
                    filterMap.put("calperiodtype", param.get("calperiodtype"));
                    filterMap.put("calperiodstartdate", param.get("calperiodstartdate"));
                    filterMap.put("calperiodenddate", param.get("calperiodenddate"));
                    filterMap.put(KEY_BIZ_ITEM_GROUP_ID, param.get(KEY_BIZ_ITEM_GROUP_ID));
                    filterMap.put(KEY_BIZ_ITEM_GROUP_NAME, param.get(KEY_BIZ_ITEM_GROUP_NAME));
                    filterMap.put(KEY_END_TIME, endTime);
                    if (startTime != null) {
                        filterMap.put(KEY_START_TIME, startTime);
                    }
                    filterMap.put("countdown", BizDataHelper.getCountDownByTime((Date)endTime, (Date)new Date()));
                    result.add(filterMap);
                    continue block0;
                }
            }
        }
        return result;
    }

    public static List<Map<String, Object>> filterTotalList(List<Map<String, Object>> totalDataList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        Map<Long, List<Map>> partionMap = totalDataList.stream().collect(Collectors.groupingBy(mp -> (Long)mp.get(KEY_BIZ_ITEM_GROUP_ID)));
        partionMap.forEach((groupId, list) -> {
            if (!CollectionUtils.isEmpty((Collection)list)) {
                list.sort((o1, o2) -> {
                    int res = ((Date)o1.get(KEY_END_TIME)).compareTo((Date)o2.get(KEY_END_TIME));
                    return res;
                });
                result.add((Map<String, Object>)list.get(0));
            }
        });
        return result;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Date currentDate = SWCDateTimeUtils.getTodayDateWithoutTime();
        Date startDate = (Date)this.getModel().getValue("datarange_startdate");
        Date endDate = (Date)this.getModel().getValue("datarange_enddate");
        if (SWCObjectUtils.isEmpty((Object)startDate) || SWCObjectUtils.isEmpty((Object)endDate)) {
            startDate = SWCDateTimeUtils.addDay((Date)currentDate, (long)-30L);
            this.getModel().setValue("datarange_startdate", (Object)startDate);
            this.getModel().setValue("datarange_enddate", (Object)currentDate);
            return;
        }
        String fieldKey = args.getProperty().getName();
        if ("datarange_startdate".equals(fieldKey)) {
            if (!SWCObjectUtils.isEmpty((Object)startDate) && SWCDateTimeUtils.dateDiff((Date)currentDate, (Date)startDate) > 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BizDataHomePagePlugin_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            this.refreshGridContainer();
        }
        if ("datarange_enddate".equals(fieldKey)) {
            if (!SWCObjectUtils.isEmpty((Object)endDate) && SWCDateTimeUtils.dateDiff((Date)currentDate, (Date)endDate) > 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u9700\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BizDataHomePagePlugin_2", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                return;
            }
            this.refreshGridContainer();
        }
        if ("bizitemgroup".equals(fieldKey)) {
            this.refreshGridContainer();
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("bizitemgroup");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MessageCarouselContainer mcc = (MessageCarouselContainer)this.getView().getControl("messagecarouselcontainerap");
        mcc.addItemClickListener((ItemClickListener)this);
        mcc.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String key;
        switch (key = args.getProperty().getName()) {
            case "bizitemgroup": {
                List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hpdi_bizdatabill", (String)"47150e89000000ac");
                ListShowParameter adminOrgParameter = (ListShowParameter)args.getFormShowParameter();
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                if (!CollectionUtils.isEmpty((Collection)permissionFilter)) {
                    for (QFilter qFilter : permissionFilter) {
                        if (!"bizitemgroup".equals(qFilter.getProperty())) continue;
                        QFilter groupItemFilter = new QFilter("id", qFilter.getCP(), qFilter.getValue());
                        filters.add(groupItemFilter);
                    }
                }
                filters.add(BizDataHelper.getOrgFilterBizOrgPerm());
                adminOrgParameter.getListFilterParameter().setQFilters(filters);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        String key;
        switch (key = arg0.getFieldName()) {
            case "bizitemgroup": {
                List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"0NXW1VOPH+QV", (String)"hsbs_bizitemgroup", (String)"47150e89000000ac");
                if (permissionFilter == null) break;
                for (QFilter qFilter : permissionFilter) {
                    arg0.addCustomQFilter(qFilter);
                }
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "immediatelyhandle": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("hpdi_bizdatabillchoicetpl");
                SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u63d0\u62a5", (String)"BizDataBillList_1", (String)"swc-hpdi-formplugin", (Object[])new Object[0]));
                showParameter.setCustomParam("billtype", (Object)"1");
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                String startTime = pageCache.get("startTime");
                String groupIds = pageCache.get("groupIds");
                String groupIdPeriodRlsStr = pageCache.get("groupIdPeriodRls");
                if (!SWCStringUtils.isEmpty((String)startTime) && !SWCStringUtils.isEmpty((String)groupIds)) {
                    int idSize;
                    List groupIdList = (List)SerializationUtils.fromJsonString((String)groupIds, List.class);
                    Map groupIdPeriodRls = (Map)SerializationUtils.fromJsonString((String)groupIdPeriodRlsStr, Map.class);
                    Long nowTimeStamp = System.currentTimeMillis();
                    int count = (int)((nowTimeStamp - Long.parseLong(startTime)) / 3500L + 1L);
                    int index = count % (idSize = groupIdList.size()) == 0 ? idSize - 1 : count % idSize - 1;
                    showParameter.setCustomParam("bizitemgroup", groupIdList.get(index));
                    showParameter.setCustomParam("calperiod", groupIdPeriodRls.get(groupIdList.get(index)));
                }
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "hpdi_bizdatabillchoicetplopen");
                showParameter.setCloseCallBack(callBack);
                this.getView().showForm(showParameter);
                break;
            }
            case "showall": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("hpdi_timewindowview");
                SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)formShowParameter);
                StyleCss css = new StyleCss();
                css.setWidth("960px");
                css.setHeight("580px");
                formShowParameter.getOpenStyle().setInlineStyleCss(css);
                formShowParameter.setShowTitle(true);
                formShowParameter.setHasRight(true);
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"hpdi_bizdatabillchoicetplopen")) {
            this.openBizDataBill(event);
        }
    }

    private void openBizDataBill(ClosedCallBackEvent event) {
        BillShowParameter show = new BillShowParameter();
        Map returnData = (Map)event.getReturnData();
        if (null == returnData) {
            return;
        }
        show.setFormId("hpdi_bizdatabill");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("billtype", returnData.get("billtype"));
        show.setCustomParam("calperiod", returnData.get("calperiod"));
        show.setCustomParam("bizItemGroupId", returnData.get("bizItemGroupId"));
        show.setCustomParam("orgId", returnData.get("orgId"));
        List mulBizItemIds = (List)returnData.get("mulBizItemIds");
        if (!CollectionUtils.isEmpty((Collection)mulBizItemIds)) {
            show.setCustomParam("mulBizItemIds", (Object)mulBizItemIds);
        }
        this.getView().showForm((FormShowParameter)show);
    }
}

